/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)minmax.c	2.17  03 Aug 1995
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * minmax.c will read an ascii table and report the
 * extreme values for all columns
 *
 * Author:	Paul Wessel
 * Date:	22-Jun-1991-1995
 * Version:	2.0
 */

#include "gmt.h"

main (argc, argv)
int argc;
char **argv; {
	int n, i, ncol, n_files = 0, fno, n_read, n_args, ix, iy;
	int  error = FALSE, nofile = TRUE, done = FALSE, step = FALSE;
	double value, dx, dy, *xyzmin, *xyzmax, west, east, south, north;
	char line[BUFSIZ], buffer[BUFSIZ], file[BUFSIZ], format[BUFSIZ], *p;
	FILE *fp = NULL;
	
	argc = gmt_begin (argc, argv);
	
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
				/* Common parameters */
                      
				case 'H':
				case ':':
				case '\0':
					error += get_common_args (argv[i], 0, 0, 0, 0);
					break;

				/* Supplemental parameters */

				case 'I':
					gmt_getinc (&argv[i][2], &dx, &dy);
					step = TRUE;
					break;
				default:
					error = TRUE;
					gmt_default_error (argv[i][1]);
					break;
			}
		}
		else
			n_files++;
	}
	
	if (step && (dx <= 0.0 || dy <= 0.0)) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR -I option.  Must specify positive increment(s)\n", gmt_program);
		error++;
	}
	if (error || gmt_quick) {	/* Because it's ok to give no arguments */
		fprintf (stderr, "minmax %s - Find extreme values in ASCII tables\n\n", GMT_VERSION);
		fprintf (stderr, "usage: minmax [files] [-H] [-Idx[/dy]] [-:]\n");
             
              	if (gmt_quick) exit(-1);
 
		explain_option ('H');
		fprintf (stderr, "	-I returns textstring -Rw/e/s/n to nearest multiple of dx/dy\n");
		explain_option (':');
		exit (-1);
	}
	
	if (n_files > 0)
		nofile = FALSE;
	else
		n_files = 1;
	
	n_args = (argc > 1) ? argc : 2;
	west = south = MAXDOUBLE;	east = north = -MAXDOUBLE;
	
	xyzmin = (double *) memory ((char *)NULL, 1, sizeof (double), "minmax");
	xyzmax = (double *) memory ((char *)NULL, 1, sizeof (double), "minmax");
	
	if (step)
		sprintf (format, "-R%s/%s/%s/%s\n", gmtdefs.d_format, gmtdefs.d_format, gmtdefs.d_format, gmtdefs.d_format);
	else
		sprintf (format, "\t<%s/%s>", gmtdefs.d_format, gmtdefs.d_format);

	ix = (gmtdefs.xy_toggle) ? 1 : 0;        iy = 1 - ix;              /* Set up which columns have x and y */

	for (fno = 1; !done && fno < n_args; fno++) {     /* Loop over input files, if any */
		if (!nofile && argv[fno][0] == '-') continue;

		
		if (nofile) {   /* Just read standard input */
			fp = stdin;
			done = TRUE;
			strcpy (file, "<stdin>");
			if (gmtdefs.verbose) fprintf (stderr, "minmax: Reading from standard input\n");
		}
		else {
			strcpy (file, argv[fno]);
			if ((fp = fopen (file, "r")) == NULL) {
				fprintf (stderr, "minmax: Cannot open file %s\n", file);
				continue;
			}
		}
		
		if (gmtdefs.io_header) for (i = 0; i < gmtdefs.n_header_recs; i++) fgets (line, BUFSIZ, fp);
		
		n = ncol = 0;
		while (fgets (line, BUFSIZ, fp)) {
			if (line[0] == '>') continue;	/* Multi-segment header */
			if (ncol == 0) {	/* First time, allocate # of columns */
				strcpy (buffer, line);
				p = strtok (buffer, " \t\n");
				while (p) {	/* Count # of fields */
					ncol++;
					p = strtok ((char *)NULL, " \t\n");
				}
			
				/* Now we know # of columns, so allocate memory */
			
				xyzmin = (double *) memory ((char *)xyzmin, ncol, sizeof (double), "minmax");
				xyzmax = (double *) memory ((char *)xyzmax, ncol, sizeof (double), "minmax");
			
				for (i = 0; i < ncol; i++) {	/* Initialize */
					xyzmin[i] = MAXDOUBLE;
					xyzmax[i] = -MAXDOUBLE;
				}
				if (step && ncol < 2) step = FALSE;
			}
		
			/* Decode all fields and update minmax arrays */
		
			p = strtok (line, " \t\n");
			i = 0;
			while (p && i < ncol) {
				n_read = sscanf (p, "%lf", &value);
				if (n_read) {
					if (value < xyzmin[i]) xyzmin[i] = value;
					if (value > xyzmax[i]) xyzmax[i] = value;
				}
				i++;
				p = strtok ((char *)NULL, " \t\n");
			}
		
			if (i != ncol) fprintf (stderr, "minmax (%s):  Expected %d but found %d fields in record # %d\n", 
				file, ncol, i, n);
		
			n++;
		}
		if (fp != stdin) fclose (fp);
		
		if (step) {
			west  = MIN (west, xyzmin[ix]);	east  = MAX (east, xyzmax[ix]);
			south = MIN (south, xyzmin[iy]);	north = MAX (north, xyzmax[iy]);
		}
		else {
			printf ("%s: N = %d", file, n);
			for (i = 0; i < ncol; i++) {
				if (xyzmin[i] == MAXDOUBLE)
					printf ("\t<NaN/NaN>");
				else
					printf (format, xyzmin[i], xyzmax[i]);
			}
			printf ("\n");
		}
	}
	if (step) {
		west  = floor (west / dx) * dx;		east  = ceil (east / dx) * dx;
		south = floor (south / dy) * dy;	north = ceil (north / dy) * dy;
		printf (format, west, east, south, north);
	}
	
	free ((char *)xyzmin);
	free ((char *)xyzmax);
	
	gmt_end (argc, argv);
}
