/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)psbasemap.c	2.29  24 Jul 1995	
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * psbasemap plots out a basemap for the given area using the specified map
 * projection.
 *
 * Author:	Paul Wessel
 * Date:	8-MAY-1990
 * Version:	2.0, from old 1.1
 *
 */
 
#include "gmt.h"

main (argc, argv)
int argc;
char **argv; {
	int i, j, k;
	
	BOOLEAN error = FALSE, paint = FALSE, miles = FALSE, draw_scale = FALSE, gave_xy = FALSE;
	BOOLEAN fancy = FALSE;
	
	double w = 0.0, e = 0.0, s = 0.0, n = 0.0, new_z_level = 0.0, x0, y0, lat, length;

	char txt_a[32], txt_b[32], txt_c[32];

	struct FILL fill;
	
	argc = gmt_begin (argc, argv);
		
	for (i = 1; i < argc; i++) {
		if (argv[i][0] != '-') error = TRUE;
		
		switch (argv[i][1]) {
		
			/* Common parameters */
			
			case 'B':
			case 'J':
			case 'K':
			case 'O':
			case 'P':
			case 'R':
			case 'U':
			case 'V':
			case 'X':
			case 'x':
			case 'Y':
			case 'y':
			case 'c':
			case '\0':
				error += get_common_args (argv[i], &w, &e, &s, &n);
				break;
				
			/* Supplemental options */
			
			case 'E':
				sscanf (&argv[i][2], "%lf/%lf", &z_project.view_azimuth, &z_project.view_elevation);
				break;
			case 'F':
				if (gmt_getrgb (&argv[i][2], &gmtdefs.basemap_frame_rgb[0], &gmtdefs.basemap_frame_rgb[1], &gmtdefs.basemap_frame_rgb[2])) {
					gmt_pen_syntax ('F');
					error++;
				}
				break;
				
			case 'G':
				if (gmt_getfill (&argv[i][2], &fill)) {
					gmt_fill_syntax ('G');
					error++;
				}
				paint = TRUE;
				break;
				
			case 'L':
				j = 2;
				if (argv[i][j] == 'f') fancy = TRUE, j++;
				if (argv[i][j] == 'x') gave_xy = TRUE, j++;
				k = sscanf (&argv[i][j], "%[^/]/%[^/]/%[^/]/%lf", txt_a, txt_b, txt_c, &length);
				x0 = ddmmss_to_degree (txt_a);
				y0 = ddmmss_to_degree (txt_b);
				lat = ddmmss_to_degree (txt_c);
				if (k != 4) {
					fprintf (stderr, "%s: GMT SYNTAX ERROR -L option:  Correct syntax\n", gmt_program);
					fprintf (stderr, "	-L[f][x]<x0>/<y0>/<lat>/<length>[m], append m for miles [Default is km]\n");
					error++;
				}
				miles = (strchr (&argv[i][2], 'm') != CNULL);
				draw_scale = TRUE;
				break;
				
			case 'Z':
				new_z_level = atof (&argv[i][2]);
				break;
				
			/* Illegal options */
			
			default:
				error = TRUE;
				gmt_default_error (argv[i][1]);
				break;
		}
	}
	
	if (gmt_quick || argc == 1) {
		fprintf (stderr,"psbasemap %s - To plot PostScript basemaps\n\n", GMT_VERSION);
		fprintf (stderr, "usage: psbasemap -B<tickinfo> -J<params> -R<west/east/south/north> [-Eas/el]\n");
		fprintf (stderr, "	[-F<r/g/b] [-G<fill>] [-K] [-L[f][x]<lon0>/<lat0>/<slat>/<length>[m]] [-O] [-P]\n");
		fprintf (stderr, "	[-U[dx/dy/][label]] [-V] [-X<xshift>] [-Y<yshift>] [-Z<zlevel>] [-c<ncopies>]\n\n");
		
		if (gmt_quick) exit (-1);
		
		explain_option ('B');
		explain_option ('J');
		explain_option ('R');
		fprintf (stderr, "\n\tOPTIONS:\n");
		fprintf (stderr, "      -F Set color used for Frame and anotation [%d/%d/%d]\n",
			gmtdefs.basemap_frame_rgb[0], gmtdefs.basemap_frame_rgb[1], gmtdefs.basemap_frame_rgb[2]);
		fprintf (stderr, "      -G fill inside of basemap with the specified color\n");
		explain_option ('K');
		fprintf (stderr, "      -L draws a simple map scaLe centered on <lon0>/<lat0>.  Use -Lx to specify cartesian coordinates instead.\n");
		fprintf (stderr, "         Scale is calculated at latitude <slat>. <length> is in km, or miles is m is appended\n");
		fprintf (stderr, "         -Lf draws a \"fancy\" scale [Default is plain]\n");
		explain_option ('O');
		explain_option ('P');
		explain_option ('U');
		explain_option ('V');
		explain_option ('X');
		fprintf (stderr, "      -Z For 3-D plots: Set the z-level of map [0]\n");
		explain_option ('c');
		explain_option ('.');
		exit (-1);
	}
	
	if (!project_info.region_supplied) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR:  Must specify -R option\n", gmt_program);
		error++;
	}
	if (!(frame_info.plot || draw_scale)) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR:  Must specify at least one of -B, -L\n", gmt_program);
		error++;
	}
	if (z_project.view_azimuth > 360.0 || z_project.view_elevation <= 0.0 || z_project.view_elevation > 90.0) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR -E option:  Enter azimuth in 0-360 range, elevation in 0-90 range\n", gmt_program);
		error++;
	}
	
	if (error) exit (-1);

	if (gmtdefs.verbose) fprintf (stderr, "psbasemap: Constructing basemap\n");

	map_setup (w, e, s, n);
	
	ps_plotinit (CNULL, gmtdefs.overlay, gmtdefs.page_orientation, gmtdefs.x_origin, gmtdefs.y_origin,
		gmtdefs.global_x_scale, gmtdefs.global_y_scale, gmtdefs.n_copies,
		gmtdefs.dpi, gmtdefs.measure_unit, gmtdefs.paper_width, gmtdefs.page_rgb, gmt_epsinfo (argv[0]));
		
	echo_command (argc, argv);
	if (gmtdefs.unix_time) timestamp (argc, argv);
	
	if (project_info.three_D) ps_transrotate (-z_project.xmin, -z_project.ymin, 0.0);

	if (paint) {
		map_clip_on (fill.r, fill.g, fill.b, 3);
		map_clip_off ();
	}
	
	ps_setpaint (gmtdefs.basemap_frame_rgb[0], gmtdefs.basemap_frame_rgb[1], gmtdefs.basemap_frame_rgb[2]);
	
	if (new_z_level != 0.0) project_info.z_level = new_z_level;
	
	if (frame_info.plot) map_basemap ();
	
	if (draw_scale) draw_map_scale (x0, y0, lat, length, miles, gave_xy, fancy);
	
	if (project_info.three_D) ps_rotatetrans (z_project.xmin, z_project.ymin, 0.0);
	ps_plotend (gmtdefs.last_page);
	
	gmt_end (argc, argv);
}
