/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)pslib_inc.h	2.15  4/11/95
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * This include file is only included in pslib.c.  Calling programs must
 * include file pslib.h
 *
 * Author:	Paul Wessel
 * Date:	9-JAN-1991-1995
 */

#define Version (2.3)

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <memory.h>
#include <time.h>
#include <ctype.h>
#include "values.h"

#ifdef sony
typedef long time_t;
#endif

#ifndef R2D
#define R2D (180.0/M_PI)
#endif
#define SMALL 1.0e-10
#define MAX_PATH 1500 /* Max path length in Level 1 implementations */
#define I_255 (1.0 / 255.0)
#ifndef MIN
#define MIN(x, y) (((x) < (y)) ? (x) : (y))
#endif
#ifndef MAX
#define MAX(x, y) (((x) > (y)) ? (x) : (y))
#endif
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* Misc macros */

#ifdef hpux
#define copysign(x,y) ((y) < 0.0 ? -fabs(x) : fabs(x))
#endif
#ifdef aux
#define copysign(x,y) ((y) < 0.0 ? -fabs(x) : fabs(x))
#endif
#ifdef ultrix
#define copysign(x,y) ((y) < 0.0 ? -fabs(x) : fabs(x))
#endif
#ifndef rint
#define rint(x) ((double)(int)(((x) < 0.0) ? (x) - 0.5 : (x) + 0.5))
#endif
#ifndef ceil
#define ceil(x) ((double)(int)(((x) < 0.0 || (x) == (int)(x)) ? (x) : (x) + 1.0))
#endif
#ifndef floor
#define floor(x) ((double)(int)(((x) > 0.0 || (x) == (int)(x)) ? (x) : (x) - 1.0))
#endif

/* Global structure used internally by pslib */

struct {
	FILE *fp;		/* PS output file pointer. NULL = stdout	*/
	int font_no;		/* Current font number				*/
	int mode;		/* 0 = Landscape, 1 = Portrait			*/
	int ix, iy;		/* Absolute coordinates of last point		*/
	int npath;		/* Length of current unstroked path		*/
	char bw_format[8];	/* Format used for grayshade value		*/
	char rgb_format[20];	/* Same, for color triplets			*/
	double xscl, yscl;	/* Global scale values [1.0]			*/
	double xoff, yoff;	/* Origin offset [1/1]				*/
	double scale;		/* Must be set through plotinit();		*/
	double p_width;		/* Paper width, set in plotinit();		*/
	double points_pr_unit;	/* # of points pr measure unit (e.g., 72/inch	*/
	int v1_path_length_limit;	/* Implementation limit on path lengths	in Level 1 PostScript	*/
	int max_path_length;	/* Maximum path length encountered during execution	*/
	int clip_path_length;	/* Current length of clip path			*/
	int hex_image;		/* TRUE writes images in hex, FALSE uses binary	*/
} ps;

	/* Font information */
	
#define N_FONTS	34	/* Current no of fonts;  To add more, modify the file
			 * PS_font_names.h and PS_font_heights.h and set N_FONTS */

double ps_font_height[N_FONTS] = {	/* Based on the size of A devided by fontsize */
#include "PS_font_heights.h"
};

char *ps_font_name[N_FONTS] = {
#include "PS_font_names.h"
};

	/* Pattern information */
	
#define N_PATTERNS 33	/* Current number of predefined patterns, #32 is user-supplied */

char ps_pattern_status[N_PATTERNS][2];
int ps_pattern_nx[N_PATTERNS][2];
int ps_pattern_ny[N_PATTERNS][2];
int ps_pattern_dx[N_PATTERNS][2];
