/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)psmegaplot.c	2.9  2/4/95
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * psmegaplot allows a regular postscript file to be magnified and split up into
 * pieces that are plotted out to make up a jigsaw puzzle. The source PS file
 * is assumed to have any translate/offset/scale statements reversed at the end
 * and that there is no showpage statement at the bottom.
 *
 * Author:	Paul Wessel
 * Date:	21-MAY-1991-1995
 * Version:	2.0
 */
 
#include "gmt.h"

#define XL 575	/* Actual plotsize on paper, origin is <18,8> (varies from printer to printer) */
#define YL 775

main (argc, argv)
int argc;
char **argv; {
	int x0, y0, i, j, nx, ny;
	double scale = 0.0;
	FILE *fp;
	char ifile[100], buffer[512], first, crop_marks = FALSE, error = FALSE;

	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
				case 'C' :
					crop_marks = TRUE;
					break;
				case 'S' :
					scale = atof (&argv[i][2]);
					break;
				case '\0' :
					gmt_quick = TRUE;
					break;
				default :
					error = TRUE;
					gmt_default_error (argv[i][1]);
					break;
			}
		}
		else
			strcpy (ifile, argv[i]);
	}
	
	if (argc == 1 || gmt_quick) {
		fprintf(stderr, "psmegaplot %s - Make postersize plot using tiling\n\n", GMT_VERSION);
		fprintf(stderr, "usage : psmegaplot psfile -S<scale> [-C]\n");

		if (gmt_quick) exit (-1);

		fprintf(stderr, "	-S sets scale, must be > 1.0\n");
		fprintf (stderr, "\n\tOPTIONS:\n");
		fprintf(stderr, "	-C means plot crop marks at corners\n");
		exit(-1);
	}
	
	if (scale <= 1.0) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR -S option:  scale must be larger than 1\n", gmt_program);
		error++;
	}
	if (error) exit (-1);
	
	if ((fp = fopen(ifile, "r")) == NULL) {
		fprintf(stderr, "psmegaplot: Could not open file %s\n", ifile);
		exit(-1);
	}
	
	ny = nx = ceil (scale);
	first = TRUE;
	printf("%%!\n");
	for (i = 0; i < nx; i++) {
		x0 = XL * i;
		for (j = 0; j < ny; j++) {
			y0 = YL * j;
			if (crop_marks) {
				printf ("1 setlinewidth\n");
				printf ("18 9 moveto 0 -1 rlineto 1 0 rlineto\n");
				printf ("574 0 rmoveto 1 0 rlineto 0 1 rlineto\n");
				printf ("0 774 rmoveto 0 1 rlineto -1 0 rlineto\n");
				printf ("-574 0 rmoveto -1 0 rlineto 0 -1 rlineto stroke\n");
			}
			printf ("%d %d translate\n", -x0, -y0);
			printf ("%.3lf %.3lf scale\n", scale, scale);
			fseek (fp, 0L, 0);
			while (fgets (buffer, 512, fp)) {
				if (!first && strstr (buffer, "dict begin")) continue;
				if (!first && strstr (buffer, "gsave")) continue;
				if (buffer[0] == '/' && first)
					printf("%s", buffer);
				else if (buffer[0] != '/')
					printf("%s", buffer);
			}
			first = FALSE;
			printf ("%.3lf %.3lf scale\n", 1./scale, 1./scale);
			printf ("%d %d translate showpage\n", x0, y0);
		}
	}
	printf ("end grestore\n");
	fclose(fp);
}
