/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)pstext.c	2.28  5/1/95
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * pstext will read (x, y, angle, size, fontno, justify, text) from stdin or file and plot
 * the textstrings at (x,y) on a map using the size/font/justification selected by
 * the user. 
 *
 * Author:	Paul Wessel
 * Date:	21-JAN-1991-1995
 * Version:	2.0 based on old v1.x
 *
 */

#include "gmt.h"

main(argc, argv)
int argc;
char *argv[]; {
	int i, justify, font, last_font, n_labels = 0, fno, n_files = 0, n_args;
	int text_size, ix, iy, key, use_font[N_FONTS];
	
	double xy[2], west = 0., east = 0.0, south = 0.0, north = 0.0, plot_x, plot_y;
	double angle, dx = 0.05, dy = 0.05, new_z_level = 0.0, z_level = 0.0;
	
	BOOLEAN error = FALSE, nofile = TRUE, box_outline = FALSE, outline = FALSE, set_z = FALSE;
	BOOLEAN solid = TRUE, draw_box = FALSE, list = FALSE, done = FALSE, clip = TRUE;
	
	char text[512], line[512], this_font[80];
	
	FILE *fp = NULL;
	
	struct PEN pen;
	struct FILL txt, box;
	
	pen.r = txt.r = gmtdefs.basemap_frame_rgb[0];
	pen.g = txt.g = gmtdefs.basemap_frame_rgb[1];
	pen.b = txt.b = gmtdefs.basemap_frame_rgb[2];
	box.r = 255 - gmtdefs.basemap_frame_rgb[0];
	box.g = 255 - gmtdefs.basemap_frame_rgb[1];
	box.b = 255 - gmtdefs.basemap_frame_rgb[2];
	pen.width = 1;

	argc = gmt_begin (argc, argv);
	
	/* Check and interpret the command line arguments */
	
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch(argv[i][1]) {
		
				/* Common parameters */
			
				case 'B':
				case 'H':
				case 'J':
				case 'K':
				case 'O':
				case 'P':
				case 'R':
				case 'U':
				case 'V':
				case 'X':
				case 'x':
				case 'Y':
				case 'y':
				case 'c':
				case ':':
				case '\0':
					error += get_common_args (argv[i], &west, &east, &south, &north);
					break;
				
				/* Supplemental parameters */
			
				case 'C':
					sscanf (&argv[i][2], "%lf/%lf", &dx, &dy);
					break;
				case 'E':
					sscanf (&argv[i][2], "%lf/%lf", &z_project.view_azimuth, &z_project.view_elevation);
					break;
				case 'F':
					if (gmt_getrgb (&argv[i][2], &gmtdefs.basemap_frame_rgb[0], &gmtdefs.basemap_frame_rgb[1], &gmtdefs.basemap_frame_rgb[2])) {
						gmt_pen_syntax ('F');
						error++;
					}
					break;
				case 'G':
					if (gmt_getfill (&argv[i][2], &txt)) {
						gmt_fill_syntax ('G');
						error++;
					}
					solid = TRUE;
					break;
				case 'L':
					list = gmt_quick = TRUE;
					break;
				case 'N':	/* Do not clip at border */
					clip = FALSE;
					break;
				case 'S':
					outline = TRUE;
					if (gmt_getpen (&argv[i][2], &pen)) {
						gmt_pen_syntax ('S');
						error++;
					}
					break;
				case 'W':
					draw_box = TRUE;
					if (argv[i][2] && argv[i][2] != 'o' && gmt_getfill (&argv[i][2], &box)) {
						gmt_fill_syntax ('W');
						error++;
					}
					if (argv[i][strlen(argv[i])-1] == 'o') box_outline = TRUE;
					break;
				case 'Z':
					new_z_level = atof (&argv[i][2]);
					set_z = TRUE;
					break;
					
				/* Options not recognized */
						
				default:
					error = TRUE;
					gmt_default_error (argv[i][1]);
					break;
			}
		}
		else
			n_files++;
	}
	
	if (argc == 1 || gmt_quick) {
		fprintf (stderr,"pstext %s - To plot textstrings on maps\n\n", GMT_VERSION);
		fprintf(stderr,"usage: pstext <txtfile> -J<params> -R<west>/<east>/<south>/<north>\n");
		fprintf (stderr, "	[-B<tickinfo>] [-C<dx>/<dy>] [-Eaz/el] [-F<r/g/b>] [-G<color>] [-H] [-K] [-L] [-N] [-O] [-P] [-S<pen>]\n");
		fprintf (stderr, "	[-U] [-V] [-W<fill>[o]] [-X<x_shift>] [-Y<y_shift>] [-Z<zlevel>] [-c<ncopies>] [-:]\n\n");
		fprintf(stderr,"	Reads (x,y,size,angle,fontno,justify,text) from <txtfile> [or stdin]\n");
		fprintf(stderr,"	Built-in escape sequences:\n");
		fprintf(stderr,"		@~ toggles between current font and Symbol font\n");
		fprintf(stderr,"		@%%<no>%% switches to font number <no>; @%%%% resets font\n");
		fprintf(stderr,"		@+ toggles between normal and superscript mode\n");
		fprintf(stderr,"		@- toggles between normal and subscript mode\n");
		fprintf(stderr,"		@# toggles between normal and Small Caps mode\n");
		fprintf(stderr,"		@!<char1><char2> makes one composite character\n");
		fprintf(stderr,"		@@ prints the @ sign itself\n");
		fprintf(stderr,"		@e, @o, @a, @E, @O, @A give the accented Scandinavian characters\n");
		fprintf(stderr,"	   (See manual page for more information)\n");
		
		if (list) {	/* List fonts */
			fprintf (stderr, "\n\tFont #	Font Name\n");
			fprintf (stderr, "\t------------------------------------\n");
			for (i = 0; i < N_FONTS; i++)
				fprintf (stderr, "\t%3d\t%s\n", i, font_name[i]);
		}
			
		if (gmt_quick) exit(-1);
		
		explain_option ('j');
		explain_option ('R');
		fprintf(stderr,"\n\tOPTIONS:\n");
		explain_option ('b');
		fprintf(stderr,"	-C sets the clearance between characters and surrounding box [0.05/0.05]\n");
		fprintf(stderr,"	   only used if -W has been set\n");
		fprintf (stderr, "	-E set azimuth and elevation of viewpoint for 3-D perspective [180/90]\n");
		fprintf (stderr, "	-F Set color used for Frame and anotation [%d/%d/%d]\n",
			gmtdefs.basemap_frame_rgb[0], gmtdefs.basemap_frame_rgb[1], gmtdefs.basemap_frame_rgb[2]);
		fprintf (stderr, "	-G set the color (red/green/blue (0-255)) for solid text [0/0/0]\n");
		explain_option ('H');
		explain_option ('K');
		fprintf (stderr, "	-N Do Not clip text that exceeds the map boundaries [Default will clip]\n");
		explain_option ('O');
		explain_option ('P');
		fprintf (stderr, "	-S draw outline of characters.  Append pen attributes\n");
		explain_option ('U');
		explain_option ('V');
		fprintf (stderr, "	-W paints a colored rectangle underneath the text.  [Default is no rectangle]\n");
		fprintf (stderr, "	   Append colors [255/255/255].   To draw outline, append o [No outline]\n");
		explain_option ('X');
		fprintf (stderr, "      -Z For 3-D plots: Set the z-level of map [0]\n");
		explain_option ('c');
		explain_option (':');
		explain_option ('.');
		exit(-1);
	}

	/* Check that the options selected are mutually consistant */
	
	if (dx < 0.0 || dy < 0.0) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR -C option:  clearances cannot be negative!\n", gmt_program);
		error++;
	}
	if (z_project.view_azimuth > 360.0 || z_project.view_elevation <= 0.0 || z_project.view_elevation > 90.0) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR -E option:  Enter azimuth in 0-360 range, elevation in 0-90 range\n", gmt_program);
		error++;
	}
	if (!project_info.region_supplied) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR:  Must specify -R option\n", gmt_program);
		error++;
	}
	
	if (error) exit (-1);

	if (n_files > 0)
		nofile = FALSE;
	else
		n_files = 1;
	n_args = (argc > 1) ? argc : 2;
	
	map_setup (west, east, south, north);
	
	ps_plotinit (CNULL, gmtdefs.overlay, gmtdefs.page_orientation, gmtdefs.x_origin, gmtdefs.y_origin,
		gmtdefs.global_x_scale, gmtdefs.global_y_scale, gmtdefs.n_copies,
		gmtdefs.dpi, gmtdefs.measure_unit, gmtdefs.paper_width, gmtdefs.page_rgb, gmt_epsinfo (argv[0]));
		
	echo_command (argc, argv);
	if (gmtdefs.unix_time) timestamp (argc, argv);
	if (project_info.three_D) ps_transrotate (-z_project.xmin, -z_project.ymin, 0.0);
	
	if (set_z) {
		project_info.z_level = new_z_level;
		z_to_zz (new_z_level, &z_level);
	}
	ps_setline (pen.width);

	if (clip) map_clip_on (-1, -1, -1, 3);
	
	last_font = 0;
	ix = (gmtdefs.xy_toggle);	iy = 1 - ix;
	
	/* if (draw_box && project_info.three_D) draw_box = FALSE; */	/* Not implemented yet */
	
	/* Mark used fonts */
	
	if (gmtdefs.want_euro_font) {
		memset ((char *)use_font, 0, N_FONTS * sizeof (int));
		if (gmtdefs.unix_time) use_font[0] = use_font[1] = TRUE;
		use_font[gmtdefs.anot_font] = TRUE;
		if (frame_info.header[0]) use_font[gmtdefs.header_font] = TRUE;
		if (frame_info.label[0][0] || frame_info.label[1][0] || frame_info.label[2][0]) use_font[gmtdefs.label_font] = TRUE;
	}
	
	for (fno = 1; !done && fno < n_args; fno++) {	/* Loop over all input files */
		if (!nofile && argv[fno][0] == '-') continue;
		if (nofile) {
			fp = stdin;
			done = TRUE;
		}
		else if ((fp = fopen (argv[fno], "r")) == NULL) {
			fprintf (stderr, "psxy: Cannot open file %s\n", argv[fno]);
			continue;
		}

		if (!nofile && gmtdefs.verbose) fprintf (stderr, "pstext: Working on file %s\n", argv[fno]);
		if (gmtdefs.io_header) for (i = 0; i < gmtdefs.n_header_recs; i++) fgets (line, 512, fp);
		while (fgets (line, 512, fp)) {
			sscanf (line, "%lf %lf %d %lf %s %d %[^\n]\n", &xy[ix], &xy[iy], &text_size, &angle, this_font, &justify, text);
			n_labels++;
			geo_to_xy (xy[0], xy[1], &plot_x, &plot_y);
			
			if (this_font[0] == '-') {
				key = get_entry (&this_font[1], font_name, N_FONTS);
				if (key < N_FONTS) font = key;
			}
			else
				font = atoi (this_font);
				
			if (font != last_font) {
				ps_setfont (font);
				last_font = font;
			}
			if (!use_font[font] && gmtdefs.want_euro_font) {	/* Must reencode this font */
				ps_def_euro_font (font_name[font]);
				use_font[font] = TRUE;
			}
			if (draw_box) gmt_textbox3d (plot_x, plot_y, z_level, text_size, font, text, angle, justify, box_outline, dx, dy, box.r, box.g, box.b);
			if (solid) {
				ps_setpaint (txt.r, txt.g, txt.b);
				gmt_text3d (plot_x, plot_y, z_level, text_size, font, text, angle, justify, FALSE);
			}
			if (outline) {
				ps_setpaint (pen.r, pen.g, pen.b);
				gmt_text3d (plot_x, plot_y, z_level, text_size, font, text, angle, justify, TRUE);
			}
		}
		if (fp != stdin) fclose (fp);
	}
	
        if (clip) map_clip_off (); 

	if (frame_info.plot) {
		ps_setpaint (gmtdefs.basemap_frame_rgb[0], gmtdefs.basemap_frame_rgb[1], gmtdefs.basemap_frame_rgb[2]);
		map_basemap ();
	}
	ps_setpaint (gmtdefs.background_rgb[0], gmtdefs.background_rgb[1], gmtdefs.background_rgb[2]);
		
	if (project_info.three_D) ps_rotatetrans (z_project.xmin, z_project.ymin, 0.0);
	ps_plotend (gmtdefs.last_page);
	if (gmtdefs.verbose) fprintf (stderr, "pstext: Plotted %d text-strings\n", n_labels);
	
	gmt_end (argc, argv);
}
