/*:VRX         Main

*/

/*  Main

*/

Main:

/*  Process the arguments.

    Get the parent window.

*/

    parse source . calledAs .

    parent = ""

    argCount = arg()

    argOff = 0

    if(VRMethod("Application", "GetVar", "parentQ.", "parentQ.")=0) then parentQ.0=0

    if( calledAs \= "COMMAND" )then do

        if argCount >= 1 then do

            parent = arg(1)

            argCount = argCount - 1

            argOff = 1

        end

    end; else do

        call VROptions 'ImplicitNames'

        call VROptions 'NoEchoQuit'

    end

    InitArgs.0 = argCount

    if( argCount > 0 )then do i = 1 to argCount

        InitArgs.i = arg( i + argOff )

    end

    drop calledAs argCount argOff



/*  Load the windows

*/

    myQueue.0 = 4

    myQueue.1 = VRMethod( "Application", "GetThreadID" )

    myQueue.2 = VRInit()

    parse source . . spec

    _VREPrimaryWindowPath = ,

        VRParseFileName( spec, "dpn" ) || ".VRW"

    _VREPrimaryWindow = ,

        VRLoad( parent, _VREPrimaryWindowPath )

    drop parent spec

    if( _VREPrimaryWindow == "" )then do

        call VRMessage "", "Cannot load window:" VRError(), ,

            "Error!"

        _VREReturnValue = 32000

        signal _VRELeaveMain

    end



/*  Process events

*/

    call Init

    signal on halt

    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )

        _VREEvent = VREvent()

        interpret _VREEvent

    end

_VREHalt:

    _VREReturnValue = Fini()

    call VRDestroy _VREPrimaryWindow

_VRELeaveMain:

    call VRFini

exit _VREReturnValue



VRLoadSecondary:

    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )

    if __vrlsWait then do

        call VRFlush

    end

    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )

    if __vrlsHWnd = '' then signal __vrlsDone

    if __vrlsWait \= 1 then signal __vrlsDone

    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 

    __vrlsTmp = __vrlsWindows.0

    if( DataType(__vrlsTmp) \= 'NUM' ) then do

        __vrlsTmp = 1

    end

    else do

        __vrlsTmp = __vrlsTmp + 1

    end

    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )

    __vrlsWindows.0 = __vrlsTmp

    do while( VRIsValidObject( VRWindow() ) = 1 )

        __vrlsEvent = VREvent()

        interpret __vrlsEvent

    end

    __vrlsTmp = __vrlsWindows.0

    __vrlsWindows.0 = __vrlsTmp - 1

    call VRWindow __vrlsWindows.__vrlsTmp 

    __vrlsHWnd = ''

__vrlsDone:

return __vrlsHWnd



/*:VRX         do_it

*/

do_it: procedure

    parse arg lSrcFileName, Confirm

    do forever

       if (lSrcFileName="") then lSrcFileName = VRFileDialog( VRWindow(), "HTML file to process", "Open", "template_*.html" )

       if (lSrcFileName = "") then call quit

       Prefix = VRParseFileName( lSrcFileName, "DP" )

       SrcFileName = VRParseFileName( lSrcFileName, "NE" )

       if (translate(substr(SrcFileName,1,9))<>"TEMPLATE_" | VRFileExists(lSrcFileName)=0) then iterate

       DestFileName = Prefix || "\ecs" || substr(SrcFileName,10)

       if (VRFileExists(DestFileName)=1) then do

          if (confirm=1) then do

             Buttons.1 = "Okay"

             Buttons.2 = "ReEnter"

             Buttons.0 = 2

             id = VRMessage( VRWindow(), DestFileName" exists, click Okay to delete it", "Output File Exists", "Warning", "Buttons.", 1, 2 )

             if (id=2) then iterate

          end

          call VRDeleteFile DestFileName

       end

       leave

    end

    call processFile lSrcFileName, 1

    call lineout DestFileName

return

/*:VRX         Fini

*/

Fini:

    window = VRWindow()

    call VRSet window, "Visible", 0

    drop window

return 0



/*:VRX         Halt

*/

Halt:

    signal _VREHalt

return



/*:VRX         Init

*/

Init:

    /* If invoked as command mode, the cmd line comes over different */

    Confirm = 1

    if (InitArgs.0 = 1) then do

       cmd = InitArgs.1

       i = 1

       do until cmd = ""

          parse var cmd InitArgs.i' 'cmd

          i = i + 1

       end

       InitArgs.0 = i - 1

       lSrcFileName = InitArgs.1

       if (InitArgs.0 > 1) then Confirm = translate(InitArgs.2) <> "NO"

    end

    else do

       lSrcFileName = ""

    end



    if (translate(lSrcFileName) = "ALL") then do

       call SysFileTree 'template_*.html', 'files', 'F'

       do i = 1 to files.0

          /* 1/14/99  11:24a          54  A----  \\MNOTEBOOK\WISEMAN\config.sample */

          file = VRParseFileName( word(files.i,5), "NE" )

          call do_it file, Confirm

       end

    end

    else do

       call do_it lSrcFileName, Confirm

    end

    call quit



    window = VRWindow()

    call VRMethod window, "CenterWindow"

    call VRSet window, "Visible", 1

    call VRMethod window, "Activate"

    drop window

return



/*:VRX         processFile

*/

processFile: procedure expose DestFileName

   parse arg InputFile, BodyFile

   FoundPrefix=0

   do while lines(InputFile)

      ibuf = linein(InputFile)

      if (BodyFile<>"") then do

         if (pos("<!-- Generated by HomePage Publisher - ",ibuf)>0 |,         

             pos("<!-- Most recent revision:",ibuf)>0 |,

             strip(ibuf) = "</Body>" |,

             Strip(ibuf) = "</Html>") then iterate

      end

      /* <!insert prefix_template.html> */

      parse var ibuf pre"<"word1" "word2">"rest

      if (translate(word1)="!INSERT") then do

         FoundPrefix=1

         if (pre<>"") then call lineout DestFileName, pre

         prefix = VRParseFileName( word2, "DP" )

         if (prefix="") then prefix = VRParseFileName( DestFileName, "DP" )

         call processFile prefix || "\" || word2

         if (rest<>"") then call lineout DestFileName, rest

      end

      else if (BodyFile<>"" & FoundPrefix=0) then do  /* Ignore everything until prefix is found */

      end

      else call lineout DestFileName, ibuf

   end

   call lineout InputFile

return



/*:VRX         Quit

*/

Quit:

    window = VRWindow()

    call VRSet window, "Shutdown", 1

    drop window

return



/*:VRX         Window1_Close

*/

Window1_Close:

    call Quit

return



