#ifndef CMNDEFS_INCLUDED
#define CMNDEFS_INCLUDED

#pragma pack(1)

#define CMNLIB_MAJVER            1
#define CMNLIB_MINVER            5
#define CMNLIB_REVVER            0

#define QH_ERROR                 (USHORT)0
#define QH_HCCCONNECT            (USHORT)1
#define QH_HCFSEARCH             (USHORT)2
#define QH_HCLLIST               (USHORT)3
#define QH_HCMMEM                (USHORT)4
#define QH_HCOOBJECT             (USHORT)5
#define QH_HCSSET                (USHORT)6
#define QH_HCSSIGNAL             (USHORT)7
#define QH_HCSPLAYGROUND         (USHORT)8
#define QH_HCSSPRITE             (USHORT)9

#ifdef INCL_CMNBUF
//-------------------------------------------------------------------------
// Buffer routines
//-------------------------------------------------------------------------
#endif

#ifdef INCL_CMNCOM
//-------------------------------------------------------------------------
// Communication routines
//-------------------------------------------------------------------------

typedef LONG COMERROR;

#define COM_ERR_NOERROR          (COMERROR)0
#define COM_ERR_ERROR            (COMERROR)-1
#define COM_ERR_NOTIMPLEMENTED   (COMERROR)-2
#define COM_ERR_NOMEMORY         (COMERROR)1
#define COM_ERR_INITFAILED       (COMERROR)2
#define COM_ERR_BADHANDLE        (COMERROR)3
#define COM_ERR_BADARGUMENT      (COMERROR)4
#define COM_ERR_NOCONNECTION     (COMERROR)5
#define COM_ERR_NOTSERVER        (COMERROR)6
#define COM_ERR_TIMEOUT          (COMERROR)7
#define COM_ERR_READFAILED       (COMERROR)8
#define COM_ERR_WRITEFAILED      (COMERROR)9
#define COM_ERR_BADDATA          (COMERROR)10
#define COM_ERR_BADACK           (COMERROR)11
#define COM_ERR_NONEFREE         (COMERROR)12
#define COM_ERR_BADCONTROL       (COMERROR)13
#define COM_ERR_BUFFERTOOLARGE   (COMERROR)14
#define COM_ERR_CC_CLOSE         (COMERROR)32
#define COM_ERR_CC_RESET         (COMERROR)33

#define MAX_REMOTENAME           256
#define MAX_CONNECTNAME          256

#define CCI_TYPE_CLIENT          (USHORT)0x0001
#define CCI_TYPE_SERVER          (USHORT)0x0002
#define CCI_TYPE_SERVERCONNECT   (USHORT)0x0004
#define CCI_TYPE_CLIENTSERVER    ((CCI_TYPE_CLIENT)|(CCI_TYPE_SERVER))
#define CCI_ATTR_NOACKS          (USHORT)0x0008

//-------------------------------------------------------------------------
// CCI_ATTR_NOTIMEOUT is used for the lTimeout field of the CCOPENINFO
// structure (CmnComOpenConnection) and the CCCONNECTINFO structure
// (CmnSetHandleInfo)
//-------------------------------------------------------------------------
#define CCI_ATTR_NOTIMEOUT       (USHORT)0

typedef struct _CCOPENINFO {
   CHAR achMachine[MAX_CONNECTNAME+1];
   CHAR achConnect[MAX_CONNECTNAME+1];
   USHORT usAttr;
   LONG lTimeout;
} CCOPENINFO, FAR *PCCOPENINFO;

typedef struct _CCCONNECTINFO {
   CHAR achConnect[MAX_CONNECTNAME+1];
   USHORT usAttr;
   ULONG ulSzData;
   LONG lTimeout;
} CCCONNECTINFO, FAR *PCCCONNECTINFO;

#define CSC_CLOSE                0x00000001L
#define CSC_RESET                0x00000002L

typedef LHANDLE HCCCONNECT;
typedef HCCCONNECT FAR *PHCCCONNECT;
#endif

#ifdef INCL_CMNDBG
//-------------------------------------------------------------------------
// Debugging routines
//-------------------------------------------------------------------------

#define DWT_TYPE_NAME            (USHORT)0
#define DWT_TYPE_FILE            (USHORT)1

#define DWT_ERROR                (SHORT)-1
#endif

#ifdef INCL_CMNFIL
//-------------------------------------------------------------------------
// File routines
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
// Note that the FCS_ATTR_* constants are equal to the FILE_* constants
// (defined in <bsedos.h>) shifted left 1 bit, with the exception of
// FCS_ATTR_NORMAL, which is 1.
//
// This allows us to specify, for example, that we want read-only files
// but *not* normal files.  This makes the underlying code a bit more
// complex, but not so complex that the extra effort outweighs the
// advantages gained.
//-------------------------------------------------------------------------
#define FCS_ATTR_NORMAL          0x00000001L
#define FCS_ATTR_READONLY        0x00000002L
#define FCS_ATTR_HIDDEN          0x00000004L
#define FCS_ATTR_SYSTEM          0x00000008L
#define FCS_ATTR_DIRECTORY       0x00000020L
#define FCS_ATTR_ARCHIVED        0x00000040L

#define FCS_ATTR_AND             0x00000000L
#define FCS_ATTR_OR              0x01000000L

#define FSF_NOFILES              0xFFFFFFFFL
#define FSF_ERROR                0xFFFFFFFEL

#define FEA_TYPE                 (PCHAR)0xFFFFFFF0L
#define FEA_KEYPHRASES           (PCHAR)0xFFFFFFF1L
#define FEA_SUBJECT              (PCHAR)0xFFFFFFF2L
#define FEA_COMMENTS             (PCHAR)0xFFFFFFF3L
#define FEA_HISTORY              (PCHAR)0xFFFFFFF4L
#define FEA_VERSION              (PCHAR)0xFFFFFFF5L
#define FEA_ICON                 (PCHAR)0xFFFFFFF6L
#define FEA_ASSOCTABLE           (PCHAR)0xFFFFFFF7L
#define FEA_HPFSNAME             (PCHAR)0xFFFFFFF8L

typedef LHANDLE HCFSEARCH;
typedef HCFSEARCH FAR *PHCFSEARCH;

//-------------------------------------------------------------------------
// FCD_TYPE_*   - CmnFilCopyDiskette() notification types
//-------------------------------------------------------------------------
#define FCD_TYPE_PROGRESS        0L
#define FCD_TYPE_MESSAGE         1L
#define FCD_TYPE_ERROR           2L

//-------------------------------------------------------------------------
// FCD_MSG_*    - CmnFilCopyDiskette() messages
//-------------------------------------------------------------------------
#define FCD_MSG_WANTSRCDISK      0L
#define FCD_MSG_WANTDESTDISK     1L
#define FCD_MSG_WANTFORMATDISK   2L
#define FCD_MSG_BEGINREAD        3L
#define FCD_MSG_ENDREAD          4L
#define FCD_MSG_BEGINWRITE       5L
#define FCD_MSG_ENDWRITE         6L
#define FCD_MSG_BEGINFORMAT      7L
#define FCD_MSG_ENDFORMAT        8L
#define FCD_MSG_BEGINVERIFY      9L
#define FCD_MSG_ENDVERIFY        10L
#define FCD_MSG_VALIDATESRCDISK  11L
#define FCD_MSG_WRITEPROTECTED   12L
#define FCD_MSG_SIZEMISMATCH     13L
#define FCD_MSG_UNFORMATTED      14L

//-------------------------------------------------------------------------
// FCD_MSG_*    - CmnFilCopyDiskette() errors
//-------------------------------------------------------------------------
#define FCD_ERR_SRCDRVINVALID    0L
#define FCD_ERR_DESTDRVINVALID   1L
#define FCD_ERR_NOMEMORY         2L
#define FCD_ERR_OPENFAILED       3L
#define FCD_ERR_CLOSEFAILED      4L
#define FCD_ERR_READFAILED       5L
#define FCD_ERR_WRITEFAILED      6L
#define FCD_ERR_FORMATFAILED     7L
#define FCD_ERR_VERIFYFAILED     8L
#define FCD_ERR_LOCKFAILED       9L
#define FCD_ERR_UNLOCKFAILED     10L
#define FCD_ERR_ABORTED          99L

//-------------------------------------------------------------------------
// PFNDISKIO            - feedback function prototype
//-------------------------------------------------------------------------
typedef BOOL (* EXPENTRY PFNDISKIO)(ULONG,ULONG,PVOID);

//-------------------------------------------------------------------------
// CFFI_SECTOR_*        - sector size constants for CmnFilFormatDiskette()
//-------------------------------------------------------------------------
#define CFFI_SECTOR_128B         0
#define CFFI_SECTOR_256B         1
#define CFFI_SECTOR_512B         2
#define CFFI_SECTOR_1024B        3

typedef struct _CFFORMATINFO {
   ULONG ulSzStruct;
   ULONG ulNumTracks;
   ULONG ulNumSectors;
   ULONG ulSzSector;
} CFFORMATINFO, *PCFFORMATINFO;

//-------------------------------------------------------------------------
// Options for CmnFilCopyDiskette()
//
// FCD_OPT_WANTFORMATTED        - if set, CmnFilCopyDiskette() will fail
//                                if the destination diskette is unformatted.
//-------------------------------------------------------------------------
#define FCD_OPT_WANTFORMATTED    0x00000001L
#endif                           // #ifdef INCL_CMNFIL

#ifdef INCL_CMNLST
//-------------------------------------------------------------------------
// Link-list routines
//-------------------------------------------------------------------------

#define LAR_TAIL                 (PFNRECCOMP)0
#define LAR_HEAD                 (PFNRECCOMP)1

#define LAUR_ERROR               0
#define LAUR_EXISTS              1
#define LAUR_NOERROR             2

#define LQRC_ERROR               -1

#define LQR_PREVIOUS             0
#define LQR_NEXT                 1

typedef struct _CLLISTINFO {
   USHORT usSzRecord;
   USHORT usNumRecords;
   PVOID pvHead;
   PVOID pvTail;
} CLLISTINFO, FAR *PCLLISTINFO;

typedef LHANDLE HCLLIST;
typedef HCLLIST FAR *PHCLLIST;

//-------------------------------------------------------------------------
// The function prototypes listed below are defined as follows:
//
// PFNRECCOMP - comparison function
// Input:  PVOID - points to a record in the list.
//         PVOID - points to application-defined data, usually passed
//                 into the function which calls this function.
// Returns:  -1 if the first record is "less than" the second, 0 if they are
//           "equal", or 1 if the first record is "greater than" the second.
//
// PFNRECFUNC - record callback function
// Input:  PVOID - points to a record in the list
//
// PFNRECMED - median finding function
// Input:  HCLLIST - handle to the list to find the median for.
// Output:  PVOID - points to a buffer of the same size as a
//                  single record in the list and should be
//                  initialized by the function to be the median
//                  of the list.  This is passed later to pfnCompare
//                  as the second parameter to find all elements
//                  that are less than and greater than this record.
// Returns:  TRUE if successful, FALSE otherwise.
//-------------------------------------------------------------------------
typedef SHORT (* EXPENTRY PFNRECCOMP)(PVOID,PVOID);
typedef VOID (* EXPENTRY PFNRECFUNC)(PVOID);
typedef BOOL (* EXPENTRY PFNRECMED)(HCLLIST,PVOID);
#endif                           // #ifdef INCL_CMNLST

#ifdef INCL_CMNMEM
//-------------------------------------------------------------------------
// Memory allocation routines
//-------------------------------------------------------------------------

typedef LONG MEMERROR;

#define MEM_ERR_NOERROR          (MEMERROR)0
#define MEM_ERR_ERROR            (MEMERROR)-1
#define MEM_ERR_BADHANDLE        (MEMERROR)1
#define MEM_ERR_NOMEMORY         (MEMERROR)2
#define MEM_ERR_SIZETOOLARGE     (MEMERROR)3
#define MEM_ERR_BADPOINTER       (MEMERROR)4

typedef struct _CMMEMINFO {
   USHORT usNumHeaps;
   ULONG ulSzHeap;
   ULONG ulMemUsed;
} CMMEMINFO, FAR *PCMMEMINFO;

typedef LHANDLE HCMMEM;
typedef HCMMEM FAR *PHCMMEM;
#endif                           // #ifdef INCL_CMNMEM

#ifdef INCL_CMNOBJ
//-------------------------------------------------------------------------
// Object routines
//-------------------------------------------------------------------------

typedef LHANDLE HCOOBJECT;
typedef HCOOBJECT FAR *PHCOOBJECT;

#define MAX_OBJECTNAME           256

typedef struct _COOBJECTINFO {
   HCOOBJECT hcoParent;
   CHAR achName[MAX_OBJECTNAME+1];
   ULONG ulSzData;
   PVOID pvData;
   USHORT usNumChildren;
   ULONG ulReserved;
} COOBJECTINFO, FAR *PCOOBJECTINFO;

typedef LONG OBJERROR;

#define OBJ_ERR_NOERROR          (OBJERROR)0
#define OBJ_ERR_ERROR            (OBJERROR)-1
#define OBJ_ERR_NOTIMPLEMENTED   (OBJERROR)-2
#define OBJ_ERR_NOMEMORY         (OBJERROR)1
#define OBJ_ERR_BADHANDLE        (OBJERROR)2
#define OBJ_ERR_BADROOTHANDLE    (OBJERROR)3
#define OBJ_ERR_SIZETOOLARGE     (OBJERROR)4
#define OBJ_ERR_BADNAME          (OBJERROR)5
#define OBJ_ERR_NOTROOT          (OBJERROR)6
#define OBJ_ERR_BADARGUMENT      (OBJERROR)7
#define OBJ_ERR_OBJECTCORRUPTED  (OBJERROR)8
#define OBJ_ERR_INITFAILED       (OBJERROR)9
#define OBJ_ERR_NOTFOUND         (OBJERROR)10

#define MAXDEPTH_UNLIMITED       (SHORT)-1
#define MAX_SERVERNAME           256

typedef struct _COROOTINFO {
   SHORT sMaxDepth;
   CHAR achName[MAX_OBJECTNAME+1];
   CHAR achServer[MAX_SERVERNAME+1];
} COROOTINFO, FAR *PCOROOTINFO;

#define OQO_PARENT               (SHORT)-1
#define OQO_FIRSTCHILD           (SHORT)-2
#define OQO_PREVIOUS             (SHORT)-3
#define OQO_NEXT                 (SHORT)-4
#define OQO_ROOT                 (SHORT)-5
#endif                           // #ifdef INCL_CMNOBJ

#ifdef INCL_CMNSET
//-------------------------------------------------------------------------
// Set routines
//-------------------------------------------------------------------------

#define SFE_SET                  0
#define SFE_CLEAR                1

#define SFE_NOTFOUND             -1
#define SFE_ERROR                -2

#define SQE_ERROR                -1
#define SQE_SET                  0
#define SQE_CLEAR                1

#define SQES_ERROR               -1
#define SQES_EQUAL               0
#define SQES_NOTEQUAL            1

typedef LHANDLE HCSSET;
typedef HCSSET FAR *PHCSSET;

typedef struct _CSSETINFO {
   ULONG ulMaxElements;
   ULONG ulElementsSet;
} CSSETINFO, FAR *PCSSETINFO;
#endif                           // #ifdef INCL_CMNSET

#ifdef INCL_CMNSIG
//-------------------------------------------------------------------------
// Signal routines
//-------------------------------------------------------------------------

#define SWS_TIMEOUT_IMMEDIATE    0
#define SWS_TIMEOUT_NEVER        -1

#define SWS_RC_ERROR             0
#define SWS_RC_TIMEOUT           1
#define SWS_RC_SIGNALSET         2

typedef LHANDLE HCSSIGNAL;
typedef HCSSIGNAL FAR *PHCSSIGNAL;

typedef LHANDLE HCSSIGNALLIST;
typedef HCSSIGNALLIST FAR *PHCSSIGNALLIST;
#endif                           // #ifdef INCL_CMNSIG

#ifdef INCL_CMNSPR
//-------------------------------------------------------------------------
// Sprite routines
//-------------------------------------------------------------------------

#define MAX_SPRITES              64

#define MAX_SPRITE_CX            128
#define MAX_SPRITE_CY            128

typedef LONG SPRERROR;

#define SPR_ERR_NOERROR          0x00000000L
#define SPR_ERR_ERROR            0xFFFFFFFFL
#define SPR_ERR_BADHANDLE        0x00000001L
#define SPR_ERR_BMPTOOLARGE      0x00000002L
#define SPR_ERR_RESOURCE         0x00000003L
#define SPR_ERR_NOMEMORY         0x00000004L
#define SPR_ERR_HASPLAYGROUND    0x00000005L
#define SPR_ERR_HASNOPLAYGROUND  0x00000006L
#define SPR_ERR_PLAYGROUNDFULL   0x00000007L
#define SPR_ERR_HASBACKGROUND    0x00000008L

typedef LHANDLE HCSSPRITE;
typedef HCSSPRITE *PHCSSPRITE;

typedef LHANDLE HCSPLAYGROUND;
typedef HCSPLAYGROUND *PHCSPLAYGROUND;
#endif                           // #ifdef INCL_CMNSPR

#ifdef INCL_CMNSTR
//-------------------------------------------------------------------------
// String routines
//-------------------------------------------------------------------------

#define SQWP_ERROR               -1

#define SCTN_TYPE_BYTE           0x0000
#define SCTN_TYPE_SHORT          0x0001
#define SCTN_TYPE_LONG           0x0002
#define SCTN_TYPE_FLOAT          0x0003
#define SCTN_TYPE_DOUBLE         0x0004
#define SCTN_ATTR_DECIMAL        0x0000
#define SCTN_ATTR_HEX            0x1000

#define SPL_ERR_ERROR            -1

#define SPL_TYPE_BYTE            0x0000
#define SPL_TYPE_CHAR            0x0001
#define SPL_TYPE_STRING          0x0002
#define SPL_TYPE_SHORT           0x0003
#define SPL_TYPE_LONG            0x0004
#define SPL_TYPE_FLOAT           0x0005
#define SPL_TYPE_DOUBLE          0x0006
#define SPL_TYPE_RESERVED        0x000F
#define SPL_ATTR_DECIMAL         0x0000
#define SPL_ATTR_HEX             0x1000

#define SPL_NOTFOUND             0xFFFF
#define SPL_FOUND                0xFFFE

typedef struct _CSLINEDESC {
   USHORT usOffset;              // 0-based offset of the field within
                                 // each line
   USHORT usLength;              // Size of the field
   USHORT usType;                // Field type (SPL_* constant)
} CSLINEDESC, FAR *PCSLINEDESC;

#define SPCL_ERR_NOMEMORY        0
#define SPCL_ERR_NOTENOUGHARGS   1
#define SPCL_ERR_BADSWITCH       2
#define SPCL_ERR_SWITCHERROR     3

typedef VOID (* EXPENTRY PFNCMDERR)(USHORT);
typedef BOOL (* EXPENTRY PFNCMDARG)(USHORT,PCHAR *,USHORT);

#define SPCL_MAX_SWITCH          8

#define SPCL_FLG_CASESENSITIVE   0x0001
#define SPCL_FLG_SUBSTRING       0x0002
#define SPCL_FLG_ARGCONCAT       0x0004

typedef struct _CSCMDDESC {
   USHORT usId;
   CHAR achSwitch[SPCL_MAX_SWITCH+1];
   USHORT usNumArgs;
   USHORT usFlags;
   PFNCMDARG pfnCallback;
} CSCMDDESC, FAR *PCSCMDDESC;

#define SPS_LEFT                 (USHORT)1
#define SPS_RIGHT                (USHORT)2
#endif                           // #ifdef INCL_CMNSET

#ifdef INCL_CMNVIO
//-------------------------------------------------------------------------
// Screen I/O routines
//-------------------------------------------------------------------------
#define VGS_UNREADABLE           0x00000001
#define VGS_REQUIRED             0x00000002

#endif                           // #ifdef INCL_CMNVIO

#ifdef INCL_CMNWIN
//-------------------------------------------------------------------------
// Windowing routines
//-------------------------------------------------------------------------
typedef struct _CWPOSITION {
   ULONG ulSzStruct;
   SWP swpPosition;              // Current size and position
   USHORT ausExtra[6];           // Minimized position and restored size and
                                 // position
} CWPOSITION, FAR *PCWPOSITION;
#endif                           // #ifdef INCL_CMNWIN

#pragma pack()

#endif                           // #ifndef CMNDEFS_INCLUDED
