/*
#####################################
#            PMDemo.h               #
#   Presentation Manager Demo for   #
#             PrjMgr                #
#####################################
#   Written 1995 by Roland Knospe   #
#####################################
*/

#define ID_MAINDIALOG   1
#define ID_BALL         2
#define ID_CANCEL       3
#define ID_BOX          4
#define ID_SAT          5
#define ID_GRAVITY      6
#define ID_TIMER        7


#define START_V_X       -1.5   /* Vx0 */
#define START_V_Y       2.6    /* Vy0 */
#define GRAV_FACTOR     10.0   /* Gravity = SliderPos * GRAV_FACTOR */

#define SAT_RADIUS      3      /* Satellite radius */
#define DAMPING         0.6    /* Collision damping */

typedef struct
{
   double x,y;
} VECTOR;

typedef struct
{
   double Gravity,
          xpos,ypos;
   LONG   xmax,ymax,
          BallArea;
   BOOL   Termination;

} THREADARGS;

INT main( void );
MRESULT EXPENTRY MainDialog( HWND, ULONG, MPARAM, MPARAM );
void InitDialog( HWND, LONG *, LONG *, LONG *, LONG *);
void Simulation( void *);
void GravSimulation( VECTOR *, VECTOR *, double );

