/** $(c1)
 *
 * Copyright (C) 2013-2022 David Azarewicz <david@88watts.net>
 * All rights reserved.
 *
 * LICENSE
 *
 * You may use this source code to develop and test this software. You may
 * produce binaries for testing and for your own use. You may not publish,
 * release, share, distribute, or otherwise give this source code to any
 * other person or organization, whether modified or not. You may not fork
 * or otherwise create any copy of this source code whether modified or not.
 * You may not publish, release, share, distribute, or otherwise give any
 * binaries produced from this code to any other person or organization,
 * whether modified or not.
 *
 * The author retains sole right of distribution of this software. Any
 * desired changes to this software must be submitted to the author.
 *
 * This software is provided as-is, without warranty of any kind, express or
 * implied, including but not limited to the warranties of merchantability,
 * fitness for any particular purpose, and noninfringement. In no event shall
 * the author(s) or copyright holder(s) be liable for any claim, damages, or
 * other liability, whether in an action of contract, tort, or otherwise
 * arising from, out of, or in connection with this software, or the use or
 * other dealings in this software.
 *
 * This copyright and license statement may not be removed.
 *
 * Coding Guidelines: <https://88watts.net/files/CodingGuidelines.c>
 */

#pragma pack(1)

#define  REQTYPE_XFERDIR_DEVTOHOST     0x80  // data transfer direction device to host
#define  REQTYPE_XFERDIR_HOSTTODEV     0x00  // data transfer direction host to device
#define  REQTYPE_TYPE_MASK             0x60  // type mask
#define  REQTYPE_TYPE_STANDARD         0x00  // Standard
#define  REQTYPE_TYPE_CLASS            0x20  // class
#define  REQTYPE_TYPE_VENDOR           0x40  // vendor
#define  REQTYPE_TYPE_RESERV           0x60  // reserved

#define  REQTYPE_RECIPIENT_DEVICE      0
#define  REQTYPE_RECIPIENT_INTERFACE   1
#define  REQTYPE_RECIPIENT_ENDPOINT    2
#define  REQTYPE_RECIPIENT_OTHER       3
#define  REQTYPE_RECIPIENT_MASK        0x1f

// HUB class specific request type modifiers
#define  REQTYPE_TYPE_HUBCLASS_PORT    0x03  // request to/from hub port


// Request values
#define  REQ_GET_STATUS                0
#define  REQ_CLEAR_FEATURE             1
#define  REQ_SET_FEATURE               3
#define  REQ_SET_ADDRESS               5
#define  REQ_GET_DESCRIPTOR            6
#define  REQ_SET_DESCRIPTOR            7
#define  REQ_GET_CONFIGURATION         8
#define  REQ_SET_CONFIGURATION         9
#define  REQ_GET_INTERFACE             10
#define  REQ_SET_INTERFACE             11
#define  REQ_SYNCH_FRAME               12

// HUB class specific request type modifiers
#define  REQ_GET_STATE                 2

// general descriptor types
#define  DESC_DEVICE                   0x01
#define  DESC_CONFIGURATION            0x02
#define  DESC_STRING                   0x03
#define  DESC_INTERFACE                0x04
#define  DESC_ENDPOINT                 0x05
// class specific dscriptor types
#define  DESC_HUB                      0x00
#define  DESC_HUB11                    0x29  //LR0323 USB 1.1 hub descriptor type

/* The "USB_SPEED" macros defines all the supported USB speeds specified in SpeedDevice. */
#define USB_SPEED_FULL 0
#define USB_SPEED_LOW 1
#define USB_SPEED_HIGH 2
#define USB_SPEED_SUPER 3

typedef struct
{
  UCHAR              ctrlID;              // (00) controller ID
  UCHAR              deviceAddress;       // (01) USB device address
  UCHAR              bConfigurationValue; // (02) USB device configuration value
  UCHAR              bInterfaceNumber;    // (03) 0 based index in interface array for this item
  UCHAR              SpeedDevice;         // (04) 0 for full speed device, 1 - low speed device  2 - high speed device
  UCHAR              portNum;             // (05) port number to which device is attached
  USHORT             parentHubIndex;      // (06) index in hub table to parent hub, -1 for root hub device
  ULONG              rmDevHandle;         // (08) Resource Manager device handle
} GETDEVINFODATA;

typedef struct _device_descriptor_
{
   UCHAR    bLength;             // (00) Size of descriptor in bytes
   UCHAR    bDescriptorType;     // (01) 0x01 - DEVICE Descriptor type
   USHORT   bcdUSB;              // (02) USB Specification Release Number
   UCHAR    bDeviceClass;        // (04) Class Code
   UCHAR    bDeviceSubClass;     // (05) SubClass Code
   UCHAR    bDeviceProtocol;     // (06) Protocol Code
   UCHAR    bMaxPacketSize0;     // (07) Maximum packet size for endpoint 0
   USHORT   idVendor;            // (08) Vendor ID
   USHORT   idProduct;           // (10) Product ID
   USHORT   bcdDevice;           // (12) Device release number
   UCHAR    iManufacturer;       // (14) Index of string descriptor describing manufacturer
   UCHAR    iProduct;            // (15) Index of string descriptor describing product
   UCHAR    iSerialNumber;       // (16) Index of string descriptor describing device's serial number
   UCHAR    bNumConfigurations;  // (17) Number of possible configurations
                                 // (18)
} DeviceDescriptor;

typedef struct _config_desc_
{
  UCHAR ucLen;
  UCHAR ucType;
  USHORT usTotalLen;
  UCHAR ucNumInterfaces;
  UCHAR ucConfigValue;
  UCHAR ucStringIx;
  UCHAR ucAttributes;
  UCHAR ucMaxPower;
} CONFIGDESC;

typedef struct _interface_desc_
{
  UCHAR ucLen;
  UCHAR ucType;
  UCHAR ucInterfaceNumber;
  UCHAR ucAlternate;
  UCHAR ucNumEndpoints;
  UCHAR ucClass;
  UCHAR ucSubClass;
  UCHAR ucProtocol;
  UCHAR ucStringIx;
} INTERFACEDESC;

typedef struct _endpoint_desc_
{
  UCHAR ucLen;
  UCHAR ucType;
  UCHAR ucAddress;
  UCHAR ucAttributes;
  USHORT usMaxPacketSize;
  UCHAR ucInterval;
} ENDPOINTDESC;

typedef struct _hid_desc_
{
  UCHAR ucLen;
  UCHAR ucType;
  USHORT bcdHID;
  UCHAR ucCountryCode;
  UCHAR ucNumDescriptors;
  UCHAR ucDescriptorType;
  USHORT usDescriptorLen;
} HIDDESC;

// USB HID device class definitions and data structures

// value used to identify last index in next index items
   #define  LAST_INDEX                       0xffff

   #define  BITS_IN_BYTE                     8
   #define  BITS_DIVIDER                     3
   #define  FULL_WORD                        0xffff
   #define  FULL_BYTE                        0xff

// HID device class definitions and structures
   #define  HID_CLASS_DESCRIPTORS_HID        0x21
   #define  HID_CLASS_DESCRIPTORS_REPORT     0x22
   #define  HID_CLASS_DESCRIPTORS_PHYSICAL   0x23

// HID request values
   #define  HID_REQUEST_GET_REPORT           0x01
   #define  HID_REQUEST_GET_IDLE             0x02
   #define  HID_REQUEST_GET_PROTOCOL         0x03
   #define  HID_REQUEST_SET_REPORT           0x09
   #define  HID_REQUEST_SET_IDLE             0x0a
   #define  HID_REQUEST_SET_PROTOCOL         0x0b

// HID protocol type values used in get/set protocol requests
   #define  HID_PROTOCOL_TYPE_BOOT           0
   #define  HID_PROTOCOL_TYPE_REPORT         1

// HID interface protocol types
   #define  HID_INTF_PROTOCOL_KBD            1
   #define  HID_INTF_PROTOCOL_MOUSE          2

// HID device interface subclases
   #define  DEV_SUBCLASS_HIDBOOTSUBCLASS     0x01

// HID device report types used in set/get report requests
   #define  HID_REPORT_TYPE_INPUT            1
   #define  HID_REPORT_TYPE_OUTPUT           2
   #define  HID_REPORT_TYPE_FEATURE          3

// HID version flags
   #define  HID_PREDRAFT3_DEVICE             0x0001   // device follows HID predraft3 requirements

typedef struct _HID_desc_info_
{
   UCHAR    bDescriptorType;        // descriptor class type
   USHORT   wDescriptorLength;      // descriptor length
}  HIDDescInfo;

typedef struct _HID_device_descriptor_
{
   UCHAR       bLength;             // Size of descriptor in bytes
   UCHAR       bDescriptorType;     // 0x21 - HID DEVICE Descriptor type
   USHORT      bcdHID;              // HID Class Specification Release Number
   UCHAR       bCountryCode;        // localized hardware country code
   UCHAR       bNumDescriptors;     // no of Class descriptors
   HIDDescInfo descriptorList[1];   // descriptor list (always includes REPORT descriptor)
}  HIDDeviceDescriptor;

// Class & Client driver common definitions and data structures

typedef  struct   _item_features
{
   UCHAR       reportID;         // 09 report ID item belongs to
   ULONG       reportSize;       // 10 data size for this item
   ULONG       reportCount;      // 14 element count for current item
   USHORT      usagePage;        // 18 item's usage page
   LONG        logMin;           // 20 logical minimum for this item
   LONG        logMax;           // 24 logical maximum for this item
   LONG        phyMin;           // 28 physical value minimum
   LONG        phyMax;           // 32 physical value maximum
   ULONG       unit;             // 36 units of measurement
   UCHAR       unitExponent;     // 40 exponent value
                                 // 41
}  ItemFeatures;

typedef  struct   _local_features
{
   // usage information
   USHORT         usagePage;        // 41 local (only for this item) usage page
   USHORT         usageMin;         // 43 usage minimum
   USHORT         usageMax;         // 45 usage maximum
   USHORT         indexToUsageList; // 47
   // physical data references
   USHORT         designatorMin;    // 49
   USHORT         designatorMax;    // 51
   USHORT         indexToDesignator;// 53
   // string data references
   UCHAR          stringMin;        // 55
   UCHAR          stringMax;        // 56
   USHORT         indexToStrings;   // 57
                                    // 59
}  LocalFeatures;

typedef struct _RepItemData
{
   UCHAR          used;             // 00 nonzero if allocated
   UCHAR          interface;        // 01 interface index
   UCHAR          mainType;         // 02 item type - input, output, feature, collection
   USHORT         itemFlags;        // 03 item flags
   USHORT         parColIndex;      // 05 parent collection index (LAST_INDEX - no parent collection)
   USHORT         indexToNextItem;  // 07 index to next main item for this report
   // item features
   ItemFeatures   itemFeatures;     // 09

   // item local data
   LocalFeatures  localFeatures;    // 41
                                    // 59
}  ReportItemData;

typedef struct _item_usage
{
   UCHAR          used;             // nonzero if allocated
   USHORT         indexToNextUsageData;
   USHORT         usagePage;        // local (only for this item) usage page
   USHORT         usageMin;         // usage minimum
   USHORT         usageMax;         // usage maximum
}  ItemUsage;

typedef struct _item_designator
{
   UCHAR          used;             // nonzero if allocated
   USHORT         indexToNextDesignatorData;
   USHORT         designatorMin;         // designator minimum
   USHORT         designatorMax;         // designator maximum
}  ItemDesignator;

typedef struct _item_strings
{
   UCHAR          used;             // nonzero if allocated
   USHORT         indexToNextStringData;
   UCHAR          stringMin;         // string minimum
   UCHAR          stringMax;         // string maximum
}  ItemString;

// report item types
   #define  HID_REPORT_ITYPE_MAIN         0
   #define  HID_REPORT_ITYPE_GLOBAL       1
   #define  HID_REPORT_ITYPE_LOCAL        2

// main item tags
   #define  HID_REPORT_TAGS_MAIN_INPUT    0x08
   #define  HID_REPORT_TAGS_MAIN_OUTPUT   0x09
   #define  HID_REPORT_TAGS_MAIN_FEATURE  0x0b
   #define  HID_REPORT_TAGS_MAIN_COLL     0x0a
   #define  HID_REPORT_TAGS_MAIN_ENDCOLL  0x0c

// global item tags
   #define  HID_REPORT_TAGS_GLOBAL_UPAGE  0x00
   #define  HID_REPORT_TAGS_GLOBAL_LMIN   0x01
   #define  HID_REPORT_TAGS_GLOBAL_LMAX   0x02
   #define  HID_REPORT_TAGS_GLOBAL_PMIN   0x03
   #define  HID_REPORT_TAGS_GLOBAL_PMAX   0x04
   #define  HID_REPORT_TAGS_GLOBAL_UEXP   0x05
   #define  HID_REPORT_TAGS_GLOBAL_UNIT   0x06
   #define  HID_REPORT_TAGS_GLOBAL_RSIZE  0x07
   #define  HID_REPORT_TAGS_GLOBAL_RID    0x08
   #define  HID_REPORT_TAGS_GLOBAL_RCOUNT 0x09
   #define  HID_REPORT_TAGS_GLOBAL_PUSH   0x0a
   #define  HID_REPORT_TAGS_GLOBAL_POP    0x0b

// local item tags
   #define  HID_REPORT_TAGS_LOCAL_USAGE   0x00
   #define  HID_REPORT_TAGS_LOCAL_UMIN    0x01
   #define  HID_REPORT_TAGS_LOCAL_UMAX    0x02
   #define  HID_REPORT_TAGS_LOCAL_DINDEX  0x03
   #define  HID_REPORT_TAGS_LOCAL_DMIN    0x04
   #define  HID_REPORT_TAGS_LOCAL_DMAX    0x05
   #define  HID_REPORT_TAGS_LOCAL_SINDEX  0x07
   #define  HID_REPORT_TAGS_LOCAL_SMIN    0x08
   #define  HID_REPORT_TAGS_LOCAL_SMAX    0x09
   #define  HID_REPORT_TAGS_LOCAL_DELIM   0x0a

// item type flags
   #define  HID_REPORT_ITEM_CONSTANT      0x0001   // 0 - data
   #define  HID_REPORT_ITEM_VARIABLE      0x0002   // 0 - Array
   #define  HID_REPORT_ITEM_RELATIVE      0x0004   // 0 - Absolute
   #define  HID_REPORT_ITEM_WRAP          0x0008   // 0 - no wrap
   #define  HID_REPORT_ITEM_NONLINEAR     0x0010   // 0 - linear
   #define  HID_REPORT_ITEM_NOPREFFERED   0x0020   // 0 - preferred state
   #define  HID_REPORT_ITEM_NULLSTATE     0x0040   // 0 - no null position
   #define  HID_REPORT_ITEM_VOLATILE      0x0080   // 0 - non volatile
   #define  HID_REPORT_ITEM_BUFFBYTES     0x0100   // 0 - bit field

// main item types
   #define  HID_REPORT_MAIN_INPUT         1
   #define  HID_REPORT_MAIN_OUTPUT        2
   #define  HID_REPORT_MAIN_FEATURE       3
   #define  HID_REPORT_MAIN_COLLECTION    4

// HID Usage Pages
   #define  HID_USAGE_PAGE_GDESKTOP       0x01  // generic desktop controls
   #define  HID_USAGE_PAGE_SIMCONTRL      0x02  // Simulation Controls
   #define  HID_USAGE_PAGE_VRCNTRLS       0x03  // VR Controls
   #define  HID_USAGE_PAGE_SPORTCNTRLS    0x04  // Sport Controls
   #define  HID_USAGE_PAGE_GAMECNTRLS     0x05  // Game Controls
   #define  HID_USAGE_PAGE_KEYBOARD       0x07  // Keyboard/Keypad
   #define  HID_USAGE_PAGE_LEDS           0x08  // LEDs
   #define  HID_USAGE_PAGE_BUTTON         0x09  // button
   #define  HID_USAGE_PAGE_ORDINAL        0x0a  // ordinal
   #define  HID_USAGE_PAGE_TELEPHONY      0x0b  // telephony
   #define  HID_USAGE_PAGE_CONSUMER       0x0c  // consumer
   #define  HID_USAGE_PAGE_DIGITIZER      0x0d  // digitizer

// generic desktop page usage IDs
   #define  HID_GDESKTOP_USAGE_POINTER    0x01  // pointer
   #define  HID_GDESKTOP_USAGE_MOUSE      0x02  // mouse
   #define  HID_GDESKTOP_USAGE_JOYSTICK   0x04  // joystick
   #define  HID_GDESKTOP_USAGE_GAMEPAD    0x05  // game pad
   #define  HID_GDESKTOP_USAGE_KEYBOARD   0x06  // keyboard
   #define  HID_GDESKTOP_USAGE_KEYPAD     0x07  // keypad
   #define  HID_GDESKTOP_USAGE_X          0x30  // X
   #define  HID_GDESKTOP_USAGE_Y          0x31  // Y

// LEDs page usage IDs
   #define  HID_LEDS_USAGE_NUMLOCK        0x01  // num lock
   #define  HID_LEDS_USAGE_CAPSLOCK       0x02  // Caps lock
   #define  HID_LEDS_USAGE_SCROLLLOCK     0x04  // scroll lock

#pragma pack()
