/*----------------------------------------------------------
   Appends a build level to WEASEL.EXE and SETUP.EXE.

           Author:       Peter Moylan
           Last revised: 15 March 2024

   Usage:
           bldlvl ver

           where ver is the version string

------------------------------------------------------------*/

parse arg ver
projHost = "PJM3"
timestamp = LEFT(DATE() TIME(),25)LEFT(projHost,10)
signature0 = "@#Peter Moylan:"ver"#@##1## "timestamp"::EN:AU:::@@"
outfile = "level.txt"
"DEL "outfile" 2> nul"
CALL LINEOUT outfile, signature0||"Weasel mail server for OS/2 and eCS and ArcaOS"
CALL STREAM outfile,'C','CLOSE'
"@copy weasel.exe /B + level.txt weasel.exe /B >nul"

"@DEL "outfile
CALL LINEOUT outfile, signature0||"Configuration program for Weasel mail server"
CALL STREAM outfile,'C','CLOSE'
"@copy setup.exe /B + level.txt setup.exe /B >nul"
"@DEL "outfile

exit

