/* SCCSID = h/lssapi.h, scs, prpq2, prpq2.001, 1.6                                                        */
#ifndef  _LSSAPI
#define  _LSSAPI
/* lssapi.h */
/* SCCSID = src/security/common/include/lssapi.h, security, odo 94/10/10                                                         */
/****************************************************************************/
/*                                                                          */
/*                            IBM Confidential                              */
/*                                                                          */
/*                 Copyright (c) IBM Corporation  1993, 1994                */
/*                           All Rights Reserved                            */
/*                                                                          */
/****************************************************************************/
/********************* Start of Specifications ******************************/
/*                                                                          */
/*  Component name: Logon Shell Services Application Programming Interface  */
/*                                                                          */
/*  Module name: lssapi.dll                                                 */
/*                                                                          */
/*  Source file name: lssapi.h                                              */
/*                 include file for lssapi.dll                              */
/*                                                                          */
/*  Function: Include Sructures and function prototypes                     */
/*                                                                          */
/*  Restrictions: n/a                                                       */
/*                                                                          */
/*  Entry point:                                                            */
/*                                                                          */
/*  Normal exit : n/a                                                       */
/*                                                                          */
/*  Error exits: n/a                                                        */
/*                                                                          */
/*  Called by: n/a                                                          */
/*                                                                          */
/*  Calls: n/a                                                              */
/*                                                                          */
/*                                                                          */
/*  Change History:                                                         */
/*                                                                          */
/* code#   ptm     date        comments                                     */
/* ===== ======= ============= ============================================ */
/* @ep            03/01/95      New event specific data for the event       */
/*                              PROCESS_CREATION (SET_CONTEXT_STATUS)       */
/********************** End of Specifications *******************************/

#include <uiserr.h>

#pragma pack(1)

/****************************************************************************/
/*                Defines for the call gate and LSS router                  */
/****************************************************************************/

#define  LSS_CALLGATE        0x3  /* Used by router to recognize LSS APIs */
#define  SES_START_EVENT     0x31
#define  SES_WAIT_EVENT      0x32
#define  SES_RETURN_EVENT    0x33
#define  SES_REGISTER_DAEMON 0x34
#define  SES_RETURNWAIT_EVENT 0x35


#define  MAX_PATH            CCHMAXPATH
#define  MAX_MESSAGE         CCHMAXPATH
#define  MAX_AUTHORITYID     255          /* max number of Authorities */
#define  MAX_SSC_MESSAGE     512          /* max length of ssc message */

#define  SES_INDEFINITE_WAIT           -1
#define  SES_IMMEDIATE_RETURN          0

/*-------------------------------------------------------------------------
--                          LSS EVENTS
--
-- An "Event" is the complete series of operations and flows that
-- result from a single SESStartEvent() call... until the results are
-- returned to the calling process.
--
-- Each LSS event is assigned a separate bit in a 32 bit 'EventVector'
-- that is provided as one of the fields of the SESStartEventStruct.
--
-- Event "State Qualifiers" (the top 8 bits of an EventVector) are
-- used in combination with Event Codes to further define an
-- intermediate state of an Event, and/or to aid the SCA receiving
-- the Event to understand what task they are being asked to perform.
--------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------
-- Phases
--------------------------------------------------------------------------*/
#define SES_PHASE_CLA                                 0x10000000
#define SES_PHASE_UIA                                 0x20000000
#define SES_PHASE_SLA                                 0x40000000
#define SES_PHASE_QUERY                               0x08000000


/*-------------------------------------------------------------------------
-- Event Codes
--------------------------------------------------------------------------*/
#define SES_EVENT_INIT                                0x00000001
#define SES_EVENT_DISPLAY_NOTEBOOK                    0x00000002
#define SES_EVENT_LOGON                               0x00000004
#define SES_EVENT_LOGOFF                              0x00000008
#define SES_EVENT_SHUTDOWN                            0x00000010
#define SES_EVENT_LOCK                                0x00000020
#define SES_EVENT_UNLOCK                              0x00000040
#define SES_EVENT_CHANGE_PASSWORD                     0x00000080
#define SES_EVENT_CREATE_PROFILE                      0x00000100
#define SES_EVENT_DELETE_PROFILE                      0x00000200
#define SES_EVENT_IA                                  0x00000400


#define SES_EVENT_CREATE_HANDLE_NOTIFY                0x00100000
#define SES_EVENT_DELETE_HANDLE_NOTIFY                0x00200000
#define SES_EVENT_SEND_SECURITY_CONTEXT               0x00400000
#define SES_EVENT_SET_CONTEXT_STATUS                  0x00800000
#define SES_EVENT_PROCESS_CREATION                    0x00800000


/*-------------------------------------------------------------------------
-- Event Phases
--------------------------------------------------------------------------*/
#define SES_EVENT_LOGON_UIA       (SES_PHASE_UIA | SES_EVENT_LOGON)
#define SES_EVENT_LOGON_SLA       (SES_PHASE_SLA | SES_EVENT_LOGON)
#define SES_EVENT_LOGON_CLA       (SES_PHASE_CLA | SES_EVENT_LOGON)
#define SES_EVENT_LOGON_QUERY     (SES_PHASE_QUERY | SES_EVENT_LOGON)

#define SES_EVENT_LOGOFF_SLA      (SES_PHASE_SLA | SES_EVENT_LOGOFF)
#define SES_EVENT_LOGOFF_CLA      (SES_PHASE_CLA | SES_EVENT_LOGOFF)
#define SES_EVENT_LOGOFF_QUERY    (SES_PHASE_QUERY | SES_EVENT_LOGOFF)

#define SES_EVENT_SHUTDOWN_SLA    (SES_PHASE_SLA | SES_EVENT_SHUTDOWN)
#define SES_EVENT_SHUTDOWN_CLA    (SES_PHASE_CLA | SES_EVENT_SHUTDOWN)
#define SES_EVENT_SHUTDOWN_QUERY  (SES_PHASE_QUERY | SES_EVENT_SHUTDOWN)

#define SES_EVENT_LOCK_SLA        (SES_PHASE_SLA | SES_EVENT_LOCK)
#define SES_EVENT_LOCK_CLA        (SES_PHASE_CLA | SES_EVENT_LOCK)
#define SES_EVENT_LOCK_QUERY      (SES_PHASE_QUERY | SES_EVENT_LOCK)

#define SES_EVENT_UNLOCK_UIA      (SES_PHASE_UIA | SES_EVENT_UNLOCK)
#define SES_EVENT_UNLOCK_SLA      (SES_PHASE_SLA | SES_EVENT_UNLOCK)
#define SES_EVENT_UNLOCK_CLA      (SES_PHASE_CLA | SES_EVENT_UNLOCK)



/*-------------------------------------------------------------------------
-- Status Codes
--------------------------------------------------------------------------*/
#define  SES_STATUS_NO_ERROR                 SES_NO_ERROR

#define  SES_STATUS_USER_AUTHENTICATED       1
#define  SES_STATUS_USER_UNAUTHENTICATED     2
#define  SES_STATUS_SYSTEM_LOGON             3
#define  SES_STATUS_SYSTEM_LOGOFF            4
#define  SES_STATUS_RESERVE_HANDLE           19

#define  SES_STATUS_GUEST_USER               6
#define  SES_STATUS_ID_ONLY                  8
#define  SES_STATUS_AUTOGUEST                9

#define  SES_STATUS_INTEGRITY_VIOLATION      13
#define  SES_STATUS_EVENT_INVALID            SES_EVENT_INVALID
#define  SES_STATUS_EVENT_TIMED_OUT          SES_EVENT_TIMED_OUT
#define  SES_STATUS_INVALID_AUTHORITY        SES_INVALID_AUTHORITY
#define  SES_STATUS_INVALID_EVENT_DATA       SES_INVALID_EVENT_DATA
#define  SES_STATUS_EVENT_FAILURE            SES_EVENT_FAILURE
#define  SES_STATUS_CANCEL                   SES_CANCEL

/*-------------------------------------------------------------------------
-- Status defines from previous UIA work
--------------------------------------------------------------------------*/
#define SUCCESS                        SES_STATUS_USER_AUTHENTICATED
#define FAILURE                        SES_STATUS_USER_UNAUTHENTICATED
#define ID_ONLY                        SES_STATUS_ID_ONLY
#define GUEST_USER                     SES_STATUS_GUEST_USER
#define NOT_FOUND                      21 /* last UIA was not found       */
#define NOT_AVAILABLE                  22 /* last UIA busy right now      */
#define NOT_APPLICABLE                 23 /* last UIA don't care          */

/*==================================================================*/
/* LSS Structures                                                   */
/*==================================================================*/

/*------------------------------------------------------------------*/
/*                                                                  */
/*   SESEventData                                                   */
/*                                                                  */
/*------------------------------------------------------------------*/

typedef struct _SESLOGON
   {
      ULONG       UserNameLen;
      CHAR        UserName[MAX_USER_NAME];
      ULONG       UserTokenLen;
      CHAR        UserToken[MAX_TOKEN];
      ULONG       CUHandle;
      ULONG       AuthoritySource;

   } SESLOGON , *PSESLOGON;


typedef struct _SESUNLOCK
   {
      ULONG       UserTokenLen;
      CHAR        UserToken[MAX_TOKEN];

   } SESUNLOCK , *PSESUNLOCK;


typedef struct _SESCHANGEPASSWORD
   {
      ULONG       ChangerNameLen;
      CHAR        ChangerName[MAX_USER_NAME];
      ULONG       ChangerPasswordLen;
      CHAR        ChangerPassword[MAX_TOKEN];
      ULONG       UserNameLen;
      CHAR        UserName[MAX_USER_NAME];
      ULONG       UserPasswordLen;
      CHAR        UserPassword[MAX_TOKEN];
      ULONG       SystemLen;
      CHAR        System[MAX_SYSTEM];

   } SESCHANGEPASSWORD , *PSESCHANGEPASSWORD;


typedef struct _SESPROFILE
  {
      ULONG       UserNameLen;
      CHAR        UserName[MAX_USER_NAME];
      ULONG       SystemLen;
      CHAR        System[MAX_SYSTEM];


  } SESPROFILE, *PSESPROFILE;


typedef struct _SESIA
   {
      ULONG       UserNameLen;
      CHAR        UserName[MAX_USER_NAME];
      ULONG       UserTokenLen;
      CHAR        UserToken[MAX_TOKEN];

   } SESIA , *PSESIA;


typedef struct _SESSENDSECURITYCONTEXT
   {
      PULONG      pMessageLength;
      PVOID       pMessage;
      ULONG       Timeout;
      ULONG       AuthorityID;

   } SESSENDSECURITYCONTEXT, *PSESSENDSECURITYCONTEXT;


typedef struct _SESPROCESSCREATION       /* @ep (replaced SETCONTEXTSTATUS)*/
  {
     CHAR             ProgramName[CCHMAXPATH];
     SECURITYCONTEXT  Context;                /* #124286 LIN 6/5/95 */

  } SESPROCESSCREATION, *PSESPROCESSCREATION;

typedef struct _SESCREATEHANDLENOTIFY
   {
      ULONG       Reserved1;
      ULONG       Reserved2;
      ULONG       Reserved3;
      ULONG       Reserved4;
      ULONG       UISControlBlockLinAddr;
      ULONG       UISHandleLinAddr;
      ULONG       UIANumberLinAddr;

   } SESCREATEHANDLENOTIFY, *PSESCREATEHANDLENOTIFY;


typedef struct _SESDELETEHANDLENOTIFY
   {
      ULONG       Reserved1;
      ULONG       Reserved2;
      ULONG       Reserved3;
      ULONG       Reserved4;
      ULONG       UISControlBlockLinAddr;
      ULONG       UISHandleLinAddr;
      ULONG       UIANumberLinAddr;

   } SESDELETEHANDLENOTIFY, *PSESDELETEHANDLENOTIFY;


typedef struct _SESREQUESTSCS
   {
      ULONG       RequestSCS;

   } SESREQUESTSCS, *PSESREQUESTSCS;


typedef union _SESEVENTDATA
   {
      SESLOGON                Logon;
      SESUNLOCK               Unlock;
      SESCHANGEPASSWORD       ChangePassword;
      SESPROFILE              Profile;
      SESIA                   IA;
      SESSENDSECURITYCONTEXT  SendSecurityContext;
      SESPROCESSCREATION      ProcessCreation;
      SESCREATEHANDLENOTIFY   CreateHandleNotify;
      SESDELETEHANDLENOTIFY   DeleteHandleNotify;
      SESREQUESTSCS           RequestSCS;

   } SESEVENTDATA, *PSESEVENTDATA;


/*------------------------------------------------------------------*/
/* The following structure is used in both:                         */
/*   SESReturnEventStatus                                           */
/*   SESWaitEvent                                                   */
/*------------------------------------------------------------------*/

typedef struct _SESEVENT
   {
      ULONG                DaemonID;      /* Dmon ID assigned  -In          */
      ULONG                ReqPID;        /* PID /SESStartEvent caller -Out */
      ULONG                ReqTID;        /* TID /SESStartEvent caller -Out */
      SESSecurityContext   SCH;           /* SecurityContext of " caller    */
      ULONG                EventID;       /* Unique Event ID  -Out          */
      ULONG                Event;         /* Event code In/Out -            */
      ULONG                EventStatus;   /* Event status In/Out            */
      SESEVENTDATA         EventData;     /* Union.. data depends on event  */

   } SESEVENT, *PSESEVENT;


/*------------------------------------------------------------------*/
/*   Structure for SESStartEvent                                    */
/*------------------------------------------------------------------*/

typedef struct _SESSTARTEVENT
   {
      ULONG                Event;         /* Event code (see Event Codes)   */
      ULONG                EventStatus;   /* Event status (see Event Status)*/
      SESEVENTDATA         EventData;     /* Union.. data depends on event  */

  } SESSTARTEVENT, *PSESSTARTEVENT;


/*------------------------------------------------------------------*/
/*   Shortcuts                                                      */
/*------------------------------------------------------------------*/
#define  LogonUserName           EventData.Logon.UserName
#define  LogoffUserName          EventData.Logoff.UserName
#define  LogonUserSecret         EventData.Logon.UserToken
#define  ReturnAuthID            SCH.SCS.SCAuth.AuthorityID


/*==================================================================*/
/* LSS Function Protypes                                            */
/*==================================================================*/

#ifndef  __SECUREH__            // From secure.h include
#ifndef  _LSSDD

APIRET APIENTRY SESRegisterDaemon(
   PULONG            DaemonID,
   ULONG             EventList);

APIRET APIENTRY SESStartEvent(
   PSESSTARTEVENT    pSES);

APIRET APIENTRY SESWaitEvent(
   PSESEVENT         pEventInfo,
   ULONG             Timeout);              //@SCA - new parm,

APIRET APIENTRY SESReturnEventStatus(
   PSESEVENT         pEventInfo);

APIRET APIENTRY SESReturnWaitEvent(
   PSESEVENT         pEventInfo,
   ULONG             Timeout);

APIRET APIENTRY SESSetContextStatus( ULONG );

APIRET APIENTRY SESSendSecurityContext(
   PULONG            pMessageLength,
   PVOID             pMessage,
   ULONG             Timeout,
   ULONG             AuthorityID);

#endif
#endif   // __SECUREH__

#pragma pack()

#endif
