/****************************** Module Header ******************************\
*
* Module Name: SCSAPI.H
*
* OS/2 xxxx include file.
*
* Copyright (c) International Business Machines Corporation 1994
*
* ===========================================================================
*
* Comments at the end of each typedef line give the name tags used in
* the assembler include version of this file.
*
* The assembler include version of this file excludes lines between NOINC
* and INC comments.
*
\***************************************************************************/
#ifndef  __SCSAPI__
#define  __SCSAPI__

#pragma pack(1)

#include <sesdef.h>
#include <uiserr.h>

#define CURRENT_PID                       0
#define LOG_ONLY                          0
#define LOG_HALT                          1
#define QPI_QUERYSIZE                     0
#define QPI_QUERYINFO                     1


/* #123286 LIN 6/5/95  Moved SECURITYCONTEXT, HSUBJECT to sesapi.h */

/*-------------------------------------------------------------------------
-- 10/4/94  Removed INFOENTRY structure.  Pointers for Name, Token data
--          and lengths in the SUBJECTINFO structure are now inline.
-------------------------------------------------------------------------*/
typedef struct _SUBJECTINFO {
  HSUBJECT      Handle;                 /* Subject Handle             */
  HSUBJECT      Instance;               /* Instance Handle            */
  PVOID         Name;                   /* Subject Name               */
  ULONG         NameLen;                /* Subject Name Length        */
  PVOID         Token;                  /* Subject Token              */
  ULONG         TokenLen;               /* Subject Token Length       */
  ULONG         Source;                 /* Source of Authentication   */
} SUBJECTINFO, *PSUBJECTINFO;



#define  SCS_ENABLED_FLAG                  1


typedef struct _SESSCSTAT                       /* Used in SESQueryAthorityID*/
        {
           ULONG  Authority;
           ULONG  AuthorityID;
         } SESSCSTAT;

typedef SESSCSTAT *PSESSCSTAT;

/* 105705 */
typedef struct _PROCESSBUF {

   PID   ProcessID;
   CHAR  ProcessName[CCHMAXPATH];

} PROCESSBUF,  *PPROCESSBUF;



   /* process name block for use in SCSCtl */

typedef struct _SESCONTROLBLOCK {
        ULONG  ulMaxNameBufLen;
        PCHAR  pName;
        ULONG  ulNameLen;
        ULONG  ulReqPID;
        ULONG  ulReqTID;
        ULONG  ulReqType;
        ULONG  ulAction;
} SESCONTROLBLOCK, *PSESCONTROLBLOCK;

#ifndef  __SECUREH__            // From secure.h include

/* Function prototypes */

APIRET APIENTRY SESCreateSubjectHandle(
   PSUBJECTINFO      pSubjectInfo);

APIRET APIENTRY SESDeleteSubjectHandle(
   HSUBJECT          SubjectHandle);

APIRET APIENTRY SESSetSubjectHandle(
   ULONG             TargetSubject,
   HSUBJECT          SubjectHandle);

APIRET APIENTRY SESQuerySubjectHandle(
   PID               pid,
   ULONG             TargetSubject,
   PHSUBJECT         pSubjectHandle);

APIRET APIENTRY SESQuerySubjectInfo(
   PID               pid,
   ULONG             TargetSubject,
   PSUBJECTINFO      pSubjectInfo);

APIRET APIENTRY SESSetSubjectInfo(
   ULONG             TargetSubject,
   PSUBJECTINFO      pSubjectInfo);

APIRET APIENTRY SESQuerySubjectHandleInfo(
   HSUBJECT          SubjectHandle,
   PSUBJECTINFO      pSubjectInfo);

APIRET APIENTRY SESSetContextStatus(
   ULONG             ContextStatus);

APIRET APIENTRY SESQueryContextStatus(
   PID               pid,
   PULONG            pContextStatus);

APIRET APIENTRY SESSetSecurityContext(
   PSECURITYCONTEXT  pSecurityContext);


APIRET APIENTRY SESCreateHandleNotify(
   PSUBJECTINFO      pSubjectInfo);

APIRET APIENTRY SESDeleteHandleNotify(
   PHSUBJECT         pSubjectHandle);

/* NOTE that SESResetThreadContext is statically linked.*/
APIRET APIENTRY SESResetThreadContext(
   ULONG             Flag);

APIRET APIENTRY SESQuerySecurityContext(
   PID               pid,
   PSECURITYCONTEXT  pSecurityContext);

APIRET APIENTRY SESQueryAuthorityID(
   PSZ               pszAuthorityTag,
   PULONG            pAuthorityID);

APIRET APIENTRY SESCtl(
   ULONG             FunctionCode,
   ULONG             SubFunctionCode,
   PVOID             pDataArea,
   ULONG             DataLengthMax,
   PULONG            pDataLengthInOut);

APIRET APIENTRY SESControlKBDMonitors(ULONG ulActionCode, PULONG pulStatus);

APIRET APIENTRY SESControlProcessCreation(
   ULONG             ulActionCode);

APIRET APIENTRY SESInactivityNotify(ULONG timeout);

APIRET APIENTRY SESKillProcess(
   PID               idProcessID);

/*-------------------------------------------------------------------------
-- 01/4/95  Removed SESQueryProcessIDs() API.  This has been replaced
-- 105705   with the new and improved flavor:  SESQueryProcessInfo()
-------------------------------------------------------------------------*/
APIRET APIENTRY SESQueryProcessInfo(
   ULONG             ulActionCode,
   HSUBJECT          CUH,
   PULONG            pulProcessCount,
   PVOID             pProcessBuf );

APIRET APIENTRY SESlogIntegrityViol(
   ULONG             Flag,
   PCHAR             plogdata);


extern APIRET APIENTRY SESCreateInstanceHandle(HSUBJECT *);

extern APIRET APIENTRY SESReserveSubjectHandle(ULONG);
extern APIRET APIENTRY SESReleaseSubjectHandle(ULONG, HSUBJECT);

#ifdef SES_TDLL
extern APIRET APIENTRY SESGetNextTDLL (PSZ , PULONG , PULONG ) ;
extern APIRET APIENTRY SESRegisterTDLL (PSZ , ULONG , ULONG ) ;
#endif


#endif   // __SECUREH__

#pragma pack()

#endif
