/****************************** Module Header ******************************\
*
* Module Name: SESAPI.H
*
* OS/2 xxxx include file.
*
* Copyright (c) International Business Machines Corporation 1994
*
* ===========================================================================
*
* The folowing symbols are used in this file for conditional sections.
*
*   #define:                To include:
*
*   INCL_LSSAPI             LSS stuff
*   INCL_SCSAPI             SCS stuff
*
* ===========================================================================
*
* Comments at the end of each typedef line give the name tags used in
* the assembler include version of this file.
*
* The assembler include version of this file excludes lines between NOINC
* and INC comments.
*
\***************************************************************************/
#ifndef  __SESAPI__
#define  __SESAPI__

#pragma pack(1)

#define  MAX_USER_NAME                 32
#define  MAX_TOKEN                     32
#define  MAX_SYSTEM                    32

#define  SETLOGFILE                    "LOGFILE"

typedef  CHAR  AUTH;
typedef  AUTH * PAUTH;

typedef struct _SCAUTH
  {
    CHAR   Flags[3];         //@SCA -old SCAFlags[3];
    CHAR   AuthorityID;      //@SCA -old SCANum;

  } SCAUTH;

typedef union _SESSCStatus
  {
    ULONG    SCStat;         /* Access entire status vector */
    SCAUTH   SCAuth;         /* Access AthorityID and flags sep */

  } SESSCStatus, *PSESSCStatus;

/* @@@ This structure will be trashed!! -- just use SESATTRIB!!!! */
/* @ph add process handles */
typedef struct _SESSecurityContext   /* AKA SecurityAttributes */
  {
    ULONG       CUH;
    ULONG       AUH;
    ULONG       CGH;
    ULONG       AGH;
    ULONG       CPH;     /* @ph */
    ULONG       APH;     /* @ph */
    SESSCStatus SCS;

  } SESSecurityContext, *PSESSecurityContext;


/*--------------------------------------------------------------*/
/* #123286 LIN moved the SECURITYCONTEXT structure and HSUBJECT */
/* 6/5/95     typedef from SCSAPI.H                             */
/*--------------------------------------------------------------*/
typedef ULONG HSUBJECT;                   // HSUBJECT is a 32-bit value used as
typedef HSUBJECT *PHSUBJECT;              // SCS handle for a user/process

typedef struct _SECURITYCONTEXT {
                HSUBJECT        CUH;       /* Client User Subject Handle   */
                HSUBJECT        AUH;       /* Agent User Subject Handle    */
                HSUBJECT        CGH;       /* Client Group Subject Handle  */
                HSUBJECT        AGH;       /* Agent Process Subject Handle */
                HSUBJECT        CPH;       /* Client Process Subject Handle*/
                HSUBJECT        APH;       /* Agent Group Subject Handle   */
                ULONG   ContextStatus;     /* Context Status               */
        } SECURITYCONTEXT;

typedef SECURITYCONTEXT *PSECURITYCONTEXT;


#pragma pack()
#endif

#ifdef   INCL_LSSAPI
#include <lssapi.h>
#endif //INCL_LSSAPI

#ifdef   INCL_SCSAPI
#include <scsapi.h>
#ifdef SES_INSTANCE
#include <instance.h>
#endif
#ifdef SES_SPLIST
#include <splist.h>
#endif
#ifdef SES_TDLL
#include <tdll.h>
#endif
#endif //INCL_SCSAPI

#ifdef   INCL_DPSAPI
#include <dpsapi.h>
#endif //INCL_DPSAPI

