/* Gaithersburg   src/security/common/include/sesdef.h, security, odo   15:49:06   10/10/94 */
/******************************************************************************/
/*  sesdef.h                                                                  */
/*                                                                            */
/*  Security Enabling Services data structures and function prototypes        */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/* ----------                                                                 */
/* Copyright (C) International Business Machines Corp., 1992, 1993.           */
/*                                                                            */
/******************************************************************************/
/* History */
/* 94.05.10      Hsin     Added for defining SCS API function codes's.   */
/*--------------------------------------------------------------------------*/
/* Generic IOCtl Category and Functions                                     */

#ifndef _SESDEF_H
#define _SESDEF_H

#pragma pack(1)

#define SES_CATEGORY                    0xe5  /* =229, User Defined Cat */
 /* device driver category e5=229 */
#define DDCAT 0xe5
#define SCS_CALLGATE DDCAT

#define CREATE_SES_HANDLE               0x40
#define DELETE_SES_HANDLE               0x41
#define SET_SES_HANDLE                  0x42
#define REQUEST_SES_AUTHORITY           0x43
#define SET_SES_ATTRIBUTES              0x44
#define SES_CONTROL                     0x45
#define LOCAL_ACCESS_CONTROL            0x46
#define QUERY_SES_HANDLE                0x60
#define QUERY_USER_INFORMATION          0x61
#define QUERY_SES_AUTHORITY             0x62
#define QUERY_SES_ATTRIBUTES            0x63

#define CREATE_SUBJECT_HANDLE           0x70
#define DELETE_SUBJECT_HANDLE           0x71
#define SET_SUBJECT_HANDLE              0x72
#define QUERY_SUBJECT_HANDLE            0x73
#define QUERY_SUBJECT_INFO              0x74
#define QUERY_SUBJECT_HANDLE_INFO       0x75
#define SET_CONTEXT_STATUS              0x80
#define QUERY_CONTEXT_STATUS            0x81
#define SET_SECURITY_CONTEXT            0x82
#define QUERY_SECURITY_CONTEXT          0x83
#define RESET_THREAD_CONTEXT            0x84 /* It was TOGGLE_EFFECTIVE_CONTEXT */
#define QUERY_AUTHORITY_ID              0x85
#define CREATE_INSTANCE_HANDLE          0x86
#define RESERVE_SUBJECT_HANDLE          0x87
#define RELEASE_SUBJECT_HANDLE          0x88
#ifdef SES_TDLL
#define GET_NEXT_TDLL                   0x89
#define REGISTER_TDLL                   0x8a
#endif

#define QUERY_PROCESS_IDS               0x8b
#define KILL_PROCESS                    0x8c
#define CONTROL_PROCESS                 0x8d
#define INACTIVITY_NOTIFY               0x8e
#define CONTROL_KBD_MONITORS            0x8f


/*       Constants  used for TargetSubject in APIs */

#define   EFFECTIVE_PROCESS                     0x0       //@ph
#define   EFFECTIVE_USER                        0x1
#define   EFFECTIVE_GROUP                       0x2
#define   EFFECTIVE_USER_AND_GROUP              0x3
#define   CLIENT_PROCESS                        0x4       //@ph
#define   CLIENT_USER                           0x5
#define   CLIENT_GROUP                          0x6
#define   CLIENT_USER_AND_GROUP                 0x7
#define   AGENT_PROCESS                         0x8       //@ph
#define   AGENT_USER                            0x9
#define   AGENT_GROUP                           0xA
#define   AGENT_USER_AND_GROUP                  0xB
#define   BOTH_CLIENT_AGENT_PROCESS             0xC       //@ph
#define   BOTH_CLIENT_AGENT_USER                0xD
#define   BOTH_CLIENT_AGENT_GROUP               0xE
#define   BOTH_CLIENT_AGENT_USER_AND_GROUP      0xF

/* Flags for SESResetThreadContext */
#define PROCESS_CONTEXT                 0       /* revert to process context */
#define THREAD_CONTEXT                  1       /* create new thread context */
#define PUSH_CONTEXT                    3       /* use temporary context */
#define POP_CONTEXT             PROCESS_CONTEXT /* revert to previous */
#define REVERT_CONTEXT          PROCESS_CONTEXT /* revert to previous */

// BUGBUG  ranga used to be SEC_TDLL
#ifdef SES_TDLL
#define TDLL_CONTEXT                    2       /* use TDLL special context */
#endif


/*---------------------------------------------*/
/* New Context Status Flag Definition          */
/*---------------------------------------------*/
#define APA_FLAG        0x00000001      /* Agent Process Authority       */
#define SPA_FLAG        0x00000002      /* Server Process Authority      */
#define RLA_FLAG        0x00000004      /* Remote Logon Authority        */
#define SLA_FLAG        0x00000008      /* System Logon Authority        */
/* reserved: 10, 20, 40, 80 */
#define ACA_FLAG        0x00000100      /* Access Control Authority      */
#define CLA_FLAG        0x00000200      /* Client Logon Authority        */
#define UIA_FLAG        0x00000400      /* User Identification Authority */
/* reserved: 800 */
#define PDF_FLAG        0x00002000      /* Personal Desktop   Auth       */
#define PSS_FLAG        0x00004000      /* ProtShell Services Auth       */
#define SES_FLAG        0x00008000      /* Security Enabling Services Auth */

#define EUF_FLAG        0x00010000      /* Effective User Flag.          */
#define EGF_FLAG        0x00020000      /* Effective Group Flag.         */
#define EPF_FLAG        0x00040000      /* Effective Process Flag        */
#define PAF_FLAG        0x00080000      /* Propagate Inheritance Flag    */
#define LUF_FLAG        0x00100000      /* Local (PM) User Flag.         */
#define LUF_NO_FLAG     0x00200000      /* Local (PM) User Flag not to be set */

/* used above: 80000 and higher */

/*-----------------------------------------------------------------------*/
/* The following flags are secure.sys options, but not necessarily bits  */
/* in the Security Context Status field...                               */
/*-----------------------------------------------------------------------*/
#define TDLL_FLAG       0x00100000      /* Trusted DLL        Option    */
#define LNDLL_FLAG      0x00200000      /* Logon Notebook DLL Option    */
#define START_FLAG      0x00400000      /* Start Program      Option    */


#define EFF_GROUP                   EGF_FLAG
#define EFF_CLIENT_GROUP            0x00000000    // ???? who uses this
#define EFF_AGENT_GROUP             EGF_FLAG

#define EFF_USER                    EUF_FLAG
#define EFF_CLIENT_USER             0x00000000    // ???? who uses this
#define EFF_AGENT_USER              EUF_FLAG


/******************************************************/
/*
 * Access Authority (8-bits)
 */
#define ACCESS_AUTH                 (ACCESS_AUTH_ACA | \
                                    ACCESS_AUTH_CLA | \
                                    ACCESS_AUTH_SLA | \
                                    ACCESS_AUTH_PDF | \
                                    ACCESS_AUTH_PSS | \
                                    ACCESS_AUTH_SES)

#define ALL_AUTH                0x0000FFFF

//@obsolete -
#define ACCESS_AUTH_ACA             ACA_FLAG
#define ACCESS_AUTH_CLA             CLA_FLAG
#define ACCESS_AUTH_SLA             SLA_FLAG
#define ACCESS_AUTH_PDF             PDF_FLAG
#define ACCESS_AUTH_SES             SES_FLAG
#define ACCESS_AUTH_PSS             PSS_FLAG

//@obsolete -
#define SES_DENY                    0x00000000
#define SES_NOTGRANT                0x00000000
#define SES_GRANT                   0x00000001
#define SES_DEFER                   0x00000002


/* @@@ what??? */
#define REQ_AUTH_RLA                RLA_FLAG
#define REQ_AUTH_UIA                UIA_FLAG

#define PROC_AUTH                   (APA_FLAG | \
                                    SPA_FLAG | \
                                    UIA_FLAG)

#define PROC_AUTH_UP                0x00000000
#define PROC_AUTH_AP                APA_FLAG
#define PROC_AUTH_SP                SPA_FLAG
#define PROC_AUTH_UIA               UIA_FLAG

#define PROC_AUTH_SPA               PROC_AUTH_SP
#define PROC_AUTH_APA               PROC_AUTH_AP
#define PROC_AUTH_UPA               PROC_AUTH_UP


#define NON_ASSOC_SES_HANDLE        0x00000000
#define NON_ASSOC_HANDLE_NUMBER     0x00000000

#define DEFAULT_SES_AUTH            0x00000000

#define MAX_NUM_HANDLE_NUMBERS      0x08000000          /*   64M */




typedef ULONG  SESHANDLE;
typedef SESHANDLE FAR *PSESHANDLE;


/*----------------------------------------------------------------------
-- @ph Add Process handles to our security attributes
--     Old struct:
--
-- typedef struct _SESATTRIB
--         {
--            SESHANDLE    ClientUserSESHandle;
--            SESHANDLE    AgentUserSESHandle;
--            SESHANDLE    ClientGroupSESHandle;
--            SESHANDLE    AgentGroupSESHandle;
--            ULONG        ulSESAuthority;
--         } SESATTRIB, FAR *PSESATTRIB;
-----------------------------------------------------------------------*/
typedef struct _SESATTRIB
        {
           SESHANDLE    ClientUserSESHandle;
           SESHANDLE    AgentUserSESHandle;
           SESHANDLE    ClientGroupSESHandle;
           SESHANDLE    AgentGroupSESHandle;
           SESHANDLE    CPH;
           SESHANDLE    APH;
           ULONG        ulSESAuthority;
        } SESATTRIB, FAR *PSESATTRIB;

#define _SESATTRIB_SIZE (sizeof(struct _SESATTRIB))     /* 32 */

/*
 * SES new Authority ID :
 * 16-255 :     Any other SCA Authority
 */
#define  AUTHID_SES               1
#define  AUTHID_PSS               2
#define  AUTHID_SLA               4                       /* @ep - was 3   */
#define  AUTHID_PLF               3                       /* @ep obsolete  */
#define  AUTHID_PDF               5                       /* @ep obsolete  */

#define         NONE    0
#define         SES     AUTHID_SES
#define         PSS     AUTHID_PSS
#define         PLF     AUTHID_PLF
#define         PDF     AUTHID_PDF
#define         SLA     AUTHID_SLA


#define SLA_UIA_NUMBER                 AUTHID_SLA

#pragma pack()

#endif /* _SESDEF_H */
