        Include Segments.Inc              ; Segment definitions
        Include 386.Inc                   ; 80386 defs
        Include AbMac.Inc                 ; Common macros
        Include DevHlp.Inc                ; Device Help definitions
        Include ..\..\include\DevSym.inc  ; Device command symbols
        Include defs.inc
        Include os2int.inc                ; os2 sensitive stuff
        include ssskpi.h

Public fUISInit
Public IDCEntryPointList
Public SecHlpUISEPList
Public UISNAME

Data32 Segment
fUISInit        db 0              ; Are we ready yet???
Data32 Ends



Code16  Segment
Assume DS:MainData, ES:MainData


;-----------------------------------------------------------------------------
; Function : USHORT SSSKPIINIT (void)
;
; This function is invoked when all the device drivers have been initialized.
; See file strat.asm for details on how this function is invoked.
;
;-----------------------------------------------------------------------------
SSSKPIINIT      Proc Near Public

        call    GetIDCEntryPoint        ; gets protect and real mode offsets and selectors
        or      ax,ax
        jnz     SSE
        call    GetSecHlpUISEPList      ; gets the offsets and the selectors of the UIS helper functions
        @FlatES
        mov     fUISInit, 1
        mov     ax,ds
        mov     es,ax
        ASSUME  ES:MainData

SSE:    mov     ax, STDON               ; send the done bit to OS/2
        ret

SSSKPIINIT      EndP



;----------------------------------------------------------------------------
; Function : USHORT GetIDCEntryPoint(void)
;
; This function returns the protect mode code segment and offset of the
; IDC Entry Point. The values are stored in the IDCEntryPointList structure.
; The layout of this structure is as shown
;
;       Real Mode Offset of IDC Entry Point             Word
;       Real Mode CS Segment of IDC Entry Point         Word
;       Real Mode DS of IDC Device Driver               Word
;       Protect Mode Offset of IDC Entry Point          Word
;       Protect Mode CS Segment of IDC Entry Point      Word
;       Protect Mode DS of IDC Device Driver            Word
;
; The following registers are used in this call
;
; BX -> Offset of Device Driver Name
; DI -> Offset of structure
;
; Carry flag is set if there is an error. Register AX will contain possible
; return error.
;
;----------------------------------------------------------------------------
GetIDCEntryPoint        Proc    Near    Public

        push    ebx
        push    edi

        mov     bx, Offset MainData:UISNAME
        mov     di, Offset MainData:IDCEntryPointList
        @DevHlp DevHlp_AttachDD
        jc      error
        xor     ax,ax

error:
        pop     edi
        pop     ebx
        Ret

GetIDCEntryPoint        EndP



;----------------------------------------------------------------------------
; Function : USHORT GetSecHlpUISEpList (void)
;
; This function imports the Code segents and the offsets of the UIS KPI calls.
; It makes a call to the IDC Service Routine which then fills up the
; SecHlpUISEPList structure with the Code segments and the offsets of the 16
; bit UIS KPI calls. The address of the SecHlpUISEPList is passed on the
; stack.
;
;----------------------------------------------------------------------------
GetSecHlpUISEPList Proc Near Public

        push    cx

        lea     ecx, Offset MainData:IDCEntryPointList
        push    Offset ds:SecHlpUISEPList

        call    dword ptr [ecx+6]        ; call Far IDC_Service_Routine
        add     esp, 2                   ; clear stack

        pop     cx
        mov     ax, 00h
        Ret

GetSecHlpUISEPList EndP

Code16  EndS


Code32  Segment
Assume DS:FLAT, ES:FLAT, FS:NOTHING, GS:NOTHING



;-----------------------------------------------------------------------------
; Function : SecHlpQuerySubjectHandle
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> PID
; EDX -> TID
; ECX -> ULONG
; ESP+10h -> PHSUBJECT
;
;-----------------------------------------------------------------------------
SecHlpQuerySubjectHandle Proc Near Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      qh_error
        push    ebx

        mov     bx, MainData             ; get  16 bit data segment
        mov     ds, bx
Assume DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        push    [esp+14h]                ; set up stack for the fourth parameter
        sub     esp, 0Ch                 ; rest of the parameters passed in reg
        call    dword ptr [ebx]
        add     esp, 10h

        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx

        jmp     short qh_exit

qh_error:
; 108006 @RM. Store a value of zero in PHSUBJECT, if error.
        mov     DWORD ptr [esp+10],0     ; Return a 0 UIS handle
        xor     eax,eax                  ; OK return code

qh_exit:
        ret

SecHlpQuerySubjectHandle EndP


;-----------------------------------------------------------------------------
; Function : SecHlpQuerySubjectInfo
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> PID
; EDX -> TID
; ECX -> ULONG
; ESP+10h -> PSUBJECTINFO
;
;-----------------------------------------------------------------------------
SecHlpQuerySubjectInfo        Proc    Near    Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      QUI_Error
        push    ebx

        mov     bx, MainData             ; get  16 bit data segment
        mov     ds, bx
Assume DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        push    [esp+14h]                ; set up stack for the fourth parameter
        sub     esp, 0Ch                 ; rest of the parameters passed in reg
        call    dword ptr [ebx+4]
        add     esp, 10h

        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short QUI_Exit

QUI_Error:
        mov     eax,1                        ; Set RC

QUI_Exit:
        ret

SecHlpQuerySubjectInfo        EndP


;-----------------------------------------------------------------------------
; Function : SecHlpQueryContextStatus
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> PID
; EDX -> TID
; ECX -> PULONG
;
;-----------------------------------------------------------------------------
SecHlpQueryContextStatus       Proc    Near    Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      QA_Error

        push    ebx

        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        sub     esp, 0Ch
        call    dword ptr [ebx+8]
        add     esp, 0Ch

        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short QA_Exit

QA_Error :
        mov     eax,1

QA_Exit:
        RET

SecHlpQueryContextStatus       EndP


;-----------------------------------------------------------------------------
; Function : SecHlpQuerySecurityContext
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> PID
; EDX -> TID
; ECX -> PSESATTRIB
;
;-----------------------------------------------------------------------------
SecHlpQuerySecurityContext      Proc    Near    Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      QAT_Error

        push    ebx
        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        sub     esp, 0Ch
        call    dword ptr [ebx+0Ch]
        add     esp, 0Ch

        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short QAT_Exit

QAT_Error:
        mov     eax,1

QAT_Exit:
        RET

SecHlpQuerySecurityContext      EndP


;-----------------------------------------------------------------------------
; Function : SecHlpQuerySubjectHandleInfo
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> HSUBJECT
; EDX -> PSUBJECTINFO
;
;-----------------------------------------------------------------------------
SecHlpQuerySubjectHandleInfo       Proc  Near   Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      QQN_Error

        push    ebx
        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        sub     esp, 08h
        call    dword ptr [ebx+10h]
        add     esp, 08h

        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short QQN_Exit


QQN_Error:
        mov     eax,1

QQN_Exit:
        RET

SecHlpQuerySubjectHandleInfo       EndP



;-----------------------------------------------------------------------------
; Function : SecHlpSetSubjectHandle
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> PID
; EDX -> TID
; ECX -> ULONG
; ESP+10h -> HSUBJECT
;
;-----------------------------------------------------------------------------
SecHlpSetSubjectHandle       Proc  Near   Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      SUH_Error

        push    ebx
        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        push    [esp+14h]                ; set up stack for the fourth parameter
        sub     esp, 0Ch                 ; rest of the parameters passed in reg
        call    dword ptr [ebx+14h]
        add     esp, 10h

;        mov     bx, FLAT:GDTArray[FLATDATA]
        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short SUH_Exit


SUH_Error:
        mov     eax,1

SUH_Exit:
        RET

SecHlpSetSubjectHandle       EndP



;-----------------------------------------------------------------------------
; Function : SecHlpSetSecurityContext
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> PID
; EDX -> TID
; ECX -> PSESATTRIB
;
;-----------------------------------------------------------------------------
SecHlpSetSecurityContext       Proc  Near   Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      SUA_Error

        push    ebx
        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        sub     esp, 0Ch
        call    dword ptr [ebx+18h]
        add     esp, 0Ch

;        mov     bx, FLAT:GDTArray[FLATDATA]
        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short SUA_Exit


SUA_Error:
        mov     eax,1

SUA_Exit:
        RET

SecHlpSetSecurityContext      EndP




;-----------------------------------------------------------------------------
; Function : SecHlpSetContextStatus
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> PID
; EDX -> TID
; ECX -> ULONG
;
;-----------------------------------------------------------------------------
SecHlpSetContextStatus       Proc  Near   Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      SCS_Error

        push    ebx
        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        sub     esp, 0Ch
        call    dword ptr [ebx+1Ch]
        add     esp, 0Ch

;        mov     bx, FLAT:GDTArray[FLATDATA]
        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short SCS_Exit


SCS_Error:
        mov     eax,1

SCS_Exit:
        RET

SecHlpSetContextStatus      EndP



;-----------------------------------------------------------------------------
; Function : SecHlpResetThreadContext
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> PID
; EDX -> TID
; ECX -> ULONG
; ESP+10h -> ULONG
;
;-----------------------------------------------------------------------------
SecHlpResetThreadContext       Proc  Near   Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      RTC_Error

        push    ebx
        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        push    [esp+14h]                ; set up stack for the fourth parameter
        sub     esp, 0Ch                 ; rest of the parameters passed in reg
        call    dword ptr [ebx+20h]
        add     esp, 10h

;        mov     bx, FLAT:GDTArray[FLATDATA]
        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short RTC_Exit


RTC_Error:
        mov     eax,1

RTC_Exit:
        RET

SecHlpResetThreadContext      EndP


;-----------------------------------------------------------------------------
; Function : SecHlpQueryAuthorityID
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> PID
; EDX -> TID
; ECX -> ULONG
;
;-----------------------------------------------------------------------------
SecHlpQueryAuthorityID       Proc  Near   Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      QAI_Error

        push    ebx
        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        sub     esp, 0Ch
        call    dword ptr [ebx+24h]
        add     esp, 0Ch

;        mov     bx, FLAT:GDTArray[FLATDATA]
        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short QAI_Exit


QAI_Error:
        mov     eax,1

QAI_Exit:
        RET

SecHlpQueryAuthorityID      EndP



;-----------------------------------------------------------------------------
; Function : SecHlpSetAuthorityID
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> PID
; EDX -> TID
; ECX -> ULONG
;
;-----------------------------------------------------------------------------
SecHlpSetAuthorityID       Proc  Near   Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      SAI_Error

        push    ebx
        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        sub     esp, 0Ch
        call    dword ptr [ebx+28h]
        add     esp, 0Ch

;        mov     bx, FLAT:GDTArray[FLATDATA]
        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short SAI_Exit


SAI_Error:
        mov     eax,1

SAI_Exit:
        RET

SecHlpSetAuthorityID      EndP



;-----------------------------------------------------------------------------
; Function : SecHlpReserveHandle
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> USHORT
; EDX -> USHORT
; ECX -> SESHANDLE
;
;-----------------------------------------------------------------------------
SecHlpReserveHandle       Proc  Near   Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      RH_Error

        push    ebx
        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        sub     esp, 0Ch
        call    dword ptr [ebx+2Ch]
        add     esp, 0Ch

;        mov     bx, FLAT:GDTArray[FLATDATA]
        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short RH_Exit


RH_Error:
        mov     eax,1

RH_Exit:
        RET

SecHlpReserveHandle      EndP



;-----------------------------------------------------------------------------
; Function : SecHlpReleaseHandle
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the UIS KPI calls and restored after
; the UISKPI calls. The arguments stored in the registers are shown below
;
; EAX -> USHORT
; EDX -> USHORT
; ECX -> SESHANDLE
;
;-----------------------------------------------------------------------------
SecHlpReleaseHandle       Proc  Near   Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      RLH_Error

        push    ebx
        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        sub     esp, 0Ch
        call    dword ptr [ebx+30h]
        add     esp, 0Ch

;        mov     bx, FLAT:GDTArray[FLATDATA]
        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short RLH_Exit


RLH_Error:
        mov     eax,1

RLH_Exit:
        RET

SecHlpReleaseHandle      EndP


;-----------------------------------------------------------------------------
; Function : SecHlpSetChildSecurityContext
;
; The parameters passed in the SecHlp calls are stored in registers instead
; of being pushed on to the stack. ( The stack however does allocate space
; for these parameters.). The data segment
; and extra segment are saved before the KPI calls and restored after
; the KPI calls. The arguments stored in the registers are shown below
;
; EAX -> PSESATTRIB
;
;-----------------------------------------------------------------------------
SecHlpSetChildSecurityContext       Proc  Near   Public

Assume  DS:FLAT
        cmp     fUISInit,0
        jz      CSC_Err

        push    ebx
        mov     bx, MainData
        mov     ds, bx
Assume  DS:MainData
        mov     ebx, Offset MainData:SecHlpUISEPList

        sub     esp, 04h
        call    dword ptr [ebx].Offset_SetChildSecurityContext
        add     esp, 04h

        mov     bx, seg FLAT:Data32
        mov     ds, bx
Assume  DS:FLAT

        pop     ebx
        jmp     short CSC_Exit

CSC_Err:
        mov     eax,1

CSC_Exit:
        RET

SecHlpSetChildSecurityContext      EndP


Code32  EndS
          End
