/*------------------------------------------------------------------------*\
|                                                                          |
|           LISTEA.CMD   - Version 1.2 - Version Date 1995-02-18           |
|                 Copyright (C) 1994 by C F S Nevada, Inc.                 |
|                                                                          |
|                  by Dick Goran  - Voice    702-732-9616                  |
|                                 - FAX      702-732-3847                  |
|                                 - CIS      71154,2002                    |
|                                 - Internet 71154.2002@compuserve.com     |
|                                                                          |
| ------------------------------------------------------------------------ |
|  REXXLIB.DLL  - OS/2 REXX external function library                      |
|                 (c) Copyright 1992-94 Quercus Systems                    |
\*------------------------------------------------------------------------*/
/*
     This program will build a file, LISTEA.TXT, in the same directory
     where this program resides. This file will contain a text listing
     of all of the Extended Attributes (in both hex and character
     notation) for all directories and files in the object system
     except that REXX metafiles are not detailed and non-local drives
     are ignored.

     Two temporary work files, SYS001 and SYS002, area created in the
     same directory where LISTEA.CMD resides while the program is
     running. They are erased on completion.

     This program may take a considerable amount of time to run
     depending on the speed of the system and the number of files to
     be processed.

     The file created by this program, LISTEA.TXT, will be large (2 MB
     - 3 MB) and can be viewed with any viewer or ASCII editor capable
     of handling large files.

     An index list of the EA names encountered is included at the end
     of LISTEA.TXT with the name of a file which contains this EA.
     Also, the number of times that that EA type occurs in the system
     is indicated.

Updates:
         94/01/12 - Eliminate non LOCAL drives
         94/01/21 - Minor changes
         94/02/04 - Check floppies & check for NOTREADY with DOSDISK()
         94/04/07 - Do not put unused drives in title line
   1.1   94/12/31 - Warp DIR output variances
   1.2   95/02/18 - NLS date parsng variances
*/
parse Version         REXX_Version .                              /* 0048 */
parse Source          OS_Name,                                    /* 0049 */
                      Calling_Environment,                        /* 0050 */
                      program_path_and_name                       /* 0051 */
GBL.environment     = 'OS2ENVIRONMENT'                            /* 0052 */
GBL.boot_drive      = LEFT( VALUE( 'RUNWORKPLACE',, GBL.environment ), 2 )
GBL.program_name    = FILESPEC( 'N', program_path_and_name )      /* 0054 */
GBL.program_path    = FILESPEC( 'D', program_path_and_name ) ||,  /* 0055 */
                      FILESPEC( 'P', program_path_and_name )      /* 0056 */
GBL.program_version = 1.1           /* version / mod of this program */
call TIME 'E'                       /* set elapsed timer - sssss.uuuuu */
                                                                  /* 0059 */
say 'Begin' GBL.program_name 'at' TIME('N')                       /* 0060 */
call REGISTER_REQUIRED_FUNCTIONS                                  /* 0061 */
                                                                  /* 0062 */
   SIGNAL ON ERROR                  /* trap object time errors     */
   SIGNAL ON FAILURE                /* trap object time errors     */
   SIGNAL ON HALT                   /* trap object time errors     */
   SIGNAL ON NOVALUE                /* trap object time errors     */
   SIGNAL ON SYNTAX                 /* trap object time errors     */
                                                                  /* 0068 */
/*-------------------------------*\                               /* 0069 */
|  Retrieve NLS dependent values  |                               /* 0070 */
\*-------------------------------*/                               /* 0071 */
GBL.sDate_character =,                                            /* 0072 */
   STRIP( SysIni( 'USER', 'PM_National', 'sDate' ), 'T', '00'x )  /* 0073 */
                                                                  /* 0074 */
/*----------------------------*\                                  /* 0075 */
|  Define output & work files  |                                  /* 0076 */
\*----------------------------*/                                  /* 0077 */
output_file = GBL.program_path || 'LISTEA.TXT'                    /* 0078 */
output_disk = TRANSLATE( FILESPEC( 'D', output_file ) )           /* 0079 */
call SysFileDelete output_file                                    /* 0080 */
output_file_line_count = 0                                        /* 0081 */
free_space = DOSDISK( 'F', output_disk )                          /* 0082 */
if free_space < (2 * 1024 * 1024) then                            /* 0083 */
   do                                                             /* 0084 */
      call LINEOUT 'CON:',,                                       /* 0085 */
               'WARNING! There may not be adequate free space on drive ' ||,
               output_disk || '.'                                 /* 0087 */
      call LINEOUT 'CON:',,                                       /* 0088 */
               '         However, program will continue.'         /* 0089 */
   end                                                            /* 0090 */
                                                                  /* 0091 */
SYS001 = GBL.program_path || 'LISTEA.SY1' /* directory lines              */
SYS002 = GBL.program_path || 'LISTEA.SY2' /* ea file size & full name     */
                                                                  /* 0094 */
/*-------------------------------*\                               /* 0095 */
|  Table & constant declarations  |                               /* 0096 */
\*-------------------------------*/                               /* 0097 */
call INITIALIZE                     /* setup tables & constants           */
output_width  = 76                  /* output page max line width         */
ea_max_length = 0                   /* length of longest name             */
                                                                  /* 0101 */
/* signal PROCESS_SYS002 */         /* for test use only */       /* 0102 */
                                                                  /* 0103 */
/*------------------------------------*\                          /* 0104 */
|  Put EA file size & names in SYS002  |                          /* 0105 */
\*------------------------------------*/                          /* 0106 */
say 'Sorting directory & file names'                              /* 0107 */
call SysFileDelete SYS002                                         /* 0108 */
do w = 1 to WORDS(drive_table)                                    /* 0109 */
   call PROCESS_DRIVE  WORD( drive_table, w )                     /* 0110 */
end                                                               /* 0111 */
call STREAM SYS002, 'C', 'CLOSE'                                  /* 0112 */
                                                                  /* 0113 */
/*---------------------------------------*\                       /* 0114 */
|  Sort and write all EAs to output file  |                       /* 0115 */
\*---------------------------------------*/                       /* 0116 */
PROCESS_SYS002:                                                   /* 0117 */
file_table. = ''                    /* initialize array */        /* 0118 */
file_table_max_length = 0                                         /* 0119 */
e = 0                                                             /* 0120 */
do while LINES(SYS002) > 0                                        /* 0121 */
   e = e + 1                                                      /* 0122 */
   input_line = LINEIN(SYS002)                                    /* 0123 */
   file_table.e = input_line                                      /* 0124 */
   file_table_max_length = MAX( file_table_max_length,,           /* 0125 */
                                LENGTH( WORD( input_line, 2 ) ) ) /* 0126 */
end                                                               /* 0127 */
call STREAM SYS002, 'C', 'CLOSE'                                  /* 0128 */
                                                                  /* 0129 */
file_table.0 = e                                                  /* 0130 */
call ARRAYSORT 'file_table', 1, file_table.0,,                    /* 0131 */
                                10, file_table_max_length         /* 0132 */
                                                                  /* 0133 */
call CHAROUT 'CON:', 'Building ' ||,                              /* 0134 */
                     output_file ||,                              /* 0135 */
                     COPIES( ' ', 2 )                             /* 0136 */
title = 'Listing of EAs on Drives ' ||,                           /* 0137 */
        title                                                     /* 0138 */
heading.1 =,                                                      /* 0139 */
         DATE('O') ||,                                            /* 0140 */
         COPIES( ' ', 2 ) ||,                                     /* 0141 */
         TIME('N')                                                /* 0142 */
space_count = output_width - LENGTH(heading.1) - LENGTH(title)  /* 940204 */
if space_count < 1 then space_count = 1                         /* 940204 */
heading.1 = heading.1 ||,                                         /* 0145 */
         COPIES( ' ', space_count ) ||,                           /* 0146 */
         title                                                    /* 0147 */
call LINEOUT output_file, heading.1 || '0D0A'x                    /* 0148 */
                                                                  /* 0149 */
bksp = '08'x                                                      /* 0150 */
progress_list = '\|/'                                            /* 0151 */
progress_subscript = 1                                            /* 0152 */
do e = 1 to file_table.0                                          /* 0153 */
   call FORMAT_EA_ITEM file_table.e                               /* 0154 */
   call CHAROUT 'CON:', bksp ||,                                  /* 0155 */
                       SUBSTR( progress_list, progress_subscript, 1 )
   progress_subscript = progress_subscript + 1                    /* 0157 */
   if progress_subscript > LENGTH(progress_list) then             /* 0158 */
      progress_subscript = 1                                      /* 0159 */
end                                                               /* 0160 */
call LINEOUT 'CON:', bksp || ' '                                  /* 0161 */
                                                                  /* 0162 */
/*--------------------------------------*\                        /* 0163 */
|  Write sorted EA index to output file  |                        /* 0164 */
\*--------------------------------------*/                        /* 0165 */
heading.2 =,                                                      /* 0166 */
   '0C'x ||,                                                      /* 0167 */
   CENTER( 'EA Index List', output_width )                        /* 0168 */
call LINEOUT output_file,  heading.2 ||,                          /* 0169 */
                           '0D0A'x                                /* 0170 */
                                                                  /* 0171 */
output_line = LEFT( 'EA Name', 22 ) ||,                           /* 0172 */
              LEFT( 'Type',     8 ) ||,                           /* 0173 */
              LEFT( 'Ct.',      7 ) ||,                           /* 0174 */
              'Example'                                           /* 0175 */
call LINEOUT output_file, output_line                             /* 0176 */
                                                                  /* 0177 */
output_line = COPIES( '-', 19 ) ||,                               /* 0178 */
              COPIES( ' ',  3 ) ||,                               /* 0179 */
              COPIES( '-',  4 ) ||,                               /* 0180 */
              COPIES( ' ',  4 ) ||,                               /* 0181 */
              COPIES( '-',  4 ) ||,                               /* 0182 */
              COPIES( ' ',  3 ) ||,                               /* 0183 */
              COPIES( '-', 39 )                                   /* 0184 */
call LINEOUT output_file, output_line                             /* 0185 */
                                                                  /* 0186 */
call ARRAYSORT 'ea_table', 1, ea_table.0                          /* 0187 */
do i = 1 to ea_table.0                                            /* 0188 */
   parse value ea_table.i with ea_name ea_hex_value ea_example    /* 0189 */
   output_line = LEFT( ea_name, 22) ||,                           /* 0190 */
                 C2X( ea_hex_value ) ||,                          /* 0191 */
                 COPIES( ' ', 3 ) ||,                             /* 0192 */
                 FORMAT( ea_table.ea_name, 5 ) ||,                /* 0193 */
                 COPIES( ' ', 3 ) ||,                             /* 0194 */
                 ea_example                                       /* 0195 */
   call WRITE_OUTPUT_FILE output_line                             /* 0196 */
end                                                               /* 0197 */
call STREAM output_file, 'C', 'CLOSE'                             /* 0198 */
                                                                  /* 0199 */
call SysFileDelete SYS001           /* erase work files                   */
call SysFileDelete SYS002                                         /* 0201 */
                                                                  /* 0202 */
call EOJ 0                                                        /* 0203 */
                                                                  /* 0204 */
!tr!=VALUE('TRACE',,'OS2Environment'); if !tr!<>'' then do;TRACE(!tr!);nop;end
/*------------------------------------------------------------------------*\
|                                                                          |
|                                End of Job                                |
|                                                                          |
\*------------------------------------------------------------------------*/
EOJ:                                                              /* 0211 */
   Procedure                                                      /* 0212 */
                                                                  /* 0213 */
if ARG() = 0 then                                                 /* 0214 */
   eoj_rc = 0                                                     /* 0215 */
else                                                              /* 0216 */
   eoj_rc = ARG(1)                                                /* 0217 */
                                                                  /* 0218 */
elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu */
parse value elapsed_time with seconds '.' micro_seconds           /* 0220 */
if SUBSTR( micro_seconds, 1, 1 ) >= 5 then                        /* 0221 */
   seconds = seconds + 1                                          /* 0222 */
ss = FORMAT( seconds // 60, 2 )                                   /* 0223 */
minutes = ( seconds - ss ) / 60                                   /* 0224 */
mm = FORMAT( minutes // 60, 2 )                                   /* 0225 */
hh = FORMAT( ( minutes - mm ) / 60, 2 )                           /* 0226 */
duration = hh':'mm':'ss                                           /* 0227 */
                                                                  /* 0228 */
parse Source   . . program_path_and_name                          /* 0229 */
program_name = FILESPEC( 'N', program_path_and_name )             /* 0230 */
say 'EOJ  ' program_name 'at' TIME('N') ||,                       /* 0231 */
    ', duration' TRANSLATE( duration, '0', ' ' )                  /* 0232 */
exit eoj_rc                                                       /* 0233 */
                                                                  /* 0234 */
/*------------------------------------------------------------------------*\
|                                                                          |
|          Get each EA and write to output file & build EA matrix          |
|                                                                          |
\*------------------------------------------------------------------------*/
FORMAT_EA_ITEM:                                                   /* 0240 */
   Procedure expose,                                              /* 0241 */
      ea_max_length,                                              /* 0242 */
      ea_table.,                                                  /* 0243 */
      GBL.program_name,                                           /* 0244 */
      output_file,                                                /* 0245 */
      output_file_line_count,                                     /* 0246 */
      contig_hex_tt,                                              /* 0247 */
      spread_hex_tt,                                              /* 0248 */
      SYS001 SYS002,                                              /* 0249 */
      tt_128                                                      /* 0250 */
                                                                  /* 0251 */
parse arg file_size file_name                                     /* 0252 */
file_name = STRIP(file_name)                                      /* 0253 */
crlf = '0D0A'x                                                    /* 0254 */
                                                                  /* 0255 */
ea_count = DOSEALIST( file_name, 'name_stem', 'value_stem', 'flag_stem' )
if ea_count > 0 then                                             /* 0257 */
   do                                                             /* 0258 */
      say '0D0A'x || 'DOSEALIST unexpected return code of ' ||,   /* 0259 */
          ea_count                                                /* 0260 */
      say '   for' file_name                                      /* 0261 */
      say '   Data for above file will not appear in ' ||,        /* 0262 */
          FILESPEC( 'N', output_file )                            /* 0263 */
      return                                                      /* 0264 */
   end                                                            /* 0265 */
                                                                  /* 0266 */
do i = 1 to name_stem.0                                           /* 0267 */
   name = STRIP( name_stem.i, 'L', '.' )                          /* 0268 */
                                                                  /* 0269 */
   /*------------------------*\                                   /* 0270 */
   |  Write Formatted output  |                                   /* 0271 */
   \*------------------------*/                                   /* 0272 */
   output_line = file_name                                        /* 0273 */
   if file_size = '<DIR>' then                                    /* 0274 */
      do                                                          /* 0275 */
         output_line = output_line || ' <DIR>'                    /* 0276 */
      end                                                         /* 0277 */
                                                                  /* 0278 */
   list_name_only = 0                                             /* 0279 */
   if ( LEFT( name, 5 ) = 'REXX.' ) |,                            /* 0280 */
         ( name = 'ICON' ) then                                   /* 0281 */
      do                                                          /* 0282 */
         list_name_only = 1                                       /* 0283 */
      end                                                         /* 0284 */
                                                                  /* 0285 */
   if list_name_only = 1 then                                     /* 0286 */
      if i = 1 then                                               /* 0287 */
         do                                                       /* 0288 */
            if output_file_line_count > 0 then                    /* 0289 */
               output_line = crlf || output_line /* preceed with blank line */
            call WRITE_OUTPUT_FILE output_line                    /* 0291 */
         end                                                      /* 0292 */
      else                                                        /* 0293 */
         nop                                                      /* 0294 */
   else                                                           /* 0295 */
      do                                                          /* 0296 */
         if output_file_line_count > 0 then                       /* 0297 */
            output_line = crlf || output_line /* preceed with blank line */
         call WRITE_OUTPUT_FILE output_line                       /* 0299 */
      end                                                         /* 0300 */
                                                                  /* 0301 */
   output_line = COPIES( ' ', 3 ) ||,                             /* 0302 */
                 LEFT( 'Flag = ''' || C2X(flag_stem.i) || '''x', 15) ||,
                 'Name = ' ||,                                    /* 0304 */
                 LEFT( name_stem.i, 35 ) ||,                      /* 0305 */
                 'Length = ''' ||,                                /* 0306 */
                 D2X( LENGTH(value_stem.i), 4 ) ||,               /* 0307 */
                 '''x'                                            /* 0308 */
   call WRITE_OUTPUT_FILE output_line                             /* 0309 */
                                                                  /* 0310 */
   if list_name_only = 0 then                                     /* 0311 */
      do                                                          /* 0312 */
         call FORMAT_EA_DETAIL  value_stem.i                      /* 0313 */
      end                                                         /* 0314 */
                                                                  /* 0315 */
   /*---------------------------------*\                          /* 0316 */
   |  Cross index EA name in EA table  |                          /* 0317 */
   \*---------------------------------*/                          /* 0318 */
   if ea_table.name = '' then                                     /* 0319 */
      do                                                          /* 0320 */
         e = ea_table.0 + 1                                       /* 0321 */
         ea_table.0 = e                                           /* 0322 */
         ea_table.e = name,                                       /* 0323 */
                      SUBSTR( value_stem.i, 2, 1 ) ||,            /* 0324 */
                      SUBSTR( value_stem.i, 1, 1 ),               /* 0325 */
                      file_name                                   /* 0326 */
         ea_table.name = 1                                        /* 0327 */
         if LENGTH(name) > ea_max_length then                     /* 0328 */
            ea_max_length = LENGTH(name)                          /* 0329 */
      end                                                         /* 0330 */
   else                                                           /* 0331 */
      do                                                          /* 0332 */
         ea_table.name = ea_table.name + 1                        /* 0333 */
      end                                                         /* 0334 */
                                                                  /* 0335 */
end                                                               /* 0336 */
                                                                  /* 0337 */
return                                                            /* 0338 */
                                                                  /* 0339 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                     Format hex & character EA detail                     |
|                                                                          |
\*------------------------------------------------------------------------*/
FORMAT_EA_DETAIL:                                                 /* 0345 */
   Procedure expose,                                              /* 0346 */
      output_file,                                                /* 0347 */
      output_file_line_count,                                     /* 0348 */
      GBL.program_name,                                           /* 0349 */
      contig_hex_tt,                                              /* 0350 */
      spread_hex_tt,                                              /* 0351 */
      SYS001 SYS002,                                              /* 0352 */
      tt_128                                                      /* 0353 */
                                                                  /* 0354 */
ea_data               = ARG(1)                                    /* 0355 */
hex_displacement      = 0                                         /* 0356 */
prev_character_string = ''                                        /* 0357 */
sameness_switch       = 0                                         /* 0358 */
                                                                  /* 0359 */
do until ea_data = ''                                             /* 0360 */
   parse value ea_data with leading_token 17 ea_data              /* 0361 */
                                                                  /* 0362 */
   temp_character_string = LEFT( leading_token, 16 )              /* 0363 */
   if temp_character_string <> prev_character_string then         /* 0364 */
      do                                                          /* 0365 */
         temp_hex_string = TRANSLATE( spread_hex_tt,,             /* 0366 */
                                      C2X(temp_character_string),,
                                      contig_hex_tt )             /* 0368 */
         word_count = ( LENGTH(leading_token) - 1 ) % 4           /* 0369 */
         byte_count = LENGTH(leading_token) - ( 4 * word_count )  /* 0370 */
         temp_hex_length = ( 9 * word_count ) + ( 2 * byte_count )
         output_line = COPIES( ' ', 10 ) ||,                      /* 0372 */
                       '+' || D2X( hex_displacement, 4 ) ||,      /* 0373 */
                       COPIES( ' ', 3 ) ||,                       /* 0374 */
                       '| ' ||,                                   /* 0375 */
                       LEFT( temp_hex_string, temp_hex_length ) ||,
                       COPIES( ' ', 35 - temp_hex_length ) ||,    /* 0377 */
                       ' |' ||,                                   /* 0378 */
                       COPIES( ' ', 3 ) ||,                       /* 0379 */
                       TRANSLATE( temp_character_string, tt_128 ) /* 0380 */
         call WRITE_OUTPUT_FILE output_line                       /* 0381 */
         sameness_switch = 0                                      /* 0382 */
      end                                                         /* 0383 */
   else                                                           /* 0384 */
      if sameness_switch = 0 then                                 /* 0385 */
         do                                                       /* 0386 */
            output_line = COPIES( ' ', 10 ) ||,                   /* 0387 */
                          '+' || D2X( hex_displacement, 4 ) ||,   /* 0388 */
                          COPIES( ' ', 3 ) ||,                    /* 0389 */
                          '| ' ||,                                /* 0390 */
                          LEFT( 'same', 35 ) ||,                  /* 0391 */
                          ' |'                                    /* 0392 */
            call WRITE_OUTPUT_FILE output_line                    /* 0393 */
            sameness_switch = 1                                   /* 0394 */
         end                                                      /* 0395 */
                                                                  /* 0396 */
   hex_displacement = hex_displacement + 16                       /* 0397 */
   prev_character_string = temp_character_string                  /* 0398 */
end                                                               /* 0399 */
return                                                            /* 0400 */
                                                                  /* 0401 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                       Initialize translate tables                        |
|                                                                          |
\*------------------------------------------------------------------------*/
INITIALIZE:                                                       /* 0407 */
   Procedure expose,                                              /* 0408 */
      contig_hex_tt,                                              /* 0409 */
      drive_table,                                                /* 0410 */
      ea_table.,                                                  /* 0411 */
      heading.,                                                   /* 0412 */
      hex_tt,                                                     /* 0413 */
      GBL.program_name,                                           /* 0414 */
      output_width,                                               /* 0415 */
      output_file,                                                /* 0416 */
      spread_hex_tt,                                              /* 0417 */
      title,                                                      /* 0418 */
      tt_128,                                                     /* 0419 */
      tt_256                                                      /* 0420 */
                                                                  /* 0421 */
drive_table  = SysDriveMap( 'A', 'LOCAL' )                        /* 0422 */
ea_table.    = ''; ea_table.0   = 0                               /* 0423 */
output_width = 76                   /* output page max line width         */
title = ''                                                        /* 0425 */
                                                                  /* 0426 */
hex_tt = COPIES( '00'x, 256 )                                     /* 0427 */
hex_tt = OVERLAY( XRANGE('30'x, '39'x), hex_tt, X2D(30) + 1 ) /* 0 - 9    */
hex_tt = OVERLAY( XRANGE('41'x, '46'x), hex_tt, X2D(41) + 1 ) /* A - F    */
hex_tt = OVERLAY( XRANGE('41'x, '46'x), hex_tt, X2D(61) + 1 ) /* a - f    */
                                                                  /* 0431 */
/* used for hex display of data */                                /* 0432 */
contig_hex_tt = XRANGE('01'x, '21'x)                              /* 0433 */
spread_hex_tt = XRANGE('01'x, '08'x) || '21'x ||,                 /* 0434 */
                XRANGE('09'x, '10'x) || '21'x ||,                 /* 0435 */
                XRANGE('11'x, '18'x) || '21'x ||,                 /* 0436 */
                XRANGE('19'x, '20'x)                              /* 0437 */
                                                                  /* 0438 */
tt_128 = COPIES( '.', 32 ) || XRANGE('20'X, '7F'X) || COPIES( '.', 128 )
tt_256 = '2E01 0203 0405 062E 2E2E 2E0B 0C2E 0E0F'X ||,           /* 0440 */
         '1011 1213 1415 1617 1819 1A2E 1C1D 1E1F'X ||,           /* 0441 */
         XRANGE('20'X, 'FE'X) || '.'                              /* 0442 */
return                                                            /* 0443 */
                                                                  /* 0444 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                Build Work File 02 From Directory Entries                 |
|                                                                          |
\*------------------------------------------------------------------------*/
PROCESS_DRIVE:                                                    /* 0450 */
   Procedure expose,                                              /* 0451 */
      GBL. SYS001 SYS002 title                                    /* 0452 */
                                                                  /* 0453 */
drive = ARG(1)                                                    /* 0454 */
notready_switch = ''                                              /* 0455 */
call ON NOTREADY name DRIVE_NOTREADY                              /* 0456 */
call STREAM drive || '*', 'D'       /* check for not ready */     /* 0457 */
call OFF NOTREADY                                                 /* 0458 */
if notready_switch <> '' then                                     /* 0459 */
   do                                                             /* 0460 */
      say '   Drive ' ||,                                         /* 0461 */
          drive ||,                                               /* 0462 */
          ' is not ready and is being ignored.'                   /* 0463 */
      return                                                      /* 0464 */
   end                                                            /* 0465 */
                                                                  /* 0466 */
/* ignore drives which are not ready */                         /* 940204 */
if DOSDISK( 'T', drive ) = -1 then                              /* 940204 */
   do                                                           /* 940204 */
      say '   Drive ' ||,                                         /* 0470 */
          drive ||,                                               /* 0471 */
          ' is not ready and will be ignored.'                    /* 0472 */
      return                                                      /* 0473 */
   end                                                            /* 0474 */
                                                                  /* 0475 */
/* ignore CD-ROM drives */                                      /* 940204 */
if DOSFILESYS(drive) = 'CDFS' then                              /* 940204 */
   do                                                           /* 940204 */
      say '   Drive ' ||,                                       /* 940204 */
          drive ||,                                               /* 0480 */
          ' is a CD-ROM and will be ignored.'                     /* 0481 */
      return                                                      /* 0482 */
   end                                                            /* 0483 */
                                                                  /* 0484 */
title = title STRIP(drive)                                        /* 0485 */
say '   Drive ' ||,                                               /* 0486 */
    drive ||,                                                     /* 0487 */
    ' is being read to extract EAs.'                              /* 0488 */
'@dir' drive || '\*.* /s /n /o:n 1>' SYS001                       /* 0489 */
                                                                  /* 0490 */
directory_of_constant = 'Directory of '                           /* 0491 */
do while LINES(SYS001) > 0                                        /* 0492 */
   directory_line = LINEIN(SYS001)                                /* 0493 */
                                                                  /* 0494 */
   parse value directory_line with . (directory_of_constant) directory_of_value
   if directory_of_value <> '' then                               /* 0496 */
      do                                                          /* 0497 */
         path_name = directory_of_value                           /* 0498 */
         if RIGHT( path_name, 1 ) <> '\' then                     /* 0499 */
            path_name = path_name || '\'                          /* 0500 */
         iterate                                                  /* 0501 */
      end                                                         /* 0502 */
   if ( SUBSTR( directory_line, 3, 1 ) <> GBL.sDate_character )  |,
      ( SUBSTR( directory_line, 6, 1 ) <> GBL.sDate_character ) then iterate
   parse var directory_line,                                      /* 0505 */
              file_date,                                          /* 0506 */
              file_time,                                          /* 0507 */
              file_size,                                          /* 0508 */
              file_ea_size,                                       /* 0509 */
              file_name                                           /* 0510 */
   if file_ea_size = 0 then iterate                               /* 0511 */
   if ( file_name = '.' )  |,                                     /* 0512 */
      ( file_name = '..' ) then iterate                           /* 0513 */
   full_file_name = path_name ||,                                 /* 0514 */
                    STRIP(file_name)                              /* 0515 */
   output_line = LEFT( file_size, 9 ) ||,                         /* 0516 */
                 full_file_name                                   /* 0517 */
   call LINEOUT SYS002, output_line                               /* 0518 */
end                                                               /* 0519 */
call STREAM SYS001, 'C', 'CLOSE'                                  /* 0520 */
call SysFileDelete SYS001                                         /* 0521 */
return                                                            /* 0522 */
                                                                  /* 0523 */
DRIVE_NOTREADY:                                                   /* 0524 */
   Procedure expose notready_switch                               /* 0525 */
notready_switch = 1                                               /* 0526 */
return                                                            /* 0527 */
                                                                  /* 0528 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                   Register external function routines                    |
|                                                                          |
\*------------------------------------------------------------------------*/
REGISTER_REQUIRED_FUNCTIONS:                                      /* 0534 */
   Procedure expose REXX_Version                                  /* 0535 */
                                                                  /* 0536 */
/*----------------------------------------*\                      /* 0537 */
|  Load REXXUtil External Function Module  |                      /* 0538 */
\*----------------------------------------*/                      /* 0539 */
function_name      = 'SysLoadFuncs'                               /* 0540 */
entry_name         = 'SysLoadFuncs'                               /* 0541 */
module             = 'RexxUtil'                                   /* 0542 */
anticipated_return = ''                                           /* 0543 */
call REGISTER_ROUTINE function_name module entry_name anticipated_return
                                                                  /* 0545 */
/*-----------------------------------*\                           /* 0546 */
|  Load the REXXLIB Function Package  |                           /* 0547 */
\*-----------------------------------*/                           /* 0548 */
if REXX_Version = 'REXX/Personal' then                            /* 0549 */
   do                                                             /* 0550 */
      module = 'qrexxlib'                                         /* 0551 */
   end                                                            /* 0552 */
else                                                              /* 0553 */
   do                                                             /* 0554 */
      module = 'rexxlib'                                          /* 0555 */
   end                                                            /* 0556 */
entry_name         = 'rexxlibregister'                            /* 0557 */
function_name      = 'RexxLibRegister'                            /* 0558 */
anticipated_return = '1'                                          /* 0559 */
call REGISTER_ROUTINE function_name module entry_name anticipated_return
return                                                            /* 0561 */
                                                                  /* 0562 */
                                                                  /* 0563 */
REGISTER_ROUTINE:                                                 /* 0564 */
parse ARG  function_name,                                         /* 0565 */
           module,                                                /* 0566 */
           entry_name,                                            /* 0567 */
           anticipated_return                                     /* 0568 */
                                                                  /* 0569 */
if RxFuncQuery(function_name) = 0 then return      /* function registered */
                                                                  /* 0571 */
if LENGTH(module) > 8 then                                        /* 0572 */
   do                                                             /* 0573 */
      dll_drive = FILESPEC( 'D', module )                         /* 0574 */
      dll_path  = STRIP( FILESPEC( 'P', module ), 'T', '\' )      /* 0575 */
      module    = FILESPEC( 'N', module )                         /* 0576 */
      '@' || dll_drive                                            /* 0577 */
      '@cd' dll_drive || dll_path                                 /* 0578 */
   end                                                            /* 0579 */
else                                                              /* 0580 */
   do                                                             /* 0581 */
      dll_drive = ''                                              /* 0582 */
   end                                                            /* 0583 */
                                                                  /* 0584 */
parse var module module_fname '.' module_fext                     /* 0585 */
if RxFuncAdd( function_name, module_fname, entry_name ) = 0 then  /* 0586 */
   do                                                             /* 0587 */
      register_call = 'call' function_name                        /* 0588 */
      interpret register_call                                     /* 0589 */
      if WORD( RESULT, 1 ) <> WORD( anticipated_return, 1 ) then  /* 0590 */
         do                                                       /* 0591 */
            Say function_name 'returned' RESULT '-',              /* 0592 */
                                         anticipated_return 'was expected'
            exit 255                                              /* 0594 */
         end                                                      /* 0595 */
   end                                                            /* 0596 */
else                                                              /* 0597 */
   do                                                             /* 0598 */
      Say 'RxFuncAdd returned' RESULT 'registering' module        /* 0599 */
      exit 254                                                    /* 0600 */
   end                                                            /* 0601 */
if dll_drive <> '' then                                           /* 0602 */
   do                                                             /* 0603 */
      '@' || LEFT( GBL.program_path_and_name, 2 )                 /* 0604 */
   end                                                            /* 0605 */
return                                                            /* 0606 */
                                                                  /* 0607 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                              Trap Routines                               |
|                                                                          |
\*------------------------------------------------------------------------*/
ERROR:   call TRAP_PROCESSING SIGL, 'ERROR',   RC                 /* 0613 */
FAILURE: call TRAP_PROCESSING SIGL, 'FAILURE', RC                 /* 0614 */
HALT:    call TRAP_PROCESSING SIGL, 'HALT',    ''                 /* 0615 */
NOVALUE: call TRAP_PROCESSING SIGL, 'NOVALUE', ''                 /* 0616 */
SYNTAX:  call TRAP_PROCESSING SIGL, 'SYNTAX',  RC                 /* 0617 */
                                                                  /* 0618 */
/* Rev. 94/06/14 */                                               /* 0619 */
TRAP_PROCESSING:                                                  /* 0620 */
   parse Source . . TRAP.path_and_program                         /* 0621 */
   if POS( ':', TRAP.path_and_program ) > 0 then                  /* 0622 */
      /* get source line if it is available */                    /* 0623 */
      do                                                          /* 0624 */
         trap_source_line = STRIP( SOURCELINE(ARG(1)) )           /* 0625 */
      end                                                         /* 0626 */
   else                                                           /* 0627 */
      /* program is running in macrospace */                      /* 0628 */
      do                                                          /* 0629 */
         TRAP.path_and_program = VALUE( 'TEMP',, 'OS2ENVIRONMENT' ) ||,
                                 TRAP.path_and_program            /* 0631 */
         trap_source_line = 'Source line is not available.'       /* 0632 */
      end                                                         /* 0633 */
                                                                  /* 0634 */
   parse value FILESPEC( 'N', TRAP.path_and_program ) with,       /* 0635 */
      TRAP.fn '.' TRAP.fe                                         /* 0636 */
   trap_file_name = FILESPEC( 'D', TRAP.path_and_program ) ||,    /* 0637 */
                    FILESPEC( 'P', TRAP.path_and_program ) ||,    /* 0638 */
                    TRAP.fn || '.' || 'DMP'                       /* 0639 */
                                                                  /* 0640 */
   /*------------------------------------------*\                 /* 0641 */
   |  check for reason not to create .DMP file  |                 /* 0642 */
   \*------------------------------------------*/                 /* 0643 */
   if ARG(2) = 'HALT',                                            /* 0644 */
         |,                                                       /* 0645 */
      RxFuncQuery( 'VARDUMP' ) <> 0,                              /* 0646 */
         |,                                                       /* 0647 */
      POS( ':', trap_file_name ) = 0 then                         /* 0648 */
      do                                                          /* 0649 */
         trap_file_name = ''                                      /* 0650 */
      end                                                         /* 0651 */
                                                                  /* 0652 */
   /*------------------------*\                                   /* 0653 */
   |  Build trap message box  |                                   /* 0654 */
   \*------------------------*/                                   /* 0655 */
   dbl.h    = 'CD'x                 /*  double line - horizontal   */
   dbl.v    = 'BA'x                 /*  double line - vertical     */
   dbl.bl   = 'C8'x                 /*  double line - bottom left  */
   dbl.br   = 'BC'x                 /*  double line - bottom right */
   dbl.tl   = 'C9'x                 /*  double line - top left     */
   dbl.tr   = 'BB'x                 /*  double line - top right    */
   say ' '                                                        /* 0662 */
   trap_error_description =,                                      /* 0663 */
      'Error line = ' || ARG(1) ||,                               /* 0664 */
      '; ' ||,                                                    /* 0665 */
      ARG(2) ||,                                                  /* 0666 */
      ' error.'                                                   /* 0667 */
   if ARG(3) <> '' then                                           /* 0668 */
      trap_error_description = trap_error_description ||,         /* 0669 */
                               '  Return code = ' || ARG(3)       /* 0670 */
   say dbl.tl || COPIES( dbl.h, LENGTH(trap_error_description) + 2 ) || dbl.tr
   say dbl.v  || COPIES( ' ',   LENGTH(trap_error_description) + 2 ) || dbl.v
   say dbl.v               trap_error_description                       dbl.v
   if trap_file_name <> '' then                                   /* 0674 */
      do                                                          /* 0675 */
   say dbl.v  || COPIES( ' ',   LENGTH(trap_error_description) + 2 ) || dbl.v
   say dbl.v     CENTER( 'See: ' || trap_file_name,,              /* 0677 */
                                      LENGTH(trap_error_description) )  dbl.v
      end                                                         /* 0679 */
   say dbl.v  || COPIES( ' ',   LENGTH(trap_error_description) + 2 ) || dbl.v
   say dbl.bl || COPIES( dbl.h, LENGTH(trap_error_description) + 2 ) || dbl.br
   say ' '                                                        /* 0682 */
   say 'Source line at time of trap:'                             /* 0683 */
   say '   ' || trap_source_line                                  /* 0684 */
   say ' '                                                        /* 0685 */
                                                                  /* 0686 */
   /*---------------------------------*\                          /* 0687 */
   |  Create .DMP file if appropriate  |                          /* 0688 */
   \*---------------------------------*/                          /* 0689 */
   if trap_file_name <> '' then                                   /* 0690 */
      do                                                          /* 0691 */
         call SysFileDelete trap_file_name                        /* 0692 */
         /* remove meaningless labels from dump for clarity */    /* 0693 */
         drop dbl. TRAP. RC RESULT SIGL !tr!                      /* 0694 */
         call VARDUMP trap_file_name  /* write variables to program.DMP file */
      end                                                         /* 0696 */
   exit -254                                                      /* 0697 */
                                                                  /* 0698 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                   Write output line & tally line count                   |
|                                                                          |
\*------------------------------------------------------------------------*/
WRITE_OUTPUT_FILE:                                                /* 0704 */
   Procedure expose,                                              /* 0705 */
      GBL.program_name,                                           /* 0706 */
      output_file,                                                /* 0707 */
      output_file_line_count,                                     /* 0708 */
      SYS001 SYS002                                               /* 0709 */
                                                                  /* 0710 */
output_file_line_count = output_file_line_count + 1               /* 0711 */
call LINEOUT output_file, ARG(1)                                  /* 0712 */
if RESULT <> 0 then                                               /* 0713 */
   do                                                             /* 0714 */
      call LINEOUT 'CON:', '0D0A'x ||,                            /* 0715 */
                           'Error writing line number ' ||,       /* 0716 */
                           output_file_line_count ||,             /* 0717 */
                           ' to ' ||,                             /* 0718 */
                           output_file || '.'                     /* 0719 */
      call LINEOUT 'CON:', 'Possibly insufficient disk space.'    /* 0720 */
      call LINEOUT 'CON:', 'Work files - ' ||,                    /* 0721 */
                           SYS001 || ' & ' || SYS002 ||,          /* 0722 */
                           ' not erased.'                         /* 0723 */
      call EOJ 255                                                /* 0724 */
   end                                                            /* 0725 */
return                                                            /* 0726 */
/*---------  REXX Cross Reference  - Created: 03/12/95 4:42pm ----------*\
    J:\REXXPROG\LISTEA\LISTEA.CMD - Directory time stamp 12/31/94 5:07p

---- VARIABLES ----
!tr!                0205<  0205   0205   0694
Calling_Environment
                    0050
DRIVE_NOTREADY      0456
GBL.                0452
GBL.boot_drive      0053<
GBL.environment     0052<  0053
GBL.program_name    0054<  0060   0244   0349   0414   0706
GBL.program_path    0055<  0078   0092   0093
GBL.program_path_and_name
                    0604
GBL.program_version
                    0057<
GBL.sDate_character
                    0072<  0503   0504
OS_Name             0049
RC                  0613   0614   0617   0694
RESULT              0590   0592   0599   0694   0713
REXX_Version        0048   0535   0549
SIGL                0613   0614   0615   0616   0617   0694
SYS001              0092<  0200   0249   0352   0452   0489   0492   0493
                    0520   0521   0709   0722
SYS002              0093<  0108   0112   0121   0123   0128   0201   0249
                    0352   0452   0518   0709   0722
TRAP.               0694
TRAP.fe             0636
TRAP.fn             0636   0639
TRAP.path_and_program
                    0621   0622   0630<  0631   0635   0637   0638
Version             0048
X                   0439   0439   0440   0441   0442   0442
anticipated_return  0543<  0544   0559<  0560   0568   0590   0593
bksp                0150<  0155   0161
byte_count          0370<  0371
contig_hex_tt       0247   0350   0368   0409   0433<
crlf                0254<  0290   0298
dbl.                0694
dbl.bl              0658<  0681
dbl.br              0659<  0681
dbl.h               0656<  0671   0681
dbl.tl              0660<  0671
dbl.tr              0661<  0671
dbl.v               0657<  0672   0672   0673   0673   0676   0676   0677
                    0678   0680   0680
directory_line      0493<  0495   0503   0504   0505
directory_of_constant
                    0491<  0495
directory_of_value  0495   0496   0498
dll_drive           0574<  0577   0578   0582<  0602
dll_path            0575<  0578
drive               0454<  0457   0462   0468   0471   0477   0480   0485
                    0487   0489
drive_table         0109   0110   0410   0422<
duration            0227<  0232
e                   0120<  0122<  0122   0130   0153   0321<  0322
ea_count            0256<  0257   0260
ea_data             0355<  0360   0361   0361
ea_example          0189   0195
ea_hex_value        0189   0191
ea_max_length       0100<  0242   0328   0329<
ea_name             0189   0190
ea_table.           0243   0411   0423<
ea_table.0          0187   0188   0321   0322<  0423<
ea_table.e          0323<
ea_table.ea_name    0193
ea_table.i          0189
ea_table.name       0319   0327<  0333<  0333
elapsed_time        0219<  0220
entry_name          0541<  0544   0557<  0560   0567   0586
eoj_rc              0215<  0217<  0233
file_date           0506
file_ea_size        0509   0511
file_name           0252   0253<  0253   0256   0261   0273   0326   0510
                    0512   0513   0515
file_size           0252   0274   0508   0516
file_table.         0118<
file_table.0        0130<  0131   0153
file_table.e        0124<  0154
file_table_max_length
                    0119<  0125<  0125   0132
file_time           0507
flag_stem.i         0303
free_space          0082<  0083
full_file_name      0514<  0517
function_name       0540<  0544   0558<  0560   0565   0570   0586   0588
                    0592
heading.            0412
heading.1           0139<  0143   0145<  0145   0148
heading.2           0166<  0169
hex_displacement    0356<  0373   0388   0397<  0397
hex_tt              0413   0427<  0428<  0428   0429<  0429   0430<  0430
hh                  0226<  0227
i                   0188   0267   0287
input_line          0123<  0124   0126
leading_token       0361   0363   0369   0370
list_name_only      0279<  0283<  0286   0311
micro_seconds       0220   0221
minutes             0224<  0225   0226
mm                  0225<  0226   0227
module              0542<  0544   0551<  0555<  0560   0566   0572   0574
                    0575   0576<  0576   0585   0599
module_fext         0585
module_fname        0585   0586
name                0268<  0280   0281   0323   0328   0329   0456
name_stem.0         0267
name_stem.i         0268   0305
notready_switch     0455<  0459   0525   0526<
output_disk         0079<  0082   0087
output_file         0078<  0079   0080   0135   0148   0169   0176   0185
                    0198   0245   0263   0347   0416   0707   0712   0719
output_file_line_count
                    0081<  0246   0289   0297   0348   0708   0711<  0711
                    0717
output_line         0172<  0176   0178<  0185   0190<  0196   0273<  0276<
                    0276   0290<  0290   0291   0298<  0298   0299   0302<
                    0309   0372<  0381   0387<  0393   0516<  0518
output_width        0099<  0143   0168   0415   0424<
path_name           0498<  0499   0500<  0500   0514
prev_character_string
                    0357<  0364   0398<
program_name        0230<  0231
program_path_and_name
                    0051   0054   0055   0056   0229   0230
progress_list       0151<  0156   0158
progress_subscript  0152<  0156   0157<  0157   0158   0159<
register_call       0588<  0589
sameness_switch     0358<  0382<  0385   0394<
seconds             0220   0222<  0222   0223   0224
space_count         0143<  0144   0144   0146
spread_hex_tt       0248   0351   0366   0417   0434<
ss                  0223<  0224   0227
temp_character_string
                    0363<  0364   0367   0380   0398
temp_hex_length     0371<  0376   0377
temp_hex_string     0366<  0376
title               0137<  0138   0143   0147   0418   0425<  0452   0485<
                    0485
trap_error_description
                    0663<  0669<  0669   0671   0672   0673   0676   0678
                    0680   0681
trap_file_name      0637<  0648   0650<  0674   0677   0690   0692   0695
trap_source_line    0625<  0632<  0684
tt_128              0250   0353   0380   0419   0439<
tt_256              0420   0440<
value_stem.i        0307   0313   0324   0325
w                   0109   0110
with                0189   0220   0361   0495   0635
word_count          0369<  0370   0371
x                   0073   0148   0150   0167   0170   0254   0259   0427
                    0428   0428   0429   0429   0430   0430   0433   0433
                    0434   0434   0434   0435   0435   0435   0436   0436
                    0436   0437   0437   0656   0657   0658   0659   0660
                    0661   0715

---- LABELS ----
DRIVE_NOTREADY      0524:
EOJ                 0203   0211:  0724
ERROR               0063   0613:
FAILURE             0064   0614:
FORMAT_EA_DETAIL    0313   0345:
FORMAT_EA_ITEM      0154   0240:
HALT                0065   0615:
INITIALIZE          0098   0407:
NOVALUE             0066   0616:
OFF                 0458
ON                  0456
PROCESS_DRIVE       0110   0450:
PROCESS_SYS002      0117:
REGISTER_REQUIRED_FUNCTIONS
                    0061   0534:
REGISTER_ROUTINE    0544   0560   0564:
SYNTAX              0067   0617:
TRAP_PROCESSING     0613   0614   0615   0616   0617   0620:
WRITE_OUTPUT_FILE   0196   0291   0299   0309   0381   0393   0704:

---- FUNCTIONS ----
ARG                 0214   0217   0355   0454   0625   0644   0664   0666
                    0668   0670   0712
ARRAYSORT           0131   0187
C2X                 0191   0303   0367
CENTER              0168   0677
CHAROUT             0134   0155
COPIES              0136   0141   0146   0178   0179   0180   0181   0182
                    0183   0184   0192   0194   0302   0372   0374   0377
                    0379   0387   0389   0427   0439   0439   0671   0672
                    0676   0680   0681
D2X                 0307   0373   0388
DATE                0140
DOSDISK             0082   0468
DOSEALIST           0256
DOSFILESYS          0477
FILESPEC            0054   0055   0056   0079   0230   0263   0574   0575
                    0576   0635   0637   0638
FORMAT              0193   0223   0225   0226
LEFT                0053   0172   0173   0174   0190   0280   0303   0305
                    0363   0376   0391   0516   0604
LENGTH              0126   0143   0143   0158   0307   0328   0329   0369
                    0370   0572   0671   0672   0676   0678   0680   0681
LINEIN              0123   0493
LINEOUT             0085   0088   0148   0161   0169   0176   0185   0518
                    0712   0715   0720   0721
LINES               0121   0492
MAX                 0125
OVERLAY             0428   0429   0430
POS                 0622   0648
RIGHT               0499
RxFuncAdd           0586
RxFuncQuery         0570   0646
SOURCELINE          0625
STREAM              0112   0128   0198   0457   0520
STRIP               0073   0253   0268   0485   0515   0575   0625
SUBSTR              0156   0221   0324   0325   0503   0504
SysDriveMap         0422
SysFileDelete       0080   0108   0200   0201   0521   0692
SysIni              0073
TIME                0058   0060   0142   0219   0231
TRACE               0205
TRANSLATE           0079   0232   0366   0380
VALUE               0053   0205   0630
VARDUMP             0695
WORD                0110   0126   0590   0590
WORDS               0109
X2D                 0428   0429   0430
XRANGE              0428   0429   0430   0433   0434   0435   0436   0437
                    0439   0442

\*-------------------  End of REXX Cross Reference  -------------------*/
