/*file: bpl.c
 *	(c) 1989, Phinloda and SHU (FMR version)
 *
 *	PC98, 286, 386, 486 ..:-) J3100, FMR version
 *		Borland C++ v3.1 (Borland JAPAN)
 *
 *	890911	v1
 *	890912	v2		option v, t, h
 *	890913	v3		bug fix
 *	890915	v4		send ACK for all packet / reenter filename
 *	890915	v5		re-enter when downloading
 *	890916	v6		DEBUG mode modification
 *	890916	v7		support 300, 1200 bps
 *	890918	v8		exit when 1st B session end
 *	890918	v9		restore messages to Japanese
 *	890918	v10		rename b.c from bp.c
 *	890930	v11		remove bplus.c
 *	891001	v12		fix v11 bugs
 *	891005	v13		fix v12 bugs, rename to bpl.exe
 *	891007	v14		time estimate
 *	891009	v15		estimate
 *	891014	v16		TI packet
 *	891014	v17		my_bplus_entry changed
 *	900225	v18		-a, d, e options
 *	900303	v19		-a debug, adjust file name if it is invalid
 *	900303	v20		change -h message
 *	900303	v21		BPL= environment bug, -d bug
 *	900305	v22		-d bug
 *	900306	v23		-t bug, change bytes, time message
 *	900430	v24		-a, upload
 *	900512	v25
 *	900516	v26		-o Flying-B+ :-)
 *	900520	v27		full rewriting
 *	900525	v28		+ packet bug, some messages
 *	900526	v29		time estimation bug
 *	900606	v30		-p option (FMR)
 *	900607	v31		-p option (J3100)
 *	900608	v32		-1, -3 bug
 *	900609	v33		FMR rsraw setup
 *	900610	v34		-i option
 *	900623	v35		FMR debug
 *	900628	v36		Failue packet bug
 *	900817	v36a	@ˑ𕪗 (M.Aza)
 *	900907	v37		test version (UNIX only)
 *	901105	v38		copy_body() bug fix
 *	901127	v39		check over-run
 *	901229	v40		dubug!, change the method of packet allocation
 *	901230	v41		numeric optoin, change _stklen
 *	910103	v42		file size message
 *	910105	v43		English version
 *	910115	v44		initiator mode, resume upload
 *	910122	v45		time stump, stopchar
 *	910127	v46		pc98, RTS flow control
 *	910129	v47		debug, 
 *	910215	v48		upload retry bug
 *	911209	v49		resume download bug
 *  920714	v50		resume downlodo bug
 *	920823	v51		compiled with ..
 *	921212	v52		-j option
 *	930728	v53		bug fix
 *	930818	v54		B16/32 only
 *	940604	v55		available to set quote characters
 *	950429	v56		make log, merge UNIX version
 *	950430	v57		debug, logname
 *          v58     test version
 *  950828  v59     2KB packet, speed_limit, bplexec.c big change
 *  950908  v60     CCITT CRC16, 32
 *          v61     test version
 *  951021  v62     upload retry bug fix, UNIX -ps option (stdio mode)
 */

#include <stdio.h>
#include <stdlib.h> /* malloc */
#include <string.h> /* strlen */
#include <time.h>

#include "bpl.h"
#include "machine.h"

#define	MYBUFSIZE	4096
#define	MYDIRSIZE	256

#define DEFAULT_BLOCK_SIZE 16 /* 2048 bytes */

#ifdef __TURBOC__
extern unsigned _stklen = 10000; /* default is 4096 */
static char borlandc_copyright_notice[] =
	"Compiled with Borland C++\n"
	"(Borland C++  Version 3.1 Copyright (c) 1991 Borland International)\n";
#endif

extern int com_send(unsigned char ch);
extern int com_setup(char *s, unsigned int size);
extern int execute_bpl_session(APPL_PARAM *);
extern void com_close(void);

void bpllog(char *s);
void log_control(int sw);
void charwarn(int c);
void strwarn(char *s);
void charout(int c);
void strout(char *s);
void nolog_strout(char *s);
void flushmsg(void);
void decout(int i);
void ldecout(unsigned long l);
static void log_time(void);
static int compare_string(char *s1, char *s2);
static int numeric_option(char *s);
static int set_options(char *s);
static void add_filename_list(char *name);
static void options(int argc, char *argv[]);
static void checkenv(char *env[]);

extern char rsraw_id_string[]; /* defined in rsraw.c */
extern char rsraw_writers[]; /* defined in rsraw.c */

static FNAME_LIST *last = NULL;
static char	mybuf[MYBUFSIZE] = {
	0, /* port number */
	1, /* flow-control */
	0, /* hard flow-control */
	0, /* default = 11 (2400 bps) */
	0  /* default = 16 (packet size = 2048 bytes) */
};

static APPL_PARAM my_param = {
	0, /* append_mode */
	DEFAULT_BLOCK_SIZE, /* block_size */
	-1, /* est_interval */
	FLAGS_SKIPENQ|FLAGS_ONLY_ONCE|FLAGS_SETFTIME, /* flags */
	0xff, /* maskchar */
	0, /* speed_limit */
	1, /* verbose */
	NULL, /* dirname */
	"bpllog.log", /* syslog */
	{0x14, 0x00, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00}, /* quote character set */
	NULL, /* syslog_fp */
	NULL /* fname_list */
};

static char mydir[MYDIRSIZE];
static char	version[] = "BPL.EXE v62, by Phinloda\n";
static int init_code = 0;
static int log_on = 0;
static int send_ctrlq = 0;
static int silent = 0;

#ifdef USE_STDIO
#define MSG_FP	stderr
#else
#define MSG_FP	stdout
#endif

#ifdef	DEBUG
FILE *debug_fp = NULL;
#endif

#define	STS_IS_NORMAL 0
#define	NEXT_ARG_IS_DIR 1

#ifdef JAPANESE

/* set_options() */
#define str_unknown_opt1 "IvV "
#define str_unknown_opt2 " ͉߂ł܂\n"
#define str_usage "\ng: bpl [-IvV] [t@C]\n"

/* add_filename_list() */
#define str_out_of_memory "܂\n"

/* main() */
#define str_bpl_start "|BPL Jn|\n"
#define str_bpl_end "|BPL I|\n"

#else

#define str_unknown_opt1 "Unknown option (-"
#define str_unknown_opt2 ")\n"
#define str_usage "\nUsage: bpl [-OPTIONS] [filename]\n"
#define str_out_of_memory "Out of memory\n"
#define str_bpl_start "- BPL start -\n"
#define str_bpl_end "- BPL end -\n"

#endif

/*-------------------------------------------------------------------*/
/*  system log
 */
static void log_time(void)
{
	struct tm *lt;
	time_t t;

	t = time(NULL);
	lt = localtime(&t);

	fprintf(my_param.syslog_fp, "%d-%02d-%02d %02d:%02d:%02d> ",
		lt->tm_year + 1900, lt->tm_mon + 1, lt->tm_mday,
		lt->tm_hour, lt->tm_min, lt->tm_sec);
}

void bpllog(char *s)
{
#define LOG_BUFFER_SIZE 80
	static char log_buffer[LOG_BUFFER_SIZE];

	if (log_on && my_param.syslog_fp != NULL) {
		int linefeed = 0;

		if (strchr(s, '\n') == NULL) {
			if (strlen(log_buffer) + strlen(s) < LOG_BUFFER_SIZE) {
				strcat(log_buffer, s);
				return;
			}
			linefeed = 1;
		}

		log_time();
		fputs(log_buffer, my_param.syslog_fp);
		fputs(s, my_param.syslog_fp);
		if (linefeed) {
			putc('\n', my_param.syslog_fp);
		}

		*log_buffer = '\0';

#ifdef DEBUG
		fclose(my_param.syslog_fp);
		my_param.syslog_fp = fopen(my_param.syslog, "a");
#endif
	}
}

void log_control(int sw)
{
	log_on = sw;
}

#ifndef USE_ORIGNAL_CONSOLE_FUNC

/*--------------------------------------------------------------------*/
void charwarn(int c)
{
	static char buf[2] = {0, 0};

	putc(c, stderr);
	buf[0] = (char) c;
	bpllog(buf);
}

/*--------------------------------------------------------------------*/
void strwarn(char *s)
{
	fputs(s, stderr);
	bpllog("warning: ");
	bpllog(s);
}

/*--------------------------------------------------------------------*/
void charout(int c)
{
	static char buf[2] = {0, 0};

	putc(c, MSG_FP);
	buf[0] = (char) c;
	bpllog(buf);
}

/*--------------------------------------------------------------------*/
void strout(char *s)
{
	fputs(s, MSG_FP);
	bpllog(s);
}

/*--------------------------------------------------------------------*/
void nolog_strout(char *s)
{
	fputs(s, MSG_FP);
}

/*--------------------------------------------------------------------*/
void flushmsg(void)
{
	fflush(MSG_FP);
}

/*--------------------------------------------------------------------*/
/*	printout decimal integer
 *	not thinking about when i == -32768
 */
void decout(int i)
{
	char buf[12];

	sprintf(buf, "%d", i);
	strout(buf);
}

/*--------------------------------------------------------------------*/
/*	printout decimal long
 */
void ldecout(unsigned long l)
{
	char buf[12];

	sprintf(buf, "%ld", l);
	strout(buf);
}

#endif

/*--------------------------------------------------------------------*/
/* 󔒂܂ł̕rB
 */
static int compare_string(char *s1, char *s2)
{
	char c1;
	char c2;

	do {
		c1 = *s1++;
		if (c1 == ' ' || c1 == '\t')
			c1 = (char) 0;
		c2 = *s2++;
		if (c2 == ' ' || c2 == '\t')
			c2 = (char) 0;
	} while ((c1 == c2) && (c1 != (char) 0));

	return (int) c1 - c2;
}

/*--------------------------------------------------------------------*/
static char *speed_table[] = {
	"1S50",
	"1S75",
	"1S110",
	"1S134",
	"1S150",
	"1S200",
	"1S300",
	"2S600",
	"4S1200",
	"6S1800",
	"8S2400",
	"8S4800",
	"8S9600",
	"8S19200",
	"8S38400",

	"1P128",
	"2P256",
	"4P512",
	"8P1024",
	NULL
};

static int numeric_option(char *s)
{
	char **table;
	int i;

	i = 0;
	for (table = speed_table; *table != NULL; table++) {
		if (compare_string(s, *table + 2) == 0) {
			if (*(*table + 1) == 'S') {
				mybuf[3] = i + 1; /* speed */
				if (mybuf[4])
					goto skip;
			}
			my_param.block_size = mybuf[4] = **table - '0';
skip:
			return 1;
		}
		i++;
	}
	return 0;
}

/*--------------------------------------------------------------------*/
static int get_syslogname(char *s)
{
	char *tmp;
	char *head;
	int i;

	s++;
	head = s;
	for (i = 0; *s && (*s != ' ') && (*s != '\t'); s++)
		i++;

	if (i) {
		tmp = malloc(i + 1);
		if (tmp == NULL) {
			strwarn(str_out_of_memory);
			exit(2);
		}
		strncpy(tmp, head, i);
		tmp[i] = '\0';
		my_param.syslog = tmp;
	}
	return i + 1; /* skip '=' */
}

/*--------------------------------------------------------------------*/
/*	return value
 *		0	nothing special
 *		1	next argument is directory name
 */
static int set_options(char *s)
{
	char c;
	int i;
	int mode;
	int sts = STS_IS_NORMAL;

	while ((c = *s) != 0) {
		if (c >= '0' && c <= '9') {
			i = numeric_option(s);
			if (i) {
				while (*s >= '0' && *s <= '9')
					s++;
				continue;
			}
		}

		s++;

		if (c >= 'A' && c <= 'Z')
			c += 'a' - 'A';
		switch (c) {
#ifdef	DEBUG
		case 'z':
			my_param.verbose = 3;
			break;
#endif

		case 'a': /* append mode */
			my_param.append_mode = 1;
			break;

		case 'b': /* binary */
			my_param.flags |= FLAGS_BINARY;
			break;

		case 'c':
			my_param.flags &= ~FLAGS_ONLY_ONCE;
			break;

		case 'd': /* set directory */
		case 'u': /* currently dummy .. */
			if (*s == ' ')
				s++; /* ? */

			if (*s) {
				for (i = 0; i < MYDIRSIZE - 1; i++) {
					if (*s == '\0')
						break;
					if (*s == ' ') {
						s++;
						break;
					}
					mydir[i] = *s++;
				}
				mydir[i] = '\0';
				my_param.dirname = (UCHAR *) mydir;
			}
			else {
				sts = NEXT_ARG_IS_DIR;
			}
			break;

		case 'e':
			my_param.flags &= ~FLAGS_SKIPENQ;
			if (*s == '=') {
				s++;
				if (s[0] == '^' && s[1] == 'j') {
					s += 2;
					init_code = 0x0a;
				} else {
					init_code = 0x0d;
				}
			}
			break;

		case 'f': /* force */
			my_param.flags |= FLAGS_FORCE;
			break;

		case 'i': /* interval, or initiator */
			if (*s >= '0' && *s <= '9') {
				my_param.est_interval = *s - '0';
				s++;
			}
#ifdef WITH_INITIATOR
			else {
				my_param.flags |= FLAGS_INITIATOR;
				if (*s == 'u') {
					my_param.flags |= FLAGS_UPLOAD;
					s++;
				}
			}
#endif
			break;

		case 'j': /* look */
			my_param.flags &= ~FLAGS_SETFTIME;
			break;

		case 'k': /* set quote table 940604 */
			for (i = 0; i < 16; i++, s++) {
				int value;

				if (*s >= '0' && *s <= '9') {
					value = *s - '0';
				} else if (*s >= 'A' && *s <= 'F') {
					value = *s - 'A' + 10;
				} else if (*s >= 'a' && *s <= 'f') {
					value = *s - 'a' + 10;
				} else {
					break;
				}

				if (i & 1) { /* i == 1,3,5.. */
					my_param.quote[i/2] = (UCHAR) (c + value);
				} else { /* i == 0,2,4.. */
					c = value << 4;
				}
			}
			break;

		case 'l': /* look */
			if (*s == 'o' || *s == 'O') {
				char c;

				c = s[1];
				if (c == 'g' || c == 'G') {
					s += 2;
					my_param.flags |= FLAGS_SYSLOG;

					if (*s == '=') {
						s += get_syslogname(s);
					}
					break;
				}
			}
			my_param.verbose |= 4;
			break;

		case 'n': /* No flow control in com_send */
			mybuf[1] = 0;
			break;
#if 0
		case 'o': /* flying CRC */
			my_param.flags |= FLAGS_FLY;
			break;
#endif
		case 'p': /* change communication Port */
			if (*s >= '0' && *s <= '9') { /* 920808 i */
				mybuf[0] = (char) (*s - '0');
				s++;
#ifdef UNIX
			} else if (*s == 's') {
				mybuf[0] = (char) 0xff;
				s++;
#endif
			} else {
				mybuf[0] = (char) 1;
			}
			break;

		case 'q': /* ^Q */
			send_ctrlq = 1;
			break;

#ifdef WITH_RESUME
		case 'r': /* Resume */
			my_param.flags |= FLAGS_RESUME;
			break;
#endif

		case 't': /* terse */
			my_param.verbose = 0;
			/* fall into next case */

		case 's': /* silent */
			silent = 1;
			break;

		case 'v': /* verbose */
			my_param.verbose |= 2;
			break;

		case 'w': /* block width */
		case 'x': /* speed limit */
			{
				int i = 0;

				while (*s >= '0' && *s <= '9') {
					i *= 10;
					i += (*s - '0');
					s++;
				}
				if (i) {
					if (c == 'w')
						my_param.block_size = mybuf[4] = i;
					else
						my_param.speed_limit = i;
				}
			}
			break;

		case '5': /* check CS */
			mybuf[2] = 1;
			break;

		case '7': /* mask parity */
			my_param.maskchar = 0x7f;
			break;

		case '-': /* ignore '-' */
		case ' ': /* ignore ' ' */
			break;

		default:
			strwarn(str_unknown_opt1);
			charwarn(c);
			strwarn(str_unknown_opt2);
			/* fall into next case */

#ifdef __TURBOC__
		case 'y':
			strwarn(borlandc_copyright_notice);
#endif
		case 'h': /* help */
			strwarn(version);
			strwarn("for CompuServe B Plus Protocol (SM)\n");
			strwarn(rsraw_id_string);
			strwarn(", rsraw.c by ");
			strwarn(rsraw_writers);
			strwarn(str_usage);
			exit(1);
		}
	}

	return sts;
}

/*--------------------------------------------------------------------*/
static void add_filename_list(char *name)
{
	FNAME_LIST *tmp;

	tmp = (FNAME_LIST *) malloc(strlen(name) + sizeof(FNAME_LIST));
	if (tmp == NULL) {
		strwarn(str_out_of_memory);
		exit(2);
	}

	tmp->next = NULL;
	strcpy(tmp->name, name);

	if (my_param.fnlist == NULL) {
		my_param.fnlist = tmp;
	}
	else {
		last->next = tmp;
	}

	last = tmp;
}

/*--------------------------------------------------------------------*/
static void options(int argc, char *argv[])
{
	char *s;
	int sts = 0;

	while (--argc > 0) {
		s = *++argv;
		if (sts == NEXT_ARG_IS_DIR) {
			sts = 0;
			my_param.dirname = (UCHAR *) s;
		}
		else {
			if (*s == '-') {
				sts = set_options(s);
			}
			else {
				add_filename_list(s);
			}
		}
	}

	if (mybuf[3] == 0)
		mybuf[3] = 11; /* default = 2400bps */
	if (mybuf[4] == 0)
		my_param.block_size = mybuf[4] = DEFAULT_BLOCK_SIZE;
			/* default = 2048 bytes */
}

/*--------------------------------------------------------------------*/
static void checkenv(char *env[])
{
	char *s;

	while ((s = *env++) != 0) {
		if (s[0] == 'B' && s[1] == 'P' && s[2] == 'L' && s[3] == '=') {
			set_options(s + 4);
		}
	}
}

/*--------------------------------------------------------------------*/
int main(int argc, char *argv[], char *env[])
{
	int sts;

	checkenv(env);
	options(argc, argv);

	/* com_setup G[ɂ͒f */
	if (com_setup(mybuf, MYBUFSIZE)) { /* setup interrupt vector */
		exit(1);
	}

	my_param.syslog_fp =
		(my_param.flags & FLAGS_SYSLOG) ?
		fopen(my_param.syslog, "a") : NULL;

	log_control(1);

	if (my_param.verbose) {
		strout(str_bpl_start);
	}

#ifdef	DEBUG
	debug_fp = NULL; /* 0 for LINUX ? */
	if (my_param.verbose > 2) {
		debug_fp = fopen("temp.dat", "wb");
	}
#endif

	if (init_code) {
		com_send((char) init_code);
	}

	sts = execute_bpl_session(&my_param);

#ifdef	DEBUG
	if (my_param.verbose > 2) {
		fclose(debug_fp);
	}
	debug_fp = fopen("buffer.dat", "wb");
	if (debug_fp) {
		fwrite(mybuf, 1, MYBUFSIZE, debug_fp);
		fclose(debug_fp);
	}
#endif

	if (send_ctrlq) {
		com_send((char) ('Q'-'@')); /* oops .. */
	}
	com_close(); /* restore interrupt vector */
	if (my_param.verbose > 0) {
		log_control(0);
		if (!silent)
			charout('G' - '@');
		charout('\n');
		log_control(1);
		strout(str_bpl_end);
	}

	if (my_param.syslog_fp != NULL) {
		fclose(my_param.syslog_fp);
	}

	return sts;
}
