/*
 *	910130 by Phinloda
 *	911209 long_to_str --> ULONG ɕύX
 *	940604 quote character [U[wł悤ɂB
 *  950825 2KB packet
 *  950829 slowdownŒf
 *	010106 OS/2 WarpΉ
 *
 * {vÓACompuserve B Plus Protocol (SM) ̈ꕔT|[g
 *
 * ҂̓sɂAB Plus ̎dlƂ͖֌WɈȉ̋@\ɒǉ
 * ĂBsKvȂĂCvg邱ƁB
 *
 *    Download ɁAt@Cւ̒ǉ (download - append mode)
 *    Upload ɁAt@C̃t@CƂ݂ȂĘA]
 *        (upload - append mode)
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "bpl.h"
#include "machine.h"

extern int com_length(void);
extern int com_recv(void);
extern int com_send(int c);
extern int get_file_information(char *filename, long info[]);
extern int kbd_check(void);
extern int second(void);
extern int set_file_time(char *file, long info[]);
extern void com_rts_off(void);
extern void com_rts_on(void);
extern void decout(int i);
extern void hms(UCHAR *s);
extern void ldecout(ULONG l);
extern void flushmsg(void);
extern void bpllog(char *s);
extern void log_control(int i);

#ifdef SUN403
extern int fclose(FILE *stream);
extern int fseek(FILE *stream, long int offset, int origin);
extern int printf(char *format, ...);
extern int unlink(char *path);
extern size_t fread(void *ptr, size_t size, size_t n, FILE *stream);
extern size_t fwrite(void *ptr, size_t size, size_t n, FILE *stream);
extern void *malloc(size_t);
extern void *memcpy(void *s1, void *s2, size_t n);
extern void free(void *ptr);
#endif

#ifndef SEEK_SET
#define SEEK_SET 0
#endif

extern void charout(int c); /* putchar(c) */
extern void strout(char *s); /* fputs(s, stdout) */
extern void nolog_strout(char *s);
extern void strwarn(char *s); /* fputs((s), stderr) */

/* STATIC ́A static łÃW[Œ`Ã
 * W[͎QƂȂƂB
 * LOCAL ́A======== Ɉ͂܂ꂽ͈͓ł̂ݎgB
 */
#define	STATIC static
#define	LOCAL static

/*--------------------------------------------------------------------*/
#define MAX_BLOCK_SIZE 16
#define	MAX_PACKET_SIZE (MAX_BLOCK_SIZE * 128) /* pPbg body ̃TCY */
static int max_packet_size = MAX_PACKET_SIZE;

/* pPbgۑ邽߂̌^`Bbody ̓éAquote Ôł
 * BȂƂ擪 1 ApPbg̎ނʂ <Type> ŁA
 * ê̂łȂƂɒӁB
 *
 * sequence ̓e
 *	'0' .. '9' gĂ
 *  'U' gĂiAbv[h̃t@Cǂݍݒj
 *	0..9 ǂݍݒ̏ԁB̏Ԃŏf̏ꍇApPbg̓
 *    e͖ƂȂB
 * LȊÓAgĂȂԂ킷BAƂẮAgp
 * ̃pPbg̔f́A '0' Ƃ̔rōsƁB
 */
typedef struct packet_t {
	int active; /* ̃pPbgack󂯎ĂȂꍇns */
	int special;
	int size;
	FILE *fp;
	long pos;
} PACKET;

static PACKET packets[10];

/* pPbgeۑ邽߂̃obt@
 */
static UCHAR *packet_body = NULL;
static int packet_size;
/* obt@ɓĂf[^ɑΉpPbg̔ԍ */
static int packet_active = -1;

/* ̃pPbg <Sequence>B0 ..9 ̒lB
 * pPbgḾAMI_ōXVB
 * pPbgḾAMpPbg̔ԍB
 */
static int packet_no = 0;

/* ŌɎ󂯎 ACKA邢͑ ACK ɑ΂ <Sequence>B
 * <Sequence> ɑΉpPbg͊ɉĂāALȂ̂͂̎
 *  <Sequence> ƂȂB
 */
static int packet_ack = 0;

/* packet_ack, packet_nõ[B
 * (<DLE>++<DLE>0)0ɃZbgB
 * pPbgMꍇApacket_no͎M_ł̃pPbgԍɂȂB
 *   ack𑗐Mꍇ́Apacket_ack̔ԍƂB
 * pPbg𑗐MꍇApacket_no͑M_ł̃pPbgԍɂȂB
 *   ackMꍇ́Apacket_ack̔ԍƂB
 */

/* T packet ɁAǂ̏ԂĂяoꂽ𔻕ʂ邽߂̏
 */
#define	FROM_TOPLEVEL 0
#define	FROM_DOWNLOAD 1
#define	FROM_UPLOAD 2

/* T packet 瓾t@C
 */
static UCHAR *t_filename = NULL;

/* {ɗpt@CB[U[̎w΁AT packet ̃t@
 * C͖āAʖgƂB܂AQɂ́A
 * t@C𗘗pꍇAɂ̖OۑB
 */
static UCHAR *real_filename = NULL;

/* TI packet ̏
 */
typedef struct {
	int valid; /* 0 ̏ꍇ́Aȉ̃f[^͖ */
	int data_type; /* 'A':ASCII, 'B':Binary */
	int compression; /* 0:no compression */
	int true_name_length; /* <true name> ̒ */
	/* info[0] f[^ (kꂽlł͂Ȃ)
	 * info[1] ^C][ ()
	 * info[2] t@C쐬N
	 * info[3] t@C쐬A00:00:00 ̕b
	 * info[4] t@CύXN
	 * info[5] t@CύX
	 */
	long info[6];
	UCHAR *true_name; /* t@C */
} FILE_INFO;

static FILE_INFO ti_information;

static char tx_kind[4]; /* Tx packetM̎ */

#define SEND_F_PACKET 1
#define RECEIVE_F_PACKET 2
static int failure_status = 0;

/* Get_DLE  FSA 
 */
#define	S_Get_DLE 1
#define	S_DLE_Seen 2
#define	S_DLE_B_Seen 3
#define	S_Get_Data 4
#define	S_Get_Check 5
#define	S_Get_CRC 6
#define	S_Verify_CRC 7
#define	S_Veify_CKS 8
#define	S_Verify_Packet 9
#define	S_Send_NAK 10
#define	S_Send_ACK 11
#define	S_Send_ENQ 12
#define	S_Resend_Packets 13

#ifdef DEBUG
static char *S_status[] = {
	"?",
	"S_Get_DLE",
	"S_DLE_Seen",
	"S_DLE_B_Seen",
	"S_Get_Data",
	"S_Get_Check",
	"S_Get_CRC",
	"S_Verify_CRC",
	"S_Veify_CKS",
	"S_Verify_Packet",
	"S_Send_NAK",
	"S_Send_ACK",
	"S_Send_ENQ",
	"S_Resend_Packets"
};
#endif

static int acknowledge_status = S_Get_DLE;
static int sa_error_count = 0; /* see document */

/* G[R[hBcommunication port ̐M 0 ` 255Aquote ꂽ
 * ʂ邽߂ɁA256 ` -511 𕶎R[hƂĎgƂ
 * (mask_recv) ߁Aۂ̃G[R[h͈͂̔͊O̒l𗘗pĂB
 */
#define	FINISH -258 /*  (no error) */
#define TIMEOUT -257 /* com_recv() Ń^CAEg */
#define	FAILURE -259 /* Failure Packet */
#define IOERROR -260 /* Ԃ̒vIȃG[ */

/* R[h
 */
#define	ETX 0x03
#define	ENQ 0x05
#define	DLE 0x10
#define	DC1 0x11
#define	DC3 0x13
#define	NAK	0x15
#define	ESC	0x1A
#define RS 0x1E

static UCHAR quotetable[256];

/* Checksum, CRC
 */
#define	CM_IS_CHECKSUM 0
#define	CM_IS_CRC 1;

/* + parameters
 */
static int block_size = (512 / 128);
static int check_method = CM_IS_CHECKSUM; /* checksum:0, CRC:1 */
static int estimate_interval = -1; /* default: time interval */
static int file_information = 1;
static int transport_layer = 0;
static int window_receive = 0;
static int window_send = 0;

#ifdef WITH_RESUME
static int download_resume = 0;
static int upload_resume = 0;
#endif

static UCHAR default_parameters[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0x00, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00};

static UCHAR my_defaults[] = {
	0x02, /* Window Send */ /* 10܂ő͂c */
	0x02, /* Window Receive */
	MAX_BLOCK_SIZE, /* Block Size */
	0x03, /* Check Method */
	0x01, /* Data Quoting Level */
	0x00, /* Transport Layer */
	0x14, 0x00, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, /* Q1-Q8 */
	0x00, /* resume download  option w莞ɗL */
	0x00, /* resume upload  option w莞ɗL */
	0x01 /* File Information */
};

static UCHAR our_defaults[17];

static FILE *syslog = NULL;
static FNAME_LIST *current_file = NULL;
static UCHAR *dirname = NULL;
static int append_mode = 0;
static int speed_limit = 0; /* nz: xspeed_limit/10 bytes/sȉȂI */
static int file_type = 'A'; /* ASCII */
static int force = 0;
static int look_text = 0;
static int set_ftime = 1;
static int stopchar = ' ';
static int verbose = 0;

#define	DOWNMODE_NORMAL 0
#define	DOWNMODE_APPEND 1
#define	DOWNMODE_RESUME 2
static int downmode = DOWNMODE_NORMAL;

#define isMSkanji1st(c) (((c) >= 0x81 && (c) <= 0xaf) || \
					   ((c) >= 0xe0 && (c) <= 0xfc)) /* MS-kanji */

#ifdef UNIX

static UCHAR pathchar = '/';
#define iskanji1st(c) ((c) & 0x80) /* EUC */

#else

static UCHAR pathchar = '\\';
#define iskanji1st(c) isMSkanji1st(c)

#endif

/* ֌W̓sŁc
 */
STATIC int send_ahead_packet(void);
STATIC void send_failure_packet(char *s);
STATIC int transfer(int mode, FILE *fp);
STATIC int send_ti_packet(int resend);

/* to debug
 */
#ifdef DEBUG
extern FILE *debug_fp;
#endif

/*===== Messages =====================================================*/
#ifdef JAPANESE

#ifdef WITH_RESUME
/* want_to_overwrite() */
#define STR_DELETE_AND_CONTINUE "̃t@C폜čƂ𑱂܂\n"
#define STR_SAME_FILENAME "̃t@C܂B\n"
#define STR_Q_DELETE "폜čƂ𑱂܂H"
#endif

/* cannot_open_message() */
#define STR_CANT_OPEN_L "t@C ("
#define STR_CANT_OPEN_R ") ̓I[vł܂\n"

/* decide_to_delete() */
#define STR_DELETE_CURRENT_1 "Mr̃t@C ("
#define STR_DELETE_CURRENT_2 ") 폜܂H"
#define STR_DELETED "폜܂\n"

/* copy_dirname() */
#define STR_TOO_LONG_PATHNAME "w̃fBNĝŖ܂\n"

/* open_tmpfile() */
#define STR_CANT_CREATE_L "t@C쐬łȂ̂ŁA"
#define STR_CANT_CREATE_R " ƂÖꎞt@CɃ_E[h܂\n"

/* ask_filename() */
#define STR_ENTER_FILENAME "t@Ci^[݂̂ŏ~j\n"

/* set_td_filename() */
#define STR_ALREADY_EXIST " ́Aɑ݂܂B\n폜ď𑱍s܂"
#define STR_BAD_FILENAME "t@Cُł\n"

/* est_sub() */
#define STR_LEFT_BYTES_PER_SEC " oCg^bA "
#define STR_TO_FINISH " ŏI)"

/* mes_filesize() */
#define STR_TOTAL_SIZE "TCY: "
#define STR_BYTES " oCg\n"

/* mes_filename() */
#define STR_FILENAME "t@C: "

/* mes_speed() */
#define STR_SPEED "x: "
#define STR_BYTES_PER_SEC " oCg^b\n"

/* s_get_dle() */
#define STR_RETRY "đv܂\n"

/* s_verify_crc() */
#define STR_CRC_ERROR "CRCv܂\n"
#define STR_DATA_ERROR "f[^[G[Ađ\n"

/* resume_setup() */
#define STR_WAIT_A_WHILE "΂炭҂\n"
#define STR_BAD_FILE "t@CɈُ킪܂\n"
#define STR_EMPTY_FILE "t@Ce͋ł\n"

/* td_packet() */
#define STR_INTERRUPT "\n𒆒f܂\n"
#define STR_WRITE_FAILURE "ݎsłB𒆒f܂\n"
#define STR_NOT_MATCHED "ev܂BVK쐬܂B\n"
#define STR_GET_FPACKET "~v󂯎܂"

/* open_tu_file() */
#define STR_FILENAME_TROUBLE "t@C̏Ɉُ킪܂\n"

/* tu_packet() */
#define STR_READ_TROUBLE "t@C̓ǂݍݒɈُ킪܂\n"
#define STR_SLOWDOWN "]xx̂ŏ𒆒f܂\n"

/* ti_message() */
#define STR_FILE_INFO "*** t@C ***\n"
#define STR_DATA_TYPE "Ef[^`: "
#define STR_TEXT "eLXg"
#define STR_BINARY "oCi"
#define STR_PICTURE "摜"
#define STR_UNKNOWN_TYPE "(s)"
#define STR_COMPRESSION "Ef[^k\n"
#define STR_FILESIZE "Et@CTCY: "
/* #define STR_BYTES " oCg\n" */
#define STR_TIMEZONE "E^C][: "
#define STR_CREATE_TIME "Et@C쐬: "
#define STR_MODIFY_TIME "Et@CύX: "
#define STR_TI_FILENAME "Et@C: "

/* tc_packet() */
#define STR_TRANSFER_COMPLETE "\n|]I|\n"
#define STR_CANT_CLOSE "t@CN[Ył܂\n"

/* transfer() */
#define STR_CANT_PROCESS "łȂf[^󂯎܂\n"

/* s_verify_packet() */
#define STR_GET_INTERRUPT ": fv󂯎܂\n"

#else

#ifdef WITH_RESUME
#define STR_DELETE_AND_CONTINUE "Delete old file, and continue\n"
#define STR_SAME_FILENAME "File already exists.\n"
#endif
#define STR_Q_DELETE "Delete it and continue?"
#define STR_CANT_OPEN_L "Can't open: "
#define STR_CANT_OPEN_R "\n"
#define STR_DELETE_CURRENT_1 "Delete current file ("
#define STR_DELETE_CURRENT_2 ") ?"
#define STR_DELETED "Deleted\n"
#define STR_TOO_LONG_PATHNAME "Directory name is too long and ignored.\n"
#define STR_CANT_CREATE_L "Can't create file, make temporary ("
#define STR_CANT_CREATE_R ").\n"
#define STR_ENTER_FILENAME "Filename (return to stop)\n"
#define STR_ALREADY_EXIST " already exists.\nDelete and continue"
#define STR_BAD_FILENAME "Bad filename\n"
#define STR_LEFT_BYTES_PER_SEC " bytes/sec, estimate: "
#define STR_TO_FINISH ")"
#define STR_TOTAL_SIZE "Total: "
#define STR_BYTES " bytes\n"
#define STR_FILENAME "Filename: "
#define STR_SPEED "Speed: "
#define STR_BYTES_PER_SEC " bytes/sec\n"
#define STR_RETRY "Retrying\n"
#define STR_CRC_ERROR "CRC error\n"
#define STR_DATA_ERROR "Data error, retrying\n"
#define STR_WAIT_A_WHILE "Wait a while...\n"
#define STR_BAD_FILE "Can't access current file\n"
#define STR_EMPTY_FILE "Current file is empty\n"
#define STR_INTERRUPT "\nStop\n"
#define STR_WRITE_FAILURE "Write failure.  Stop.\n"
#define STR_NOT_MATCHED "Contents mismatched.  Create new one.\n"
#define STR_GET_FPACKET "Received a failure packet\n"
#define STR_FILENAME_TROUBLE "Error in filename operation\n"
#define STR_READ_TROUBLE "File read error\n"
#define STR_SLOWDOWN "Slowdown.  Cancelling transfer.\n"
#define STR_FILE_INFO "*** File information ***\n"
#define STR_DATA_TYPE "o Data type: "
#define STR_TEXT "text"
#define STR_BINARY "binary"
#define STR_PICTURE "image"
#define STR_UNKNOWN_TYPE "(unknown)"
#define STR_COMPRESSION "o Data compression\n"
#define STR_FILESIZE "o File size: "
#define STR_BYTES " bytes\n"
#define STR_TIMEZONE "o Time zone: "
#define STR_CREATE_TIME "o File create time: "
#define STR_MODIFY_TIME "o File modify time: "
#define STR_TI_FILENAME "o Filename: "
#define STR_TRANSFER_COMPLETE "\n- Transfer complete -\n"
#define STR_CANT_CLOSE "Can't close\n"
#define STR_CANT_PROCESS "Invalid T packet (not supported?)\n"
#define STR_GET_INTERRUPT ": failure packet\n"

#endif

/*===== Checksum, CRC ================================================*/
LOCAL UWORD crc_table[] = {
	0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7,
	0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF,
	0x1231, 0x0210, 0x3273, 0x2252, 0x52B5, 0x4294, 0x72F7, 0x62D6,
	0x9339, 0x8318, 0xB37B, 0xA35A, 0xD3BD, 0xC39C, 0xF3FF, 0xE3DE,
	0x2462, 0x3443, 0x0420, 0x1401, 0x64E6, 0x74C7, 0x44A4, 0x5485,
	0xA56A, 0xB54B, 0x8528, 0x9509, 0xE5EE, 0xF5CF, 0xC5AC, 0xD58D,
	0x3653, 0x2672, 0x1611, 0x0630, 0x76D7, 0x66F6, 0x5695, 0x46B4,
	0xB75B, 0xA77A, 0x9719, 0x8738, 0xF7DF, 0xE7FE, 0xD79D, 0xC7BC,
	0x48C4, 0x58E5, 0x6886, 0x78A7, 0x0840, 0x1861, 0x2802, 0x3823,
	0xC9CC, 0xD9ED, 0xE98E, 0xF9AF, 0x8948, 0x9969, 0xA90A, 0xB92B,
	0x5AF5, 0x4AD4, 0x7AB7, 0x6A96, 0x1A71, 0x0A50, 0x3A33, 0x2A12,
	0xDBFD, 0xCBDC, 0xFBBF, 0xEB9E, 0x9B79, 0x8B58, 0xBB3B, 0xAB1A,
	0x6CA6, 0x7C87, 0x4CE4, 0x5CC5, 0x2C22, 0x3C03, 0x0C60, 0x1C41,
	0xEDAE, 0xFD8F, 0xCDEC, 0xDDCD, 0xAD2A, 0xBD0B, 0x8D68, 0x9D49,
	0x7E97, 0x6EB6, 0x5ED5, 0x4EF4, 0x3E13, 0x2E32, 0x1E51, 0x0E70,
	0xFF9F, 0xEFBE, 0xDFDD, 0xCFFC, 0xBF1B, 0xAF3A, 0x9F59, 0x8F78,
	0x9188, 0x81A9, 0xB1CA, 0xA1EB, 0xD10C, 0xC12D, 0xF14E, 0xE16F,
	0x1080, 0x00A1, 0x30C2, 0x20E3, 0x5004, 0x4025, 0x7046, 0x6067,
	0x83B9, 0x9398, 0xA3FB, 0xB3DA, 0xC33D, 0xD31C, 0xE37F, 0xF35E,
	0x02B1, 0x1290, 0x22F3, 0x32D2, 0x4235, 0x5214, 0x6277, 0x7256,
	0xB5EA, 0xA5CB, 0x95A8, 0x8589, 0xF56E, 0xE54F, 0xD52C, 0xC50D,
	0x34E2, 0x24C3, 0x14A0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
	0xA7DB, 0xB7FA, 0x8799, 0x97B8, 0xE75F, 0xF77E, 0xC71D, 0xD73C,
	0x26D3, 0x36F2, 0x0691, 0x16B0, 0x6657, 0x7676, 0x4615, 0x5634,
	0xD94C, 0xC96D, 0xF90E, 0xE92F, 0x99C8, 0x89E9, 0xB98A, 0xA9AB,
	0x5844, 0x4865, 0x7806, 0x6827, 0x18C0, 0x08E1, 0x3882, 0x28A3,
	0xCB7D, 0xDB5C, 0xEB3F, 0xFB1E, 0x8BF9, 0x9BD8, 0xABBB, 0xBB9A,
	0x4A75, 0x5A54, 0x6A37, 0x7A16, 0x0AF1, 0x1AD0, 0x2AB3, 0x3A92,
	0xFD2E, 0xED0F, 0xDD6C, 0xCD4D, 0xBDAA, 0xAD8B, 0x9DE8, 0x8DC9,
	0x7C26, 0x6C07, 0x5C64, 0x4C45, 0x3CA2, 0x2C83, 0x1CE0, 0x0CC1,
	0xEF1F, 0xFF3E, 0xCF5D, 0xDF7C, 0xAF9B, 0xBFBA, 0x8FD9, 0x9FF8,
	0x6E17, 0x7E36, 0x4E55, 0x5E74, 0x2E93, 0x3EB2, 0x0ED1, 0x1EF0
};

#define CRC_32_POLY           0xedb88320L
#define CCITT_CRC_32_COMPARE  0xdebb20e3

static ULONG ccitt_32_tab[] = { /* CRC polynomial 0xedb88320 */
	0x00000000UL, 0x77073096UL, 0xee0e612cUL, 0x990951baUL,
	0x076dc419UL, 0x706af48fUL, 0xe963a535UL, 0x9e6495a3UL,
	0x0edb8832UL, 0x79dcb8a4UL, 0xe0d5e91eUL, 0x97d2d988UL,
	0x09b64c2bUL, 0x7eb17cbdUL, 0xe7b82d07UL, 0x90bf1d91UL,
	0x1db71064UL, 0x6ab020f2UL, 0xf3b97148UL, 0x84be41deUL,
	0x1adad47dUL, 0x6ddde4ebUL, 0xf4d4b551UL, 0x83d385c7UL,
	0x136c9856UL, 0x646ba8c0UL, 0xfd62f97aUL, 0x8a65c9ecUL,
	0x14015c4fUL, 0x63066cd9UL, 0xfa0f3d63UL, 0x8d080df5UL,
	0x3b6e20c8UL, 0x4c69105eUL, 0xd56041e4UL, 0xa2677172UL,
	0x3c03e4d1UL, 0x4b04d447UL, 0xd20d85fdUL, 0xa50ab56bUL,
	0x35b5a8faUL, 0x42b2986cUL, 0xdbbbc9d6UL, 0xacbcf940UL,
	0x32d86ce3UL, 0x45df5c75UL, 0xdcd60dcfUL, 0xabd13d59UL,
	0x26d930acUL, 0x51de003aUL, 0xc8d75180UL, 0xbfd06116UL,
	0x21b4f4b5UL, 0x56b3c423UL, 0xcfba9599UL, 0xb8bda50fUL,
	0x2802b89eUL, 0x5f058808UL, 0xc60cd9b2UL, 0xb10be924UL,
	0x2f6f7c87UL, 0x58684c11UL, 0xc1611dabUL, 0xb6662d3dUL,
	0x76dc4190UL, 0x01db7106UL, 0x98d220bcUL, 0xefd5102aUL,
	0x71b18589UL, 0x06b6b51fUL, 0x9fbfe4a5UL, 0xe8b8d433UL,
	0x7807c9a2UL, 0x0f00f934UL, 0x9609a88eUL, 0xe10e9818UL,
	0x7f6a0dbbUL, 0x086d3d2dUL, 0x91646c97UL, 0xe6635c01UL,
	0x6b6b51f4UL, 0x1c6c6162UL, 0x856530d8UL, 0xf262004eUL,
	0x6c0695edUL, 0x1b01a57bUL, 0x8208f4c1UL, 0xf50fc457UL,
	0x65b0d9c6UL, 0x12b7e950UL, 0x8bbeb8eaUL, 0xfcb9887cUL,
	0x62dd1ddfUL, 0x15da2d49UL, 0x8cd37cf3UL, 0xfbd44c65UL,
	0x4db26158UL, 0x3ab551ceUL, 0xa3bc0074UL, 0xd4bb30e2UL,
	0x4adfa541UL, 0x3dd895d7UL, 0xa4d1c46dUL, 0xd3d6f4fbUL,
	0x4369e96aUL, 0x346ed9fcUL, 0xad678846UL, 0xda60b8d0UL,
	0x44042d73UL, 0x33031de5UL, 0xaa0a4c5fUL, 0xdd0d7cc9UL,
	0x5005713cUL, 0x270241aaUL, 0xbe0b1010UL, 0xc90c2086UL,
	0x5768b525UL, 0x206f85b3UL, 0xb966d409UL, 0xce61e49fUL,
	0x5edef90eUL, 0x29d9c998UL, 0xb0d09822UL, 0xc7d7a8b4UL,
	0x59b33d17UL, 0x2eb40d81UL, 0xb7bd5c3bUL, 0xc0ba6cadUL,
	0xedb88320UL, 0x9abfb3b6UL, 0x03b6e20cUL, 0x74b1d29aUL,
	0xead54739UL, 0x9dd277afUL, 0x04db2615UL, 0x73dc1683UL,
	0xe3630b12UL, 0x94643b84UL, 0x0d6d6a3eUL, 0x7a6a5aa8UL,
	0xe40ecf0bUL, 0x9309ff9dUL, 0x0a00ae27UL, 0x7d079eb1UL,
	0xf00f9344UL, 0x8708a3d2UL, 0x1e01f268UL, 0x6906c2feUL,
	0xf762575dUL, 0x806567cbUL, 0x196c3671UL, 0x6e6b06e7UL,
	0xfed41b76UL, 0x89d32be0UL, 0x10da7a5aUL, 0x67dd4accUL,
	0xf9b9df6fUL, 0x8ebeeff9UL, 0x17b7be43UL, 0x60b08ed5UL,
	0xd6d6a3e8UL, 0xa1d1937eUL, 0x38d8c2c4UL, 0x4fdff252UL,
	0xd1bb67f1UL, 0xa6bc5767UL, 0x3fb506ddUL, 0x48b2364bUL,
	0xd80d2bdaUL, 0xaf0a1b4cUL, 0x36034af6UL, 0x41047a60UL,
	0xdf60efc3UL, 0xa867df55UL, 0x316e8eefUL, 0x4669be79UL,
	0xcb61b38cUL, 0xbc66831aUL, 0x256fd2a0UL, 0x5268e236UL,
	0xcc0c7795UL, 0xbb0b4703UL, 0x220216b9UL, 0x5505262fUL,
	0xc5ba3bbeUL, 0xb2bd0b28UL, 0x2bb45a92UL, 0x5cb36a04UL,
	0xc2d7ffa7UL, 0xb5d0cf31UL, 0x2cd99e8bUL, 0x5bdeae1dUL,
	0x9b64c2b0UL, 0xec63f226UL, 0x756aa39cUL, 0x026d930aUL,
	0x9c0906a9UL, 0xeb0e363fUL, 0x72076785UL, 0x05005713UL,
	0x95bf4a82UL, 0xe2b87a14UL, 0x7bb12baeUL, 0x0cb61b38UL,
	0x92d28e9bUL, 0xe5d5be0dUL, 0x7cdcefb7UL, 0x0bdbdf21UL,
	0x86d3d2d4UL, 0xf1d4e242UL, 0x68ddb3f8UL, 0x1fda836eUL,
	0x81be16cdUL, 0xf6b9265bUL, 0x6fb077e1UL, 0x18b74777UL,
	0x88085ae6UL, 0xff0f6a70UL, 0x66063bcaUL, 0x11010b5cUL,
	0x8f659effUL, 0xf862ae69UL, 0x616bffd3UL, 0x166ccf45UL,
	0xa00ae278UL, 0xd70dd2eeUL, 0x4e048354UL, 0x3903b3c2UL,
	0xa7672661UL, 0xd06016f7UL, 0x4969474dUL, 0x3e6e77dbUL,
	0xaed16a4aUL, 0xd9d65adcUL, 0x40df0b66UL, 0x37d83bf0UL,
	0xa9bcae53UL, 0xdebb9ec5UL, 0x47b2cf7fUL, 0x30b5ffe9UL,
	0xbdbdf21cUL, 0xcabac28aUL, 0x53b39330UL, 0x24b4a3a6UL,
	0xbad03605UL, 0xcdd70693UL, 0x54de5729UL, 0x23d967bfUL,
	0xb3667a2eUL, 0xc4614ab8UL, 0x5d681b02UL, 0x2a6f2b94UL,
	0xb40bbe37UL, 0xc30c8ea1UL, 0x5a05df1bUL, 0x2d02ef8dUL
};

/*
 * CCITT CRC-16
 */

#define CRC_CCITT_POLY 0x8408L /* X^16+X^12+X^5+X^0 */
#define CCITT_CRC_16_COMPARE 0xf0b8

static UWORD ccitt_16_tab[] = { /* CRC-CCITT polynomial 0x8408 */
	0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf,
	0x8c48, 0x9dc1, 0xaf5a, 0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7,
	0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c, 0x75b7, 0x643e,
	0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876,
	0x2102, 0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd,
	0xad4a, 0xbcc3, 0x8e58, 0x9fd1, 0xeb6e, 0xfae7, 0xc87c, 0xd9f5,
	0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5, 0x453c,
	0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974,
	0x4204, 0x538d, 0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb,
	0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868, 0x99e1, 0xab7a, 0xbaf3,
	0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a,
	0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72,
	0x6306, 0x728f, 0x4014, 0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9,
	0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3, 0x8a78, 0x9bf1,
	0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738,
	0xffcf, 0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70,
	0x8408, 0x9581, 0xa71a, 0xb693, 0xc22c, 0xd3a5, 0xe13e, 0xf0b7,
	0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76, 0x7cff,
	0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036,
	0x18c1, 0x0948, 0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e,
	0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e, 0xf2a7, 0xc03c, 0xd1b5,
	0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd,
	0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134,
	0x39c3, 0x284a, 0x1ad1, 0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c,
	0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1, 0xa33a, 0xb2b3,
	0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb,
	0xd68d, 0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232,
	0x5ac5, 0x4b4c, 0x79d7, 0x685e, 0x1ce1, 0x0d68, 0x3ff3, 0x2e7a,
	0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238, 0x93b1,
	0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9,
	0xf78f, 0xe606, 0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330,
	0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3, 0x2c6a, 0x1ef1, 0x0f78
};

/*--------------------------------------------------------------------*/
/* Checksum ܂ CRC ̌vZ
 */
static UWORD crc_16;
static ULONG crc_32;

STATIC void add_check_value(int i)
{
	if (check_method == 1) {
		crc_16 = crc_table[((crc_16 >> 8) ^ i) & 0xff] ^ (crc_16 << 8);
	} else if (check_method == 2) {
		crc_16 = ccitt_16_tab[(crc_16 ^ i) & 0xff] ^ (crc_16 >> 8);
	} else if (check_method == 3) {
		crc_32 = ccitt_32_tab[(crc_32 ^ i) & 0xff] ^ (crc_32 >> 8);
	} else {
		crc_16 <<= 1;
		if (crc_16 > 0xff) {
			crc_16 &= 0xff;
			crc_16++;
		}
		crc_16 += i;
		if (crc_16 > 0xff) {
			crc_16 &= 0xff;
			crc_16++;
		}
	}
}

STATIC void clear_check_value(int i)
{
	if (check_method > 0) {
		crc_16 = 0xffff;
		crc_32 = 0xffffffffUL;
	} else {
		crc_16 = 0;
	}
	add_check_value(i);
}

/* CRCvnz߂ */
STATIC int check_check_value(ULONG l)
{
	switch (check_method) {
	case 0:
	case 1:
		return l == crc_16;

	case 2:
		add_check_value((int) (l >> 8));
		add_check_value((int) l);
		return crc_16 == 0xf0b8;

	case 3:
		add_check_value((int) (l >> 24));
		add_check_value((int) (l >> 16));
		add_check_value((int) (l >> 8));
		add_check_value((int) l);
		return crc_32 == 0xdebb20e3;

	default:
		return 0;
	}
}

/*===== Quoting ======================================================*/
STATIC void set_our_quotetable(UCHAR *table)
{
	UCHAR bit_pattern;
	int c;
	int i;
	int j;

	for (i = 0; i < 256; i++) {
		quotetable[i] = 0;
	}

	c = 0;
	for (i = 0; i < 8; i++) {
		if (i == 4) { /* Switch to upper control set */
			c = 128;
		}

		bit_pattern = table[i];

		for (j = 0; j < 8; j++) {
			if (bit_pattern & 0x80) {
				quotetable[c] = c + ((c < 0x20) ? 0x40 : -0x20);
			}
			bit_pattern <<= 1;
			c++;
		}
	}
}

/*--------------------------------------------------------------------*/
STATIC void set_quoting_level(int i)
{
	static UCHAR set0[] = {0x94, 0x00, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00};
	static UCHAR set1[] = {0x14, 0x00, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00};
	static UCHAR set2[] = {0x14, 0x00, 0xd4, 0x00, 0x00, 0x00, 0x50, 0x00};
	static UCHAR set3[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
	static UCHAR *quoting_set[4] = {set0, set1, set2, set3};

	if (i >= 0 && i < 4) {
		set_our_quotetable(quoting_set[i]);
	}
}

/*===== Communication port ===========================================*/
/*	Wait until any data is received, or timeout.
 *
 *	wait: 1..59
 *
 *	return value:	0..255, valid data
 *					-256..-1, key was hit (code - 256)
 *					-257 timeout
 *					-258 abort request (DLE DLE DLE DLE)
 */
STATIC int com_trecv(int wait)
{
	int i;
	int passed;
	int tstart;
	static int dle_count = 0;

	tstart = -1;

	do {
		if (com_length() > 0) { /* receive */
			i = com_recv();
			if (dle_count < 4) {
				if (i == DLE)
					dle_count++;
				else
					dle_count = 0;
			}
			return dle_count == 4 ? -258 : i;
		}
		i = kbd_check();
		if (i == stopchar)
			return i - 256; /* key was hit */
		if (tstart == -1) {	/* only at first */
			tstart = second();
		}
		passed = second() - tstart; /* second() returns 0..59 */
		if (passed < 0)
			passed += 60;
	} while (passed < wait);

	return TIMEOUT;
}

/*--------------------------------------------------------------------*/
#define TIMEOUT_INTERVAL 16

STATIC int bp_com_recv(void)
{
	return com_trecv(TIMEOUT_INTERVAL);
}

/*--------------------------------------------------------------------*/
/* DLE ǂݎꍇɂ́Aquote ̏sʂ߂B
 * ȊÓAquote ׂPƂŌꂽꍇ́Aʂ̂߂ɁA
 * {̃R[h 256 A256 .. 511 ̒l߂B
 * quote ͒ډZBe[uQƂĂȂ߁A\Ȃ
 * quote ꂽꍇ̖߂l͕ۏ؂ȂB
 */
STATIC int mask_recv(void)
{
	int c;

	c = bp_com_recv();
	if (c >= 0) { /* ok */
		if (c == DLE) { /* quote */
			c = bp_com_recv();
			if (c >= 0) { /* ok */
				c += (c < 0x60) ? -0x40 : 0x20;
			}
		} else if (quotetable[c]) {
			/* quote ׂPƂőĂꍇ */
			c |= 0x100;
		}
	}
	return c;
}

/*--------------------------------------------------------------------*/
/* string  com_send đM
 */
STATIC int com_ssend(char *str)
{
	char c;
	int sts;

	while ((c = *str++) != 0) {
		sts = com_send(c);
		if (sts < 0)
			break;
	}
	return sts;
}

/*--------------------------------------------------------------------*/
STATIC int mask_send(int c)
{
	int q;
	int sts;

	c &= 0xff;
	q = quotetable[c];
	if (q) {
		sts = com_send(DLE);
		if (sts < 0)
			return sts;
		c = q;
	}
	return com_send(c);
}

/*===== utilities ====================================================*/
/*--------------------------------------------------------------------*/
/* bZ[W\Bverbose == 0 ̏ꍇɂ́A\sȂBɕ\
 * ɂ́Astrwarn gB
 */
STATIC void message(char *s)
{
	if (verbose)
		strout(s);
}

/*--------------------------------------------------------------------*/
STATIC void nolog_message(char *s)
{
	if (verbose)
		nolog_strout(s);
}

/*--------------------------------------------------------------------*/
STATIC void vmessage(char *s)
{
	if (verbose > 1)
		strout(s);
}

/*--------------------------------------------------------------------*/
#define INTERVAL_LIMIT 7

STATIC int kbd_tcheck(int init)
{
	static int time_start;
	int c;

	if (init) {
		time_start = second();
		return 0;
	}

	while ((c = kbd_check()) == -1) {
		int now;
		int passed;

		/* Y/N ̔f҂ꍇɁADLE + ; 莞ԂƂɑ */
		now = second();
		passed = now - time_start;
		if (passed < 0)
			passed += 60;
		if (passed > INTERVAL_LIMIT) {
			com_ssend("\020;");
			time_start = now;
		}
	}
	return c;
}

/*--------------------------------------------------------------------*/
STATIC int my_gets(char *buf, int limit)
{
	char *s;
	int pos = 0;

	log_control(0);
	s = buf;
	limit--;
	(void) kbd_tcheck(1);
	while (pos < limit) {
		int c;

		c = kbd_tcheck(0);
		if (c == '\010' && pos > 0) {
			pos--;
			s--;
			charout('\010');
		} else if (c == 0x0d) {
			break;
		} else {
			charout(c);
			*s++ = (char) c;
			pos++;
		}
	}
	*s = '\0';
	log_control(1);
	return 0;
}

/*--------------------------------------------------------------------*/
/* yes or no
 */
STATIC int yn(char *s)
{
	int sts = -1;

	log_control(0);
	strout(s);
	strout(" (y/n) ");
#if defined(UNIX) || defined(OS2)
	flushmsg();
#endif
	(void) kbd_tcheck(1); /* start */
	while (sts == -1) {
		switch (kbd_tcheck(0)) {
		case 'y':
		case 'Y':
			strout(" Yes\n");
			sts = 1;
			break;

		case 'n':
		case 'N':
			strout(" No\n");
			sts = 0;
			break;
		}
	}

	log_control(1);
	return sts;
}

/*--------------------------------------------------------------------*/
STATIC void remove_cr_or_lf(char *s)
{
	while (*s) {
		if (*s == 0x0a || *s == 0x0d) {
			*s = '\0';
			break;
		}
		s++;
	}
}

#ifdef WITH_RESUME
/*--------------------------------------------------------------------*/
STATIC int want_to_overwrite(void)
{
	if (force) {
		/* force ̏ꍇɂ́Averbose == 0 ̎ɕ\Ȃ */
		/* ũt@C폜čƂ𑱂܂v */
		message(STR_DELETE_AND_CONTINUE);
		return 1;
	}

	nolog_strout(STR_SAME_FILENAME); /* ũt@C܂Bv */
	return yn(STR_Q_DELETE); /* u폜čƂ𑱂܂Hv */
}
#endif

/*--------------------------------------------------------------------*/
STATIC void cannot_open_message(void)
{
	message(STR_CANT_OPEN_L); /* ut@C (v */
	message((char *) real_filename);
	message(STR_CANT_OPEN_R); /* u̓I[vł܂\nv */
}

/*--------------------------------------------------------------------*/
/* t@C폜邩ǂmFA폜̗v΍폜B
 */
STATIC void decide_to_delete(void)
{
	if (downmode == DOWNMODE_NORMAL) {
		nolog_strout(STR_DELETE_CURRENT_1); /* uMr̃t@C (v */
		nolog_strout((char *) real_filename);
		if (yn(STR_DELETE_CURRENT_2)) { /* u) 폜܂ Hv */
			unlink((char *) real_filename);
			nolog_strout(STR_DELETED); /* u폜܂\nv */
		}
	}
}

/*--------------------------------------------------------------------*/
#define FNAME_WORK_MAX	256 /* v39 ł 128 */

LOCAL UCHAR *fname_work;
LOCAL int fname_w_index;
LOCAL int fname_w_error;

/*--------------------------------------------------------------------*/
LOCAL void add_char(int c)
{
	if (fname_w_index < FNAME_WORK_MAX) {
		fname_work[fname_w_index++] = (UCHAR) c;
	} else {
		fname_w_error = 1;
	}
}

/*--------------------------------------------------------------------*/
/* t@Cǂݍ (쐬) fBNgw肳Ă΁Aobt@
 * 擪ɃRs[B
 */
LOCAL void copy_dirname(void)
{
	int len;

	fname_work[0] = '\0';
	if (dirname == NULL)
		return;

	len = strlen(dirname);
	if (len > FNAME_WORK_MAX - 2) {
		/* uw̃fBNĝŖ܂\n"v */
		message(STR_TOO_LONG_PATHNAME);
	} else {
		UCHAR pathstr[2];
		int c;
		int i;

		strcpy(fname_work, dirname);
		for (i = 0; i < len; i++) {
			c = fname_work[i];
			if (iskanji1st(c)) { /* QoCgڂ pathchar ͏Ȃ */
				/*  pathchar ǉđvł邱ƂmF */
				if (i == (len - 1)) {
					fname_work[i] = '\0';
				}
				i++;
			} else {
				if (i == (len - 1) && c == pathchar) {
					fname_work[i] = '\0';
				}
			}
		}
		pathstr[0] = pathchar;
		pathstr[1] = '\0';
		strcat(fname_work, pathstr);
	}
}

/*--------------------------------------------------------------------*/
/* fname_work + fname_w_index ȍ~Ƀt@CǉB
 * ̏ OS Ɉˑ
 */

#if defined(UNIX) || defined(OS2)
/* UNIX or OS/2 version
 * 擪 pathchar ̌JԂ΁Apathchar 1 ɒuB
 */
LOCAL int copy_body(UCHAR *s)
{
	int pos = 0;

	while (*s) {
		/* r pathchar ꂽꍇ́A|WVNAB
		 * pathname/filename ̂悤ȏꍇ̏
		 */
		if (*s == pathchar) {
			while (*s == pathchar)
				s++;
			add_char(pathchar);
			pos = 0;
		} else if (*s == '.' && pos == 0) { /* pathchar  */
			if (s[1] == pathchar) {
				s += 2;
				continue;
			}
			if (s[1] != '.' || s[2] != pathchar) { /* .. appeared */
				return -1;
			}
			add_char('.');
			add_char('.');
			add_char(pathchar);
			s += 3;
			while (*s == pathchar)
				s++;
		} else if (*s == ' ') { /* ʏ̃t@C */
			/* t@C̊Ԃɋ󔒂ꍇAȌ͖̕ */
			pos = FNAME_WORK_MAX;
			s++;
		} else {
			if (iskanji1st(s[0])) {
				/* 擪oCĝݑ݂鎞͖ */
				if (s[1] == '\0')
					return -1;
				/* 2 oCgڂł`FbN͂ɁAĂ */
				if (pos < FNAME_WORK_MAX - 1) {
					add_char(s[0]);
					add_char(s[1]);
					pos += 2;
				}
				s += 2;
			} else {
				if (pos < FNAME_WORK_MAX) {
					add_char(s[0]);
					pos++;
				}
				s++;
			}
		}
	}

	if (pos == 0)
		return -1;
	add_char('\0');
	return fname_w_error;
}
#else

/* MSDOS 
 * 擪 pathchar ̌JԂ΁Apathchar 1 ɒuB
 */
LOCAL int copy_body(UCHAR *s)
{
	int pos = 0;

	while (*s) {
		/* r pathchar ꂽꍇ́A|WVNAB
		 * pathname/filename ̂悤ȏꍇ̏
		 */
		if (*s == pathchar) {
			while (*s == pathchar)
				s++;
			add_char(pathchar);
			pos = 0;
		} else if (*s == '.') {
			if (pos == 0) { /* pathchar  */
				if (s[1] == pathchar) {
					s += 2;
					continue;
				}
				if (s[1] != '.' || s[2] != pathchar) { /* .. appeared */
					return -1;
				}
				add_char('.');
				add_char('.');
				add_char(pathchar);
				s += 3;
				while (*s == pathchar)
					s++;
			} else if (pos < 9) {
				add_char('.');
				s++;
				pos = 9;
			} else { /* AFTER_BODY */
				return -1;
			}
		} else if (*s == ' ') { /* ʏ̃t@C */
			/* t@C̊Ԃɋ󔒂ꍇAȌ͖̕ */
			if (pos > 0) {
				if (pos < 9) {
					pos = 8;
				} else {
					pos = 12;
				}
			}
			s++;
		} else {
			if (iskanji1st(s[0])) {
				/* 擪oCĝݑ݂鎞͖ */
				if (s[1] == '\0')
					return -1;
				/* c蕶 1 Ȃ疳 */
				/* 2 oCgڂł`FbN͂ɁAĂ */
				if (pos == 7 || pos == 8) {
					pos = 8;
				} else if (pos >= 11) {
					pos = 12;
				} else {
					add_char(s[0]);
					add_char(s[1]);
				}
				s += 2;
				pos += 2;
			} else {
				if (pos < 8 || (pos >= 9 && pos <= 11)) {
					add_char(s[0]);
					pos++;
				}
				s++; /* 901105 */
			}
		}
	}

	if (pos == 0)
		return -1;
	add_char('\0');
	return fname_w_error;
}
#endif

/*--------------------------------------------------------------------*/
/* t@C쐬BI 0AG[͕̒l߂
 */
STATIC int create_real_filename(UCHAR *s)
{
	int sts;

	/* Ɨ̈̊lуCfbNX̏ */
	fname_work = (UCHAR *) malloc((size_t) FNAME_WORK_MAX + 1);
	if (fname_work == NULL)
		return -1; /* out of memory */
	fname_w_error = 0;

	/* s  drive name ܂ pathchar Ŏn܂ĂƂ́AwfB
	 * Ng͖B
	 */
#ifndef UNIX
	if (*s != '\0' && s[1] == ':') {
		fname_work[0] = *s;
		fname_work[1] = s[1];
		fname_work[2] = '\0';
		s += 2;
	} else
#endif
	if (*s == pathchar) {
		fname_work[0] = s[0];
		fname_work[1] = '\0';
		s++;
	} else {
		copy_dirname();
		if (s[0] == '.' && s[1] == pathchar)
			s += 2;
	}

	fname_w_index = strlen(fname_work);
	if (copy_body(s)) { /* t@Cُ */
		strcpy(fname_work, tmpnam(NULL));
	}

	free(real_filename);
	real_filename = (UCHAR *) malloc(strlen(fname_work) + 1);

	if (real_filename != NULL) {
		strcpy(real_filename, fname_work);
		sts = 0;
	} else {
		sts = -1; /* out of memory */
	}
	free(fname_work);
	return sts;
}

/*--------------------------------------------------------------------*/
STATIC FILE *open_tmpfile(void)
{
	FILE *fp;
	UCHAR *my_tmp;
	char *tmp;

	tmp = tmpnam(NULL);
	my_tmp = (UCHAR *) malloc(strlen(tmp) + 1);
	if (my_tmp == NULL)
		return NULL;
	strcpy(my_tmp, tmp);

	fp = fopen(tmp, "wb");
	if (fp == NULL) {
		free(my_tmp);
	} else {
		/* fBNg current g */
		strwarn(STR_CANT_CREATE_L); /* ut@C쐬łȂ̂Łv */
		strwarn((char *) my_tmp);
		/* uƂÖꎞt@CɃ_E[h܂\nv */
		strwarn(STR_CANT_CREATE_R);
		free(real_filename);
		real_filename = my_tmp;
	}
	return fp;
}

/*--------------------------------------------------------------------*/
STATIC FILE *open_file(char *mode)
{
	FILE *fp;

	/* ́̕Aŏ while Ń[v肾̂ŁA 1
	 * sɉ߂̂łBif ŏ̂Ȃ 2 sɕ₷
	 * ȂAAt@C쐬s̎ɃC^NeBuɂ
	 * ̂ŁÂ܂ܕuB
	 */
	if ((fp = fopen(real_filename, mode)) == NULL) {
		/* w̃t@CI[vłȂ̂ŁAꎞt@C쐬B
		 * ꎞt@ClĂAʂ malloc ̈ɃRs[
		 * ̂ĝ́Ǎ̏IŁAreal_filename
		 * (Ȃ킿Amy_tmp)  free 邽
		 */
		if (*mode == 'r')
			return NULL;
		fp = open_tmpfile();
	}
	return fp;
}

/*--------------------------------------------------------------------*/
STATIC int ask_filename(char *buf)
{
	nolog_strout(STR_ENTER_FILENAME); /* ut@Ci^[݂̂ŏ~j\nv */
	my_gets(buf, 80);
	remove_cr_or_lf(buf);
	return strlen(buf) ? 0 : -1;
}

/*--------------------------------------------------------------------*/
STATIC int set_td_filename(void)
{
	char buf[83];
	FILE *fp;
	int sts;

	for (;;) {
		fp = fopen(real_filename, "rb");
		if (fp == NULL) { /* ̃t@CȂ΁Aʏ download */
			return DOWNMODE_NORMAL;
		}
		fclose(fp);

		if (append_mode)
			return DOWNMODE_APPEND;
#ifdef WITH_RESUME
		if (download_resume > 0) /* Resume download */
			return DOWNMODE_RESUME;
#endif
		if (force)
			return DOWNMODE_NORMAL;
		if (verbose == 0) {
			/* tempname */
			return -1;
		}
		nolog_strout((char *) real_filename);
		/* u ́Aɑ݂܂B\n폜ď𑱍s܂v */
		if (yn(STR_ALREADY_EXIST)) {
			return DOWNMODE_NORMAL;
		}
		do {
			sts = 1;
			if (ask_filename(buf)) {
				return -1;
			}
			if (create_real_filename((UCHAR *) buf) < 0) {
				strout(STR_BAD_FILENAME); /* ut@Cُł\nv */
			} else {
				sts = 0;
			}
		} while (sts);
	}
}

/*--------------------------------------------------------------------*/
LOCAL ULONG get_current_time(void)
{
	UCHAR buf[3];
	long t;
	static long last_time = 0;
	static int day = 0;

	hms(buf); /* get hour, minute, and second */
	t = (long) day + buf[0];
	t *= (long) 60;
	t += (long) buf[1];
	t *= (long) 60;
	t += (long) buf[2];
	if (t < last_time) {
		t += (long) 24 * 60 * 60;
		day += 24;
	}
	return (ULONG) (last_time = t);
}

/*--------------------------------------------------------------------*/
STATIC void showtime(ULONG t)
{
	char s[9];
	int i;

	i = (int) (t % 3600);
	sprintf(s, "%02d:%02d:%02d", (int) (t / 3600), i / 60, i % 60);
	strout(s);
}

/*--------------------------------------------------------------------*/
STATIC void est_sub(ULONG rest, ULONG rate)
{
	if (rest > 0) {
		strout(" (");
		ldecout(rate);
		strout(STR_LEFT_BYTES_PER_SEC); /* u oCg^bA " */
		showtime(rest);
		strout(STR_TO_FINISH); /* u ŏI)v */
	}
}

/*--------------------------------------------------------------------*/
/* ɕKvȎc莞Ԃ̗\z
 * ŏ ESTIMATE_COUNT ̓]ʂ́AsȂߖB
 */
#define	ESTIMATE_COUNT 2
#define ESTIMATE_INTERVAL 6
#define ESTIMATE_BUFFER_SIZE 16

LOCAL int mes_estimate(ULONG filesize, ULONG sendsize, int count)
{
	ULONG now;
	ULONG pass_time;
	ULONG rate;
	ULONG rest;
	int i;
	int sts = 0;
	static int call_count; /* Ă΂閈 ++ */
	static int ring_full;
	static int my_count; /* f[^L^閈 ++ */
	static ULONG last_t;
	static ULONG size[ESTIMATE_BUFFER_SIZE];
	static ULONG t[ESTIMATE_BUFFER_SIZE];

	if (count == 0) {
		ring_full = my_count = call_count = 0;
		last_t = (ULONG) 0;
	}

	if (count < ESTIMATE_COUNT)
		return 0;

	now = get_current_time();
	if (now - last_t >= ESTIMATE_INTERVAL) {
		size[my_count] = sendsize;
		t[my_count] = last_t = now;
		my_count++;
		if (my_count > ESTIMATE_BUFFER_SIZE - 1) {
			my_count = 0;
			ring_full = 1;
		}
	} else { /* f[^͍XVȂ */
		if (estimate_interval < 0)
			return 0;
	}

	if (estimate_interval > 0) {
		call_count++;
		if (call_count < estimate_interval)
			return 0;
		call_count = 0;
	}

	i = ring_full ? my_count : 0;
	pass_time = now - t[i];
	if (pass_time < 1)
		return 0;

	rate = (sendsize - size[i]) / pass_time;
	if (speed_limit > 0) {
		if ((rate / 10) < speed_limit)
			sts = -1;
	}

	if (estimate_interval) { /* 0̏ꍇ͕\Ȃ */
		if (rate > 0) {
			rest = (filesize - sendsize) / rate;
			est_sub(rest, rate);
		}
	}

	return sts;
}

/*--------------------------------------------------------------------*/
/*	f[^TCY\
 */
STATIC int mes_datasize(ULONG filesize, ULONG sendsize, int count)
{
	int sts = 0;

	if (verbose > 0) {
		log_control(0);
		ldecout(sendsize);
		strout(" bytes");
	}

	if (filesize > 0) {
		if (speed_limit || ((verbose > 0) && estimate_interval))
			sts = mes_estimate(filesize, sendsize, count);
	}

	if (verbose > 0) {
		charout('\r');
#if defined(UNIX) || defined(OS2)
		flushmsg();
#endif
		log_control(1);
	}

	return sts;
}

/*--------------------------------------------------------------------*/
/*	t@CTCY\
 */
STATIC void mes_filesize(ULONG filesize)
{
	if (verbose > 0) {
		strout(STR_TOTAL_SIZE); /* uTCY: v */
		ldecout(filesize);
		strout(STR_BYTES); /* uoCg\nv */
	}
}

/*--------------------------------------------------------------------*/
/*	t@C\
 */
STATIC void mes_filename(void)
{
	message(STR_FILENAME); /* ut@C: v */
	message((char *) real_filename);
	message("\n");
}

/*--------------------------------------------------------------------*/
/* ]x\
 */
STATIC void mes_speed(ULONG size, ULONG second)
{
	ULONG l;

	if (verbose && second) {
		l = (ULONG) 10 * size / second;
		strout(STR_SPEED); /* ux: v */
		ldecout(l / 10);
		charout('.');
		ldecout(l % 10);
		strout(STR_BYTES_PER_SEC); /* u oCg^b\nv */
	}
}

/*--------------------------------------------------------------------*/
LOCAL UCHAR *ltoa_str;

LOCAL void ltoa_sub(ULONG l)
{
	if (l > 9) {
		ltoa_sub(l / 10);
	}
	*ltoa_str++ = (char) (l % 10) + '0';
}

/*--------------------------------------------------------------------*/
STATIC void ulong_to_str(ULONG l, UCHAR *s)
{
	if (s == NULL)
		s = ltoa_str;

	ltoa_str = s;
	ltoa_sub((ULONG) l);
	*ltoa_str = '\0';
}

/*--------------------------------------------------------------------*/
STATIC void add_ulong_to_str(ULONG l, UCHAR *s)
{
	ulong_to_str(l, s);
	*ltoa_str++ = ' ';
	*ltoa_str = '\0';
}

/*===== utilities (packet) ===========================================*/
/*--------------------------------------------------------------------*/
STATIC void init_all_packets(void)
{
	int i;

	for (i = 0; i < 10; i++) {
		packets[i].active = 0;
		packets[i].special = 0;
		packets[i].pos = (long) 0;
		packets[i].fp = NULL;
	}

	packet_active = -1;
}

/*===== Send a packet ================================================*/
/* packet_no, packet_sizew肵āApacket_bodye𑗐MB
 * Send Ahead ̊mFɌĂяoƁB
 * packet_no͍XVB
 */
STATIC int send_packet(void)
{
	PACKET *pac;
	int i;
	int size;

	pac = &packets[packet_no];

	if (packet_active != packet_no && pac->special == 0 && pac->fp != NULL) {
		size_t n;

		fseek(pac->fp, pac->pos, SEEK_SET);
		n = fread(packet_body + 1, 1, pac->size - 1, pac->fp);
		if (n != pac->size - 1) {
			return -1; /* failure packet ? */
		}
		packet_body[0] = 'N';
		packet_size = pac->size;
		packet_active = packet_no;
	}

#ifdef DEBUG
	fprintf(stderr, "send_packet (packet=%d, type=%c, ack=%d, pos=%ld)\n",
		packet_no, packet_body[0], packet_ack, packets[packet_no].pos);
#endif
	/* Lead-in */
	com_send(DLE);
	com_send('B');
	com_send(packet_no + '0'); /* must be 0 .. 9 */
	clear_check_value(packet_no + '0');
	pac->active = 1;

	/* Type */
	/* Body */
	size = pac->size;
	for (i = 0; i < size; i++) {
		UCHAR data;

		data = packet_body[i];
		mask_send(data);
		add_check_value(data);
	}

	/* Trailer */
	com_send(ETX);
	add_check_value(ETX);
	switch (check_method) {
	default: /* ? */
	case 1:
		mask_send(crc_16 >> 8); /* mask_send ́Aɉ 8 rbĝݑ */
		/* fall into next case */

	case 0:
		mask_send(crc_16);
		break;

	case 2:
		crc_16 ^= 0xffff;
		mask_send(crc_16);
		mask_send(crc_16 >> 8);
		com_send(RS);
		break;

	case 3: /* CCITT 32 */
		crc_32 ^= 0xffffffffUL;
		mask_send((int) (crc_32));
		mask_send((int) (crc_32 >> 8));
		mask_send((int) (crc_32 >> 16));
		mask_send((int) (crc_32 >> 24));
		com_send(RS);
		break;
	}

	return 0; /* error check ? */
}

/*--------------------------------------------------------------------*/
/* send acknowledge, set pac->sequence to 0
 * sequence = 0 .. 9
 * packet_ack͎w肵ԍɃZbg
 */
STATIC void send_ack(int sequence)
{
#ifdef DEBUG
	fprintf(stderr, "send_ack %d\n", sequence);
#endif
	com_send(DLE);
	com_send(sequence + '0');
	packets[sequence].active = 0; /* ς̃pPbg͉ */
	packet_ack = sequence;
}

/*===== Receive a packet =============================================*/
LOCAL int after_enq = 0;
LOCAL int data_error = 0;

LOCAL int s_get_dle(int receive)
{
	int c;

	c = bp_com_recv();
	if (c == RS)
		return 0; /* ignore this */

	if (c != DLE) {
		after_enq = 0;
	}
	switch (c) {
	case DLE:
		acknowledge_status = S_DLE_Seen;
		break;

	case NAK:
		acknowledge_status = receive ? S_Get_DLE : S_Send_ENQ;
		nolog_message("\n");
		message(STR_RETRY); /* uđv܂\nv */
		break;

	case ENQ:
		acknowledge_status = S_Send_ACK;
		break;

	case ETX:
		vmessage("\nget ETX\n");
		acknowledge_status = S_Send_NAK;
		break;

	case TIMEOUT:
		vmessage("\nTimeout 1\n");
		acknowledge_status = receive ? S_Send_NAK : S_Send_ENQ;
		break;

	default:
		if (c < 0) {
			return c;
		} else {
			acknowledge_status = S_Get_DLE;
		}
	}
	return 0;
}

/*--------------------------------------------------------------------*/
/* sequence Ŏw肳ꂽ packetAсAȑO packet 𖢎gp
 * ԂɂB
 * sequence = 0 .. 9
 */
STATIC void free_packet(int sequence)
{
	if (packets[sequence].active == 0) {
		/* ôȂpPbgւ ACK */
		return;
	}

	do {
		packets[sequence].active = 0;
		if (packet_active == sequence)
			packet_active = -1;
		sequence--;
		if (sequence < 0)
			sequence = 9;
	} while (packets[sequence].active);
}

/*--------------------------------------------------------------------*/
LOCAL int s_dle_seen(int receive)
{
	int c;

	c = bp_com_recv();
	switch (c) {
	case 'B':
		acknowledge_status = S_DLE_B_Seen;
		break;

	case ';':
		acknowledge_status = S_Get_DLE;
		break;

	case ENQ:
		acknowledge_status = S_Send_ACK;
		break;

	case TIMEOUT:
		vmessage("Timeout 2\n");
		acknowledge_status = receive ? S_Send_NAK : S_Send_ENQ;
		break;

	default:
		if (c < 0) {
			return c;
		} else if (c >= '0' && c <= '9') { /* Positive Ack */
#ifdef DEBUG
			fprintf(stderr, "get ack %c\n", c);
#endif
			if (after_enq) {
				/* ENQ 𑗂ɂ́AACK  2 ߂Ă̂ŁA
				 * vꍇɂ́AS_Resend_Packets ֑JڂB
				 * vȂ΁AENQ ēxMB
				 */
				static int last_sequence = 0;

				if (after_enq == 2) { /* 1 ڂ ACK */
					last_sequence = c;
					acknowledge_status = S_Get_DLE;
				} else { /* 2 ڂ ACK */
					acknowledge_status =
						(last_sequence != c) ? S_Send_ENQ : S_Resend_Packets;
				}
				after_enq--;
			} else {
#ifdef DEBUG
				fprintf(debug_fp, "\ns_dle_seen: ack received %c\n", c);
#endif
				packet_ack = c - '0';
				free_packet(packet_ack);
				if (sa_error_count > 0)
					sa_error_count--;
				return FINISH;
			}
		} else {
			acknowledge_status = S_Get_DLE;
		}
	}
	return 0;
}

/*--------------------------------------------------------------------*/
LOCAL int s_dle_b_seen(void)
{
	int c;

	c = bp_com_recv();
	switch (c) {
	default:
		if (c < 0) {
			return c;
		} else if (c >= '0' && c <= '9') {
			/* sequence ̓ǂݎ */
			packet_body[0] = c;
			packet_size = 1;
			clear_check_value(c);
			acknowledge_status = S_Get_Data;
			data_error = 0;
			break;
		}
		vmessage("\nBad sequence\n");
		/* fall into next case */

	case TIMEOUT:
		acknowledge_status = S_Send_NAK;
		vmessage("\nTimeout 3\n");
		break;

	case ENQ:
		acknowledge_status = S_Send_ACK;
		break;
	}
	return 0;
}

/*--------------------------------------------------------------------*/
LOCAL int s_get_data(void)
{
	int c;

	c = mask_recv();
	switch (c) {
	case ETX | 0x100:
		add_check_value(ETX);
		acknowledge_status = S_Get_Check;
		break;

	case ENQ | 0x100:
		acknowledge_status = S_Send_ACK;
		break;

	case TIMEOUT:
		vmessage("\nTimeout 4\n");
		acknowledge_status = S_Send_NAK;
		break;

	default:
		if (data_error == 3)
			return 0;
		if (c < 0) {
			/* key ꂽꍇAcf[^tbVȂĂ悢̂ ? */
			if (c >= -256) {
				data_error = 3;
				return 0;
			}
			else
				return c;
		} else if (c < 256) {
			add_check_value(c);
			if (packet_size < max_packet_size + 3) {
				packet_body[packet_size++] = (UCHAR) c;
			} else {
				data_error = 1;
			}
			/* acknowledge_status ͕ωȂ */
		} else {
			data_error = 2;
		}
	}
	return data_error == 3 ? FAILURE : 0;
}

/*--------------------------------------------------------------------*/
static int get_crc_count;

LOCAL int s_get_check(ULONG *checksum)
{
	int c;

	c = mask_recv(); /* checksum  quote 邱Ƃ */
	if (c == TIMEOUT || c > 255) {
		vmessage("\nTimeout 5\n");
		acknowledge_status = S_Send_NAK;
	} else if (c < 0) {
		return c; /* error or interrupt */
	} else {
		if (check_method) {
			acknowledge_status = S_Get_CRC;
			get_crc_count = (check_method == 3) ? 3 : 1;
		} else {
			acknowledge_status = S_Veify_CKS;
		}
		*checksum = (ULONG) c & 0xff;
	}
	return 0;
}

/*--------------------------------------------------------------------*/
LOCAL int s_get_crc(ULONG *crc)
{
	int c;

	c = mask_recv(); /* CRC  quote 邱Ƃ */
	if (c == TIMEOUT || c > 255) {
		vmessage("\nTimeout 6\n");
		acknowledge_status = S_Send_NAK;
	} else if (c < 0) {
		return c; /* error or interrupt */
	} else {
		if (--get_crc_count == 0)
			acknowledge_status = S_Verify_CRC;
		*crc = (*crc << 8) + c;
	}
	return 0;
}

/*--------------------------------------------------------------------*/
LOCAL void s_verify_crc(ULONG crc)
{
	int crc_ok;

	crc_ok = check_check_value(crc);
	if (crc_ok && data_error == 0) {
		acknowledge_status = S_Verify_Packet;
	} else {
		nolog_message("\n");
		if (crc_ok == 0)
			message(STR_CRC_ERROR); /* CRCv܂ */
		message(STR_DATA_ERROR); /* uf[^[G[Ađ\nv */
		acknowledge_status = S_Send_NAK;
	}
}

#define s_verify_cks s_verify_crc

/*--------------------------------------------------------------------*/
/* sequence mFB
 *	pPbg̎̔ԍł΁AIB
 *	F packet ȂAɏIB
 *	pPbg̍Ō̔ԍł΁AACK ߂B
 *	ȊȌꍇɂ NAK ߂B
 *
 * ҂ԍ̃pPbgꂽꍇ́Apacket_noXVB
 */
#define	ERROR_MAX_COUNT 16
#define ERROR_CLEAR_COUNT 2
LOCAL int nac_count = 0;
LOCAL int ok_count = 0;

LOCAL int s_verify_packet(void)
{
	int sequence;
	int next_seq;

#ifdef DEBUG
		fprintf(stderr, "s_verify_packet (seq = %c, type = %c)\n",
			packet_body[0], packet_body[1]);
#endif

	if (packet_body[1] == 'F') {
		packet_body[packet_size++] = '\0';
		message((char *) packet_body + 3);
		message(STR_GET_INTERRUPT);
		failure_status = RECEIVE_F_PACKET;
		send_ack(packet_body[0] - '0'); /* sequence */
		return FAILURE;
	}

	if (nac_count > 0) {
		if (++ok_count >= ERROR_CLEAR_COUNT) {
			nac_count--;
			ok_count = 0;
		}
	}

	next_seq = (packet_no + 1) % 10;
	sequence = packet_body[0] - '0';
	if (sequence == next_seq) {
		packet_no = next_seq;
		packets[packet_no].active = 1;
		packets[packet_no].size = packet_size; /* sv? */
		return FINISH;
	}

	acknowledge_status = sequence == packet_no ? S_Send_ACK : S_Send_NAK;
	return 0;
}

/*--------------------------------------------------------------------*/
/* G[̃JEǵA̒ʂ
 * nak 𑗐M邲ƂɁA
 *		nac_count  1 
 *		ok_count  0 Ƃ
 *		nac_count  ERROR_MAX_COUNT 𒴂AُI
 * nac_count > 0 ȂAack 𑗐M邲ƂɁA
 *		ok_count  1 
 *		ok_count  ERROR_CLEAR_COUNT ȏȂA
 *			nac_count  1 
 *			ok_count  0 Ƃ
 */
LOCAL int s_send_nak(void)
{
	acknowledge_status = S_Get_DLE;
	nac_count++;
	ok_count = 0;
	if (nac_count > ERROR_MAX_COUNT) {
		return IOERROR;
	}

	if (failure_status)
		return 0;

	return com_send(NAK);
}

/*--------------------------------------------------------------------*/
LOCAL void s_send_ack(void)
{
	acknowledge_status = S_Get_DLE;
	send_ack(packet_no); /* ŌɐɏpPbg */
}

/*--------------------------------------------------------------------*/
LOCAL void s_send_enq(void)
{
	acknowledge_status = S_Get_DLE;
	com_send(ENQ);
	com_send(ENQ);
	after_enq = 2;
}

/*--------------------------------------------------------------------*/
LOCAL int s_resend_packets(void)
{
	int packet_no_end;
	int sts;

	sa_error_count += 3;
	if (sa_error_count >= 12) {
		window_receive = 0;
	}

	packet_no_end = packet_no;
	packet_no = packet_ack;

	for (;;) {
		PACKET *pac;

		packet_no++;
		if (packet_no > 9)
			packet_no = 0;
		if (packet_no == packet_no_end)
			break;

		pac = &packets[packet_no];
		if (pac->active) {
			if (pac->special) {
				if (pac->special == 1) { /* TI packet */
					sts = send_ti_packet(1); /* resend TI packet */
					if (sts < 0)
						break;
				}
			} else {
				if (pac->fp != NULL) {
					int n;

					if (packet_active != packet_no) {
						fseek(pac->fp, pac->pos, SEEK_SET);
						n = fread(packet_body + 1, 1, pac->size - 1, pac->fp);
						if (n != pac->size - 1) {
							send_failure_packet("Iread failure");
							sts = -1;
							break;
						}
						packet_body[0] = 'N';
						packet_size = pac->size;
						packet_active = packet_no;
					}
				} else if (pac->active == 2) { /* packet_body */
					strcpy(packet_body, tx_kind);
					if (tx_kind[1] == 'U' || tx_kind[1] == 'D') {
						strcat(packet_body, real_filename);
					}
				}
				sts = send_ahead_packet();
				if (sts < 0)
					break;
			}
		} else {
			/* ͂̃pPbgȂ ? */
#ifdef DEBUG
			fprintf(debug_fp, "\ns_resend_packet: lost packet asked %c\n",
				packet_no);
#endif
			send_failure_packet("Sbad sequence number");
			sts = -1;
			break;
		}
	}

	acknowledge_status = S_Get_DLE;

	return sts;
}

/*--------------------------------------------------------------------*/
/* ACK ҂Ԃ FSA
 * ack ꂽA0 ߂B
 * packet 󂯎ꍇ́A1 ߂Be current_packetB
 * error ̏ꍇ < 0
 */
STATIC int wait_for_acknowledge(int receive)
{
	ULONG checksum;
	int sts = 0;

	after_enq = 0;
	while (sts >= 0) {
#ifdef DEBUG
		if (acknowledge_status <= S_Resend_Packets) {
			static int last_ack_status;

			if (acknowledge_status != last_ack_status ||
				acknowledge_status != S_Get_Data) {
				fprintf(stderr, "acknowledge_status = %s\n",
					S_status[acknowledge_status]);
			}
			last_ack_status = acknowledge_status;
		} else {
			fprintf(stderr, "acknowledge_status out of range\n");
		}
#endif
		switch (acknowledge_status) {
		case S_Get_DLE:
			sts = s_get_dle(receive);
			break;

		case S_DLE_Seen:
			sts = s_dle_seen(receive);
			break;

		case S_DLE_B_Seen:
			sts = s_dle_b_seen();
			break;

		case S_Get_Data:
			sts = s_get_data();
			break;

		case S_Get_Check:
			sts = s_get_check(&checksum);
			break;

		case S_Get_CRC:
			sts = s_get_crc(&checksum);
			break;

		case S_Verify_CRC:
			s_verify_crc(checksum);
			sts = 0;
			break;

		case S_Veify_CKS:
			s_verify_cks(checksum);
			sts = 0;
			break;

		case S_Verify_Packet:
			sts = s_verify_packet();
			break;

		case S_Send_NAK:
			sts = s_send_nak();
			break;

		case S_Send_ACK:
			s_send_ack();
			sts = 0;
			break;

		case S_Send_ENQ:
			s_send_enq();
			sts = 0;
			break;

		case S_Resend_Packets:
			sts = s_resend_packets();
			break;
		}
	}

	if (sts == FINISH) {
		sts = acknowledge_status == S_Verify_Packet ? 1: 0;
	}
	return sts;
}

/*===== Read a packet ================================================*/
/* ߂l̏ꍇ͊ Failure Packet MĂ̂ŁA
 *   terminal mode ܂ŕA邱ƁB
 * O߂ꍇ́Apacket_bodyɓeĂB
 */
STATIC int read_packet(int initial_status)
{
#if 0
	int next;

	next = packet_no;

	acknowledge_status = initial_status;
	do {
		if (wait_for_acknowledge(1) < 0) {
			return -1;
		}
	} while (packets[next].active == 0); /* pPbgꂽǂmF */

	return 0;
#else
	int next;

	acknowledge_status = initial_status;
	while (packet_ack == packet_no) {
		if (wait_for_acknowledge(1) < 0) {
			return -1;
		}
	}

	/* pPbgꂽǂmF */
	next = (packet_ack + 1) % 10;
	if (packets[next].active)
		return 0;

	return -1;
#endif
}

/*===== Send ahead a packet ==========================================*/
/* w肳ꂽ܂ł̐摗肪łƂOŁAACK ҂
 * ]āA0 ŌĂяo΁AMpPbgɑ΂ ACK SĉB
 * ̊֐̒l߂ꍇ́AFailure Packet ɑMĂB
 *
 * mode == 0 ̏ꍇ́AACK ܂ő҂B
 * mode == 1 ̏ꍇ́ApPbgMꍇɂ 1 ߂B
 * ̏ꍇAfailure packet Mꍇ -1 ߂B
 */
STATIC int wait_ack(int ahead_allowed, int mode)
{
	int sts = 0;
	int send_ahead;

#ifdef DEBUG
	fprintf(debug_fp, "\nwait_ack(%d, %d): pacno=%d, ack=%d\n",
		ahead_allowed, mode, packet_no, packet_ack);
	fprintf(stderr, "\nwait_ack(%d, %d): pacno=%d, ack=%d\n",
		ahead_allowed, mode, packet_no, packet_ack);
#endif
	do {
		/* packet_no͍ŌɑpPbgԍ */
		send_ahead = packet_no - packet_ack;
		if (send_ahead < 0)
			send_ahead += 10;
		if (send_ahead <= ahead_allowed)
			break;
		acknowledge_status = S_Get_DLE;
		sts = wait_for_acknowledge(0);
	} while (mode ? sts == 0 : sts >= 0);

	return sts;
}

/*--------------------------------------------------------------------*/
STATIC int send_ahead_packet(void)
{
	int sts;

	sts = wait_ack(window_receive + 1, 0);
	if (sts >= 0) {
		sts = send_packet(); /* packet_noɑΉpPbg𑗂B */
	}
	return sts;
}

/*--------------------------------------------------------------------*/
STATIC int send_current_packet(int size)
{
	packets[packet_no].size = size;
	return send_ahead_packet();
}

/*--------------------------------------------------------------------*/
STATIC int send_tx_packet(char *s)
{
	int sts;

	strcpy(tx_kind, s);
	strcpy(packet_body, s);
	if (s[1] == 'U' || s[1] == 'D') {
		strcat(packet_body, real_filename);
	}
	packet_no++;
	if (packet_no > 9)
		packet_no = 0;

	packets[packet_no].special = 2; /* Tx */
	packet_active = -1;
	sts = send_current_packet(strlen(packet_body));
	return sts;
}

/*===== Failure packet ==============================================*/
/* Failure packet MBobt@̑SpPbg͖ɂȂB
 * current_packet ͈UNAB
 */
STATIC void send_failure_packet(char *s)
{
	if (failure_status == 0) {
		init_all_packets();
#ifdef DEBUG
		fprintf(debug_fp, "\nsend_FP (%s)\n", s);
#endif
		failure_status = SEND_F_PACKET; /* F packet M */
		packet_body[0] = 'F';
		packets[packet_no].special = 'F'; /* failure */
		strcpy(packet_body + 1, s);

		/* ̃pPbg𑗐MAACK ҂B菇ɖ肠H */
		(void) send_current_packet((int) strlen(packet_body));
		/* (void) wait_ack(0, 0); */
	}
}

/*===== TI packet ====================================================*/
/* TI < 1 ̏ꍇɂ́AĂяoȂ
 */
STATIC int send_ti_packet(int resend)
{
	UCHAR *s;
	int i;
	int size;

	s = packet_body;
	*s++ = 'T';
	*s++ = 'I';
	*s++ = (char) ti_information.data_type;
	*s++ = (char) ti_information.compression;
	for (i = 0; i < 6; i++) {
		add_ulong_to_str(ti_information.info[i], i ? NULL : s);
	}
	strcat((char *) s, ti_information.true_name);

	if (resend == 0) {
		packet_no++;
		if (packet_no > 9)
			packet_no = 0;
	}

	packets[packet_no].pos = 0L;
	packets[packet_no].size = size = strlen((char *) s) + 4;
	packets[packet_no].fp = NULL;
	packets[packet_no].active = 1;
	packets[packet_no].special = 1; /* TI packet */
	packet_active = -1;

	return send_current_packet(size);
}

/*===== File transfer ================================================*/
/* ̕ϐ́Aȉ̊֐ł̂ݎgĂB
 *	scan_byte()
 *	scan_number()
 *	ti_packet()
 */
static UCHAR *scan_ptr;
static UCHAR *scan_end;
static int scan_error;

/*--------------------------------------------------------------------*/
STATIC void scan_init(int skip)
{
	/* pac->body ̑傫ɂׂāApac->size ͏\Ƃz肵
	 * ĂBscan_end ́AK pac->body ̒Ɋ܂܂OB
	 */
	scan_ptr = packet_body + skip;
	scan_end = packet_body + packet_size;
	scan_error = 0;
}

/*--------------------------------------------------------------------*/
/* 1 byte *scan_ptr XLA|C^ړB
 * I[o[̏ꍇɂ scan_error  1 ƂA֐ 0 ߂B
 */
static int scan_byte(void)
{
	if (scan_ptr >= scan_end) {
		scan_error = 1;
		return 0;
	}
	return (int) *scan_ptr++;
}

#if 1
/*--------------------------------------------------------------------*/
static long scan_number(void)
{
	int i;
	int minus = 0;
	int scan = 0;
	long l = (long) 0;

	while (scan_ptr < scan_end) {
		i = (int) *scan_ptr++;
		if (i >= '0' && i <= '9') {
			scan = 2;
			l *= (long) 10;
			l += (long) (i - '0');
		} else if (i == '-') {
			if (scan == 0) {
				minus = 1;
				scan = 1;
			} else {
				scan_error = 1;
				break;
			}
		} else if (i == ' ') {
			if (scan == 2 || scan == 0) { /* 󔒂ǂݔ΂ */
				while ((scan_ptr < scan_end) && (*scan_ptr == ' '))
					scan_ptr++;
				if (scan)
					break;
			} else {
				scan_error = 1;
				break;
			}
		} else {
			scan_error = 1;
			break;
		}
	}

	return minus ? -l : l;
}

#else

/*--------------------------------------------------------------------*/
LOCAL void skip_space(void)
{
	while (*scan_ptr == ' ')
		scan_ptr++;
}

LOCAL long scan_long(void)
{
	long l = (long) 0;
	int i;

	for (;;) {
		i = (int) *scan_ptr;
		if (i >= '0' && i <= '9') {
			l *= (long) 10;
			l += (long) (i - '0');
		} else {
			if (i == 0)
				scan_error = 1;
			break;
		}
		scan_ptr++;
	}
	return l;
}

static long scan_number(void)
{
	long l;
	int minus;

	skip_space();
	if (*scan_ptr == '-') {
		scan_ptr++;
		minus = 1;
	} else {
		minus = 0;
	}
	l = scan_long();
	return minus ? -l : l;
}

#endif

#ifdef WITH_RESUME
/*--------------------------------------------------------------------*/
LOCAL void str_check_value(UCHAR *buf, int n)
{
	while (n-- > 0) {
		add_check_value((int) *buf++);
	}
}

/*--------------------------------------------------------------------*/
/* resume Jn̂߂ɁAt@Cw肵ǂݍ݁ACRC vZ
 * Blength  -1 w肵ꍇɂ́At@CׂēǂݍށB
 * [߂l]
 *		I	ǂݍ񂾒
 *		ُI	-1
 */
STATIC long resume_setup(long length)
{
	FILE *fp;
	UCHAR *buf; /* Ɨp̈͋󂫃pPbg𗘗p */
	ULONG now;
	ULONG start_time;
	int sts;
	long file_size;
	long size;
	size_t n;

	start_time = get_current_time();
	nolog_message(STR_WAIT_A_WHILE); /* u΂炭҂\nv */
	buf = packet_body;

	fp = open_file("rb"); /* real_filename ͐ݒ肳Ă邱 */
	if (fp == NULL) { /* can't open */
		return (long) -1;
	}

	n = fread(buf, 1, 1, fp);
	if (n == 0) { /* gȂ */
		sts = ferror(fp);
		fclose(fp);
		if (sts) {
			message(STR_BAD_FILE); /* ut@CɈُ킪܂\n"v */
			return (long) -1;
		} else {
			message(STR_EMPTY_FILE); /* ut@Ce͋ł\n"v */
			return (long) 0;
		}
	}

	/* check value vZAfile size ߂ */
	file_size = 1;
	clear_check_value(buf[0]);

	while (length < 0 || (size = length - file_size) > 0) {
		if (length < 0 || size > max_packet_size)
			size = max_packet_size;
		n = fread(buf, 1, (size_t) size, fp);
		if (n < 1) {
			break;
		}
		str_check_value(buf, n);
		file_size += n;

		now = get_current_time();
		if (now - start_time > 8) {
			com_ssend("\020;");
			now = start_time;
		}
	}

	/* f[^͓ǂݏI */
	sts = ferror(fp);
	fclose(fp);
	if (sts) { /* read error */
		message(STR_BAD_FILE);
		return (long) -1;
	}

	return file_size;
}

/*--------------------------------------------------------------------*/
/* resume download
 * -1: fatal error, f邱
 * 0: resume ͂łȂ̂ŁAVK_E[h邱
 *  Bug!  I'm sorry, but you can't resume download a file which is larger
 *        than 2147483647 bytes..
 */
LOCAL long resume_start(UCHAR kind)
{
	UCHAR *buf; /* Ɨp̈͋󂫃pPbg𗘗p */
	long file_size;

	file_size = resume_setup((long) -1);
	if (file_size >= 0) {
		buf = packet_body;

		/* ݂ł邱ƂmF邱ƁB
		 * ݂łȂꍇAwrite protect ̉\BI
		 * Ƀt@C̃[hύX邩A邢͕ʃt@CɓeR
		 * s[ĂA overwrite @lB
		 */

		/* Tr packet 쐬 */
		buf[0] = 'T';
		buf[1] = kind;
		if (kind == 'r') {
			ULONG ul;

			add_ulong_to_str(file_size, buf + 2);
			ul = (check_method == 3) ? crc_32 : (ULONG) crc_16;
			if (check_method > 1) {
				ul ^= 0xffffffffUL;
				if (check_method == 2)
					ul &= 0xffff;
			}
			add_ulong_to_str(ul, NULL);
			packet_ack = packet_no; /* ACK͑MȂ */
			packet_no++;
			if (packet_no > 9)
				packet_no = 0;
			if (send_current_packet((int) strlen(buf)) < 0) {
				file_size = (long) -1;
			} else {
				if (wait_ack(0, 0) < 0)
					file_size = (long) -1;
			}
		} else {
#ifdef WITH_INITIATOR
			UCHAR *s;
			ULONG ul;

			buf[2] = 'B'; /* Binary only */
			s = buf + 3;
			add_ulong_to_str(file_size, s);
			ul = (check_method == 3) ? crc_32 : (ULONG) crc_16;
			if (check_method > 1) {
				ul ^= 0xffffffffUL;
				if (check_method == 2)
					ul &= 0xffff;
			}
			add_ulong_to_str(ul, NULL);
			strcat(s, real_filename);
			if (send_current_packet((int) strlen(buf)) < 0)
				file_size = (long) -1;
#endif
		}
	}
	return file_size;
}

#endif /* WITH_RESUME */

/*--------------------------------------------------------------------*/
static int td_filename(void)
{
	UCHAR *fname;

	/* TD pPbg̓ełȂAڃt@Cw肵AۑfBN
	 * gw肷ꍇ̏s
	 */
	fname = (current_file == NULL) ? t_filename : (UCHAR *) current_file->name;
	if (create_real_filename(fname) < 0) {
		return -1;
	}

	/* t@Ĉꍇ́A
	 *  ̃t@C폜ĐVK쐬
	 *  ʂ̖Õt@C쐬
	 *  𒆒f (-1)
	 *   DR > 0 ȂAresume download s
	 * ́A4 IsB
	 */
	downmode = set_td_filename();
	return downmode < 0 ? -1 : 0;
}

/*--------------------------------------------------------------------*/
LOCAL UCHAR *look_buffer = NULL;
LOCAL UCHAR *look_current = NULL;
LOCAL UCHAR *look_end = NULL;

LOCAL void look_char(UCHAR ch)
{
	static UCHAR holdchar = 0;

#ifdef SJIS_TO_EUC
	if (ch == 0x0d)
		return;
#endif

	if (holdchar) {
#ifdef SJIS_TO_EUC
		int sjis_h, sjis_l, euc_h, euc_l;

		sjis_h = (int) holdchar;
		sjis_l = (int) ch;
		if (sjis_l > 0x9e) {
			euc_h = (sjis_h - ((sjis_h > 0x9f) ? 0xb0 : 0x70)) << 1;
			euc_l = sjis_l - 0x7e;
		} else {
			euc_h = ((sjis_h - (sjis_h > 0x9f ? 0xb1 : 0x71)) << 1) + 1;
			euc_l = sjis_l - 0x1f;
			if (sjis_l >= 0x80)
				euc_l--;
		}
		holdchar = (UCHAR) (euc_h | 0x80);
		ch = (UCHAR) (euc_l | 0x80);
#endif
		*look_current++ = holdchar;
		holdchar = 0;
	} else {
#ifdef SJIS_TO_EUC
		if (isMSkanji1st(ch)) {
			holdchar = ch;
			return;
		}
		if (ch > 0x7f) {
			*look_current++ = 0x8e;
		}
#else
		if (iskanji1st(ch)) {
			holdchar = ch;
			return;
		}
#endif
	}
	*look_current++ = ch;
	if (ch == '\n' || look_current >= look_end) {
		*look_current = '\0';
		strout((char *) look_buffer);
		look_current = look_buffer;
	}
}

/*--------------------------------------------------------------------*/
/* packet ̒g\
 */
LOCAL void look_packet(int size, UCHAR *s)
{
	if (look_buffer != NULL) {
		charout('\n');
		while (size-- > 0) {
			look_char(*s++);
		}
		charout('\n');
	}
}

/*--------------------------------------------------------------------*/
/* download B̏ł́AN, T, F, ȊÕpPbg͎󂯎邱
 * łȂB
 * Z^[ -> [ TD pPbg (̊֐ĂяoȌ)
 * resume łȂꍇ
 *    [ -> Z^[ ACK
 *    Z^[ -> [ N pPbgc
 * resume ̏ꍇ́A
 *    [ -> Z^[ Tr pPbg
 *    a) Z^[ -> [ Fr pPbgȂAf
 *    b) Z^[ -> [ Tf pPbgȂAŏ瑗MĂ
 *       [ -> Z^[ ACK
 *    Z^[ -> [ N pPbgc
 */
static int td_packet(int from_initiator)
{
	FILE *fp;
	ULONG recvsize = (ULONG) 0;
	ULONG start_size;
	ULONG start_time;
	ULONG filesize = 0;
	int n;
	int count;
	int size;
	int sts = 0;

	/* t@C쐬At@C̗LAoverwrite mF */
	if (td_filename() < 0) {
		goto error_case;
	}

#ifdef WITH_INITIATOR
	if (from_initiator) {
		if (downmode == DOWNMODE_RESUME) {
#ifdef WITH_RESUME
			/* upload resume JnBterminal ̉ 3 ʂlB
			 * 1: CRC vꍇcɍŏ packet 𑗂Ă
			 *    resume_upload_start() ͐̒l߂
			 * 2: Fr ԂĂꍇ
			 *    resume_upload_start() ͕̒l߂
			 * 3: Tf ԂĂꍇ
			 *   ̏ꍇ́AeقȂĂ̂ŁAVK쐬ɂȂBTf ɑ
			 *    ACK 𑗂΁Aterminal ŏ packet ĂB
			 *    resume_upload_start()  0 ߂
			 */
			recvsize = resume_start((UCHAR) 'u');
			if (recvsize == (ULONG) -1L) { /* F packet M */
				return -1;
			}
#endif /* WITH_RESUME */
		} else {
			sts = send_tx_packet("TUB");
		}
		sts = wait_ack(0, 1); /* ACK f[^܂ő҂ */
	} else {
#endif /* WITH_INITIATOR */

#ifdef WITH_RESUME
		if (downmode == DOWNMODE_RESUME) {
			recvsize = resume_start((UCHAR) 'r'); /* Tr packet 𑗐M */
			if (recvsize == (ULONG) -1L) { /* F packet M */
				return -1;
			}
		}
#endif /* WITH_RESUME */

#ifdef WITH_INITIATOR
	}
#endif

	fp = open_file(downmode ? "ab" : "wb");
	if (fp == NULL) {
		goto error_case;
	}

	/* TD packet ɑ΂ ACK 𑗐MBresume download ̏ꍇ́ATr packet
	 *  ACK 𑗂Ă̂ŁAXLbv
	 */
#ifdef WITH_INITIATOR
	if (!from_initiator)
#endif
#ifdef WITH_RESUME
	if (downmode != DOWNMODE_RESUME)
#endif
	{
		send_ack(packet_no);
	}

	count = 0;
	mes_filename();
	start_time = get_current_time();
	start_size = recvsize; /* xvZp */
	do {
		if (sts == 0)
			sts = read_packet(S_Get_DLE);
		if (sts < 0) {
			message(STR_INTERRUPT); /* u𒆒f܂\nv */
			sts = -1;
			break;
		}
		switch (packet_body[1]) {
		case 'N':
			size = packet_size - 2;
			com_rts_off();
			n = fwrite(packet_body + 2, 1, size, fp);
			com_rts_on();
			if (n < size) {
				/* uݎsłB𒆒f܂\nv */
				message(STR_WRITE_FAILURE);
				send_failure_packet("EWrite failure");
				sts = -1;
			} else {
				if (look_text && ti_information.data_type == 'A') {
					look_packet(size, packet_body + 2);
				}
				send_ack(packet_body[0] - '0');
				recvsize += (ULONG) n;
				if (filesize) {
					sts = mes_datasize(filesize, recvsize, count);
					if (sts < 0) { /* slowdown */
						message(STR_SLOWDOWN);
						send_failure_packet("AUser abort");
						sts = -2;
					}
				} else {
					sts = 0;
				}
			}
			count++;
			break;

		case 'T':
			/* ACK, F packet  transfer() ōs */
			sts = transfer(FROM_DOWNLOAD, fp);
			if (sts == 1) { /* normal end */
				/* TC packet 󂯎Afp  close Ă */
				mes_speed(recvsize - start_size,
					get_current_time() - start_time);
				return 1;
			} else if (sts == 2) { /* TI packet */
				filesize = ti_information.info[0];
				mes_filesize(filesize);
				sts = 0;
			} else if (sts == 3) { /* Tf packet */
#ifdef WITH_RESUME
				/* uev܂BVK쐬܂B\nv */
				fclose(fp);
				fp = NULL;
				message(STR_NOT_MATCHED);
				if (want_to_overwrite()) { /* t@C͔j󂳂 */
					fp = open_file("wb");
				}
				if (fp == NULL) {
					fp = open_tmpfile();
					if (fp == NULL)
						goto error_case;
				}
				recvsize = 0;
				sts = 0;
				downmode = DOWNMODE_NORMAL;
				send_ack(packet_body[0] - '0');
#endif
			}
			/* sts < 0 ̏ꍇɂ́A failure packet ͑Ă */
			break;

		case 'F':
			send_ack(packet_body[0] - '0');
			message(STR_GET_FPACKET); /* u~v󂯎܂v */
			sts = -1;
			break;

		default:
			send_failure_packet("NUnknown packet");
			sts = -1; /* unknown */
			break;
		}
	} while (sts == 0);

	fclose(fp);
	if (sts != -2) {
		decide_to_delete();
	}
	return sts;

error_case:
	send_failure_packet("CCannot create file");
	return -1;
}

/*--------------------------------------------------------------------*/
/* t@C̃TCY߂Bt@C|C^͌Ăтʒuړ
 * ȂB
 */
LOCAL ULONG get_filesize(FILE *fp)
{
	ULONG len;
	ULONG pos;

	pos = ftell(fp);
	fseek(fp, 0L, 2);
	len = ftell(fp);
	fseek(fp, pos, 0);
	return len;
}

/*--------------------------------------------------------------------*/
/*	t@C̍ḗBLZ͉͂Ƀ^[ NULL
 *	߂B
 */
LOCAL FILE *reenter_filename(void)
{
	FILE	*fp;
	char	buf[83];

	do {
		if (ask_filename(buf))
			return NULL;
		if (create_real_filename((UCHAR *) buf) < 0)
			fp = NULL;
		else {
			fp = fopen(real_filename, "rb");
		}
		if (fp == NULL) {
			cannot_open_message();
		}
	} while (fp == NULL);

	return fp;
}

/*--------------------------------------------------------------------*/
LOCAL void create_file_information(void)
{
	int sts;

	ti_information.valid = 0;
	sts = get_file_information((char *) real_filename, ti_information.info);
	if (sts == 0) {
		int length;
		char *s;

		ti_information.data_type = file_type;
		ti_information.compression = 0;
		length = strlen(real_filename);
		s = ti_information.true_name = malloc(length + 2);
		if (s != NULL) {
			*s++ = (char) length;
			strcpy(s, real_filename);
			ti_information.valid = 1;
		}
	}
}

/*--------------------------------------------------------------------*/
/* t@CI[vB
 * append mode ̎ɂ́Aw肳Ăt@CgăI[v
 * I[vłȂꍇɂ́AbZ[W\ NULL ߂B
 */
STATIC FILE *open_tu_file(int atfirst)
{
	FILE *fp;
	UCHAR *fname;
	int at_first_time = atfirst;
	int sts;
	static int second_time;

	do {
		do {
			if (atfirst) {
				fname = t_filename;
				if (!append_mode) {
					if (current_file != NULL)
						fname = (UCHAR *) current_file->name;
				}
#ifdef WITH_INITIATOR
				/* t@Cw肳Ȃ */
				if (fname == NULL)
					return NULL;
#endif
				second_time = 1;
				atfirst = 0;
			} else {
				if (!second_time) {
					if (current_file != NULL)
						current_file = current_file->next;
				}
				second_time = 0;
				if (current_file == NULL) {
					/* append mode Ōゾ烁bZ[W͕sv */
					return NULL;
				}
				fname = (UCHAR *) current_file->name;
			}
			sts = create_real_filename(fname);
			if (sts) {
				if (!append_mode) {
					/* ut@C̏Ɉُ킪܂\nv */
					message(STR_FILENAME_TROUBLE);
					return NULL;
				}
			}
		} while (sts);

		if (at_first_time)
			create_file_information();
		fp = fopen(real_filename, "rb");
		if (fp == NULL) { /* t@CȂ */
			cannot_open_message();
			if (!append_mode)
				return reenter_filename();
		}
	} while (fp == NULL);

	return fp;
}

/*--------------------------------------------------------------------*/
/* upload 
 * Z^[ -> [ Tu
 *    s\ȂA[ -> Z^[ N pPbgc
 *    ss\A܂ UR=1 ȂA[ -> Z^[ Fr pPbgŒf
 *    CRC svōŏ瑗ȂA[ -> Z^[ Tf pPbg
 *    Z^[ -> [ ACK
 *    [ -> Z^[ N pPbg
 */
STATIC int tu_packet(int call_send_ack, FILE *fp)
{
	ULONG filesize;
	ULONG sendsize;
	ULONG startsize;
	ULONG start_time;
	int block_byte;
	int count;
	int n;
	int sts;
	long pos;

	if (fp == NULL) {
		fp = open_tu_file(1); /* ̂ 1 */
		if (fp == NULL) {
			send_failure_packet("MFile not found");
			return -1;
		}
	}

	filesize = get_filesize(fp);
	sendsize = ftell(fp);
	count = 0;
	block_byte = 128 * block_size;

	if (call_send_ack) { /* TU packetւack߂Ă */
		send_ack(packet_no);
	}

	mes_filename();
	mes_filesize(filesize);

	if (file_information > 0 && ti_information.valid) {
		sts = send_ti_packet(0);
		if (sts < 0)
			goto FAILED;
	}

	start_time = get_current_time();
	startsize = sendsize;
	pos = ftell(fp);
	for (;;) {
		packet_body[0] = 'N';
		fseek(fp, pos, SEEK_SET);
		n = fread(packet_body + 1, 1, block_byte, fp);
		if (n == 0) {
			sts = ferror(fp);
			if (sts != 0) {
				send_failure_packet("EFile read failure");
				/* ut@C̓ǂݍݒɈُ킪܂\nv */
				message(STR_READ_TROUBLE);
				break;
			}

			if (!append_mode) { /* I */
				break;
			}

			/* NAK߂ĂɁAđȂ΂ȂȂ̂ŁA
			 * SpPbgackmFĂfclose
			 */
			sts = wait_ack(0, 0);
			if (sts < 0) {
				break;
			}
			fclose(fp);

			fp = open_tu_file(0);
			if (fp == NULL)
				break;
			mes_filename();
			filesize += get_filesize(fp);
			mes_filesize(filesize);
		} else { /* n > 0 */
			packet_no++;
			if (packet_no > 9)
				packet_no = 0;
			packets[packet_no].pos = pos;
			packets[packet_no].size = n;
			packets[packet_no].fp = fp;
			packets[packet_no].active = 0;
			packets[packet_no].special = 0;
			packet_active = packet_no;
			sts = send_current_packet(n + 1);
			if (sts < 0) {
				/* F packet ͑ĂȂ͂ */
				send_failure_packet("ATransfer cancelled");
				break;
			}
			sendsize += (ULONG) n;
			pos += (long) n;
			count++;
			if (mes_datasize(filesize, sendsize, count) < 0) { /* slowdown */
				message(STR_SLOWDOWN);
				send_failure_packet("AUser abort");
				sts = -2;
				break;
			}
		}
	}

FAILED:
	if (fp != NULL) {
		fclose(fp);
	}

	if (sts == 0) {
		sts = send_tx_packet("TC");
		if (sts == 0) {
			sts = wait_ack(0, 0);
		}
		nolog_message("\n");
		mes_speed(filesize - startsize, get_current_time() - start_time);
	}

	return sts == 0 ? 1 : sts;
}

/*--------------------------------------------------------------------*/
LOCAL void date_time(ULONG d, ULONG t)
{
	ldecout(d / 10000L);
	charout('/');
	d %= 10000L;
	ldecout(d / 100);
	charout('/');
	ldecout(d % 100);
	charout(' ');
	showtime(t);
	strout("\n");
}

/*--------------------------------------------------------------------*/
LOCAL void ti_message(void)
{
	char *s;

	if (verbose > 1) {
		strout(STR_FILE_INFO); /* u*** t@C ***\nv */
		strout(STR_DATA_TYPE); /* uo f[^`: v */
		switch (ti_information.data_type) {
		case 'A':
			s = STR_TEXT; /* ueLXgv */
			break;
		case 'B':
			s = STR_BINARY; /* uoCiv */
			break;
		case 'I':
			s = STR_PICTURE; /* u摜v */
			break;
		default:
			s = STR_UNKNOWN_TYPE; /* u(s)v */
			break;
		}
		strout(s);
		strout("\n");
		if (ti_information.compression) {
			strout(STR_COMPRESSION); /* uo f[^k\nv */
		}
		strout(STR_FILESIZE); /* uo t@CTCY: v */
		ldecout(ti_information.info[0]);
		strout(STR_BYTES); /* u bytes\nv */
		if (verbose > 1) {
			strout(STR_TIMEZONE); /* uo ^C][: v */
			decout((int) ti_information.info[1]);
			strout("\n");
		}
		if (ti_information.info[2]) {
			strout(STR_CREATE_TIME); /* uo t@C쐬: v */
			date_time(ti_information.info[2], ti_information.info[3]);
		}
		if (ti_information.info[4]) {
			strout(STR_MODIFY_TIME); /* uo t@CύX: v */
			date_time(ti_information.info[4], ti_information.info[5]);
		}
		if (ti_information.true_name != NULL) {
			strout(STR_TI_FILENAME); /* uo t@C: v */
			strout((char *) ti_information.true_name + 1);
			strout("\n");
		}
	}
}

/*--------------------------------------------------------------------*/
/* TI packet (pac) ̏񂩂AFILE_INFO `̃f[^𐶐A
 * ti_informaition ֊i[B
 */
LOCAL int ti_packet(void)
{
	UCHAR *s;
	int i;
	int length;

	scan_init(3); /* <seq> T I */
	ti_information.valid = 0;
	ti_information.data_type = scan_byte();
	ti_information.compression = scan_byte();
	for (i = 0; i < 6; i++) {
		ti_information.info[i] = scan_number();
	}
	length = scan_byte();
	if (scan_error == 0) {
		ti_information.true_name = s = (UCHAR *) malloc(length + 2);
		if (s != NULL) {
			*s++ = (char) length;
			while (length-- > 0) {
				*s++ = (UCHAR) scan_byte();
			}
			*s = 0;
		}
	}
	if (scan_error)
		return -1;
	ti_information.valid = 1;
	ti_message();
	return 0;
}

/*--------------------------------------------------------------------*/
/* Ȉꍇɂ 1AG[̏ꍇɂ -1 ߂B
 */
static int tc_packet(FILE *fp)
{
	int sts;

	nolog_message(STR_TRANSFER_COMPLETE); /* u\n|]I|\nv */
	sts = ferror(fp);
	fclose(fp);
	if (sts) {
		message(STR_CANT_CLOSE); /* ut@CN[Ył܂\nv */
		send_failure_packet("EError during close");
		return -1;
	}
	send_ack(packet_no);
	if (ti_information.valid && set_ftime) {
		set_file_time((char *) real_filename, ti_information.info);
	}
	return 1;
}

/*--------------------------------------------------------------------*/
/* T packet t@CoAt_filename Ɋi[B
 */
LOCAL int set_t_filename(UCHAR *s, int len)
{
	if (len <= 0)
		return -1;
	free(t_filename);
	t_filename = NULL;
	t_filename = (UCHAR *) malloc(len + 1);
	if (t_filename == NULL)
		return -1;
	memcpy(t_filename, (char *) s, len);
	t_filename[len] = 0;
#ifdef DEBUG
	fprintf(debug_fp, "\nset_t_filename %s\n", t_filename);
#endif

	return 0;
}

#ifdef WITH_RESUME
/*--------------------------------------------------------------------*/
/* upload resume (TU) / download resume (TD)  CRC G[܂
 * file length ُ킪ꍇɌĂ΂BfȂ -1Aŏ珈
 * Ȃ 0 ߂B
 * mode  upload_resume or download_resume ̒lČĂяoB
 */
LOCAL int resume_packet_failed(int mode)
{
	int sts;

	if (mode == 2) {
		sts = send_tx_packet("Tf");
		if (sts == 0)
			sts = wait_ack(0, 0);
	} else { /* mode == 1 */
		send_tx_packet("Fr");
		sts = -1;
	}
	return sts;
}

/*--------------------------------------------------------------------*/
LOCAL int upload_resume_packet(void)
{
	FILE *fp;
	ULONG crc;
	long length;

	/*  ack ͕Kv?? */
	send_ack(packet_body[0] - '0');

	/* Data Type ͖ */
	scan_init(4); /* <seq> T u <datatype> */
	length = scan_number();
	crc = scan_number();
#ifdef DEBUG
	fprintf(debug_fp, "\nupload_resume_packet: length = %ld, crc = %x\n",
		length, crc);
#endif

	/* file name  */
	while (*scan_ptr == ' ')
		scan_ptr++;
	if (scan_error ||
		set_t_filename(scan_ptr, (int) (scan_end - scan_ptr - 3)) < 0) {
		/* something fatal */
		send_failure_packet("MFile not found");
		return -1;
	}
	fp = open_tu_file(1);
	if (fp == NULL)
		return -1;

	length = resume_setup(length);
	if (length < 0 || check_check_value(crc) == 0) {
		/* resume łȂBŏ瑗邱ƂɂȂB */
		if (resume_packet_failed(upload_resume) < 0) {
			/* upload_resume ̏Ԃɏ] Tf ܂ Fr pPbg𑗂A
			 * ŏ瑗M\Ȃ 0 ȏAsȂ畉̒l߂ĂB
			 */
			return -1;
		}
		length = 0;
	}

	fp = open_file("rb");
	if (fp == NULL)
		return -1;

	fseek(fp, length, 0);
	return tu_packet(0, fp);
}
#endif /* WITH_RESUME */

/*--------------------------------------------------------------------*/
/* T pPbg
 * Ɉُ킪΁Å֐o鎞_ Failure Packet Ă
 * BȂAACK ĂB
 */
static int transfer(int mode, FILE *fp)
{
	UCHAR type;
	int sts = -1;

#ifdef DEBUG
	fprintf(debug_fp, "\ntransfer\n");
#endif
	type = packet_body[2];
	if (mode == FROM_TOPLEVEL && (type == 'D' || type == 'U')) {
		ti_information.valid = 0;
		/* t@Cϐ t_filename ɃZbgB
		 */
		sts = set_t_filename(packet_body + 4, packet_size - 4);
		if (sts < 0)
			return sts;
	}

	switch (type) {
	case 'D': /* Download */
		if (mode != FROM_TOPLEVEL)
			goto invalid;
		sts = td_packet(0);
		break;

	case 'U': /* Upload */
		if (mode != FROM_TOPLEVEL)
			goto invalid;
		sts = tu_packet(1, NULL);
		break;

	case 'C': /* Close */
		if (mode == FROM_TOPLEVEL)
			goto invalid;
		sts = tc_packet(fp);
		break;

	case 'I': /* Information */
		sts = ti_packet();
		send_ack(packet_no); /* TI packet ُ͖̈ */
		sts = 2; /* ߒl 2 */
		break;

#ifdef WITH_RESUME
	/* Upload ResumeAFROM_TOPLEVEL ō\ȂǂAKv */
	case 'u':
		if (mode != FROM_TOPLEVEL)
			goto invalid;
		sts = upload_resume_packet();
		break;

	case 'f': /* Tf .. resume failed */
		if (mode == FROM_TOPLEVEL)
			goto invalid;
		sts = 3;
		break;
#endif

	default: /* unknown */
invalid:
		/* uo[Wł͏łȂpPbg܂\nv */
		message(STR_CANT_PROCESS);
		send_failure_packet("NInvalid T Packet");
		sts = -1;
		break;
	}
	return sts;
}

/*===== Setup mode ===================================================*/
static void reset_normal(void)
{
	block_size = 512 / 128;
	set_quoting_level(1); /* Default B+ */
	check_method = CM_IS_CHECKSUM;
	packet_no = packet_ack = 0;
}

/*--------------------------------------------------------------------*/
LOCAL void show_defaults(UCHAR *s, int size, char *message)
{
	int i;
	static char *table [] = {
		"WS=", ", WR=", ", BS=", ", CM=", ", DQ=", ", TL=",
		"\nQ1=", ", Q2=", ", Q3=", ", Q4=", ", Q5=", ", Q6=",
		", Q7=", ", Q8=", "\nDR=", ", UR=", ", FI="
	};

	strout(message);
	for (i = 0; i < size; i++) {
		strout(i < 17 ? table[i] : ", ??=");
		decout((int) *s++);
	}
	charout('\n');
}

/*--------------------------------------------------------------------*/
/* default 킹B
 * ̊֐ "+ packet"MɌĂ΂B
 */
STATIC int set_our_defaults(void)
{
	UCHAR *param;
	int i;
	int size;
	int use_quote_set;

	size = packet_size - 2;
	if (size > sizeof(our_defaults))
		size = sizeof(our_defaults);
	param = packet_body + 2; /* <seq> + */
	if (verbose > 1) {
		show_defaults(param, size, "host: ");
		show_defaults(my_defaults, sizeof(our_defaults), "my  : ");
	}
	memcpy(our_defaults, default_parameters, sizeof(our_defaults));
	use_quote_set = 0;
	for (i = 0; i < size; i++) {
		if (i >= 6 && i <= 13) { /* quote set */
			our_defaults[i] = my_defaults[i] | param[i];
		} else {
			our_defaults[i] =
				my_defaults[i] < param[i] ?
				my_defaults[i] :
				param[i];
		}
	}

	if (size < 13) {
		use_quote_set = 1;
	}

	/* Window Send  Window Receive ́Aւ */
	window_send = our_defaults[1];
	window_receive = our_defaults[0];
	our_defaults[0] = window_send;
	our_defaults[1] = window_receive;

	block_size = our_defaults[2];
	if (block_size == 0) {
		our_defaults[2] = block_size = 512/128;
	}

	/* pPbg̑傫𐧌BƃʂB */
	if (max_packet_size > block_size * 128)
		max_packet_size = block_size * 128;

	check_method = our_defaults[3];
	transport_layer = our_defaults[5];
	if (use_quote_set == 0) {
#ifdef WITH_RESUME
		download_resume = our_defaults[14];
		upload_resume = our_defaults[15];
#endif
		file_information = our_defaults[16];
	}

	return use_quote_set;
}

/*--------------------------------------------------------------------*/
static int set_to_bplus(void)
{
	int sts;
	int default_sts;

	default_sts = set_our_defaults();
	check_method = CM_IS_CHECKSUM; /* for next packet only */
	set_quoting_level(3);

	/* + pPbg𑗐M */
	send_ack(packet_no);

	packet_active = -1;
	packet_body[0] = '+';
	memcpy(packet_body + 1, our_defaults, 17);

	packet_no++;
	if (packet_no > 9)
		packet_no = 0;
	sts = send_current_packet(18);
	check_method = our_defaults[3];
	if (sts == 0) {
		sts = wait_ack(0, 0);
	}

	if (default_sts == 0)
		set_our_quotetable(our_defaults + 6);
	else
		set_quoting_level(our_defaults[4]);

	if (verbose > 1)
		show_defaults(our_defaults, 17, "our :");

	return sts;
}

/*===== Terminal emulation ===========================================*/
/* ^[~i (Terminal Program Status)
 */
#define	TPS_Terminal 0
#define	TPS_DLE_Seen 1
#define	TPS_Get_First_Packet 2

LOCAL int terminal_program_status = TPS_Terminal;
LOCAL char init_string[6] = {DLE, '+', '+', DLE, '0', 0};

/*--------------------------------------------------------------------*/
/* XXX -- Other model/type
 * CA -- ANSI/VT100 Cursor Control
 * SS7o -- 80x24 screen,
 * PB -- Use B protocol
 */
LOCAL char response[] = "#XXX,CA,SS7o,PB,+";

LOCAL void answer_esc_i(void)
{
	char tmp[16];
	int checksum = 0;
	int i;

	for (i = 0; i < sizeof(response); i++) {
		com_send(response[i]);
		checksum += response[i];
	}
	/* 4 ɂȂ悤ɁA擪 '0'  pad B̂߂ɁA10000 ǉ
	 * ĂǍ̎𑗐MĂB
	 */
	ulong_to_str((ULONG) 10000 + checksum, (UCHAR *) tmp);
	com_ssend(tmp + 1);
	com_send(0x0d);
	return;
}

/*--------------------------------------------------------------------*/
LOCAL int terminal(void)
{
	int c;
	int sts = 0;

	c = bp_com_recv();
	switch (c) {
	/* ̃f[^ ENQ ȂAnormal B vgR̐ݒɃZbgŁA
	 * DLE + + DLE 0 𑗐MBԂ TPS_Terminal ̂܂܁B
	 */
	case ENQ:
		com_ssend(init_string); /* <DLE> + + <DLE> 0 */
		reset_normal();
		break;

	/* ̃f[^ DLE ȂAdle_seen() s
	 */
	case DLE:
		terminal_program_status = TPS_DLE_Seen;
		break;

	case ESC:
		c = bp_com_recv();
		if (c == 'I') {
			answer_esc_i();
			break;
		}
		charout(ESC);
		/* fall into default */

	/* ȊÕf[^́Â܂܉ʂɕ\B
	 */
	default:
		if (c >= -256 && c < 0) { /* L[ꂽ */
			sts = -2;
		} else if (c >= 0) {
			charout(c);
		}
		break;
	}
	return sts;
}

/*--------------------------------------------------------------------*/
LOCAL int dle_seen(void)
{
	int c;
	int sts = 0;
	static int dle_count = 0;

	c = bp_com_recv();
	if (c == DLE) {

		dle_count++;
		if (dle_count == 3)
			return -1;
		return 0;
	}
	dle_count = 0;

	if (c == 'B') { /* DLE B ŃpPbgJnł邱Ƃ̊mFƂȂ */
		sts = 0;
		terminal_program_status = TPS_Get_First_Packet;
	} else {
		if (c < 0) { /* Timeout or Error (Cancel) */
			sts = -2;
		}
		terminal_program_status = TPS_Terminal;
	}
	return sts;
}

/*--------------------------------------------------------------------*/
/* terminal mode Ŏ󂯎pPbg̏
 */
LOCAL int get_first_packet(void)
{
	int sts;

	/* ̏Ԃ͕K TPS_Terminal */
	terminal_program_status = TPS_Terminal;

	/* <Sequence> <Type> <Body> <Trailer> ǂݍށB */
	sts = read_packet(S_DLE_B_Seen);
	if (sts < 0) { /* error - Failure Packet N 𑗐M */
#if 0
		send_failure_packet("NFatal error");
#endif
		sts = 0;
	} else {
		switch (packet_body[1]) {
		case '+':
			sts = set_to_bplus();
			break;

		case 'T':
			sts = transfer(FROM_TOPLEVEL, NULL);
			break;

		default:
			send_failure_packet("NNot implemented");
			sts = 0; /* łȂpPbg͖ */
			break;
		}
#ifdef DEBUG
		fprintf(debug_fp, "\nget_first_packet: type = %c\n", packet_body[1]);
#endif
	}

	return sts;
}

/*--------------------------------------------------------------------*/
LOCAL int start_terminal(APPL_PARAM *param)
{
	/* static ϐɃp[^Ԑݒ */
	force = param->flags & FLAGS_FORCE;
	file_type = param->flags & FLAGS_BINARY ? 'B' : 'A';
	set_ftime = param->flags & FLAGS_SETFTIME;
	verbose = param->verbose & 3;
	look_text = param->verbose & 4;
	append_mode = param->append_mode;
	estimate_interval = param->est_interval;
	dirname = param->dirname;
	current_file = param->fnlist;
	my_defaults[2] = param->block_size;
	/* 940604  quote character set̎w */
	memcpy(my_defaults + 6, param->quote, 8);
	speed_limit = param->speed_limit;
	syslog = param->syslog_fp;
#ifdef WITH_RESUME
	if (param->flags & FLAGS_RESUME) {
		my_defaults[14] = download_resume = 2;
		my_defaults[15] = upload_resume = 2;
	}
#endif
	ti_information.valid = 0;

	/* packet ۑ̈̊l
	 * body + wb_ + checksum (4*2 bytes max)
	 */
	packet_body = malloc(max_packet_size + 16);
	if (packet_body == NULL)
		return -1;
	init_all_packets();

	look_buffer = (UCHAR *) malloc(max_packet_size);
	if (look_buffer != NULL) {
		look_current = look_buffer;
		look_end = look_buffer + max_packet_size - 4;
	}
	return 0;
}

/*--------------------------------------------------------------------*/
LOCAL void end_terminal(int sts)
{
	if ((sts < 0) && (failure_status == 0)) {
		send_failure_packet("ATransfer cancelled");
	}
	if (failure_status) {
		do {
			while (com_trecv(2) >= 0)
				;
			com_send('Q'-'@');
		} while (com_trecv(2) >= 0);
	}

	/* packet ۑp̃obt@ */
	free(packet_body);
	packet_body = NULL;
	free(real_filename);
	real_filename = NULL;
	free(t_filename);
	t_filename = NULL;
	free(ti_information.true_name);
	ti_information.true_name = NULL;
	free(look_buffer);
	look_buffer = NULL;
}

/*--------------------------------------------------------------------*/
#ifdef DEBUG
static void print_parameters(APPL_PARAM *param)
{
	if (debug_fp) {
		fprintf(debug_fp, "force: %d\n", param->flags & FLAGS_FORCE);
		fprintf(debug_fp, "verbose: %d\n", param->verbose);
		fprintf(debug_fp, "append_mode: %d\n", param->append_mode);
		fprintf(debug_fp, "skipenq: %d\n", param->flags & FLAGS_SKIPENQ);
		fprintf(debug_fp, "only_once: %d\n", param->flags & FLAGS_ONLY_ONCE);
		fprintf(debug_fp, "block_size: %d\n", param->block_size);
		fprintf(debug_fp, "maskchar: %d\n", param->maskchar);
		fprintf(debug_fp, "dirname: %s\n", param->dirname ? (char *) param->dirname : "none");
		fprintf(debug_fp, "fnlist: %s\n", param->dirname ? "exists" : "none");
#ifdef WITH_INITIATOR
		fprintf(debug_fp, "initiator: %d\n", param->flags & FLAGS_INITIATOR);
#endif
	}
}
#endif

#ifdef WITH_INITIATOR
/*--------------------------------------------------------------------*/
LOCAL int send_plus_packet(void)
{
	int sts;

	set_quoting_level(3);
	packet_body[0] = '+';
	memcpy(packet_body + 1, my_defaults, 17);
	packets[packet_no].pos = 0;
	packets[packet_no].size = 18;
	packets[packet_no].fp = NULL;
	packets[packet_no].active = 1;
	packets[packet_no].special = 3;
	sts = send_current_packet(18);
	if (sts == 0) {
		sts = wait_ack(0, 0);
	}
	if (sts) {
		bpllog("send_plus_packet error");
		return sts;
	}

	sts = read_packet(S_Get_DLE);
	if (sts < 0)
		return -1;
	set_our_defaults();
	set_our_quotetable(our_defaults + 6);
	send_ack(packet_no);
#ifdef DEBUG
	fprintf(debug_fp, "\npacket_ack = %c, packet_no = %c\n",
		packet_ack, packet_no);
#endif
	return 256; /* normal end */
}

/*--------------------------------------------------------------------*/
LOCAL int start_initiator(void)
{
	int i;
	int sts;

	for (;;) {
		sts = com_send(ENQ);
		if (sts < 0)
			return sts;

		do {
			sts = bp_com_recv();
		} while (sts >= 0 && sts != DLE);

		if (sts == TIMEOUT)
			continue;

		if (sts < 0)
			return sts;

		for (i = 1; i < 5; i++) {
			sts = bp_com_recv();
			if (sts != init_string[i])
				break;
		}

		if (i == 5) {
			packet_no++;
			if (packet_no > 9)
				packet_no = 0;
			sts = send_plus_packet();
			if (sts == 256)
				break;
		}
	}

	return sts == 256 ? 0 : -1;
}

#ifdef WITH_RESUME
/*--------------------------------------------------------------------*/
/* Initiator  Tr pPbgB
 */
LOCAL long download_resume_packet(void)
{
	ULONG file_size; /* ۂɓǂݍ񂾃t@C̑傫 */
	ULONG length; /* XLbvTCY */
	ULONG crc;

	scan_init(3); /* "<seq> T r" XLbv */
	length = scan_number();
	crc = scan_number();

	if (scan_error || (length == 0)) {
		return (long) -1;
	}
#ifdef DEBUG
	fprintf(debug_fp, "\nlength = %ld\n", length);
#endif
	file_size = resume_setup(length);
	if ((file_size == (ULONG) -1L) || check_check_value(crc) == 0) {
		return (long) resume_packet_failed(download_resume);
	}
	return file_size;
}
#endif

/*--------------------------------------------------------------------*/
/* TD packet 𑗐MAACK ł͂Ȃ Tr packet ߂ĂƁAresume
 * download sB
 */
LOCAL int download_start(void)
{
	int sts;
	int td_sequence;
	FILE *fp;

	fp = open_tu_file(1); /* wt@CI[vł邱Ƃ̊mF */
	if (fp == NULL) {
		message(STR_BAD_FILENAME);
		return -1;
	}
	fclose(fp);
	fp = NULL;

	sts = send_tx_packet("TDB");
	if (sts < 0)
		return sts;
	td_sequence = packet_no;

#ifdef WITH_RESUME
	sts = wait_ack(0, 1);

	if (sts < 0)
		return sts;

	if (sts > 0) {
		if (packet_body[1] == 'T' && packet_body[2] == 'r') {
			long size = (long) 0;

			/* TU pPbgɑ΂ Tr pPbg߂ĂꍇATU pPb
			 * gւ ACK ƂăJEgB
			 */
			free_packet(td_sequence);

			/* pac  ack őĂ܂BApac ̒͒
			 * download_resume_packet() ĂяoŎgĂ邱Ƃɒ
			 */
			send_ack(packet_no);

			size = download_resume_packet();
			if (size < (long) 0) {
				return -1;
			}
			fp = open_file("rb");
			if (fp == NULL) {
				return -1;
			}
			fseek(fp, size, 0);
		}
	}

#else

	sts = wait_ack(0, 0);

#endif /* WITH_RESUME */

	sts = tu_packet(0, fp);
	return sts;
}

/*--------------------------------------------------------------------*/
int simulate_initiator(APPL_PARAM *param)
{
	int sts; /* ُ͈̎AȂ琳 */

	do {
		sts = start_initiator();
		if (sts < 0)
			break;
		sts = param->flags & FLAGS_UPLOAD ? td_packet(1) : download_start();
	} while (sts == 0 ||
		 ((sts > 0) && ((param->flags & FLAGS_ONLY_ONCE) == 0)));

	end_terminal(sts);

	return sts > 0 ? 0 : sts;
}
#endif

/*--------------------------------------------------------------------*/
/* ʐM
 */
int execute_bpl_session(APPL_PARAM *param)
{
	int sts; /* ُ͈̎AȂ琳 */

#ifdef DEBUG
	print_parameters(param);
#endif

	if (start_terminal(param) < 0) { /* communication port ݒ蓙 */
		return -1;
	}

	reset_normal();

#ifdef WITH_INITIATOR
	if (param->flags & FLAGS_INITIATOR) {
		return simulate_initiator(param);
	}
#endif

	terminal_program_status = TPS_Terminal;
	if (param->flags & FLAGS_SKIPENQ) {
		com_ssend(init_string);
	}

	do {
		switch (terminal_program_status) {
		case TPS_Terminal:
			sts = terminal();
			break;

		case TPS_DLE_Seen:
			sts = dle_seen();
			break;

		case TPS_Get_First_Packet:
			sts = get_first_packet();
			break;
		}

		if (sts > 0) { /* normal end */
			sts = 0;
			if (param->flags & FLAGS_ONLY_ONCE)
				break;
		}
	} while (sts == 0);

	end_terminal(sts);
	return sts;
}

/*===== Written by Phinloda, 1990, 1991, 1995  ========================*/
