/**/

   /***************************************************************************************************/
   /*  shows the PID(s) of a process                                                                  */
   /*  this is a stripped-down version of pstree.cmd that only shows PIDs                             */
   /*  Anton Monroe <amonroe5301@gmail.com>                                                           */
   /***************************************************************************************************/

   Main: /*fold00*/
   /* =============================================================================================== */
   /* =============================================================================================== */
   parse arg MainArgs
   call Init
   call MakeProcList
   PIDlist = PIDof(ProcName)
   PIDlistX = ''
   if Opt.0x then do
         do i = 1 to words(PIDlist)
            PIDlistX = PIDlistX d2x(word(PIDlist, i))
         end i
         PIDlist = strip(PIDlistX)
      end
   if CalledAs == 'FUNCTION' then
      return PIDlist
   else do
         say PIDlist
         exit 0
      end
   /* === End of Main =============================================================================== */

   Init: /*fold00*/
   /* =============================================================================================== */
   /* =============================================================================================== */
   /* Load RexxUtil Library                                                                           */
   if RxFuncQuery('SysLoadFuncs') then do
         call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
         call SysLoadFuncs
      end
   if RxFuncQuery('rxqprocstatus') then do
         call RxFuncAdd 'rxuinit', 'rxu', 'rxuinit'
         call RxuInit
      end
   signal on NoValue

   G. = ''
   parse source . CalledAs G.0me
   G.0me = filespec('name', G.0me)

   /*  the command line is very simple; no need to pull in GetOpts and all its dependencies           */
   Opt. = 0
   ProcName = ''
   do i = 1 to words(MainArgs)
      thisarg = translate(word(MainArgs, i))
      select
         when thisarg == '-HELP' then
            Opt.0help = 1
         when thisarg == '-X' then
            Opt.0x = 1
         when thisarg == '-HEX' then
            Opt.0x = 1
         when thisarg == '-DEBUG' then
            Opt.0debug = 1
         otherwise
            ProcName = ProcName thisarg
      end   /*  select  */
   end i

   ProcName = strip(ProcName)
   if Opt.0help then do
         call Help
         return 0
      end
   if ProcName == '' then do
         call Help
         return 1
      end
   shared = 'G. Opt. Proc.'
   return
   /* === End of Init =============================================================================== */

   PIDof: procedure expose (shared) /*fold00*/
   /* =============================================================================================== */
   /*    returns the PID(s) of a given process name                                                   */
   /*    In:     process name                                                                         */
   /*    Out:    process PID                                                                          */
   /* =============================================================================================== */
   parse upper arg ProcNames
   ret = ''
   /*    there may be more than one process that matches the name, so search whole list               */
   do while ProcNames \= ''
      parse var ProcNames ToMatch ProcNames
      if Opt.0debug then call Mark 'ToMatch'
      do i = 1 to Proc.0
         ToTry = translate(Proc.i.0Pname)
         if ToMatch == filespec('N', ToMatch) then
            ToTry = filespec('N', Proc.i.0Pname)
         if FileExt(ToMatch) \= '' then do
               /*    we cannot just use filespec() to compare filenames because the caller            */
               /*    might be trying to match a path+filename                                         */
               if ReverseAbbrev(ToTry, ToMatch) then do
                     aMatch = Proc.i.0pid
                     if Opt.0debug then call Mark 'ToTry ToMatch', 'found match'
                     ret = ret' 'aMatch
                  end
            end
         else do
               if ReverseAbbrev(ToTry, ToMatch) == 1 ,
                | ReverseAbbrev(ToTry, ToMatch||'.EXE') == 1 ,
                | ReverseAbbrev(ToTry, ToMatch||'.COM') == 1 then do
                     aMatch = Proc.i.0pid
                     if Opt.0debug then call Mark 'ToTry ToMatch', 'found match'
                     ret = ret' 'aMatch
                  end
            end   /*  end else  */
      end i
   end   /*  while ProcNames  */
   ret = NumSort(ret)
   return strip(ret)
   /* === End of PIDof ============================================================================== */

   MakeProcList: /*fold00*/
   /* =============================================================================================== */
   /*    use RXU to get a lot of things we do not need, copy the parts we want to a                   */
   /*    stem with meaningful names                                                                   */
   /* ----------------------------------------------------------------------------------------------- */
   /*    stem q. has complete output of rxqProcStatus, copy only what we need into Proc.              */
   /* =============================================================================================== */
   call RxQProcStatus 'q.'
   Proc. = ''
   do i = 1 to q.0P.0
      Proc.i.0pid = x2d(q.0P.i.1)
      Proc.i.0Pname = q.0P.i.6
   end i
   Proc.0 = q.0P.0
   return 0
   /* === End of MakeProcList ======================================================================= */

   Help: /*fold00*/
   /* =============================================================================================== */
   /* =============================================================================================== */
   call lineout 'stderr', 'Usage:'
   call lineout 'stderr', '   'G.0me '<process name> [<process name> ...] [-x|-hex] [-debug]'
   call lineout 'stderr', 'Examples:'
   call lineout 'stderr', '   'G.0me '4OS2'
   call lineout 'stderr', '   'G.0me '4OS2 -hex'
   call lineout 'stderr', '   'G.0me '4OS2.exe'
   call lineout 'stderr', 'or if used as a Rexx function:'
   call lineout 'stderr', '    PID = PIDof("4OS2")'
   call lineout 'stderr', '    PID = PIDof("4OS2 -hex")'
   call lineout 'stderr', '    if PIDof("4OS2") \= "" then'
   call lineout 'stderr', ''
   call lineout 'stderr', 'Options:'
   call lineout 'stderr', '    -x, -hex     show PID as hex instead of decimal'
   call lineout 'stderr', '    -debug       show some debugging information'
   call lineout 'stderr', ''
   return 1
   /* === End of Help =============================================================================== */

   NumSort: procedure /*fold00*/
   /* =============================================================================================== */
   /*  Usage:                                                                                         */
   /*        string = NumSort(string)                                                                 */
   /*  sorts a space-separated list of positive numbers into numerical order                          */
   /*                                                                                                 */
   /*  Examples:                                                                                      */
   /*        string = NumSort('15 14 1 3 2')                                                          */
   /*           returns "1 2 3 14 15"                                                                 */
   /*                                                                                                 */
   /*  only handles negative numbers above -999999999                                                 */
   /*                                                                                                 */
   /*  This was adapted from the WordSort procedure in Toby Thurston's checkfunc.cmd                  */
   /* =============================================================================================== */
   s = arg(1)
   s = '-999999999' s                                  /* the leading 'null word' simplifies the sort */
   do j = 2 to words(s)
      i = j -1
      if word(s, i) > word(s, j) then do
            key = word(s, j)
            s = delword(s, j, 1)
            do until word(s, i) <= key
               i = i -1
            end
            s = subword(s, 1, i) key subword(s, 1 + i)
         end
   end j
   return space(subword(s, 2))                               /* get rid of the null word at the front */
   /* === End of NumSort ============================================================================ */

   Mark: /*fold00*/
   0Mark:
   /* =============================================================================================== */
   /*  Usage:                                                                                         */
   /*       CALL Mark [<list of variable names>] [, <string>]                                         */
   /* ----------------------------------------------------------------------------------------------- */
   /*  Shows the filename and line number it was called from, the current values of the               */
   /*  variables named, and an informational string                                                   */
   /*  Arg(1) is a list of variable names                                                             */
   /*  Arg(2) can be any descriptive text                                                             */
   /*  Examples:                                                                                      */
   /*      CALL mark 'varA varB', 'At top of the "DO x = 1 to 5" loop'                                */
   /*  If no variable names are given, it will just show a message:                                   */
   /*      CALL mark '', 'At top of the "DO x = 1 to 5" loop'                                         */
   /*                                                                                                 */
   /*  This must share all the variables of whatever routine it was called from.                      */
   /*  I cannot think of a way to do it without setting at least one variable here,                   */
   /*  so reserve the variable '_' for the use of Mark and similar routines.                          */
   /* =============================================================================================== */
   _ = sigl
   call lineout 'stderr', ''
   if arg(2, 'e') ,
    & arg(2) = '' then nop
   else call lineout 'stderr', '[Mark]['value('G.0me')':'_']' arg(2)
   do _ = 1 to 99
      if word(arg(1), _) = '' then leave _
      if symbol(word(arg(1), _)) = 'VAR' then
         call lineout 'stderr', '      '||left(word(arg(1), _), 30)||'= "'||value(word(arg(1), _))||'"'
      if symbol(word(arg(1), _)) = 'LIT' then
         call lineout 'stderr', '      '||left(word(arg(1), _), 30)||' is not defined'
      if symbol(word(arg(1), _)) = 'BAD' then
         call lineout 'stderr', '      '||left(word(arg(1), _), 30)||' is not a variable'
   end _
   drop _
   return 0
   /* === End of 0Mark ============================================================================== */

   NoValue: /*fold00*/
   0NoValue:
   /* =============================================================================================== */
   /*  A simple NoValue handler.                                                                      */
   /*  The only variables it uses are _ and __, which it assumes are not used elsewhere               */
   /* ----------------------------------------------------------------------------------------------- */
   signal off NoValue
   _ = sigl
   parse source . . __
   __ = filespec('name', __)

   call lineout 'stderr', '['__'][NOVALUE Handler] at line '_' for variable "'condition('d')'"'
   call lineout 'stderr', '     ==> 'sourceline(_)
   call lineout 'stderr', 'NOVALUE can also be triggered by a missing CALL'
   exit 9
   /* === End of 0NoValue =========================================================================== */

   FileExt: procedure /*fold00*/
   /* =============================================================================================== */
   /*  Usage:                                                                                         */
   /*        string = FileExt(<filename>)                                                             */
   /*                                                                                                 */
   /*    returns the extension of a file name, like 4os2 "%@ext[]                                     */
   /* =============================================================================================== */
   parse arg Fname
   ret = ''
   Fname = filespec('N', Fname)
   dot = lastpos('.', Fname)
   if dot > 0 then ret = substr(Fname, dot +1)
   return ret
   /* === End of FileExt ============================================================================ */

   ReverseAbbrev: procedure /*fold00*/
   /* =============================================================================================== */
   /*     Usage:                                                                                      */
   /*        ret = ReverseAbbrev(longstring, string)                                                  */
   /*        returns:  1  if there is a match, 0 otherwise                                            */
   /*                                                                                                 */
   /* like ABBREV() but on the right                                                                  */
   /*                                                                                                 */
   /*  Example  :thisRc = ReverseAbbrev('config.sys', '.sys')                                         */
   /*                        would return 1                                                           */
   /*  note that Abbrev() and ReverseAbbrev() are case-sensitive; this would be better:               */
   /*            thisRc = ReverseAbbrev(translate('config.sys'), translate('.sys'))                   */
   /*                                                                                                 */
   /*           ReverseAbbrev( 'C:\OS2\PMDD.SYS', 'PMDD.SYS' ) is 1                                   */
   /*           ReverseAbbrev( 'C:\OS2\PMDD.SYS', 'PMDD.ADD' ) is 0                                   */
   /* which means you must use the complete basename plus extension                                   */
   /* =============================================================================================== */
   /* akm: taken from RXTT.INF                                                                        */
   /*      added minimum length = 1 so a null string will return 0                                    */
   /* =============================================================================================== */

   return abbrev(reverse(arg(1)), reverse(arg(2)), 1)
   /* === End of ReverseAbbrev ====================================================================== */

