/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.jar.Manifest;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentJarClassLoader;
import org.apache.batik.bridge.Messages;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.ScriptHandler;
import org.apache.batik.script.Window;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class BaseScriptingEnvironment {
    public static final String INLINE_SCRIPT_DESCRIPTION = "BaseScriptingEnvironment.constant.inline.script.description";
    protected static final String EVENT_NAME = "event";
    protected static final String ALTERNATE_EVENT_NAME = "evt";
    protected BridgeContext bridgeContext;
    protected UserAgent userAgent;
    protected Document document;
    protected ParsedURL docPURL;

    public static boolean isDynamicDocument(Document document) {
        Element element = document.getDocumentElement();
        if (element.getNamespaceURI().equals("http://www.w3.org/2000/svg")) {
            if (element.getAttributeNS(null, "onabort").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onresize").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onunload").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onscroll").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onzoom").length() > 0) {
                return true;
            }
            return BaseScriptingEnvironment.isDynamicElement(document.getDocumentElement());
        }
        return false;
    }

    public static boolean isDynamicElement(Element element) {
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            String string = element.getLocalName();
            if (string.equals("script")) {
                return true;
            }
            if (string.startsWith("animate") || string.equals("set")) {
                return true;
            }
            if (element.getAttributeNS(null, "onkeyup").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onkeydown").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onkeypress").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onload").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onactivate").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onclick").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onfocusin").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onfocusout").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmousedown").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmousemove").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseout").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseover").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseup").length() > 0) {
                return true;
            }
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && BaseScriptingEnvironment.isDynamicElement((Element)node)) {
                    return true;
                }
                node = node.getNextSibling();
            }
        }
        return false;
    }

    public BaseScriptingEnvironment(BridgeContext bridgeContext) {
        this.bridgeContext = bridgeContext;
        this.document = bridgeContext.getDocument();
        this.docPURL = new ParsedURL(((SVGDocument)this.document).getURL());
        this.userAgent = this.bridgeContext.getUserAgent();
    }

    public org.apache.batik.script.Window createWindow(Interpreter interpreter, String string) {
        return new Window(interpreter, string);
    }

    public org.apache.batik.script.Window createWindow() {
        return this.createWindow(null, null);
    }

    public void initializeEnvironment(Interpreter interpreter, String string) {
        interpreter.bindObject("window", (Object)this.createWindow(interpreter, string));
    }

    public void loadScripts() {
        org.apache.batik.script.Window window = null;
        NodeList nodeList = this.document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "script");
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        while (n2 < n) {
            block23: {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                String string;
                Element element = (Element)nodeList.item(n2);
                String string2 = element.getAttributeNS(null, "type");
                if (string2.length() == 0) {
                    string2 = "text/ecmascript";
                }
                if (string2.equals("application/java-archive")) {
                    try {
                        String string3;
                        string = XLinkSupport.getXLinkHref((Element)element);
                        object5 = new ParsedURL(XMLBaseSupport.getCascadedXMLBase((Element)element), string);
                        this.checkCompatibleScriptURL(string2, (ParsedURL)object5);
                        object4 = null;
                        try {
                            object4 = new URL(this.docPURL.toString());
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        object3 = new DocumentJarClassLoader(new URL(object5.toString()), (URL)object4);
                        object2 = ((URLClassLoader)object3).findResource("META-INF/MANIFEST.MF");
                        if (object2 != null && (string3 = ((Manifest)(object = new Manifest(((URL)object2).openStream()))).getMainAttributes().getValue("Script-Handler")) != null) {
                            ScriptHandler scriptHandler = (ScriptHandler)((ClassLoader)object3).loadClass(string3).newInstance();
                            if (window == null) {
                                window = this.createWindow();
                            }
                            scriptHandler.run(this.document, window);
                        }
                        break block23;
                    }
                    catch (Exception exception) {
                        if (this.userAgent != null) {
                            this.userAgent.displayError(exception);
                        }
                        break block23;
                    }
                }
                string = this.bridgeContext.getInterpreter(string2);
                if (string == null) {
                    object5 = this.bridgeContext.getUserAgent();
                    if (object5 != null) {
                        object5.displayError(new Exception("Unknown language: " + string2));
                    }
                    return;
                }
                if (!hashSet.contains(string2)) {
                    hashSet.add(string2);
                    this.initializeEnvironment((Interpreter)string, string2);
                }
                try {
                    object5 = XLinkSupport.getXLinkHref((Element)element);
                    object3 = Messages.getMessage(INLINE_SCRIPT_DESCRIPTION);
                    if (((String)object5).length() > 0) {
                        object3 = object5;
                        object2 = new ParsedURL(XMLBaseSupport.getCascadedXMLBase((Element)element), (String)object5);
                        this.checkCompatibleScriptURL(string2, (ParsedURL)object2);
                        object4 = new InputStreamReader(object2.openStream());
                    } else {
                        object2 = element.getFirstChild();
                        if (object2 == null) break block23;
                        object = new StringBuffer();
                        while (object2 != null) {
                            ((StringBuffer)object).append(object2.getNodeValue());
                            object2 = object2.getNextSibling();
                        }
                        object4 = new StringReader(((StringBuffer)object).toString());
                    }
                    string.evaluate((Reader)object4, (String)object3);
                }
                catch (IOException iOException) {
                    if (this.userAgent != null) {
                        this.userAgent.displayError(iOException);
                    }
                    return;
                }
                catch (InterpreterException interpreterException) {
                    this.handleInterpreterException(interpreterException);
                    return;
                }
                catch (SecurityException securityException) {
                    if (this.userAgent == null) break block23;
                    this.userAgent.displayError(securityException);
                }
            }
            ++n2;
        }
    }

    protected void checkCompatibleScriptURL(String string, ParsedURL parsedURL) {
        this.userAgent.checkLoadScript(string, parsedURL, this.docPURL);
    }

    public void dispatchSVGLoadEvent() {
        SVGSVGElement sVGSVGElement = (SVGSVGElement)this.document.getDocumentElement();
        String string = sVGSVGElement.getContentScriptType();
        Interpreter interpreter = this.bridgeContext.getInterpreter(string);
        if (interpreter == null) {
            UserAgent userAgent = this.bridgeContext.getUserAgent();
            if (userAgent != null) {
                userAgent.displayError(new Exception("Unknown language: " + string));
            }
            return;
        }
        this.dispatchSVGLoad((Element)sVGSVGElement, interpreter, true, string);
    }

    protected void dispatchSVGLoad(Element element, final Interpreter interpreter, boolean bl, String string) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                this.dispatchSVGLoad((Element)node, interpreter, bl, string);
            }
            node = node.getNextSibling();
        }
        DocumentEvent documentEvent = (DocumentEvent)((Object)element.getOwnerDocument());
        Event event = documentEvent.createEvent("SVGEvents");
        event.initEvent("SVGLoad", false, false);
        EventTarget eventTarget = (EventTarget)((Object)element);
        final String string2 = element.getAttributeNS(null, "onload");
        EventListener eventListener = null;
        if (string2.length() > 0) {
            if (bl) {
                this.checkCompatibleScriptURL(string, this.docPURL);
                bl = false;
            }
            eventListener = new EventListener(){

                public void handleEvent(Event event) {
                    try {
                        interpreter.bindObject(BaseScriptingEnvironment.EVENT_NAME, (Object)event);
                        interpreter.bindObject(BaseScriptingEnvironment.ALTERNATE_EVENT_NAME, (Object)event);
                        interpreter.evaluate((Reader)new StringReader(string2));
                    }
                    catch (IOException iOException) {
                    }
                    catch (InterpreterException interpreterException) {
                        BaseScriptingEnvironment.this.handleInterpreterException(interpreterException);
                    }
                }
            };
            eventTarget.addEventListener("SVGLoad", eventListener, false);
        }
        eventTarget.dispatchEvent(event);
        if (string2.length() > 0) {
            eventTarget.removeEventListener("SVGLoad", eventListener, false);
        }
    }

    protected void dispatchSVGZoomEvent() {
        this.dispatchSVGDocEvent("SVGZoom");
    }

    protected void dispatchSVGScrollEvent() {
        this.dispatchSVGDocEvent("SVGScroll");
    }

    protected void dispatchSVGResizeEvent() {
        this.dispatchSVGDocEvent("SVGResize");
    }

    protected void dispatchSVGDocEvent(String string) {
        SVGSVGElement sVGSVGElement;
        SVGSVGElement sVGSVGElement2 = sVGSVGElement = (SVGSVGElement)this.document.getDocumentElement();
        DocumentEvent documentEvent = (DocumentEvent)((Object)this.document);
        Event event = documentEvent.createEvent("SVGEvents");
        event.initEvent(string, false, false);
        sVGSVGElement2.dispatchEvent(event);
    }

    protected void handleInterpreterException(InterpreterException interpreterException) {
        if (this.userAgent != null) {
            Exception exception = interpreterException.getException();
            this.userAgent.displayError((Exception)(exception == null ? interpreterException : exception));
        }
    }

    protected void handleSecurityException(SecurityException securityException) {
        if (this.userAgent != null) {
            this.userAgent.displayError(securityException);
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;

        public Window(Interpreter interpreter, String string) {
            this.interpreter = interpreter;
            this.language = string;
        }

        public Object setInterval(String string, long l) {
            return null;
        }

        public Object setInterval(Runnable runnable, long l) {
            return null;
        }

        public void clearInterval(Object object) {
        }

        public Object setTimeout(String string, long l) {
            return null;
        }

        public Object setTimeout(Runnable runnable, long l) {
            return null;
        }

        public void clearTimeout(Object object) {
        }

        public DocumentFragment parseXML(String string, Document document) {
            return null;
        }

        public void getURL(String string, Window.GetURLHandler getURLHandler) {
        }

        public void getURL(String string, Window.GetURLHandler getURLHandler, String string2) {
        }

        public void alert(String string) {
        }

        public boolean confirm(String string) {
            return false;
        }

        public String prompt(String string) {
            return null;
        }

        public String prompt(String string, String string2) {
            return null;
        }

        public BridgeContext getBridgeContext() {
            return BaseScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }
    }
}

