/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.MarkerBridge;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.gvt.MarkerShapePainter;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.apache.batik.util.CSSConstants;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;

public abstract class PaintServer
implements SVGConstants,
CSSConstants,
ErrorConstants {
    protected PaintServer() {
    }

    public static ShapePainter convertMarkers(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 36);
        Marker marker = PaintServer.convertMarker(element, value, bridgeContext);
        value = CSSUtilities.getComputedStyle(element, 35);
        Marker marker2 = PaintServer.convertMarker(element, value, bridgeContext);
        value = CSSUtilities.getComputedStyle(element, 34);
        Marker marker3 = PaintServer.convertMarker(element, value, bridgeContext);
        if (marker != null || marker2 != null || marker3 != null) {
            MarkerShapePainter markerShapePainter = new MarkerShapePainter(shapeNode.getShape());
            markerShapePainter.setStartMarker(marker);
            markerShapePainter.setMiddleMarker(marker2);
            markerShapePainter.setEndMarker(marker3);
            return markerShapePainter;
        }
        return null;
    }

    public static Marker convertMarker(Element element, Value value, BridgeContext bridgeContext) {
        if (value.getPrimitiveType() == 21) {
            return null;
        }
        String string = value.getStringValue();
        Element element2 = bridgeContext.getReferencedElement(element, string);
        Bridge bridge = bridgeContext.getBridge(element2);
        if (bridge == null || !(bridge instanceof MarkerBridge)) {
            throw new BridgeException(element, "css.uri.badTarget", new Object[]{string});
        }
        return ((MarkerBridge)bridge).createMarker(bridgeContext, element2, element);
    }

    public static ShapePainter convertFillAndStroke(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Paint paint = PaintServer.convertFillPaint(element, (GraphicsNode)shapeNode, bridgeContext);
        Paint paint2 = PaintServer.convertStrokePaint(element, (GraphicsNode)shapeNode, bridgeContext);
        Shape shape = shapeNode.getShape();
        if (shape == null) {
            return null;
        }
        if (paint != null && paint2 != null) {
            FillShapePainter fillShapePainter = new FillShapePainter(shape);
            fillShapePainter.setPaint(paint);
            StrokeShapePainter strokeShapePainter = new StrokeShapePainter(shape);
            strokeShapePainter.setStroke(PaintServer.convertStroke(element));
            strokeShapePainter.setPaint(paint2);
            CompositeShapePainter compositeShapePainter = new CompositeShapePainter(shape);
            compositeShapePainter.addShapePainter((ShapePainter)fillShapePainter);
            compositeShapePainter.addShapePainter((ShapePainter)strokeShapePainter);
            return compositeShapePainter;
        }
        if (paint2 != null) {
            StrokeShapePainter strokeShapePainter = new StrokeShapePainter(shape);
            strokeShapePainter.setStroke(PaintServer.convertStroke(element));
            strokeShapePainter.setPaint(paint2);
            return strokeShapePainter;
        }
        if (paint != null) {
            FillShapePainter fillShapePainter = new FillShapePainter(shape);
            fillShapePainter.setPaint(paint);
            return fillShapePainter;
        }
        return null;
    }

    public static Paint convertStrokePaint(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 50);
        float f = PaintServer.convertOpacity(value);
        value = CSSUtilities.getComputedStyle(element, 44);
        return PaintServer.convertPaint(element, graphicsNode, value, f, bridgeContext);
    }

    public static Paint convertFillPaint(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 16);
        float f = PaintServer.convertOpacity(value);
        value = CSSUtilities.getComputedStyle(element, 15);
        return PaintServer.convertPaint(element, graphicsNode, value, f, bridgeContext);
    }

    protected static Paint convertPaint(Element element, GraphicsNode graphicsNode, Value value, float f, BridgeContext bridgeContext) {
        if (value.getCssValueType() == 1) {
            switch (value.getPrimitiveType()) {
                case 21: {
                    return null;
                }
                case 25: {
                    return PaintServer.convertColor(value, f);
                }
                case 20: {
                    return PaintServer.convertURIPaint(element, graphicsNode, value, f, bridgeContext);
                }
            }
            throw new Error();
        }
        ListValue listValue = (ListValue)value;
        Value value2 = listValue.item(0);
        switch (value2.getPrimitiveType()) {
            case 25: {
                return PaintServer.convertRGBICCColor(element, value2, (ICCColor)listValue.item(1), f, bridgeContext);
            }
            case 20: {
                Paint paint = PaintServer.silentConvertURIPaint(element, graphicsNode, listValue, f, bridgeContext);
                if (paint != null) break;
                value2 = listValue.item(1);
                switch (value2.getPrimitiveType()) {
                    case 21: {
                        return null;
                    }
                    case 25: {
                        if (listValue.getLength() == 2) {
                            return PaintServer.convertColor(value2, f);
                        }
                        return PaintServer.convertRGBICCColor(element, value2, (ICCColor)listValue.item(2), f, bridgeContext);
                    }
                }
                throw new Error();
            }
        }
        throw new Error();
    }

    public static Paint silentConvertURIPaint(Element element, GraphicsNode graphicsNode, ListValue listValue, float f, BridgeContext bridgeContext) {
        Paint paint = null;
        try {
            paint = PaintServer.convertURIPaint(element, graphicsNode, listValue.item(0), f, bridgeContext);
        }
        catch (BridgeException bridgeException) {
            // empty catch block
        }
        return paint;
    }

    public static Paint convertURIPaint(Element element, GraphicsNode graphicsNode, Value value, float f, BridgeContext bridgeContext) {
        String string = value.getStringValue();
        Element element2 = bridgeContext.getReferencedElement(element, string);
        Bridge bridge = bridgeContext.getBridge(element2);
        if (bridge == null || !(bridge instanceof PaintBridge)) {
            throw new BridgeException(element, "css.uri.badTarget", new Object[]{string});
        }
        return ((PaintBridge)bridge).createPaint(bridgeContext, element2, element, graphicsNode, f);
    }

    public static Color convertRGBICCColor(Element element, Value value, ICCColor iCCColor, float f, BridgeContext bridgeContext) {
        Color color = null;
        if (iCCColor != null) {
            color = PaintServer.convertICCColor(element, iCCColor, f, bridgeContext);
        }
        if (color == null) {
            color = PaintServer.convertColor(value, f);
        }
        return color;
    }

    public static Color convertICCColor(Element element, ICCColor iCCColor, float f, BridgeContext bridgeContext) {
        String string = iCCColor.getColorProfile();
        if (string == null) {
            return null;
        }
        SVGColorProfileElementBridge sVGColorProfileElementBridge = (SVGColorProfileElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "color-profile");
        if (sVGColorProfileElementBridge == null) {
            return null;
        }
        ICCColorSpaceExt iCCColorSpaceExt = sVGColorProfileElementBridge.createICCColorSpaceExt(bridgeContext, element, string);
        if (iCCColorSpaceExt == null) {
            return null;
        }
        int n = iCCColor.getNumberOfColors();
        float[] fArray = new float[n];
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = iCCColor.getColor(n2);
            ++n2;
        }
        float[] fArray2 = iCCColorSpaceExt.intendedToRGB(fArray);
        return new Color(fArray2[0], fArray2[1], fArray2[2], f);
    }

    public static Color convertColor(Value value, float f) {
        int n = PaintServer.resolveColorComponent(value.getRed());
        int n2 = PaintServer.resolveColorComponent(value.getGreen());
        int n3 = PaintServer.resolveColorComponent(value.getBlue());
        return new Color(n, n2, n3, Math.round(f * 255.0f));
    }

    /*
     * Unable to fully structure code
     */
    public static Stroke convertStroke(Element var0) {
        block4: {
            var1_1 = CSSUtilities.getComputedStyle(var0, 51);
            var2_2 = var1_1.getFloatValue();
            if (var2_2 == 0.0f) {
                return null;
            }
            var1_1 = CSSUtilities.getComputedStyle(var0, 47);
            var3_3 = PaintServer.convertStrokeLinecap(var1_1);
            var1_1 = CSSUtilities.getComputedStyle(var0, 48);
            var4_4 = PaintServer.convertStrokeLinejoin(var1_1);
            var1_1 = CSSUtilities.getComputedStyle(var0, 49);
            var5_5 = PaintServer.convertStrokeMiterlimit(var1_1);
            var1_1 = CSSUtilities.getComputedStyle(var0, 45);
            var6_6 = PaintServer.convertStrokeDasharray(var1_1);
            var7_7 = 0.0f;
            if (var6_6 == null || !((var7_7 = (var1_1 = CSSUtilities.getComputedStyle(var0, 46)).getFloatValue()) < 0.0f)) break block4;
            var8_8 = 0.0f;
            var9_9 = 0;
            while (var9_9 < var6_6.length) {
                var8_8 += var6_6[var9_9];
                ++var9_9;
            }
            if (var6_6.length % 2 != 0) {
                var8_8 *= 2.0f;
            }
            if (var8_8 != 0.0f) ** GOTO lbl27
            var7_7 = 0.0f;
            break block4;
lbl-1000:
            // 1 sources

            {
                var7_7 += var8_8;
lbl27:
                // 2 sources

                ** while (var7_7 < 0.0f)
            }
        }
        return new BasicStroke(var2_2, var3_3, var4_4, var5_5, var6_6, var7_7);
    }

    public static float[] convertStrokeDasharray(Value value) {
        float[] fArray = null;
        if (value.getCssValueType() == 2) {
            int n = value.getLength();
            fArray = new float[n];
            float f = 0.0f;
            int n2 = 0;
            while (n2 < fArray.length) {
                fArray[n2] = value.item(n2).getFloatValue();
                f += fArray[n2];
                ++n2;
            }
            if (f == 0.0f) {
                fArray = null;
            }
        }
        return fArray;
    }

    public static float convertStrokeMiterlimit(Value value) {
        float f = value.getFloatValue();
        return f < 1.0f ? 1.0f : f;
    }

    public static int convertStrokeLinecap(Value value) {
        String string = value.getStringValue();
        switch (string.charAt(0)) {
            case 'b': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 's': {
                return 2;
            }
        }
        throw new Error();
    }

    public static int convertStrokeLinejoin(Value value) {
        String string = value.getStringValue();
        switch (string.charAt(0)) {
            case 'm': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 'b': {
                return 2;
            }
        }
        throw new Error();
    }

    public static int resolveColorComponent(Value value) {
        switch (value.getPrimitiveType()) {
            case 2: {
                float f = value.getFloatValue();
                f = f > 100.0f ? 100.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(255.0f * f / 100.0f);
            }
            case 1: {
                float f = value.getFloatValue();
                f = f > 255.0f ? 255.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(f);
            }
        }
        throw new Error();
    }

    public static float convertOpacity(Value value) {
        float f = value.getFloatValue();
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }
}

