/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGPathElementBridge
extends SVGDecoratedShapeElementBridge {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();

    public String getLocalName() {
        return "path";
    }

    public Bridge getInstance() {
        return new SVGPathElementBridge();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        String string = element.getAttributeNS(null, "d");
        if (string.length() == 0) return;
        AWTPathProducer aWTPathProducer = new AWTPathProducer();
        aWTPathProducer.setWindingRule(CSSUtilities.convertFillRule(element));
        try {
            try {
                PathParser pathParser = new PathParser();
                pathParser.setPathHandler((PathHandler)aWTPathProducer);
                pathParser.parse(string);
            }
            catch (ParseException parseException) {
                BridgeException bridgeException = new BridgeException(element, "attribute.malformed", new Object[]{"d"});
                bridgeException.setGraphicsNode((GraphicsNode)shapeNode);
                throw bridgeException;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            shapeNode.setShape(aWTPathProducer.getShape());
            throw throwable;
        }
        shapeNode.setShape(aWTPathProducer.getShape());
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("d")) {
            if (mutationEvent.getNewValue().length() == 0) {
                ((ShapeNode)this.node).setShape(DEFAULT_SHAPE);
            } else {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            }
            this.handleGeometryChanged();
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }
}

