/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGAltGlyphHandler;
import org.apache.batik.bridge.SVGFontUtilities;
import org.apache.batik.bridge.SVGTextPathElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGTextContent;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SVGTextElementBridge
extends AbstractGraphicsNodeBridge
implements SVGTextContent {
    protected static final Integer ZERO = new Integer(0);
    protected AttributedString layoutedText;
    protected DOMChildNodeRemovedEventListener childNodeRemovedEventListener = new DOMChildNodeRemovedEventListener();
    protected DOMSubtreeModifiedEventListener subtreeModifiedEventListener = new DOMSubtreeModifiedEventListener();
    private boolean hasNewACI;
    private Element cssProceedElement;

    public String getLocalName() {
        return "text";
    }

    public Bridge getInstance() {
        return new SVGTextElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        TextNode textNode = (TextNode)super.createGraphicsNode(bridgeContext, element);
        if (textNode == null) {
            return null;
        }
        if (bridgeContext.getTextPainter() != null) {
            textNode.setTextPainter(bridgeContext.getTextPainter());
        }
        RenderingHints renderingHints = CSSUtilities.convertTextRendering(element, null);
        if ((renderingHints = CSSUtilities.convertColorRendering(element, renderingHints)) != null) {
            textNode.setRenderingHints(renderingHints);
        }
        textNode.setLocation(this.getLocation(bridgeContext, element));
        return textNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new TextNode();
    }

    protected Point2D getLocation(BridgeContext bridgeContext, Element element) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(stringTokenizer.nextToken(), "x", context);
        }
        string = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(stringTokenizer.nextToken(), "y", context);
        }
        return new Point2D.Float(f, f2);
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        element.normalize();
        this.computeLayoutedText(bridgeContext, element, graphicsNode);
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setClip(CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext));
        graphicsNode.setPointerEventType(CSSUtilities.convertPointerEvents(element));
        if (bridgeContext.isDynamic()) {
            this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        }
        SVGUtilities.bridgeChildren(bridgeContext, element);
    }

    public boolean isComposite() {
        return false;
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        EventTarget eventTarget = (EventTarget)((Object)element);
        eventTarget.addEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        bridgeContext.storeEventListener(eventTarget, "DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        eventTarget.addEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        bridgeContext.storeEventListener(eventTarget, "DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                this.addContextToChild(bridgeContext, (Element)node);
            }
            node = node.getNextSibling();
        }
    }

    protected void addContextToChild(BridgeContext bridgeContext, Element element) {
        if (element.getNamespaceURI().equals("http://www.w3.org/2000/svg")) {
            if (element.getLocalName().equals("tspan")) {
                ((SVGOMElement)element).setSVGContext((SVGContext)new TspanBridge(bridgeContext, this, element));
            } else if (element.getLocalName().equals("textPath")) {
                ((SVGOMElement)element).setSVGContext((SVGContext)new TextPathBridge(bridgeContext, this, element));
            } else if (element.getLocalName().equals("tref")) {
                ((SVGOMElement)element).setSVGContext((SVGContext)new TRefBridge(bridgeContext, this, element));
            }
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                this.addContextToChild(bridgeContext, (Element)node);
            }
            node = node.getNextSibling();
        }
    }

    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                this.layoutedText = null;
                break;
            }
            case 1: {
                String string;
                if (!node.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !(string = node.getLocalName()).equals("tspan") && !string.equals("altGlyph") && !string.equals("a") && !string.equals("textPath") && !string.equals("tref")) break;
                this.addContextToChild(this.ctx, (Element)node);
                this.layoutedText = null;
                break;
            }
        }
        if (this.layoutedText == null) {
            this.computeLayoutedText(this.ctx, this.e, this.node);
        }
    }

    public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
        EventTarget eventTarget = mutationEvent.getTarget();
        eventTarget.removeEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        eventTarget.removeEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        super.handleDOMNodeRemovedEvent(mutationEvent);
    }

    public void handleDOMChildNodeRemovedEvent(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                if (!this.isParentDisplayed(node)) break;
                this.layoutedText = null;
                break;
            }
            case 1: {
                String string;
                if (!node.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !(string = node.getLocalName()).equals("tspan") && !string.equals("altGlyph") && !string.equals("a") && !string.equals("textPath") && !string.equals("tref")) break;
                this.layoutedText = null;
                break;
            }
        }
    }

    public void handleDOMSubtreeModifiedEvent(MutationEvent mutationEvent) {
        if (this.layoutedText == null) {
            this.computeLayoutedText(this.ctx, this.e, this.node);
        }
    }

    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        if (this.isParentDisplayed(node)) {
            this.layoutedText = null;
        }
    }

    protected boolean isParentDisplayed(Node node) {
        String string;
        Node node2 = node.getParentNode();
        return node2.getNodeType() == 1 && node2.getNamespaceURI().equals("http://www.w3.org/2000/svg") && ((string = node2.getLocalName()).equals("text") || string.equals("tspan") || string.equals("altGlyph") || string.equals("a") || string.equals("textPath") || string.equals("tref"));
    }

    protected void computeLayoutedText(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        AttributedString attributedString = this.buildAttributedString(bridgeContext, element);
        this.addGlyphPositionAttributes(attributedString, element, bridgeContext);
        if (bridgeContext.isDynamic()) {
            this.layoutedText = new AttributedString(attributedString.getIterator());
        }
        TextNode textNode = (TextNode)graphicsNode;
        textNode.setAttributedCharacterIterator(attributedString.getIterator());
        TextDecoration textDecoration = this.getTextDecoration(element, (GraphicsNode)textNode, new TextDecoration(), bridgeContext);
        this.addPaintAttributes(attributedString, element, textNode, textDecoration, bridgeContext);
        textNode.setAttributedCharacterIterator(attributedString.getIterator());
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate")) {
            if (string.equals("x") || string.equals("y")) {
                ((TextNode)this.node).setLocation(this.getLocation(this.ctx, this.e));
            }
            this.computeLayoutedText(this.ctx, this.e, this.node);
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }

    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
        this.hasNewACI = false;
        int[] nArray = cSSEngineEvent.getProperties();
        int n = 0;
        while (n < nArray.length) {
            switch (nArray[n]) {
                case 1: 
                case 11: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 32: 
                case 52: 
                case 55: 
                case 57: 
                case 58: {
                    if (this.hasNewACI) break;
                    this.hasNewACI = true;
                    this.computeLayoutedText(this.ctx, this.e, this.node);
                }
            }
            ++n;
        }
        this.cssProceedElement = cSSEngineEvent.getElement();
        super.handleCSSEngineEvent(cSSEngineEvent);
        this.cssProceedElement = null;
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 15: 
            case 16: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: {
                AttributedString attributedString;
                TextDecoration textDecoration;
                if (this.hasNewACI) break;
                this.hasNewACI = true;
                TextNode textNode = (TextNode)this.node;
                if (this.cssProceedElement == this.e) {
                    textDecoration = new TextDecoration();
                    attributedString = new AttributedString(this.layoutedText.getIterator());
                } else {
                    textDecoration = this.getParentTextDecoration(textNode.getAttributedCharacterIterator(), this.cssProceedElement);
                    attributedString = new AttributedString(textNode.getAttributedCharacterIterator());
                }
                textNode.setAttributedCharacterIterator(attributedString.getIterator());
                TextDecoration textDecoration2 = this.getTextDecoration(this.cssProceedElement, (GraphicsNode)textNode, textDecoration, this.ctx);
                this.addPaintAttributes(attributedString, this.cssProceedElement, textNode, textDecoration2, this.ctx);
                textNode.setAttributedCharacterIterator(attributedString.getIterator());
                break;
            }
            case 54: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertTextRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            case 9: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertColorRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element) {
        AttributedStringBuffer attributedStringBuffer = new AttributedStringBuffer();
        this.fillAttributedStringBuffer(bridgeContext, element, true, null, attributedStringBuffer);
        return attributedStringBuffer.toAttributedString();
    }

    protected void fillAttributedStringBuffer(BridgeContext bridgeContext, Element element, boolean bl, TextPath textPath, AttributedStringBuffer attributedStringBuffer) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return;
        }
        String string = XMLSupport.getXMLSpace((Element)element);
        boolean bl2 = string.equals("preserve");
        boolean bl3 = true;
        boolean bl4 = !bl2;
        boolean bl5 = !bl2;
        Element element2 = element;
        Map map = null;
        Node node = element.getFirstChild();
        while (node != null) {
            boolean bl6 = node.getNextSibling() == null;
            int n = attributedStringBuffer.getLastChar();
            bl4 = !bl2 && bl3 && (bl || n == 32 || n == -1);
            switch (node.getNodeType()) {
                case 1: {
                    Object object;
                    Object object2;
                    Object object3;
                    if (node.getNamespaceURI() != "http://www.w3.org/2000/svg") break;
                    element2 = (Element)node;
                    String string2 = node.getLocalName();
                    if (string2.equals("tspan") || string2.equals("altGlyph")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, textPath, attributedStringBuffer);
                        break;
                    }
                    if (string2.equals("textPath")) {
                        object3 = (SVGTextPathElementBridge)bridgeContext.getBridge(element2);
                        object2 = ((SVGTextPathElementBridge)object3).createTextPath(bridgeContext, element2);
                        if (object2 == null) break;
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, (TextPath)object2, attributedStringBuffer);
                        break;
                    }
                    if (string2.equals("tref")) {
                        object3 = XLinkSupport.getXLinkHref((Element)((Element)node));
                        object2 = bridgeContext.getReferencedElement((Element)node, (String)object3);
                        string = TextUtilities.getElementContent((Element)object2);
                        if ((string = this.normalizeString(string, bl2, bl4, bl6 && bl)) == null) break;
                        boolean bl7 = bl5 = !bl2 && string.charAt(0) == ' ';
                        if (bl5 && !attributedStringBuffer.isEmpty()) {
                            attributedStringBuffer.stripLast();
                        }
                        object = this.getAttributeMap(bridgeContext, element2, textPath);
                        attributedStringBuffer.append(string, (Map)object);
                        break;
                    }
                    if (!string2.equals("a")) break;
                    object3 = (EventTarget)((Object)element2);
                    object2 = bridgeContext.getUserAgent();
                    object = new SVGAElementBridge.AnchorListener((UserAgent)object2);
                    object3.addEventListener("click", (EventListener)object, false);
                    bridgeContext.storeEventListener((EventTarget)object3, "click", (EventListener)object, false);
                    this.fillAttributedStringBuffer(bridgeContext, element2, false, textPath, attributedStringBuffer);
                    break;
                }
                case 3: 
                case 4: {
                    string = node.getNodeValue();
                    string = this.normalizeString(string, bl2, bl4, bl6 && bl);
                    if (string == null) break;
                    boolean bl8 = bl5 = !bl2 && string.charAt(0) == ' ';
                    if (bl5 && !attributedStringBuffer.isEmpty()) {
                        attributedStringBuffer.stripLast();
                    }
                    if (map == null) {
                        map = this.getAttributeMap(bridgeContext, element, textPath);
                    }
                    attributedStringBuffer.append(string, map);
                }
            }
            bl3 = false;
            node = node.getNextSibling();
        }
    }

    protected String normalizeString(String string, boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        stringBuffer.append(' ');
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n;
            }
        } else {
            char c;
            boolean bl4 = false;
            int n = 0;
            if (bl2) {
                block11: while (n < string.length()) {
                    switch (string.charAt(n)) {
                        default: {
                            break block11;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            ++n;
                        }
                    }
                }
            }
            int n2 = n;
            while (n2 < string.length()) {
                c = string.charAt(n2);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        if (bl4) break;
                        stringBuffer.append(' ');
                        bl4 = true;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        bl4 = false;
                    }
                }
                ++n2;
            }
            if (bl3) {
                while ((c = stringBuffer.length()) > '\u0000') {
                    if (stringBuffer.charAt(c - '\u0001') == ' ') {
                        stringBuffer.deleteCharAt(c - '\u0001');
                        continue;
                    }
                    break;
                }
            }
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        if (bl2 && bl3) {
            return " ";
        }
        return null;
    }

    protected boolean nodeAncestorOf(Node node, Node node2) {
        if (node2 == null || node == null) {
            return false;
        }
        Node node3 = node2.getParentNode();
        while (node3 != null && node3 != node) {
            node3 = node3.getParentNode();
        }
        return node3 == node;
    }

    protected void addGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        int n;
        int n2;
        ArrayList arrayList;
        Object object;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n3 = -1;
        int n4 = 0;
        while (n4 < attributedCharacterIterator.getEndIndex()) {
            attributedCharacterIterator.setIndex(n4);
            Element element2 = (Element)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 == element || this.nodeAncestorOf(element, element2)) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        if (n3 == -1) {
            return;
        }
        int n5 = attributedCharacterIterator.getEndIndex() - 1;
        int n6 = attributedCharacterIterator.getEndIndex() - 1;
        while (n6 >= 0) {
            attributedCharacterIterator.setIndex(n6);
            object = (Element)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (object == element || this.nodeAncestorOf(element, (Node)object)) {
                n5 = n6;
                break;
            }
            --n6;
        }
        object = element.getAttributeNS(null, "x");
        String string = element.getAttributeNS(null, "y");
        String string2 = element.getAttributeNS(null, "dx");
        String string3 = element.getAttributeNS(null, "dy");
        String string4 = element.getAttributeNS(null, "rotate");
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        if (((String)object).length() != 0) {
            arrayList = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "x", (String)object, bridgeContext);
            n2 = arrayList.size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n5) {
                    attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.X, arrayList.get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string.length() != 0) {
            arrayList = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "y", string, bridgeContext);
            n2 = arrayList.size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n5) {
                    attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.Y, arrayList.get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string2.length() != 0) {
            arrayList = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "dx", string2, bridgeContext);
            n2 = arrayList.size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n5) {
                    attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.DX, arrayList.get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string3.length() != 0) {
            arrayList = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "dy", string3, bridgeContext);
            n2 = arrayList.size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n5) {
                    attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.DY, arrayList.get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string4.length() != 0) {
            arrayList = TextUtilities.svgRotateArrayToFloats(element, "rotate", string4, bridgeContext);
            n2 = arrayList.size();
            if (n2 == 1) {
                attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ROTATION, arrayList.get(0), n3, n5 + 1);
            } else {
                n = 0;
                while (n < n2) {
                    if (n3 + n <= n5) {
                        attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ROTATION, arrayList.get(n), n3 + n, n3 + n + 1);
                    }
                    ++n;
                }
            }
        }
        this.addChildGlyphPositionAttributes(attributedString, element, bridgeContext);
    }

    protected void addChildGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            String string;
            if (node.getNodeType() == 1 && "http://www.w3.org/2000/svg".equals(node.getNamespaceURI()) && ((string = node.getLocalName()).equals("tspan") || string.equals("altGlyph") || string.equals("a") || string.equals("textPath") || string.equals("tref"))) {
                this.addGlyphPositionAttributes(attributedString, (Element)node, bridgeContext);
            }
            node = node.getNextSibling();
        }
    }

    protected void addPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextDecoration textDecoration, BridgeContext bridgeContext) {
        Object object;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n = -1;
        int n2 = 0;
        while (n2 < attributedCharacterIterator.getEndIndex()) {
            attributedCharacterIterator.setIndex(n2);
            Element element2 = (Element)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 == element || this.nodeAncestorOf(element, element2)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        int n3 = attributedCharacterIterator.getEndIndex() - 1;
        int n4 = attributedCharacterIterator.getEndIndex() - 1;
        while (n4 >= 0) {
            attributedCharacterIterator.setIndex(n4);
            object = (Element)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (object == element || this.nodeAncestorOf(element, (Node)object)) {
                n3 = n4;
                break;
            }
            --n4;
        }
        object = CSSUtilities.convertOpacity(element);
        attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.OPACITY, object, n, n3 + 1);
        Paint paint = PaintServer.convertFillPaint(element, (GraphicsNode)textNode, bridgeContext);
        attributedString.addAttribute(TextAttribute.FOREGROUND, paint, n, n3 + 1);
        Paint paint2 = PaintServer.convertStrokePaint(element, (GraphicsNode)textNode, bridgeContext);
        attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT, paint2, n, n3 + 1);
        Stroke stroke = PaintServer.convertStroke(element);
        attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.STROKE, stroke, n, n3 + 1);
        if (textDecoration != null) {
            attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT, textDecoration.underlinePaint, n, n3 + 1);
            attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT, textDecoration.underlineStrokePaint, n, n3 + 1);
            attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE, textDecoration.underlineStroke, n, n3 + 1);
            attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT, textDecoration.overlinePaint, n, n3 + 1);
            attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT, textDecoration.overlineStrokePaint, n, n3 + 1);
            attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE, textDecoration.overlineStroke, n, n3 + 1);
            attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT, textDecoration.strikethroughPaint, n, n3 + 1);
            attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT, textDecoration.strikethroughStrokePaint, n, n3 + 1);
            attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE, textDecoration.strikethroughStroke, n, n3 + 1);
        }
        this.addChildPaintAttributes(attributedString, element, textNode, textDecoration, bridgeContext);
    }

    protected void addChildPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextDecoration textDecoration, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            String string;
            if (node.getNodeType() == 1 && "http://www.w3.org/2000/svg".equals(node.getNamespaceURI()) && ((string = node.getLocalName()).equals("tspan") || string.equals("altGlyph") || string.equals("a") || string.equals("textPath") || string.equals("tref"))) {
                Element element2 = (Element)node;
                TextDecoration textDecoration2 = this.getTextDecoration(element2, (GraphicsNode)textNode, textDecoration, bridgeContext);
                this.addPaintAttributes(attributedString, element2, textNode, textDecoration2, bridgeContext);
            }
            node = node.getNextSibling();
        }
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, TextPath textPath) {
        String string;
        Object object;
        Object object2;
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        boolean bl = false;
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER, element);
        if (element.getTagName().equals("altGlyph")) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER, new SVGAltGlyphHandler(bridgeContext, element));
        }
        if (textPath != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH, textPath);
        }
        TextNode.Anchor anchor = TextUtilities.convertTextAnchor(element);
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE, anchor);
        Float f = TextUtilities.convertFontSize(element);
        hashMap.put(TextAttribute.SIZE, f);
        Float f2 = TextUtilities.convertFontWeight(element);
        Value value = CSSUtilities.getComputedStyle(element, 27);
        String string2 = value.getCssText();
        hashMap.put(TextAttribute.WEIGHT, f2);
        String string3 = CSSUtilities.getComputedStyle(element, 25).getStringValue();
        hashMap.put(TextAttribute.POSTURE, TextUtilities.convertFontStyle(element));
        String string4 = CSSUtilities.getComputedStyle(element, 24).getStringValue();
        hashMap.put(TextAttribute.WIDTH, TextUtilities.convertFontStretch(element));
        Value value2 = CSSUtilities.getComputedStyle(element, 21);
        Vector<GVTFontFamily> vector = new Vector<GVTFontFamily>();
        int n = value2.getLength();
        int n2 = 0;
        while (n2 < n) {
            object2 = value2.item(n2);
            object = object2.getStringValue();
            GVTFontFamily gVTFontFamily = SVGFontUtilities.getFontFamily(element, bridgeContext, (String)object, string2, string3);
            vector.add(gVTFontFamily);
            ++n2;
        }
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES, vector);
        object2 = TextUtilities.convertBaselineShift(element);
        if (object2 != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, object2);
        }
        if ((string = (value2 = CSSUtilities.getComputedStyle(element, 55)).getStringValue()).charAt(0) == 'n') {
            hashMap.put(TextAttribute.BIDI_EMBEDDING, ZERO);
        } else {
            value2 = CSSUtilities.getComputedStyle(element, 11);
            object = value2.getStringValue();
            block0 : switch (((String)object).charAt(0)) {
                case 'l': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    switch (string.charAt(0)) {
                        case 'b': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(-2));
                            break;
                        }
                        case 'e': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(2));
                        }
                    }
                    break;
                }
                case 'r': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    switch (string.charAt(0)) {
                        case 'b': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(-1));
                            break block0;
                        }
                        case 'e': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(1));
                        }
                    }
                }
            }
        }
        value2 = CSSUtilities.getComputedStyle(element, 58);
        string = value2.getStringValue();
        switch (string.charAt(0)) {
            case 'l': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR);
                break;
            }
            case 'r': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL);
                break;
            }
            case 't': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB);
            }
        }
        value2 = CSSUtilities.getComputedStyle(element, 29);
        switch (value2.getPrimitiveType()) {
            case 21: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO);
                break;
            }
            case 11: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(value2.getFloatValue()));
                break;
            }
            case 12: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float((double)(value2.getFloatValue() * 180.0f) / Math.PI));
                break;
            }
            case 13: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(value2.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        value2 = CSSUtilities.getComputedStyle(element, 28);
        switch (value2.getPrimitiveType()) {
            case 11: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float(value2.getFloatValue()));
                break;
            }
            case 12: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float((double)(value2.getFloatValue() * 180.0f) / Math.PI));
                break;
            }
            case 13: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float(value2.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        object = TextUtilities.convertLetterSpacing(element);
        if (object != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING, object);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((object = TextUtilities.convertWordSpacing(element)) != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING, object);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((object = TextUtilities.convertKerning(element)) != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.KERNING, object);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((string = element.getAttributeNS(null, "textLength")).length() != 0) {
            float f3 = UnitProcessor.svgOtherLengthToUserSpace(string, "textLength", context);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH, new Float(f3));
            string = element.getAttributeNS(null, "lengthAdjust");
            if (string.length() < 10) {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
            } else {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL);
            }
        }
        return hashMap;
    }

    protected TextDecoration getParentTextDecoration(AttributedCharacterIterator attributedCharacterIterator, Element element) {
        Object object;
        Object object2 = null;
        int n = -1;
        int n2 = 0;
        while (n2 < attributedCharacterIterator.getEndIndex()) {
            attributedCharacterIterator.setIndex(n2);
            object = (Element)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (this.nodeAncestorOf((Node)object, element)) {
                object2 = object;
                n = n2;
            }
            if (object == element || this.nodeAncestorOf(element, (Node)object)) break;
            ++n2;
        }
        object = new TextDecoration();
        if (object2 == null) {
            return object;
        }
        attributedCharacterIterator.setIndex(n);
        ((TextDecoration)object).underlinePaint = (Paint)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
        ((TextDecoration)object).underlineStrokePaint = (Paint)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
        ((TextDecoration)object).underlineStroke = (Stroke)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
        ((TextDecoration)object).overlinePaint = (Paint)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
        ((TextDecoration)object).overlineStrokePaint = (Paint)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
        ((TextDecoration)object).overlineStroke = (Stroke)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
        ((TextDecoration)object).strikethroughPaint = (Paint)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
        ((TextDecoration)object).strikethroughStrokePaint = (Paint)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
        ((TextDecoration)object).strikethroughStroke = (Stroke)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
        return object;
    }

    protected TextDecoration getTextDecoration(Element element, GraphicsNode graphicsNode, TextDecoration textDecoration, BridgeContext bridgeContext) {
        int n = 53;
        Value value = CSSUtilities.getComputedStyle(element, n);
        StyleMap styleMap = ((CSSStylableElement)element).getComputedStyleMap(null);
        if (styleMap.isNullCascaded(n)) {
            return textDecoration;
        }
        TextDecoration textDecoration2 = new TextDecoration(textDecoration);
        short s = value.getCssValueType();
        switch (value.getCssValueType()) {
            case 2: {
                ListValue listValue = (ListValue)value;
                Paint paint = PaintServer.convertFillPaint(element, graphicsNode, bridgeContext);
                Paint paint2 = PaintServer.convertStrokePaint(element, graphicsNode, bridgeContext);
                Stroke stroke = PaintServer.convertStroke(element);
                int n2 = listValue.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    Value value2 = listValue.item(n3);
                    String string = value2.getStringValue();
                    switch (string.charAt(0)) {
                        case 'u': {
                            if (paint != null) {
                                textDecoration2.underlinePaint = paint;
                            }
                            if (paint2 != null) {
                                textDecoration2.underlineStrokePaint = paint2;
                            }
                            if (stroke == null) break;
                            textDecoration2.underlineStroke = stroke;
                            break;
                        }
                        case 'o': {
                            if (paint != null) {
                                textDecoration2.overlinePaint = paint;
                            }
                            if (paint2 != null) {
                                textDecoration2.overlineStrokePaint = paint2;
                            }
                            if (stroke == null) break;
                            textDecoration2.overlineStroke = stroke;
                            break;
                        }
                        case 'l': {
                            if (paint != null) {
                                textDecoration2.strikethroughPaint = paint;
                            }
                            if (paint2 != null) {
                                textDecoration2.strikethroughStrokePaint = paint2;
                            }
                            if (stroke == null) break;
                            textDecoration2.strikethroughStroke = stroke;
                        }
                    }
                    ++n3;
                }
                return textDecoration2;
            }
        }
        return TextDecoration.EMPTY_TEXT_DECORATION;
    }

    public int getNumberOfChars() {
        return this.getNumberOfChars(this.e);
    }

    public Rectangle2D getExtentOfChar(int n) {
        return this.getExtentOfChar(this.e, n);
    }

    public Point2D getStartPositionOfChar(int n) {
        return this.getStartPositionOfChar(this.e, n);
    }

    public Point2D getEndPositionOfChar(int n) {
        return this.getEndPositionOfChar(this.e, n);
    }

    public void selectSubString(int n, int n2) {
        this.selectSubString(this.e, n, n2);
    }

    public float getRotationOfChar(int n) {
        return this.getRotationOfChar(this.e, n);
    }

    public float getComputedTextLength() {
        return this.getComputedTextLength(this.e);
    }

    public float getSubStringLength(int n, int n2) {
        return this.getSubStringLength(this.e, n, n2);
    }

    public int getCharNumAtPosition(float f, float f2) {
        return this.getCharNumAtPosition(this.e, f, f2);
    }

    protected int getNumberOfChars(Element element) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n == -1) {
            return 0;
        }
        int n2 = this.getLastCharacterIndexForElement(attributedCharacterIterator, element);
        Object var5_5 = null;
        List list = this.getTextRuns((TextNode)this.node);
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            int n5 = 0;
            while (n5 < list.size()) {
                StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(n5);
                TextSpanLayout textSpanLayout = textRun.getLayout();
                if (textSpanLayout.hasCharacterIndex(n4)) {
                    if (textSpanLayout.isOnATextPath()) {
                        int n6;
                        int n7;
                        GVTGlyphVector gVTGlyphVector = textSpanLayout.getGlyphVector();
                        if (textSpanLayout.isAltGlyph()) {
                            n7 = gVTGlyphVector.getNumGlyphs();
                            n6 = 0;
                            int n8 = 0;
                            while (n8 < n7) {
                                if (gVTGlyphVector.isGlyphVisible(n8)) {
                                    ++n6;
                                }
                                ++n8;
                            }
                            int n9 = 1;
                            while (textSpanLayout.hasCharacterIndex(n4 + 1)) {
                                ++n9;
                                ++n4;
                            }
                            n3 += n9 * n6 / n7;
                        } else {
                            n7 = -1;
                            do {
                                if ((n6 = textSpanLayout.getGlyphIndex(n4)) == -1) {
                                    n6 = textSpanLayout.isLeftToRight() ? 1 + n7 : (n7 == -1 ? gVTGlyphVector.getNumGlyphs() - 1 : n7 - 1);
                                }
                                n7 = n6;
                                if (!gVTGlyphVector.isGlyphVisible(n6)) continue;
                                ++n3;
                            } while (++n4 <= n2 && textSpanLayout.hasCharacterIndex(n4));
                            --n4;
                        }
                    } else {
                        ++n3;
                        while (n4 < n2 && textSpanLayout.hasCharacterIndex(n4 + 1)) {
                            ++n4;
                            ++n3;
                        }
                    }
                }
                ++n5;
            }
            ++n4;
        }
        return n3;
    }

    protected Rectangle2D getExtentOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n2 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n2 == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        if (characterInformation != null) {
            Cloneable cloneable;
            Object object;
            GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
            if (characterInformation.glyphIndexStart == characterInformation.glyphIndexEnd) {
                object = gVTGlyphVector.getGlyphOutline(characterInformation.glyphIndexStart);
            } else {
                cloneable = new GeneralPath();
                int n3 = characterInformation.glyphIndexStart;
                while (n3 <= characterInformation.glyphIndexEnd) {
                    ((Path2D)cloneable).append(gVTGlyphVector.getGlyphOutline(n3), false);
                    ++n3;
                }
                object = cloneable;
            }
            cloneable = this.getCTM();
            object = ((AffineTransform)cloneable).createTransformedShape((Shape)object);
            return object.getBounds2D();
        }
        return null;
    }

    protected Point2D getStartPositionOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n2 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n2 == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        if (characterInformation != null) {
            return this.getStartPoint(characterInformation);
        }
        return null;
    }

    protected Point2D getStartPoint(CharacterInformation characterInformation) {
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        Point2D point2D = gVTGlyphVector.getGlyphPosition(characterInformation.glyphIndexStart);
        Point2D.Float float_ = new Point2D.Float();
        AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(characterInformation.glyphIndexStart);
        double d = 0.0;
        double d2 = 0.0;
        if (affineTransform != null) {
            affineTransform.transform(new Point2D.Double(d, d2), float_);
            d = ((Point2D)float_).getX();
            d2 = ((Point2D)float_).getY();
        }
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
        affineTransform2.transform(new Point2D.Double(d, d2), float_);
        AffineTransform affineTransform3 = new AffineTransform(this.getCTM());
        Point2D.Float float_2 = new Point2D.Float();
        affineTransform3.transform(float_, float_2);
        return float_2;
    }

    protected Point2D getEndPositionOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int n2 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n2 == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        if (characterInformation != null) {
            return this.getEndPoint(characterInformation);
        }
        return null;
    }

    protected Point2D getEndPoint(CharacterInformation characterInformation) {
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        Point2D point2D = gVTGlyphVector.getGlyphPosition(characterInformation.glyphIndexEnd);
        Point2D.Float float_ = new Point2D.Float();
        AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(characterInformation.glyphIndexEnd);
        GVTGlyphMetrics gVTGlyphMetrics = gVTGlyphVector.getGlyphMetrics(characterInformation.glyphIndexEnd);
        double d = 0.0;
        double d2 = 0.0;
        d = gVTGlyphMetrics.getHorizontalAdvance();
        if (affineTransform != null) {
            affineTransform.transform(new Point2D.Double(d, d2), float_);
            d = ((Point2D)float_).getX();
            d2 = ((Point2D)float_).getY();
        }
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
        affineTransform2.transform(new Point2D.Double(d, d2), float_);
        AffineTransform affineTransform3 = new AffineTransform(this.getCTM());
        Point2D.Float float_2 = new Point2D.Float();
        affineTransform3.transform(float_, float_2);
        return float_2;
    }

    protected float getRotationOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int n2 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n2 == -1) {
            return 0.0f;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        double d = 0.0;
        int n3 = 0;
        if (characterInformation != null) {
            GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
            int n4 = characterInformation.glyphIndexStart;
            while (n4 <= characterInformation.glyphIndexEnd) {
                ++n3;
                double d2 = 0.0;
                AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(n4);
                if (affineTransform != null) {
                    double d3 = affineTransform.getScaleX();
                    double d4 = affineTransform.getShearX();
                    if (d3 == 0.0) {
                        d2 = d4 > 0.0 ? Math.PI : -Math.PI;
                    } else {
                        d2 = Math.atan(d4 / d3);
                        if (d3 < 0.0) {
                            d2 += Math.PI;
                        }
                    }
                    d2 = Math.toDegrees(-d2) % 360.0;
                    d += d2 - characterInformation.getComputedOrientationAngle();
                }
                ++n4;
            }
        }
        return (float)(d / (double)n3);
    }

    protected float getComputedTextLength(Element element) {
        return this.getSubStringLength(element, 0, this.getNumberOfChars(element));
    }

    protected float getSubStringLength(Element element, int n, int n2) {
        float f = 0.0f;
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int n3 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n3 == -1) {
            return -1.0f;
        }
        List list = this.getTextRuns(textNode);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n3, n, attributedCharacterIterator);
        CharacterInformation characterInformation2 = null;
        int n4 = characterInformation.characterIndex + 1;
        int n5 = n + 1;
        while (n5 < n + n2) {
            if (characterInformation.layout.hasCharacterIndex(n4)) {
                ++n4;
            } else {
                characterInformation2 = this.getCharacterInformation(list, n3, n5 - 1, attributedCharacterIterator);
                f += this.distanceFirstLastCharacterInRun(characterInformation, characterInformation2);
                characterInformation = this.getCharacterInformation(list, n3, n5, attributedCharacterIterator);
                n4 = characterInformation.characterIndex + 1;
                characterInformation2 = null;
            }
            ++n5;
        }
        if (characterInformation2 == null) {
            characterInformation2 = this.getCharacterInformation(list, n3, n + n2 - 1, attributedCharacterIterator);
        }
        return f += this.distanceFirstLastCharacterInRun(characterInformation, characterInformation2);
    }

    protected float distanceFirstLastCharacterInRun(CharacterInformation characterInformation, CharacterInformation characterInformation2) {
        float[] fArray = characterInformation.layout.getGlyphAdvances();
        int n = characterInformation.glyphIndexStart;
        int n2 = characterInformation.glyphIndexEnd;
        int n3 = characterInformation2.glyphIndexStart;
        int n4 = characterInformation2.glyphIndexEnd;
        int n5 = n < n3 ? n : n3;
        int n6 = n2 < n4 ? n4 : n2;
        return fArray[n6 + 1] - fArray[n5];
    }

    protected float distanceBetweenRun(CharacterInformation characterInformation, CharacterInformation characterInformation2) {
        CharacterInformation characterInformation3 = new CharacterInformation();
        characterInformation3.layout = characterInformation.layout;
        characterInformation3.glyphIndexEnd = characterInformation.layout.getGlyphCount() - 1;
        Point2D point2D = this.getEndPoint(characterInformation3);
        characterInformation3.layout = characterInformation2.layout;
        characterInformation3.glyphIndexStart = 0;
        Point2D point2D2 = this.getStartPoint(characterInformation3);
        float f = characterInformation2.isVertical() ? (float)(point2D2.getY() - point2D.getY()) : (float)(point2D2.getX() - point2D.getX());
        return f;
    }

    protected void selectSubString(Element element, int n, int n2) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int n3 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n3 == -1) {
            return;
        }
        List list = this.getTextRuns(textNode);
        int n4 = this.getLastCharacterIndexForElement(attributedCharacterIterator, element);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n3, n, attributedCharacterIterator);
        CharacterInformation characterInformation2 = this.getCharacterInformation(list, n3, n + n2 - 1, attributedCharacterIterator);
        Mark mark = textNode.getMarkerForChar(characterInformation.characterIndex, true);
        Mark mark2 = characterInformation2 != null && characterInformation2.characterIndex <= n4 ? textNode.getMarkerForChar(characterInformation2.characterIndex, false) : textNode.getMarkerForChar(n4, false);
        textNode.setSelection(mark, mark2);
    }

    protected int getCharNumAtPosition(Element element, float f, float f2) {
        TextNode textNode = (TextNode)this.node;
        List list = this.getTextRuns(textNode);
        TextHit textHit = null;
        int n = list.size() - 1;
        while (n >= 0 && textHit == null) {
            textHit = ((StrokingTextPainter.TextRun)list.get(n)).getLayout().hitTestChar(f, f2);
            --n;
        }
        if (textHit == null) {
            return -1;
        }
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n2 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        int n3 = this.getLastCharacterIndexForElement(attributedCharacterIterator, element);
        int n4 = textHit.getCharIndex();
        if (n4 >= n2 && n4 <= n3) {
            return n4 - n2;
        }
        return -1;
    }

    protected int getFirstCharacterIndexForElement(AttributedCharacterIterator attributedCharacterIterator, Element element) {
        int n = -1;
        int n2 = 0;
        while (n2 < attributedCharacterIterator.getEndIndex()) {
            attributedCharacterIterator.setIndex(n2);
            Element element2 = (Element)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 == element || this.nodeAncestorOf(element, element2)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    protected int getLastCharacterIndexForElement(AttributedCharacterIterator attributedCharacterIterator, Element element) {
        int n = attributedCharacterIterator.getEndIndex() - 1;
        int n2 = attributedCharacterIterator.getEndIndex() - 1;
        while (n2 >= 0) {
            attributedCharacterIterator.setIndex(n2);
            Element element2 = (Element)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 == element || this.nodeAncestorOf(element, element2)) {
                n = n2;
                break;
            }
            --n2;
        }
        return n;
    }

    protected List getTextRuns(TextNode textNode) {
        if (textNode.getTextRuns() == null) {
            textNode.getPrimitiveBounds();
        }
        return textNode.getTextRuns();
    }

    protected CharacterInformation getCharacterInformation(List list, int n, int n2, AttributedCharacterIterator attributedCharacterIterator) {
        int n3;
        GVTGlyphVector gVTGlyphVector;
        int n4 = 0;
        int n5 = 0;
        StrokingTextPainter.TextRun textRun = null;
        n5 = n;
        while (n4 < n2 + 1) {
            int n6 = 0;
            while (n6 < list.size() && n4 < n2 + 1) {
                textRun = (StrokingTextPainter.TextRun)list.get(n6);
                TextSpanLayout textSpanLayout = textRun.getLayout();
                if (textSpanLayout.hasCharacterIndex(n5)) {
                    if (textSpanLayout.isOnATextPath()) {
                        int n7;
                        gVTGlyphVector = textSpanLayout.getGlyphVector();
                        if (textSpanLayout.isAltGlyph()) {
                            n3 = gVTGlyphVector.getNumGlyphs();
                            n7 = 0;
                            int n8 = 0;
                            while (n8 < n3) {
                                if (gVTGlyphVector.isGlyphVisible(n8)) {
                                    ++n7;
                                }
                                ++n8;
                            }
                            int n9 = 1;
                            while (textSpanLayout.hasCharacterIndex(n5 + 1)) {
                                ++n9;
                                ++n5;
                            }
                            if ((n4 += n9 * n7 / n3) > n2 + 1) {
                                n4 = n2 + 1;
                            }
                        } else {
                            n3 = -1;
                            do {
                                if ((n7 = textSpanLayout.getGlyphIndex(n5)) == -1) {
                                    n7 = textSpanLayout.isLeftToRight() ? 1 + n3 : (n3 == -1 ? gVTGlyphVector.getNumGlyphs() - 1 : n3 - 1);
                                }
                                n3 = n7;
                                if (!gVTGlyphVector.isGlyphVisible(n7)) continue;
                                ++n4;
                            } while (n4 < n2 + 1 && textSpanLayout.hasCharacterIndex(++n5));
                            --n5;
                        }
                    } else {
                        ++n4;
                        while (n4 < n2 + 1 && textSpanLayout.hasCharacterIndex(n5 + 1)) {
                            ++n5;
                            ++n4;
                        }
                    }
                }
                ++n6;
            }
            ++n5;
        }
        if (n4 != n2 + 1) {
            return null;
        }
        CharacterInformation characterInformation = new CharacterInformation();
        characterInformation.characterIndex = n5 - 1;
        characterInformation.layout = textRun.getLayout();
        if (characterInformation.layout.isAltGlyph()) {
            characterInformation.glyphIndexStart = 0;
            characterInformation.glyphIndexEnd = characterInformation.layout.getGlyphCount() - 1;
            boolean bl = false;
            gVTGlyphVector = characterInformation.layout.getGlyphVector();
            n3 = 0;
            while (n3 < gVTGlyphVector.getNumGlyphs()) {
                if (!bl && gVTGlyphVector.isGlyphVisible(n3)) {
                    characterInformation.glyphIndexStart = n3;
                    bl = true;
                }
                if (bl && !gVTGlyphVector.isGlyphVisible(n3)) {
                    characterInformation.glyphIndexEnd = n3 - 1;
                    break;
                }
                ++n3;
            }
        } else {
            characterInformation.glyphIndexStart = characterInformation.layout.getGlyphIndex(characterInformation.characterIndex);
            if (characterInformation.glyphIndexStart == -1) {
                if (characterInformation.layout.isLeftToRight()) {
                    characterInformation.glyphIndexStart = characterInformation.layout.getGlyphIndex(characterInformation.characterIndex - 1) + 1;
                } else {
                    characterInformation.glyphIndexStart = characterInformation.layout.getGlyphIndex(characterInformation.characterIndex + 1) - 1;
                    if (characterInformation.glyphIndexStart == -2) {
                        characterInformation.glyphIndexStart = characterInformation.layout.getGlyphCount() - 1;
                    }
                }
            }
            characterInformation.glyphIndexEnd = characterInformation.glyphIndexStart;
        }
        return characterInformation;
    }

    protected class CharacterInformation {
        TextSpanLayout layout;
        int glyphIndexStart;
        int glyphIndexEnd;
        int characterIndex;

        protected CharacterInformation() {
        }

        public boolean isVertical() {
            return this.layout.isVertical();
        }

        public double getComputedOrientationAngle() {
            return this.layout.getComputedOrientationAngle(this.characterIndex);
        }
    }

    protected class TspanBridge
    extends AbstractTextChildTextContent {
        public TspanBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
            String string = mutationEvent.getAttrName();
            if (string.equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate")) {
                this.textBridge.computeLayoutedText(this.ctx, this.textBridge.e, this.textBridge.node);
            }
        }
    }

    protected class TextPathBridge
    extends AbstractTextChildTextContent {
        public TextPathBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }
    }

    protected class TRefBridge
    extends AbstractTextChildTextContent {
        public TRefBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
            String string = mutationEvent.getAttrName();
            if (string.equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate")) {
                this.textBridge.computeLayoutedText(this.ctx, this.textBridge.e, this.textBridge.node);
            }
        }
    }

    protected class AbstractTextChildTextContent
    extends AbstractTextChildBridgeUpdateHandler
    implements SVGTextContent {
        public AbstractTextChildTextContent(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public int getNumberOfChars() {
            return this.textBridge.getNumberOfChars(this.e);
        }

        public Rectangle2D getExtentOfChar(int n) {
            return this.textBridge.getExtentOfChar(this.e, n);
        }

        public Point2D getStartPositionOfChar(int n) {
            return this.textBridge.getStartPositionOfChar(this.e, n);
        }

        public Point2D getEndPositionOfChar(int n) {
            return this.textBridge.getEndPositionOfChar(this.e, n);
        }

        public void selectSubString(int n, int n2) {
            this.textBridge.selectSubString(this.e, n, n2);
        }

        public float getRotationOfChar(int n) {
            return this.textBridge.getRotationOfChar(this.e, n);
        }

        public float getComputedTextLength() {
            return this.textBridge.getComputedTextLength(this.e);
        }

        public float getSubStringLength(int n, int n2) {
            return this.textBridge.getSubStringLength(this.e, n, n2);
        }

        public int getCharNumAtPosition(float f, float f2) {
            return this.textBridge.getCharNumAtPosition(this.e, f, f2);
        }
    }

    protected abstract class AbstractTextChildBridgeUpdateHandler
    extends AbstractTextChildSVGContext
    implements BridgeUpdateHandler {
        public AbstractTextChildBridgeUpdateHandler(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        }

        public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
            this.textBridge.handleDOMNodeInsertedEvent(mutationEvent);
        }

        public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
            this.dispose();
        }

        public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
            this.textBridge.handleDOMCharacterDataModified(mutationEvent);
        }

        public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
            this.textBridge.handleCSSEngineEvent(cSSEngineEvent);
        }

        public void dispose() {
            ((SVGOMElement)this.e).setSVGContext(null);
        }
    }

    protected abstract class AbstractTextChildSVGContext
    implements SVGContext {
        protected BridgeContext ctx;
        protected SVGTextElementBridge textBridge;
        protected Element e;

        public AbstractTextChildSVGContext(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            this.ctx = bridgeContext;
            this.textBridge = sVGTextElementBridge2;
            this.e = element;
        }

        public float getPixelUnitToMillimeter() {
            return this.ctx.getUserAgent().getPixelUnitToMillimeter();
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public Rectangle2D getBBox() {
            return null;
        }

        public AffineTransform getCTM() {
            return null;
        }

        public AffineTransform getGlobalTransform() {
            return null;
        }

        public AffineTransform getScreenTransform() {
            return null;
        }

        public void setScreenTransform(AffineTransform affineTransform) {
        }

        public float getViewportWidth() {
            return this.ctx.getBlockWidth(this.e);
        }

        public float getViewportHeight() {
            return this.ctx.getBlockHeight(this.e);
        }

        public float getFontSize() {
            return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
        }
    }

    protected static class TextDecoration {
        static final TextDecoration EMPTY_TEXT_DECORATION = new TextDecoration();
        Paint underlinePaint;
        Paint underlineStrokePaint;
        Stroke underlineStroke;
        Paint overlinePaint;
        Paint overlineStrokePaint;
        Stroke overlineStroke;
        Paint strikethroughPaint;
        Paint strikethroughStrokePaint;
        Stroke strikethroughStroke;

        TextDecoration() {
            this.underlinePaint = null;
            this.underlineStrokePaint = null;
            this.underlineStroke = null;
            this.overlinePaint = null;
            this.overlineStrokePaint = null;
            this.overlineStroke = null;
            this.strikethroughPaint = null;
            this.strikethroughStrokePaint = null;
            this.strikethroughStroke = null;
        }

        TextDecoration(TextDecoration textDecoration) {
            this.underlinePaint = textDecoration.underlinePaint;
            this.underlineStrokePaint = textDecoration.underlineStrokePaint;
            this.underlineStroke = textDecoration.underlineStroke;
            this.overlinePaint = textDecoration.overlinePaint;
            this.overlineStrokePaint = textDecoration.overlineStrokePaint;
            this.overlineStroke = textDecoration.overlineStroke;
            this.strikethroughPaint = textDecoration.strikethroughPaint;
            this.strikethroughStrokePaint = textDecoration.strikethroughStrokePaint;
            this.strikethroughStroke = textDecoration.strikethroughStroke;
        }
    }

    protected static class AttributedStringBuffer {
        protected List strings = new ArrayList();
        protected List attributes = new ArrayList();
        protected int count = 0;
        protected int length = 0;

        public boolean isEmpty() {
            return this.count == 0;
        }

        public int length() {
            return this.length;
        }

        public void append(String string, Map map) {
            if (string.length() == 0) {
                return;
            }
            this.strings.add(string);
            this.attributes.add(map);
            ++this.count;
            this.length += string.length();
        }

        public int getLastChar() {
            if (this.count == 0) {
                return -1;
            }
            String string = (String)this.strings.get(this.count - 1);
            return string.charAt(string.length() - 1);
        }

        public void stripLast() {
            String string = (String)this.strings.remove(this.count - 1);
            if (string.charAt(string.length() - 1) == ' ') {
                if (string.length() == 1) {
                    this.attributes.remove(--this.count);
                    return;
                }
                this.strings.add(string.substring(0, string.length() - 1));
                --this.length;
            } else {
                this.strings.add(string);
            }
        }

        public AttributedString toAttributedString() {
            switch (this.count) {
                case 0: {
                    return new AttributedString(" ");
                }
                case 1: {
                    return new AttributedString((String)this.strings.get(0), (Map)this.attributes.get(0));
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.strings.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            AttributedString attributedString = new AttributedString(stringBuffer.toString());
            Iterator iterator2 = this.strings.iterator();
            Iterator iterator3 = this.attributes.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                int n2 = n + string.length();
                Map map = (Map)iterator3.next();
                Iterator iterator4 = map.keySet().iterator();
                Iterator iterator5 = map.values().iterator();
                while (iterator4.hasNext()) {
                    AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)iterator4.next();
                    Object v = iterator5.next();
                    attributedString.addAttribute(attribute, v, n, n2);
                }
                n = n2;
            }
            return attributedString;
        }

        public String toString() {
            switch (this.count) {
                case 0: {
                    return "";
                }
                case 1: {
                    return (String)this.strings.get(0);
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.strings.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            return stringBuffer.toString();
        }
    }

    protected class DOMSubtreeModifiedEventListener
    implements EventListener {
        protected DOMSubtreeModifiedEventListener() {
        }

        public void handleEvent(Event event) {
            SVGTextElementBridge.this.handleDOMSubtreeModifiedEvent((MutationEvent)event);
        }
    }

    protected class DOMChildNodeRemovedEventListener
    implements EventListener {
        protected DOMChildNodeRemovedEventListener() {
        }

        public void handleEvent(Event event) {
            SVGTextElementBridge.this.handleDOMChildNodeRemovedEvent((MutationEvent)event);
        }
    }
}

