/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.ShapePainter;

public class CompositeShapePainter
implements ShapePainter {
    protected Shape shape;
    protected ShapePainter[] painters;
    protected int count;

    public CompositeShapePainter(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public void addShapePainter(ShapePainter shapePainter) {
        if (shapePainter == null) {
            return;
        }
        if (this.shape != shapePainter.getShape()) {
            shapePainter.setShape(this.shape);
        }
        if (this.painters == null) {
            this.painters = new ShapePainter[2];
        }
        if (this.count == this.painters.length) {
            ShapePainter[] shapePainterArray = new ShapePainter[this.count * 3 / 2 + 1];
            System.arraycopy(this.painters, 0, shapePainterArray, 0, this.count);
            this.painters = shapePainterArray;
        }
        this.painters[this.count++] = shapePainter;
    }

    public ShapePainter getShapePainter(int n) {
        return this.painters[n];
    }

    public int getShapePainterCount() {
        return this.count;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.painters != null) {
            int n = 0;
            while (n < this.count) {
                this.painters[n].paint(graphics2D);
                ++n;
            }
        }
    }

    public Shape getPaintedArea() {
        if (this.painters != null) {
            Area area = new Area();
            int n = 0;
            while (n < this.count) {
                Shape shape = this.painters[n].getPaintedArea();
                if (shape != null) {
                    area.add(new Area(shape));
                }
                ++n;
            }
            return area;
        }
        return null;
    }

    public Rectangle2D getPaintedBounds2D() {
        if (this.painters != null) {
            GeneralPath generalPath = new GeneralPath();
            int n = 0;
            while (n < this.count) {
                Shape shape = this.painters[n].getPaintedArea();
                if (shape != null) {
                    generalPath.append(shape, false);
                }
                ++n;
            }
            return generalPath.getBounds2D();
        }
        return null;
    }

    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        if (this.painters != null) {
            int n = 0;
            while (n < this.count) {
                this.painters[n].setShape(shape);
                ++n;
            }
        }
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }
}

