/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

import com.sun.tools.javamake.ClassInfo;
import com.sun.tools.javamake.ClassPath;
import com.sun.tools.javamake.PCDEntry;
import com.sun.tools.javamake.PCDManager;
import com.sun.tools.javamake.RefClassFinder;
import com.sun.tools.javamake.Utils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class CompatibilityChecker {
    private PCDManager pcdm;
    private RefClassFinder rf;
    ClassInfo oldClassInfo;
    ClassInfo newClassInfo;
    private boolean versionsCompatible;
    private boolean publicConstantChanged;

    public CompatibilityChecker(PCDManager pCDManager, boolean bl, boolean bl2) {
        this.pcdm = pCDManager;
        this.publicConstantChanged = false;
        this.rf = new RefClassFinder(pCDManager, bl, bl2);
    }

    public boolean compareClassVersions(PCDEntry pCDEntry) {
        this.oldClassInfo = this.pcdm.getClassInfoForPCDEntry(0, pCDEntry);
        this.newClassInfo = this.pcdm.getClassInfoForPCDEntry(1, pCDEntry);
        this.rf.initialize(this.oldClassInfo.name, pCDEntry.javaFileFullPath.endsWith(".jar"));
        this.versionsCompatible = true;
        this.checkAccessFlags();
        this.checkSuperclasses();
        this.checkImplementedInterfaces();
        this.checkFields();
        this.checkMethodsAndConstructors();
        return this.versionsCompatible;
    }

    public void checkDeletedClass(PCDEntry pCDEntry) {
        this.oldClassInfo = pCDEntry.oldClassInfo;
        this.rf.initialize(this.oldClassInfo.name, pCDEntry.javaFileFullPath.endsWith(".jar"));
        this.rf.findReferencingClassesForDeletedClass(this.oldClassInfo);
        String string = this.oldClassInfo.isPublic() ? null : this.oldClassInfo.packageName;
        this.rf.findClassesDeclaringField(("class$" + this.oldClassInfo.name).intern(), "java/lang/Class", true, string);
        this.checkForFinalFields();
    }

    public String[] getAffectedClasses() {
        return this.rf.getAffectedClassNames();
    }

    private void checkAccessFlags() {
        char c = this.oldClassInfo.accessFlags;
        char c2 = this.newClassInfo.accessFlags;
        if (c == c2) {
            return;
        }
        if (!Modifier.isFinal(c) && Modifier.isFinal(c2)) {
            this.versionsCompatible = false;
            this.rf.findDirectSubclasses(this.oldClassInfo);
        }
        if (!Modifier.isAbstract(c) && Modifier.isAbstract(c2)) {
            this.versionsCompatible = false;
            this.rf.findReferencingClasses0(this.oldClassInfo);
        }
        if (Modifier.isPublic(c2)) {
            return;
        }
        if (Modifier.isProtected(c2)) {
            if (Modifier.isPublic(c)) {
                this.versionsCompatible = false;
                this.rf.findDiffPackageAndNotSubReferencingClasses1(this.oldClassInfo);
            }
        } else if (Modifier.isPrivate(c2)) {
            if (Modifier.isPrivate(c)) {
                return;
            }
            this.versionsCompatible = false;
            if (Modifier.isPublic(c)) {
                this.rf.findReferencingClasses1(this.oldClassInfo);
            } else if (Modifier.isProtected(c)) {
                this.rf.findThisPackageOrSubReferencingClasses1(this.oldClassInfo);
            } else {
                this.rf.findThisPackageReferencingClasses1(this.oldClassInfo);
            }
        } else if (Modifier.isPublic(c)) {
            this.versionsCompatible = false;
            this.rf.findDiffPackageReferencingClasses1(this.oldClassInfo);
        } else if (Modifier.isProtected(c)) {
            this.versionsCompatible = false;
            this.rf.findDiffPackageAndSubReferencingClasses1(this.oldClassInfo);
        }
    }

    private void checkSuperclasses() {
        ArrayList arrayList = this.oldClassInfo.getAllSuperclassNames();
        ArrayList arrayList2 = this.newClassInfo.getAllSuperclassNames();
        int n = arrayList.size() - 1;
        int n2 = 0;
        while (n2 <= n) {
            String string = (String)arrayList.get(n2);
            if (!arrayList2.contains(string)) {
                this.versionsCompatible = false;
                ClassInfo classInfo = this.pcdm.getClassInfoForName(0, string);
                if (classInfo == null && (classInfo = ClassPath.getClassInfoForName(string, this.pcdm)) == null) {
                    classInfo = new ClassInfo(string, this.pcdm);
                }
                this.rf.findReferencingClasses2(classInfo, this.oldClassInfo);
            }
            ++n2;
        }
        if (this.oldClassInfo.isInterface() || arrayList.size() == 0) {
            return;
        }
        if (!arrayList.contains("java/lang/RuntimeException") && !arrayList.contains("java/lang/Error")) {
            return;
        }
        if (!arrayList2.contains("java/lang/RuntimeException") && !arrayList2.contains("java/lang/Error")) {
            if (!arrayList2.contains("java/lang/Throwable")) {
                return;
            }
            this.versionsCompatible = false;
            this.rf.findReferencingClasses0(this.oldClassInfo);
            this.rf.findRefsToMethodsThrowingException(this.oldClassInfo);
        }
    }

    private void checkImplementedInterfaces() {
        Set set = this.oldClassInfo.getAllImplementedIntfNames();
        Set set2 = this.newClassInfo.getAllImplementedIntfNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set2.contains(string)) continue;
            this.versionsCompatible = false;
            ClassInfo classInfo = this.pcdm.getClassInfoForName(0, string);
            if (classInfo == null && (classInfo = ClassPath.getClassInfoForName(string, this.pcdm)) == null) {
                classInfo = new ClassInfo(string, this.pcdm);
            }
            this.rf.findReferencingClasses2(classInfo, this.oldClassInfo);
        }
    }

    private void checkFields() {
        int n;
        boolean bl;
        int n2;
        String[] stringArray = this.oldClassInfo.fieldNames;
        String[] stringArray2 = this.oldClassInfo.fieldSignatures;
        char[] cArray = this.oldClassInfo.fieldAccessFlags;
        String[] stringArray3 = this.newClassInfo.fieldNames;
        String[] stringArray4 = this.newClassInfo.fieldSignatures;
        char[] cArray2 = this.newClassInfo.fieldAccessFlags;
        int n3 = stringArray != null ? stringArray.length : 0;
        int n4 = n2 = stringArray3 != null ? stringArray3.length : 0;
        int n5 = 0;
        while (n5 < n3) {
            char c = cArray[n5];
            if (!Modifier.isPrivate(c)) {
                String string = stringArray[n5];
                String string2 = stringArray2[n5];
                bl = false;
                int n6 = n2 - 1;
                int n7 = n5 < n2 ? n5 : n6;
                n = 0;
                while (n < n2) {
                    if (string == stringArray3[n7] && string2 == stringArray4[n7]) {
                        bl = true;
                        break;
                    }
                    n7 = n7 < n6 ? ++n7 : 0;
                    ++n;
                }
                if (bl) {
                    --n4;
                    char c2 = cArray2[n7];
                    this.checkFieldModifiers(c, c2, n5, n7);
                    if (this.publicConstantChanged) {
                        return;
                    }
                } else if (Modifier.isStatic(c) && Modifier.isFinal(c) && this.oldClassInfo.primitiveConstantInitValues != null && this.oldClassInfo.primitiveConstantInitValues[n5] != null) {
                    this.versionsCompatible = false;
                    this.rf.findAllProjectClasses(this.oldClassInfo, n5);
                    if (Modifier.isPublic(c)) {
                        this.publicConstantChanged = true;
                        return;
                    }
                } else {
                    this.versionsCompatible = false;
                    this.rf.findReferencingClassesForField(this.oldClassInfo, n5);
                }
            }
            ++n5;
        }
        if (n4 > 0) {
            n5 = 0;
            while (n5 < n2) {
                String string = stringArray3[n5];
                bl = false;
                n = 0;
                while (n < n3) {
                    if (string == stringArray[n]) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    String string3 = this.oldClassInfo.superName;
                    while (string3 != null) {
                        ClassInfo classInfo = this.pcdm.getClassInfoForName(0, string3);
                        if (classInfo == null) break;
                        String[] stringArray5 = classInfo.fieldNames;
                        int n8 = stringArray5 != null ? stringArray5.length : 0;
                        n = 0;
                        while (n < n8) {
                            if (string == stringArray5[n]) {
                                this.versionsCompatible = false;
                                this.rf.findReferencingClassesForField(classInfo, n);
                            }
                            ++n;
                        }
                        string3 = classInfo.superName;
                    }
                }
                ++n5;
            }
        }
    }

    private void checkFieldModifiers(int n, int n2, int n3, int n4) {
        if (n == n2 && Modifier.isStatic(n) && Modifier.isFinal(n) && !ClassInfo.constFieldInitValuesEqual(this.oldClassInfo, n3, this.newClassInfo, n4)) {
            this.versionsCompatible = false;
            this.rf.findAllProjectClasses(this.oldClassInfo, n3);
            if (Modifier.isPublic(n)) {
                this.publicConstantChanged = true;
            }
            return;
        }
        if (Modifier.isStatic(n) && Modifier.isFinal(n) && (!Modifier.isFinal(n2) || !ClassInfo.constFieldInitValuesEqual(this.oldClassInfo, n3, this.newClassInfo, n4))) {
            this.versionsCompatible = false;
            this.rf.findAllProjectClasses(this.oldClassInfo, n3);
            if (Modifier.isPublic(n)) {
                this.publicConstantChanged = true;
            }
        } else if (Modifier.isPrivate(n2) || !Modifier.isFinal(n) && Modifier.isFinal(n2) || Modifier.isStatic(n) != Modifier.isStatic(n2) || Modifier.isVolatile(n) != Modifier.isVolatile(n2)) {
            this.versionsCompatible = false;
            this.rf.findReferencingClassesForField(this.oldClassInfo, n3);
        } else if (Modifier.isPublic(n) && Modifier.isProtected(n2)) {
            this.versionsCompatible = false;
            this.rf.findDiffPackageReferencingClassesForField(this.oldClassInfo, n3);
        } else if (!(!Modifier.isPublic(n) && !Modifier.isProtected(n) || Modifier.isPublic(n2) || Modifier.isProtected(n2) || Modifier.isPrivate(n2))) {
            this.versionsCompatible = false;
            if (Modifier.isPublic(n)) {
                this.rf.findDiffPackageReferencingClassesForField(this.oldClassInfo, n3);
            } else {
                this.rf.findDiffPackageAndSubReferencingClassesForField(this.oldClassInfo, n3);
            }
        }
    }

    private void checkForFinalFields() {
        char[] cArray = this.oldClassInfo.fieldAccessFlags;
        int n = this.oldClassInfo.fieldNames != null ? this.oldClassInfo.fieldNames.length : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Modifier.isPrivate(c) && Modifier.isStatic(c) && Modifier.isFinal(c)) {
                this.rf.findAllProjectClasses(this.oldClassInfo, n2);
                if (Modifier.isPublic(c)) {
                    this.publicConstantChanged = true;
                    return;
                }
            }
            ++n2;
        }
    }

    private void checkMethodsAndConstructors() {
        block31: {
            int n;
            String[] stringArray;
            char c;
            int n2;
            int n3;
            String[] stringArray2 = this.oldClassInfo.methodNames;
            String[] stringArray3 = this.oldClassInfo.methodSignatures;
            char[] cArray = this.oldClassInfo.methodAccessFlags;
            String[] stringArray4 = this.newClassInfo.methodNames;
            String[] stringArray5 = this.newClassInfo.methodSignatures;
            char[] cArray2 = this.newClassInfo.methodAccessFlags;
            int n4 = stringArray2 != null ? stringArray2.length : 0;
            int n5 = n3 = stringArray4 != null ? stringArray4.length : 0;
            int n6 = 0;
            while (n6 < n4) {
                char c2 = cArray[n6];
                if (!Modifier.isPrivate(c2)) {
                    String string = stringArray2[n6];
                    String string2 = stringArray3[n6];
                    boolean bl = false;
                    int n7 = n3 - 1;
                    int n8 = n6 < n3 ? n6 : n7;
                    n2 = 0;
                    while (n2 < n3) {
                        if (string == stringArray4[n8] && string2 == stringArray5[n8]) {
                            bl = true;
                            break;
                        }
                        n8 = n8 < n7 ? ++n8 : 0;
                        ++n2;
                    }
                    if (bl) {
                        --n5;
                        c = cArray2[n8];
                        if (c2 != c) {
                            this.checkMethodModifiers(c2, c, n6);
                        }
                        if (this.newClassInfo.checkedExceptions != null && this.newClassInfo.checkedExceptions[n8] != null) {
                            if (this.oldClassInfo.checkedExceptions == null) {
                                this.versionsCompatible = false;
                                this.rf.findReferencingClassesForMethod(this.oldClassInfo, n6);
                            } else if (this.oldClassInfo.checkedExceptions[n6] == null) {
                                this.versionsCompatible = false;
                                this.rf.findReferencingClassesForMethod(this.oldClassInfo, n6);
                            } else {
                                stringArray = this.oldClassInfo.checkedExceptions[n6];
                                String[] stringArray6 = this.newClassInfo.checkedExceptions[n8];
                                n = 0;
                                while (n < stringArray6.length) {
                                    String string3 = stringArray6[n];
                                    bl = false;
                                    int n9 = 0;
                                    while (n9 < stringArray.length) {
                                        if (string3 == stringArray[n9]) {
                                            bl = true;
                                            break;
                                        }
                                        ++n9;
                                    }
                                    if (!bl) {
                                        this.versionsCompatible = false;
                                        this.rf.findReferencingClassesForMethod(this.oldClassInfo, n6);
                                        break;
                                    }
                                    ++n;
                                }
                            }
                        }
                    } else {
                        this.versionsCompatible = false;
                        this.rf.findReferencingClassesForMethod(this.oldClassInfo, n6);
                        if (this.oldClassInfo.isAbstract() && !Modifier.isAbstract(c2)) {
                            this.rf.findConcreteSubclassesNotOverridingAbstractMethod(this.oldClassInfo, this.oldClassInfo, n6);
                        }
                    }
                }
                ++n6;
            }
            if (n5 <= 0) break block31;
            if (!this.oldClassInfo.isInterface()) {
                n6 = 0;
                while (n6 < n3) {
                    c = cArray2[n6];
                    if (!Modifier.isPrivate(c)) {
                        String string = stringArray4[n6];
                        stringArray = stringArray5[n6];
                        boolean bl = Modifier.isStatic(c);
                        n = 0;
                        n2 = 0;
                        while (n2 < n4) {
                            if (string == stringArray2[n2] && stringArray == stringArray3[n2]) {
                                n = 1;
                                break;
                            }
                            ++n2;
                        }
                        if (n == 0) {
                            this.oldClassInfo.findExistingSameNameMethods(string, string != "<init>", false, new ClassInfo.MethodHandler((String)stringArray, bl){
                                private final /* synthetic */ String val$newMSig;
                                private final /* synthetic */ boolean val$isStatic;
                                {
                                    this.val$newMSig = string;
                                    this.val$isStatic = bl;
                                }

                                void handleMethod(ClassInfo classInfo, int n) {
                                    String string = classInfo.methodSignatures[n];
                                    if (this.val$newMSig == string && this.val$isStatic && classInfo != CompatibilityChecker.this.oldClassInfo || this.val$newMSig != string && Utils.sameParamNumber(this.val$newMSig, string)) {
                                        CompatibilityChecker.this.versionsCompatible = false;
                                        CompatibilityChecker.this.rf.findReferencingClassesForMethod(classInfo, n);
                                    }
                                }
                            });
                            if (Modifier.isAbstract(c)) {
                                this.versionsCompatible = false;
                                this.rf.findConcreteSubclassesNotOverridingAbstractMethod(this.oldClassInfo, this.newClassInfo, n6);
                            }
                            if (this.subclassesDeclareSameNameMethod(this.oldClassInfo, string)) {
                                this.versionsCompatible = false;
                            }
                        }
                    }
                    ++n6;
                }
            } else {
                n6 = 0;
                while (n6 < n3) {
                    c = cArray2[n6];
                    String string = stringArray4[n6];
                    stringArray = stringArray5[n6];
                    boolean bl = false;
                    n2 = 0;
                    while (n2 < n4) {
                        if (string == stringArray2[n2] && stringArray == stringArray3[n2]) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        this.versionsCompatible = false;
                        this.oldClassInfo.findExistingSameNameMethods(string, true, true, new ClassInfo.MethodHandler((String)stringArray){
                            private final /* synthetic */ String val$newMSig;
                            {
                                this.val$newMSig = string;
                            }

                            void handleMethod(ClassInfo classInfo, int n) {
                                String string = classInfo.methodSignatures[n];
                                if (this.val$newMSig != string && Utils.sameParamNumber(this.val$newMSig, string)) {
                                    CompatibilityChecker.this.rf.findReferencingClassesForMethod(classInfo, n);
                                }
                            }
                        });
                        this.rf.findDirectlyAndOtherwiseImplementingConcreteClasses(this.oldClassInfo);
                        this.rf.findAbstractSubtypesWithSameNameMethod(this.oldClassInfo, string, (String)stringArray);
                        break;
                    }
                    ++n6;
                }
            }
        }
    }

    private void checkMethodModifiers(int n, int n2, int n3) {
        if (Modifier.isPrivate(n2)) {
            this.versionsCompatible = false;
            this.rf.findReferencingClassesForMethod(this.oldClassInfo, n3);
        } else if (Modifier.isPublic(n) && Modifier.isProtected(n2)) {
            this.versionsCompatible = false;
            this.rf.findDiffPackageReferencingClassesForMethod(this.oldClassInfo, n3);
        } else if (!(!Modifier.isPublic(n) && !Modifier.isProtected(n) || Modifier.isPublic(n2) || Modifier.isProtected(n2) || Modifier.isPrivate(n2))) {
            this.versionsCompatible = false;
            if (Modifier.isPublic(n)) {
                this.rf.findDiffPackageReferencingClassesForMethod(this.oldClassInfo, n3);
            } else {
                this.rf.findDiffPackageAndSubReferencingClassesForMethod(this.oldClassInfo, n3);
            }
        } else if (Modifier.isPrivate(n) && !Modifier.isPrivate(n2) || Modifier.isProtected(n) && Modifier.isPublic(n2) || !Modifier.isPublic(n) && !Modifier.isProtected(n) && !Modifier.isPrivate(n) && (Modifier.isPublic(n2) || Modifier.isProtected(n2))) {
            this.versionsCompatible = false;
            this.rf.findSubclassesReimplementingMethod(this.oldClassInfo, n3);
        }
        if (!Modifier.isAbstract(n) && Modifier.isAbstract(n2) || Modifier.isStatic(n) != Modifier.isStatic(n2)) {
            this.versionsCompatible = false;
            this.rf.findReferencingClassesForMethod(this.oldClassInfo, n3);
            if (!Modifier.isAbstract(n) && Modifier.isAbstract(n2)) {
                this.rf.findConcreteSubclassesNotOverridingAbstractMethod(this.oldClassInfo, this.newClassInfo, n3);
            }
        }
        if (!Modifier.isFinal(n) && Modifier.isFinal(n2)) {
            this.versionsCompatible = false;
            this.rf.findSubclassesReimplementingMethod(this.oldClassInfo, n3);
        }
    }

    private boolean subclassesDeclareSameNameMethod(ClassInfo classInfo, String string) {
        boolean bl = false;
        ClassInfo[] classInfoArray = classInfo.getDirectSubclasses();
        int n = 0;
        while (n < classInfoArray.length) {
            ClassInfo classInfo2 = classInfoArray[n];
            int n2 = classInfo2.declaresSameNameMethod(string);
            if (n2 >= 0) {
                this.rf.addToAffectedClassNames(classInfo2.name);
                this.rf.findReferencingClassesForMethod(classInfo2, n2);
                bl = true;
            }
            if (this.subclassesDeclareSameNameMethod(classInfo2, string)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }
}

