package net.sf.colossus.server;


import java.io.*;


/**
 * Class ConfigFileFilter implements a FilenameFilter for cfg files.
 * @author David Ripton
 * @version $Id: ConfigFileFilter.java,v 1.6 2004/01/22 01:26:41 dripton Exp $
 */

public final class ConfigFileFilter extends javax.swing.filechooser.FileFilter
    implements FilenameFilter
{
    public static final String description = "Colossus options file";


    public boolean accept(File dir, String name)
    {
        if (name.endsWith(Constants.optionsExtension))
        {
            return true;
        }
        else
        {
            return false;
        }
    }


    public boolean accept(File f)
    {
        if (f.isDirectory())
        {
            return true;
        }
        String name = f.getName();
        return accept(null, name);
    }

    public String getDescription()
    {
        return description;
    }
}
