/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.event.UninstallerListener;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.FileExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class Destroyer
extends Thread {
    private boolean forceDestroy;
    private String installPath;
    private AbstractUIProgressHandler handler;

    public Destroyer(String installPath, boolean forceDestroy, AbstractUIProgressHandler handler) {
        super("IzPack - Destroyer");
        this.installPath = installPath;
        this.forceDestroy = forceDestroy;
        this.handler = handler;
    }

    public void run() {
        try {
            List[] listeners = this.getListenerLists();
            ArrayList executables = this.getExecutablesList();
            FileExecutor executor = new FileExecutor(executables);
            executor.executeFiles(2, this.handler);
            ArrayList files = this.getFilesList();
            int size = files.size();
            this.informListeners(listeners[0], 1, files, this.handler);
            this.handler.startAction("destroy", size);
            for (int i = 0; i < size; ++i) {
                File file = (File)files.get(i);
                this.informListeners(listeners[1], 3, file, this.handler);
                file.delete();
                this.informListeners(listeners[1], 4, file, this.handler);
                this.handler.progress(i, file.getAbsolutePath());
            }
            this.informListeners(listeners[0], 2, files, this.handler);
            this.handler.progress(size, "[ cleanups ]");
            this.cleanup(new File(this.installPath));
            this.handler.stopAction();
        }
        catch (Exception err) {
            this.handler.stopAction();
            err.printStackTrace();
            this.handler.emitError("exception caught", err.toString());
        }
    }

    private void askUninstallerRemoval() throws Exception {
        InputStream in = Destroyer.class.getResourceAsStream("/jarlocation.log");
        InputStreamReader inReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inReader);
        File jar = new File(reader.readLine());
        File path = new File(reader.readLine());
        File inst = new File(this.installPath);
        jar.deleteOnExit();
        path.deleteOnExit();
        inst.deleteOnExit();
    }

    private ArrayList getFilesList() throws Exception {
        TreeSet files = new TreeSet(Collections.reverseOrder());
        InputStream in = Destroyer.class.getResourceAsStream("/install.log");
        InputStreamReader inReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inReader);
        reader.readLine();
        String read = reader.readLine();
        while (read != null) {
            files.add(new File(read));
            read = reader.readLine();
        }
        return new ArrayList(files);
    }

    private ArrayList getExecutablesList() throws Exception {
        ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
        ObjectInputStream in = new ObjectInputStream(Destroyer.class.getResourceAsStream("/executables"));
        int num = in.readInt();
        for (int i = 0; i < num; ++i) {
            ExecutableFile file = (ExecutableFile)in.readObject();
            executables.add(file);
        }
        return executables;
    }

    private void cleanup(File file) throws Exception {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                this.cleanup(files[i]);
            }
            file.delete();
        } else if (this.forceDestroy) {
            file.delete();
        }
    }

    private List[] getListenerLists() throws Exception {
        List[] uninstaller = new ArrayList[]{new ArrayList(), new ArrayList()};
        InputStream in = Destroyer.class.getResourceAsStream("/uninstallerListeners");
        if (in != null) {
            ObjectInputStream objIn = new ObjectInputStream(in);
            List listeners = (List)objIn.readObject();
            objIn.close();
            Iterator iter = listeners.iterator();
            while (iter != null && iter.hasNext()) {
                Class<?> clazz = Class.forName((String)iter.next());
                UninstallerListener ul = (UninstallerListener)clazz.newInstance();
                if (ul.isFileListener()) {
                    ((ArrayList)uninstaller[1]).add(ul);
                }
                ((ArrayList)uninstaller[0]).add(ul);
            }
        }
        return uninstaller;
    }

    private void informListeners(List listeners, int action, Object param, AbstractUIProgressHandler handler) {
        Iterator iter = listeners.iterator();
        UninstallerListener il = null;
        while (iter.hasNext()) {
            try {
                il = (UninstallerListener)iter.next();
                switch (action) {
                    case 1: {
                        il.beforeDeletion((List)param, handler);
                        break;
                    }
                    case 2: {
                        il.afterDeletion((List)param, handler);
                        break;
                    }
                    case 3: {
                        il.beforeDelete((File)param, handler);
                        break;
                    }
                    case 4: {
                        il.afterDelete((File)param, handler);
                    }
                }
            }
            catch (Throwable e) {
                handler.emitError("Skipping custom action because exception caught during " + il.getClass().getName(), e.toString());
            }
        }
    }
}

