/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.uninstaller.Destroyer;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class UninstallerFrame
extends JFrame {
    private IconsDatabase icons;
    protected LocaleDatabase langpack;
    private JLabel warningLabel;
    protected JCheckBox targetDestroyCheckbox;
    protected JProgressBar progressBar;
    protected JButton destroyButton;
    protected JButton quitButton;
    private GridBagLayout layout;
    private GridBagConstraints gbConstraints;
    private Color buttonsHColor = new Color(230, 230, 230);
    protected String installPath;

    public UninstallerFrame() throws Exception {
        super("IzPack - Uninstaller");
        this.langpack = new LocaleDatabase(UninstallerFrame.class.getResourceAsStream("/langpack.xml"));
        this.getInstallPath();
        this.icons = new IconsDatabase();
        this.loadIcons();
        UIManager.put("OptionPane.yesButtonText", this.langpack.getString("installer.yes"));
        UIManager.put("OptionPane.noButtonText", this.langpack.getString("installer.no"));
        UIManager.put("OptionPane.cancelButtonText", this.langpack.getString("installer.cancel"));
        this.setIconImage(this.icons.getImageIcon("JFrameIcon").getImage());
        this.buildGUI();
        this.addWindowListener(new WindowHandler());
        this.pack();
        this.centerFrame(this);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void buildGUI() {
        JPanel contentPane = (JPanel)this.getContentPane();
        this.layout = new GridBagLayout();
        contentPane.setLayout(this.layout);
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        ActionsHandler handler = new ActionsHandler();
        JPanel glassPane = (JPanel)this.getGlassPane();
        glassPane.addMouseListener(new MouseAdapter(){});
        glassPane.addMouseMotionListener(new MouseMotionAdapter(){});
        glassPane.addKeyListener(new KeyAdapter(){});
        ButtonFactory.useButtonIcons();
        ButtonFactory.useHighlightButtons();
        this.warningLabel = new JLabel(this.langpack.getString("uninstaller.warning"), this.icons.getImageIcon("warning"), 11);
        this.buildConstraints(this.gbConstraints, 0, 0, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 17;
        this.gbConstraints.fill = 0;
        this.layout.addLayoutComponent(this.warningLabel, this.gbConstraints);
        contentPane.add(this.warningLabel);
        this.targetDestroyCheckbox = new JCheckBox(this.langpack.getString("uninstaller.destroytarget") + this.installPath, false);
        this.buildConstraints(this.gbConstraints, 0, 1, 2, 1, 1.0, 0.0);
        this.layout.addLayoutComponent(this.targetDestroyCheckbox, this.gbConstraints);
        contentPane.add(this.targetDestroyCheckbox);
        this.gbConstraints.fill = 2;
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(this.langpack.getString("InstallPanel.begin"));
        this.buildConstraints(this.gbConstraints, 0, 2, 2, 1, 1.0, 0.0);
        this.layout.addLayoutComponent(this.progressBar, this.gbConstraints);
        contentPane.add(this.progressBar);
        this.destroyButton = ButtonFactory.createButton(this.langpack.getString("uninstaller.uninstall"), this.icons.getImageIcon("delete"), this.buttonsHColor);
        this.destroyButton.addActionListener(handler);
        this.buildConstraints(this.gbConstraints, 0, 3, 1, 1, 0.5, 0.0);
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 17;
        this.layout.addLayoutComponent(this.destroyButton, this.gbConstraints);
        contentPane.add(this.destroyButton);
        this.quitButton = ButtonFactory.createButton(this.langpack.getString("installer.quit"), this.icons.getImageIcon("stop"), this.buttonsHColor);
        this.quitButton.addActionListener(handler);
        this.buildConstraints(this.gbConstraints, 1, 3, 1, 1, 0.5, 0.0);
        this.gbConstraints.anchor = 13;
        this.layout.addLayoutComponent(this.quitButton, this.gbConstraints);
        contentPane.add(this.quitButton);
    }

    private void centerFrame(Window frame) {
        Dimension frameSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2 - 10);
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    private void getInstallPath() throws Exception {
        InputStream in = UninstallerFrame.class.getResourceAsStream("/install.log");
        InputStreamReader inReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inReader);
        this.installPath = reader.readLine();
        reader.close();
    }

    private void loadIcons() throws Exception {
        this.icons = new IconsDatabase();
        URL url = UninstallerFrame.class.getResource("/img/trash.png");
        ImageIcon img = new ImageIcon(url);
        this.icons.put("delete", img);
        url = UninstallerFrame.class.getResource("/img/stop.png");
        img = new ImageIcon(url);
        this.icons.put("stop", img);
        url = UninstallerFrame.class.getResource("/img/flag.png");
        img = new ImageIcon(url);
        this.icons.put("warning", img);
        url = UninstallerFrame.class.getResource("/img/JFrameIcon.png");
        img = new ImageIcon(url);
        this.icons.put("JFrameIcon", img);
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    class ActionsHandler
    implements ActionListener {
        ActionsHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == UninstallerFrame.this.quitButton) {
                System.exit(0);
            } else if (src == UninstallerFrame.this.destroyButton) {
                Destroyer destroyer = new Destroyer(UninstallerFrame.this.installPath, UninstallerFrame.this.targetDestroyCheckbox.isSelected(), new DestroyerHandler());
                destroyer.start();
            }
        }
    }

    private final class DestroyerHandler
    implements AbstractUIProgressHandler {
        private DestroyerHandler() {
        }

        public void startAction(String name, int max) {
            UninstallerFrame.this.progressBar.setMinimum(0);
            UninstallerFrame.this.progressBar.setMaximum(max);
            UninstallerFrame.this.blockGUI();
        }

        public void stopAction() {
            UninstallerFrame.this.progressBar.setString(UninstallerFrame.this.langpack.getString("InstallPanel.finished"));
            UninstallerFrame.this.targetDestroyCheckbox.setEnabled(false);
            UninstallerFrame.this.destroyButton.setEnabled(false);
            UninstallerFrame.this.releaseGUI();
        }

        public void progress(int pos, String message) {
            UninstallerFrame.this.progressBar.setValue(pos);
            UninstallerFrame.this.progressBar.setString(message);
        }

        public void nextStep(String step_name, int step_no, int no_of_substeps) {
        }

        public void emitNotification(String text) {
        }

        public boolean emitWarning(String title, String text) {
            return JOptionPane.showConfirmDialog(null, text, title, 2, 2) == 0;
        }

        public void emitError(String title, String error) {
            UninstallerFrame.this.progressBar.setString(error);
            JOptionPane.showMessageDialog(null, error, title, 2);
        }

        public int askQuestion(String title, String question, int choices) {
            return this.askQuestion(title, question, choices, -1);
        }

        public int askQuestion(String title, String question, int choices, int default_choice) {
            int jo_choices = 0;
            if (choices == 37) {
                jo_choices = 0;
            } else if (choices == 38) {
                jo_choices = 1;
            }
            int user_choice = JOptionPane.showConfirmDialog(null, question, title, jo_choices, 3);
            if (user_choice == 2) {
                return 45;
            }
            if (user_choice == 0) {
                return 47;
            }
            if (user_choice == 1) {
                return 49;
            }
            return default_choice;
        }
    }

    private final class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

