/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.A.Y;
import com.sillysoft.B.E;
import com.sillysoft.B.J;
import com.sillysoft.B.Q;
import com.sillysoft.lux.B;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.CardSequence;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.D.A;
import com.sillysoft.lux.K;
import com.sillysoft.lux.agent.LuxAgent;
import com.sillysoft.lux.util.BoardHelper;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.StringTokenizer;

public class Board {
    private Country[] countries;
    private LuxAgent[] agents;
    private int[] agentCards;
    private boolean pickCountriesRandomly;
    private String[] contNames;
    private B world;
    private boolean finished = false;

    public Board(B b2) {
        this.world = b2;
    }

    public boolean cashCards(Card card, Card card2, Card card3) {
        return this.world.A(card, card2, card3);
    }

    public void placeArmies(int n, Country country) {
        if (country == null) {
            System.out.println("ERROR in board.placeArmies() -> country==null");
            Thread.dumpStack();
            return;
        }
        this.placeArmies(n, country.getCode());
    }

    public void placeArmies(int n, int n2) {
        if (!this.world.F(n, n2)) {
            System.out.println("ERROR returned from board.placeArmies(). You don't own country " + n2);
            Thread.dumpStack();
        }
    }

    public int attack(Country country, Country country2, boolean bl) {
        if (country == null || country2 == null) {
            System.out.println("board.attack -> (attacker == null || defender == null)");
            return -1;
        }
        return this.attack(country.getCode(), country2.getCode(), bl);
    }

    public int attack(int n, int n2, boolean bl) {
        return this.world.A(n, n2, bl);
    }

    public int fortifyArmies(int n, Country country, Country country2) {
        if (country == null || country2 == null) {
            System.out.println("board.fortifyArmies -> (origin == null || destination == null)");
            return -1;
        }
        return this.fortifyArmies(n, country.getCode(), country2.getCode());
    }

    public int fortifyArmies(int n, int n2, int n3) {
        return this.world.A(n, n2, n3);
    }

    void setCountries(Country[] countryArray) {
        if (!this.finished) {
            this.countries = countryArray;
        }
    }

    void setAgents(LuxAgent[] luxAgentArray) {
        if (!this.finished) {
            this.agents = luxAgentArray;
        }
    }

    public void setContinentNames(String[] stringArray) {
        if (!this.finished) {
            this.contNames = stringArray;
        }
    }

    public void finished() {
        this.finished = true;
    }

    public Country[] getCountries() {
        Country[] countryArray = new Country[this.countries.length];
        for (int i = 0; i < this.countries.length; ++i) {
            countryArray[i] = this.countries[i];
        }
        return countryArray;
    }

    public int getNumberOfCountries() {
        return this.countries.length;
    }

    public int getNumberOfContinents() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfCountries(); ++i) {
            n = Math.max(n, this.countries[i].getContinent());
        }
        return ++n;
    }

    public int getContinentBonus(int n) {
        return this.world.Q(n);
    }

    public String getContinentName(int n) {
        return this.contNames[n];
    }

    public int getNumberOfPlayers() {
        return this.agents.length;
    }

    public int getNumberOfPlayersLeft() {
        int n = 0;
        if (this.agents == null) {
            System.out.println("oops in Board.getNumberOfPlayersLeft -> agents is null 65422211");
        }
        for (int i = 0; i < this.agents.length; ++i) {
            if (!BoardHelper.playerIsStillInTheGame(i, this.countries)) continue;
            ++n;
        }
        return n;
    }

    public int getPlayerIncome(int n) {
        return this.world.E(n);
    }

    public String getPlayerName(int n) {
        return this.world.F(n);
    }

    public String getAgentName(int n) {
        if (n < 0) {
            return "empty_nation";
        }
        return this.agents[n].name();
    }

    public int getPlayerCards(int n) {
        return this.world.V.G.H(n);
    }

    public int getNextCardSetValue() {
        return this.world.I();
    }

    public boolean tookOverACountry() {
        return this.world._();
    }

    public boolean useCards() {
        return this.world.V.C.useCards;
    }

    public boolean transferCards() {
        return this.world.V.C.cardTransfer;
    }

    public boolean immediateCash() {
        return this.world.V.C.immediateCardCash;
    }

    public String toString() {
        String string = "";
        string = string + "Country #\t\tContinent\t\tOwner\t\tArmies\n";
        for (int i = 0; i < this.getNumberOfCountries(); ++i) {
            string = string + "\t";
            string = string + i;
            string = string + "\t\t\t";
            string = string + this.countries[i].getContinent();
            string = string + "\t\t\t";
            string = string + this.countries[i].getOwner();
            string = string + "\t\t\t";
            string = string + this.countries[i].getArmies();
            string = string + "\n";
        }
        return string;
    }

    void kill(B b2) {
        if (this.world == b2) {
            this.world = null;
            this.agents = null;
            this.countries = null;
        } else {
            System.out.println("Someone not allowed tried to kill the board");
        }
    }

    public boolean playAudioAtURL(final String string) {
        if (string == null) {
            System.out.println("Board.playAudio() was called with audioURL == null");
            return false;
        }
        if (!J.Y || !Q.A("soundAgents", true)) {
            return false;
        }
        try {
            new Thread(){

                public void run() {
                    try {
                        Y.B(new URL(string));
                    }
                    catch (Throwable throwable) {
                        System.out.println(throwable + " caught while playing audio for an agent");
                    }
                }
            }.start();
            return true;
        }
        catch (Exception exception) {
            System.out.println("Board.playAudio() caught an exception (" + exception + "). Perhaps the game hasn't started yet.");
            return false;
        }
    }

    public boolean sendChat(String string, LuxAgent luxAgent) {
        if (string == null) {
            System.out.println("Board.sendChat() was called with message == null");
            return false;
        }
        if (string.startsWith("/") || string.startsWith("\\")) {
            System.out.println("Board.sendChat() was called with a message that starts with '/' or '', which is not allowed");
            return false;
        }
        try {
            A a2 = this.world.V.E;
            if (a2 == null) {
                return false;
            }
            if (this.world.l == -1) {
                System.out.println("Board.sendChat() was called before the game has started");
                return false;
            }
            String string2 = this.world.A(luxAgent);
            if (string2 == null) {
                return false;
            }
            a2.E(string, string2);
            return true;
        }
        catch (Exception exception) {
            System.out.println("Board.sendChat() caught an exception (" + exception + "). Perhaps the game hasn't started yet.");
            return false;
        }
    }

    public boolean sendChat(String string) {
        if (string == null) {
            System.out.println("Board.sendChat() was called with message == null");
            return false;
        }
        if (string.startsWith("/") || string.startsWith("\\")) {
            System.out.println("Board.sendChat() was called with a message that starts with '/' or '', which is not allowed");
            return false;
        }
        try {
            A a2 = this.world.V.E;
            if (a2 == null) {
                return false;
            }
            if (this.world.l == -1) {
                System.out.println("Board.sendChat() was called before the game has started");
                return false;
            }
            StringWriter stringWriter = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            string3 = string3.substring(string3.indexOf("at ") + 3, string3.lastIndexOf("("));
            string3 = string3.substring(0, string3.lastIndexOf("."));
            int n = string3.lastIndexOf(".");
            if (n != -1) {
                string3 = string3.substring(n + 1);
            }
            a2.E(string, string3);
            return true;
        }
        catch (Exception exception) {
            System.out.println("Board.sendChat() caught an exception (" + exception + "). Perhaps the game hasn't started yet.");
            return false;
        }
    }

    public boolean sendEmote(String string) {
        if (string == null) {
            System.out.println("Board.sendChat() was called with message == null");
            return false;
        }
        if (string.startsWith("/") || string.startsWith("\\")) {
            System.out.println("Board.sendChat() was called with a message that starts with '/' or '', which is not allowed");
            return false;
        }
        try {
            A a2 = this.world.V.E;
            if (a2 == null) {
                return false;
            }
            if (this.world.l == -1) {
                System.out.println("Board.sendChat() was called before the game has started");
                return false;
            }
            StringWriter stringWriter = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            string3 = string3.substring(string3.indexOf("at ") + 3, string3.lastIndexOf("("));
            string3 = string3.substring(0, string3.lastIndexOf("."));
            int n = string3.lastIndexOf(".");
            if (n != -1) {
                string3 = string3.substring(n + 1);
            }
            a2.D(string, string3);
            return true;
        }
        catch (Exception exception) {
            System.out.println("Board.sendChat() caught an exception (" + exception + "). Perhaps the game hasn't started yet.");
            return false;
        }
    }

    public boolean sendEmote(String string, LuxAgent luxAgent) {
        if (string == null) {
            System.out.println("Board.sendEmote() was called with message == null");
            return false;
        }
        if (string.startsWith("/") || string.startsWith("\\")) {
            System.out.println("Board.sendEmote() was called with a message that starts with '/' or '', which is not allowed");
            return false;
        }
        try {
            A a2 = this.world.V.E;
            if (a2 == null) {
                return false;
            }
            if (this.world.l == -1) {
                System.out.println("Board.sendEmote() was called before the game has started");
                return false;
            }
            String string2 = this.world.A(luxAgent);
            if (string2 == null) {
                return false;
            }
            a2.D(string, string2);
            return true;
        }
        catch (Exception exception) {
            System.out.println("Board.sendChat() caught an exception (" + exception + "). Perhaps the game hasn't started yet.");
            return false;
        }
    }

    public static String getAgentPath() {
        return E.A() + "Agents" + File.separator;
    }

    public String storageGet(String string, String string2) {
        return Q.A("agent_" + string, string2);
    }

    public boolean storageGetBoolean(String string, boolean bl) {
        return Q.A("agent_" + string, bl);
    }

    public int storageGetInt(String string, int n) {
        return Q.B("agent_" + string, n);
    }

    public float storageGetFloat(String string, float f2) {
        return Q.A("agent_" + string, f2);
    }

    public void storagePut(String string, String string2) {
        Q.B("agent_" + string, string2);
    }

    public void storagePutBoolean(String string, boolean bl) {
        Q.B("agent_" + string, bl);
    }

    public void storagePutInt(String string, int n) {
        Q.A("agent_" + string, n);
    }

    public void storagePutFloat(String string, float f2) {
        Q.B("agent_" + string, f2);
    }

    public void storageRemoveKey(String string) {
        Q.E("agent_" + string);
    }

    public LuxAgent getAgentInstance(String string) {
        return K.D(string);
    }

    public String getCardProgression() {
        if (this.useCards()) {
            return CardSequence.sequences[this.world.V.C.cardSequenceCode];
        }
        return "0";
    }

    public int getContinentIncrease() {
        return this.world.V.C.continentSequence.intIncrease();
    }

    public int getTurnSecondsLeft() {
        return this.world.V.B();
    }

    public int getTurnCount() {
        return this.world.X;
    }
}

