/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.B.E;
import com.sillysoft.B.N;
import com.sillysoft.B.X;
import com.sillysoft.lux.B;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.LuxMapGenerator;
import com.sillysoft.lux.MapLoader;
import com.sillysoft.lux.gui.G;
import com.sillysoft.lux.gui.J;
import com.sillysoft.lux.gui.K;
import com.sillysoft.lux.gui.T;
import com.sillysoft.lux.gui.f;
import java.awt.geom.GeneralPath;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.StringTokenizer;

public class BoardFile
implements Serializable {
    static final long serialVersionUID = 3422169136258069307L;
    public String contents;
    private String filename;
    private String description;
    private String playerInfoLocation;
    private boolean shortContinentLabels;
    private int mark = 0;

    public BoardFile(String string, int n) throws Exception {
        String string2 = E.A() + "Boards" + File.separator + "Random" + File.separator + string + n + ".luxb";
        if (new File(string2).exists()) {
            this.createFromPath(string2);
        } else {
            N.A("we are using createFromGenerator()");
            this.createFromGenerator(string, n);
        }
    }

    private void createFromGenerator(String string, int n) throws Exception {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        LuxMapGenerator luxMapGenerator = f.I().B(string);
        boolean bl = luxMapGenerator.generate(printWriter, string, n, new MapLoader(null));
        try {
            printWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createFromReader(new BufferedReader(new StringReader(stringWriter.toString())));
        this.filename = "notCachedGenerated.luxb";
    }

    public BoardFile(String string) throws Exception {
        this.createFromPath(string);
    }

    public BoardFile(String string, boolean bl) throws Exception {
        this.createFromPath(E.A() + "Boards" + File.separator + "Saved" + File.separator + string + ".luxb");
    }

    private void createFromPath(String string) throws Exception {
        this.filename = string.substring(string.indexOf(File.separator + "Saved" + File.separator) + 7);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
        this.createFromReader(bufferedReader);
    }

    private void createFromReader(BufferedReader bufferedReader) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        String string = bufferedReader.readLine();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        if ("luxboard-1.0".equals(string)) {
            throw new Exception("The board file is malformed");
        }
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.contents = stringBuffer.toString();
    }

    void load(T t) throws Exception {
        B b2 = t.J;
        K k = null;
        if (t instanceof G) {
            k = ((G)t).\u00c2;
        }
        this.load(t, b2, k);
    }

    public void load(K k) throws Exception {
        this.load(null, null, k);
    }

    private void load(T t, B b2, K k) throws Exception {
        String string;
        int n;
        String string2;
        Object object;
        String[] stringArray;
        String[] stringArray2;
        if (t != null) {
            t.G("loading file " + this.filename);
        }
        boolean bl = t != null;
        System.out.println("\nLoading -> " + this.filename);
        if (!this.contents.startsWith("<?xml")) {
            try {
                t.G("adding XML declaration");
                N.A("BoardFile.load is adding the xml declaration to a file it reads in");
                this.saveToPath(E.A() + "Boards" + File.separator + "Saved" + File.separator + this.filename);
            }
            catch (Exception exception) {
                System.out.println("Tried to add the XML declaration to a board file that was missing it, but failed.");
            }
        }
        if (t != null && t.C.savedGame) {
            String string3;
            int n2 = X.D("player", this.contents);
            stringArray2 = new String[n2];
            stringArray = new String[n2];
            String[] stringArray3 = new String[n2];
            object = new boolean[n2];
            int n3 = 0;
            while ((string3 = X.A("player", this.contents, n3)) != null) {
                stringArray2[n3] = X.B("name", string3);
                stringArray[n3] = X.B("type", string3);
                stringArray3[n3] = X.B("color", string3);
                object[n3] = "Human".equals(stringArray[n3]);
                ++n3;
            }
            string2 = X.B("title", this.contents);
            t.C.takeValues(stringArray, stringArray2, stringArray3, (boolean[])object, string2);
        }
        if (t != null) {
            t.G("loading map data");
        }
        if (bl && t instanceof G) {
            ((G)t).I(X.B("title", this.contents));
            try {
                t.C.width = Integer.parseInt(X.B("width", this.contents));
                t.C.height = Integer.parseInt(X.B("height", this.contents));
                if (t.C.width == 0 || t.C.height == 0) {
                    throw new Exception("Cannot have a width or height of 0");
                }
                ((G)t).y();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Exception("Error in <width> or <height>: " + exception.getMessage());
            }
        }
        int n4 = X.D("country", this.contents);
        if (bl) {
            String string4 = X.B("theme", this.contents);
            if (k != null) {
                k.M(string4);
            }
            b2.D(n4);
            if (k != null) {
                k.K(n4);
            }
            t.G("absorbing the data for " + n4 + " countries");
        }
        int[] nArray = new int[n4];
        stringArray2 = (String[])new int[n4];
        stringArray = (String[])new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = -1;
            stringArray2[i] = (String)-1;
            stringArray[i] = (String)true;
        }
        int n5 = X.D("continent", this.contents);
        if (bl && k != null) {
            k.L(n5);
        }
        String[] stringArray4 = new String[n5];
        int[] nArray2 = new int[n5];
        int n6 = 0;
        while (true) {
            String string5 = X.A("continent", this.contents, n6);
            object = string5;
            if (string5 == null) break;
            stringArray4[n6] = X.B("continentname", (String)object);
            try {
                nArray2[n6] = Integer.parseInt(X.B("bonus", (String)object));
            }
            catch (Exception exception) {
                throw new Exception("Error in the <bonus> tag for continent '" + stringArray4[n6] + "': " + exception.getMessage());
            }
            if (bl && k != null) {
                try {
                    String string6 = X.B("color", (String)object);
                    if (string6 != null) {
                        k.A(n6, com.sillysoft.B.K.F(string6));
                    }
                    k.A(n6, stringArray4[n6]);
                }
                catch (Exception exception) {
                    throw new Exception("Error in the <color> tag for continent '" + stringArray4[n6] + "': " + exception.getMessage());
                }
            }
            try {
                if (k != null) {
                    k.C(n6, X.B("labellocation", (String)object));
                }
            }
            catch (Exception exception) {
                throw new Exception("Error in the <labellocation> tag in continent '" + stringArray4[n6] + "': " + exception.getMessage());
            }
            n = 0;
            while ((string2 = X.A("country", (String)object, n)) != null) {
                string = X.B("name", string2);
                int n7 = -1;
                try {
                    String string7;
                    StringTokenizer stringTokenizer;
                    n7 = Integer.parseInt(X.B("id", string2));
                    if (n7 >= nArray.length) {
                        throw new Exception("You are using an <id> that is too high (" + n7 + "). Note that the <id>s must start at 0, not 1.");
                    }
                    if (nArray[n7] != -1) {
                        throw new Exception("Duplicate <id>: " + n7);
                    }
                    nArray[n7] = n6;
                    if (bl) {
                        if (k != null) {
                            k.D(n7, string);
                        }
                        b2.B(n7, string);
                        stringTokenizer = new StringTokenizer(X.B("adjoining", string2), ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            b2.E(n7, Integer.parseInt(stringTokenizer.nextToken()));
                        }
                        try {
                            string7 = X.B("initialOwner", string2);
                            if (string7 != null) {
                                stringArray2[n7] = (String)Integer.parseInt(string7);
                            }
                            if ((string7 = X.B("initialArmies", string2)) != null) {
                                stringArray[n7] = (String)Integer.parseInt(string7);
                            }
                        }
                        catch (Exception exception) {
                            throw new Exception("Error in initialOwner or initialArmies");
                        }
                    }
                    GeneralPath generalPath = new GeneralPath();
                    int n8 = 0;
                    while ((string7 = X.A("polygon", string2, n8)) != null) {
                        stringTokenizer = new StringTokenizer(string7, " ,");
                        int n9 = Integer.parseInt(stringTokenizer.nextToken());
                        int n10 = Integer.parseInt(stringTokenizer.nextToken());
                        generalPath.moveTo(n9, n10);
                        while (stringTokenizer.hasMoreTokens()) {
                            generalPath.lineTo(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                        }
                        generalPath.lineTo(n9, n10);
                        generalPath.closePath();
                        ++n8;
                    }
                    if (k != null) {
                        k.A(n7, generalPath);
                        k.B(n7, X.B("armylocation", string2));
                    }
                }
                catch (Exception exception) {
                    throw new Exception("Error in country '" + string + "' (could be country with id " + n7 + "): " + exception);
                }
                ++n;
            }
            ++n6;
        }
        if (t != null) {
            t.G("it's all in the details (doing them now)");
        }
        if (bl) {
            b2.A(nArray, (int[])stringArray2, (int[])stringArray, nArray2, stringArray4);
            if (k != null) {
                k.A(nArray);
            }
        }
        if (!bl && k != null) {
            k.t();
        }
        try {
            String string8;
            n = 0;
            while ((string8 = X.A("line", this.contents, n)) != null) {
                string = X.B("position", string8);
                if (!string.trim().equals("")) {
                    if (k != null) {
                        k.A(new J(string8));
                    }
                } else {
                    N.A("There is a <line> with an empty <position>");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new Exception("Error in <line>: " + exception.getMessage());
        }
        this.description = X.B("description", this.contents);
        this.playerInfoLocation = X.B("playerInfoLocation", this.contents);
        this.shortContinentLabels = "true".equals(X.B("shortContinentLabels", this.contents));
        if (k != null) {
            k.b();
        }
        if (!bl && k != null) {
            k.L(null);
        }
    }

    private String readLine() {
        int n = this.contents.indexOf(10, this.mark);
        if (n == -1) {
            this.mark = 0;
            return null;
        }
        String string = this.contents.substring(this.mark, n);
        this.mark = n + 1;
        return string;
    }

    private void close() {
        this.mark = 0;
    }

    public String pathCustom() {
        return E.A() + "Boards" + File.separator + "Saved" + File.separator + this.filename;
    }

    public void saveCustom(String string) {
        String string2;
        File file;
        if (string == null) {
            string = this.filename;
        }
        if ((file = new File(string2 = E.A() + "Boards" + File.separator + "Saved" + File.separator + string)).exists()) {
            N.A("BOARDFILE -> decided not to overwrite existing file");
        } else {
            try {
                this.saveToPath(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void saveToPath(String string) throws IOException {
        N.A("using filename='" + this.filename + "' path='" + string);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8")));
        String string2 = this.readLine();
        if (!string2.startsWith("<?xml")) {
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        printWriter.println(string2);
        while ((string2 = this.readLine()) != null) {
            printWriter.println(string2);
        }
        printWriter.close();
    }

    public boolean existsCustom() {
        System.out.println("filename = " + this.filename);
        return new File(this.pathCustom()).exists();
    }

    public void saveResized(float f2, String string) {
        String string2;
        StringTokenizer stringTokenizer;
        int n;
        int n2;
        int n3;
        String string3;
        String string4;
        int n4;
        String[] stringArray = new String[]{"version"};
        String[] stringArray2 = new String[]{"theme", "title", "author", "email", "webpage", "description", "shortContinentLabels"};
        String[] stringArray3 = new String[]{"bonus"};
        String[] stringArray4 = new String[]{"color", "continentname"};
        String[] stringArray5 = new String[]{"id", "adjoining"};
        String[] stringArray6 = new String[]{"name", "initialOwner", "initialArmies"};
        String[] stringArray7 = new String[]{"color", "width", "above"};
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<luxboard>\n");
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            stringBuffer.append("<" + stringArray[n4] + ">" + X.B(stringArray[n4], this.contents) + "</" + stringArray[n4] + ">\n");
        }
        stringBuffer.append("<height>" + (int)(f2 * (float)Integer.parseInt(X.B("height", this.contents))) + "</height>\n");
        stringBuffer.append("<width>" + (int)(f2 * (float)Integer.parseInt(X.B("width", this.contents))) + "</width>\n");
        for (n4 = 0; n4 < stringArray2.length; ++n4) {
            string4 = X.B(stringArray2[n4], this.contents);
            if (string4 == null) continue;
            stringBuffer.append("<" + stringArray2[n4] + ">" + string4 + "</" + stringArray2[n4] + ">\n");
        }
        n4 = 0;
        while ((string3 = X.A("continent", this.contents, n4)) != null) {
            String string5;
            int n5;
            stringBuffer.append("<continent>\n");
            for (n3 = 0; n3 < stringArray3.length; ++n3) {
                stringBuffer.append("<" + stringArray3[n3] + ">" + X.B(stringArray3[n3], string3) + "</" + stringArray3[n3] + ">\n");
            }
            for (n3 = 0; n3 < stringArray4.length; ++n3) {
                string4 = X.B(stringArray4[n3], string3);
                if (string4 == null) continue;
                stringBuffer.append("<" + stringArray4[n3] + ">" + string4 + "</" + stringArray4[n3] + ">\n");
            }
            string4 = X.B("labellocation", string3);
            if (string4 != null) {
                n3 = string4.indexOf(",");
                n5 = Integer.parseInt(string4.substring(0, n3));
                n2 = Integer.parseInt(string4.substring(n3 + 1));
                stringBuffer.append("<labellocation>" + (int)((float)n5 * f2) + "," + (int)((float)n2 * f2) + "</labellocation>\n");
            }
            n3 = 0;
            while ((string5 = X.A("country", string3, n3)) != null) {
                String string6;
                stringBuffer.append("<country>\n");
                for (n5 = 0; n5 < stringArray5.length; ++n5) {
                    stringBuffer.append("<" + stringArray5[n5] + ">" + X.B(stringArray5[n5], string5) + "</" + stringArray5[n5] + ">\n");
                }
                for (n5 = 0; n5 < stringArray6.length; ++n5) {
                    string4 = X.B(stringArray6[n5], string5);
                    if (string4 == null) continue;
                    stringBuffer.append("<" + stringArray6[n5] + ">" + string4 + "</" + stringArray6[n5] + ">\n");
                }
                string4 = X.B("armylocation", string5);
                if (string4 != null) {
                    n5 = string4.indexOf(",");
                    n2 = Integer.parseInt(string4.substring(0, n5));
                    n = Integer.parseInt(string4.substring(n5 + 1));
                    stringBuffer.append("<armylocation>" + (int)((float)n2 * f2) + "," + (int)((float)n * f2) + "</armylocation>\n");
                }
                int n6 = 0;
                while ((string6 = X.A("polygon", string5, n6)) != null) {
                    stringBuffer.append("<polygon>");
                    stringTokenizer = new StringTokenizer(string6, " ,");
                    do {
                        n2 = Integer.parseInt(stringTokenizer.nextToken());
                        n = Integer.parseInt(stringTokenizer.nextToken());
                        stringBuffer.append((int)((float)n2 * f2) + "," + (int)((float)n * f2) + " ");
                    } while (stringTokenizer.hasMoreTokens());
                    stringBuffer.append("</polygon>\n");
                    ++n6;
                }
                stringBuffer.append("</country>\n");
                ++n3;
            }
            stringBuffer.append("</continent>\n");
            ++n4;
        }
        n3 = 0;
        while ((string2 = X.A("line", this.contents, n3)) != null) {
            stringBuffer.append("<line>");
            for (int i = 0; i < stringArray7.length; ++i) {
                string4 = X.B(stringArray7[i], string2);
                if (string4 == null) continue;
                stringBuffer.append("<" + stringArray7[i] + ">" + string4 + "</" + stringArray7[i] + ">\n");
            }
            String string7 = X.B("position", string2);
            stringBuffer.append("<position>");
            stringTokenizer = new StringTokenizer(string7, " ,");
            do {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
                stringBuffer.append((int)((float)n2 * f2) + "," + (int)((float)n * f2) + " ");
            } while (stringTokenizer.hasMoreTokens());
            stringBuffer.append("</position>\n");
            stringBuffer.append("</line>\n");
            ++n3;
        }
        stringBuffer.append("</luxboard>\n");
        File file = new File(E.A() + "Boards" + File.separator + "Saved" + File.separator + string);
        if (file.exists()) {
            String string8 = E.A() + "Boards" + File.separator + "Saved" + File.separator + string.substring(0, string.length() - 5);
            n2 = 1;
            do {
                file = new File(string8 + "." + n2 + ".luxb");
                ++n2;
            } while (file.exists());
        }
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            printWriter.print(stringBuffer);
            printWriter.close();
        }
        catch (Throwable throwable) {
            System.out.println("Lux -> error in BoardFile.saveResized().");
            throwable.printStackTrace();
        }
    }

    public int getScenarioNumberPlayers() {
        if (this.contents.indexOf("<initialOwner>") == -1) {
            return 0;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.contents.indexOf("<initialOwner>" + i + "</initialOwner>") != -1) continue;
            return i;
        }
        return 6;
    }

    public boolean getScenarioEmptyLand() {
        return this.contents.indexOf("<initialOwner>-1</initialOwner>") != -1;
    }

    public String playerInfoLocation() {
        return this.playerInfoLocation;
    }

    public boolean shortContinentLabels() {
        return this.shortContinentLabels;
    }

    public void saveGame(T t, String string) {
        String string2;
        Object object;
        int n;
        int n2;
        String string3;
        String string4;
        int n3;
        String[] stringArray = new String[]{"version", "width", "height"};
        String[] stringArray2 = new String[]{"theme", "author", "email", "webpage", "title", "description", "shortContinentLabels", "playerInfoLocation"};
        String[] stringArray3 = new String[]{"bonus"};
        String[] stringArray4 = new String[]{"color", "continentname", "labellocation"};
        String[] stringArray5 = new String[]{"id", "adjoining"};
        String[] stringArray6 = new String[]{"name", "armylocation"};
        String[] stringArray7 = new String[]{"color", "width", "above"};
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<luxboard>\n");
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            stringBuffer.append("<" + stringArray[n3] + ">" + X.B(stringArray[n3], this.contents) + "</" + stringArray[n3] + ">\n");
        }
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            string4 = X.B(stringArray2[n3], this.contents);
            if (string4 == null) continue;
            stringBuffer.append("<" + stringArray2[n3] + ">" + string4 + "</" + stringArray2[n3] + ">\n");
        }
        n3 = 0;
        while ((string3 = X.A("continent", this.contents, n3)) != null) {
            String string5;
            stringBuffer.append("<continent>\n");
            for (n2 = 0; n2 < stringArray3.length; ++n2) {
                stringBuffer.append("\t<" + stringArray3[n2] + ">" + X.B(stringArray3[n2], string3) + "</" + stringArray3[n2] + ">\n");
            }
            for (n2 = 0; n2 < stringArray4.length; ++n2) {
                string4 = X.B(stringArray4[n2], string3);
                if (string4 == null) continue;
                stringBuffer.append("\t<" + stringArray4[n2] + ">" + string4 + "</" + stringArray4[n2] + ">\n");
            }
            n2 = 0;
            while ((string5 = X.A("country", string3, n2)) != null) {
                stringBuffer.append("\t<country>\n");
                for (n = 0; n < stringArray5.length; ++n) {
                    stringBuffer.append("\t\t<" + stringArray5[n] + ">" + X.B(stringArray5[n], string5) + "</" + stringArray5[n] + ">\n");
                }
                for (n = 0; n < stringArray6.length; ++n) {
                    string4 = X.B(stringArray6[n], string5);
                    if (string4 == null) continue;
                    stringBuffer.append("\t\t<" + stringArray6[n] + ">" + string4 + "</" + stringArray6[n] + ">\n");
                }
                n = Integer.parseInt(X.B("id", string5));
                stringBuffer.append("\t\t<initialOwner>" + t.J.e[n].getOwner() + "</initialOwner>\n");
                stringBuffer.append("\t\t<initialArmies>" + t.J.e[n].getArmies() + "</initialArmies>\n");
                int n4 = 0;
                while ((object = X.A("polygon", string5, n4)) != null) {
                    stringBuffer.append("\t\t<polygon>");
                    stringBuffer.append((String)object);
                    stringBuffer.append("</polygon>\n");
                    ++n4;
                }
                stringBuffer.append("\t</country>\n");
                ++n2;
            }
            stringBuffer.append("</continent>\n");
            ++n3;
        }
        n2 = 0;
        while ((string2 = X.A("line", this.contents, n2)) != null) {
            stringBuffer.append("<line>");
            stringBuffer.append(string2);
            stringBuffer.append("</line>\n");
            ++n2;
        }
        stringBuffer.append("\n\n");
        n2 = t.C.playerNames.length;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("<player><name>");
            stringBuffer.append(t.C.playerNames[n]);
            stringBuffer.append("</name><type>");
            stringBuffer.append(t.C.playerTypes[n]);
            stringBuffer.append("</type><color>");
            stringBuffer.append(t.C.colorPassString[n]);
            stringBuffer.append("</color></player>\n");
            stringBuffer.append("<playerCards>");
            object = t.J.N(n);
            for (int i = 0; i < ((Card[])object).length; ++i) {
                stringBuffer.append("<cardString>");
                stringBuffer.append(object[i].toString());
                stringBuffer.append("</cardString>");
            }
            stringBuffer.append("</playerCards>\n\n");
        }
        stringBuffer.append("<gameRound>");
        stringBuffer.append(t.J.X);
        stringBuffer.append("</gameRound>\n");
        stringBuffer.append("<CardsObject>");
        stringBuffer.append(t.C.cardSequence.toString());
        stringBuffer.append("</CardsObject>\n");
        stringBuffer.append("<ContinentObject>");
        stringBuffer.append(t.C.continentSequence.toString());
        stringBuffer.append("</ContinentObject>\n");
        stringBuffer.append("<turnPhase>");
        stringBuffer.append(t.J.c);
        stringBuffer.append("</turnPhase>\n");
        stringBuffer.append("<fluxArmies>");
        stringBuffer.append(t.O());
        stringBuffer.append("</fluxArmies>\n");
        stringBuffer.append("<tookOverACountry>");
        stringBuffer.append(t.J._());
        stringBuffer.append("</tookOverACountry>\n");
        stringBuffer.append("<userSelectedCountry>");
        stringBuffer.append(t.J.R);
        stringBuffer.append("</userSelectedCountry>\n");
        stringBuffer.append("<currentPlayer>");
        stringBuffer.append(t.J.E);
        stringBuffer.append("</currentPlayer>\n");
        if (t.J.c == 22) {
            stringBuffer.append("<userAttackedTo>");
            stringBuffer.append(t.J.Y);
            stringBuffer.append("</userAttackedTo>\n");
        }
        if (t.J.c == 3) {
            stringBuffer.append("<ma>");
            for (n = 0; n < t.J.e.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(t.J.e[n].getMoveableArmies());
            }
            stringBuffer.append("</ma>\n");
        }
        stringBuffer.append("</luxboard>\n");
        if (!string.endsWith(".luxsave")) {
            string = string + ".luxsave";
        }
        new File(BoardFile.savedGameDir()).mkdirs();
        File file = new File(BoardFile.savedGameDir() + string);
        N.A("Saving game to " + BoardFile.savedGameDir() + string);
        if (file.exists()) {
            file.delete();
        }
        try {
            object = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            ((PrintWriter)object).print(stringBuffer);
            ((PrintWriter)object).close();
        }
        catch (Throwable throwable) {
            System.out.println("Lux -> error in BoardFile.saveGame().");
            throwable.printStackTrace();
        }
    }

    public static String savedGameDir() {
        return E.A() + "SavedGames" + File.separator;
    }
}

