/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.B.X;
import com.sillysoft.lux.Country;
import java.util.ArrayList;

public class Card {
    int countryCode;
    int symbol;

    public Card(int n, int n2) {
        this.symbol = n2;
        this.countryCode = n2 == 3 ? -1 : n;
    }

    public Card(String string) {
        try {
            this.symbol = Integer.parseInt(X.A("symbol", string));
            this.countryCode = Integer.parseInt(X.A("country", string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getCode() {
        return this.countryCode;
    }

    public int getSymbol() {
        return this.symbol;
    }

    public static boolean isASet(Card card, Card card2, Card card3) {
        if (card == null || card2 == null || card3 == null) {
            return false;
        }
        int[] nArray = new int[4];
        int n = card.getSymbol();
        nArray[n] = nArray[n] + 1;
        int n2 = card2.getSymbol();
        nArray[n2] = nArray[n2] + 1;
        int n3 = card3.getSymbol();
        nArray[n3] = nArray[n3] + 1;
        if (nArray[0] + nArray[3] == 3 || nArray[1] + nArray[3] == 3 || nArray[2] + nArray[3] == 3) {
            return true;
        }
        return Math.min(nArray[0], 1) + Math.min(nArray[1], 1) + Math.min(nArray[2], 1) + nArray[3] > 2;
    }

    public static boolean containsASet(Card[] cardArray) {
        int n;
        if (cardArray == null || cardArray.length < 3) {
            return false;
        }
        int[] nArray = new int[4];
        for (n = 0; n < cardArray.length; ++n) {
            int n2 = cardArray[n].getSymbol();
            nArray[n2] = nArray[n2] + 1;
        }
        for (n = 0; n < 3; ++n) {
            if (nArray[n] + nArray[3] <= 2) continue;
            return true;
        }
        return Math.min(nArray[0], 1) + Math.min(nArray[1], 1) + Math.min(nArray[2], 1) + nArray[3] > 2;
    }

    public static Card[] getRandomSet(Card[] cardArray) {
        int n;
        Card[] cardArray2 = new Card[3];
        int[] nArray = new int[4];
        for (n = 0; n < cardArray.length; ++n) {
            int n2 = cardArray[n].getSymbol();
            nArray[n2] = nArray[n2] + 1;
        }
        for (n = 0; n < 3; ++n) {
            if (nArray[n] + nArray[3] <= 2) continue;
            int n3 = 0;
            for (int i = 0; n3 != 3 && i < cardArray.length; ++i) {
                if (cardArray[i].getSymbol() != n && cardArray[i].getSymbol() != 3) continue;
                cardArray2[n3] = cardArray[i];
                ++n3;
            }
            return cardArray2;
        }
        for (n = 0; n < cardArray.length; ++n) {
            if (cardArray2[0] == null && cardArray[n].getSymbol() == 0) {
                cardArray2[0] = cardArray[n];
                continue;
            }
            if (cardArray2[1] == null && cardArray[n].getSymbol() == 1) {
                cardArray2[1] = cardArray[n];
                continue;
            }
            if (cardArray2[2] == null && cardArray[n].getSymbol() == 2) {
                cardArray2[2] = cardArray[n];
                continue;
            }
            if (cardArray[n].getSymbol() != 3) continue;
            if (nArray[0] == 0 && cardArray2[0] == null) {
                cardArray2[0] = cardArray[n];
                continue;
            }
            if (nArray[1] == 0 && cardArray2[1] == null) {
                cardArray2[1] = cardArray[n];
                continue;
            }
            if (nArray[2] != 0 || cardArray2[2] != null) continue;
            cardArray2[2] = cardArray[n];
        }
        return cardArray2;
    }

    public static Card[] getBestSet(Card[] cardArray, int n, Country[] countryArray) {
        int n2;
        ArrayList<Card> arrayList = new ArrayList<Card>();
        ArrayList<Card> arrayList2 = new ArrayList<Card>();
        for (int i = 0; i < cardArray.length; ++i) {
            if (cardArray[i].getSymbol() != 3) {
                arrayList.add(cardArray[i]);
                continue;
            }
            arrayList2.add(cardArray[i]);
        }
        if (cardArray.length > arrayList.size()) {
            Card[] cardArray2 = new Card[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                cardArray2[i] = (Card)arrayList.get(i);
            }
            Card[] cardArray3 = Card.getBestSet(cardArray2, n, countryArray);
            if (cardArray3 != null) {
                return cardArray3;
            }
            if (cardArray.length > arrayList.size() + 1) {
                Card[] cardArray4 = new Card[arrayList.size() + 1];
                for (int i = 0; i < arrayList.size(); ++i) {
                    cardArray4[i] = (Card)arrayList.get(i);
                }
                cardArray4[cardArray4.length - 1] = (Card)arrayList2.get(0);
                Card[] cardArray5 = Card.getBestSet(cardArray4, n, countryArray);
                if (cardArray5 != null) {
                    return cardArray5;
                }
            }
        }
        int[] nArray = new int[cardArray.length];
        int n3 = 0;
        for (int i = 0; i < cardArray.length; ++i) {
            if (cardArray[i].getCode() == -1) {
                nArray[i] = -1;
                continue;
            }
            nArray[i] = countryArray[cardArray[i].getCode()].getOwner();
            if (nArray[i] != n) continue;
            ++n3;
        }
        Card[] cardArray6 = new Card[n3];
        int n4 = 0;
        for (int i = 0; i < cardArray.length; ++i) {
            if (nArray[i] != n) continue;
            cardArray6[n4] = cardArray[i];
            ++n4;
        }
        if (n3 > 2 && Card.containsASet(cardArray6)) {
            return Card.getRandomSet(cardArray6);
        }
        if (n3 > 1) {
            Card[] cardArray7 = new Card[n3 + 1];
            for (n2 = 0; n2 < n3; ++n2) {
                cardArray7[n2] = cardArray6[n2];
            }
            for (n2 = 0; n2 < cardArray.length; ++n2) {
                if (nArray[n2] == n) continue;
                cardArray7[n3] = cardArray[n2];
                if (!Card.containsASet(cardArray7)) continue;
                return Card.getRandomSet(cardArray7);
            }
        }
        if (n3 > 0) {
            Card[] cardArray8 = new Card[n3 + 2];
            for (n2 = 0; n2 < n3; ++n2) {
                cardArray8[n2] = cardArray6[n2];
            }
            for (n2 = 0; n2 < cardArray.length; ++n2) {
                for (int i = 0; i < cardArray.length; ++i) {
                    if (nArray[n2] == n || nArray[i] == n || n2 == i) continue;
                    cardArray8[n3] = cardArray[n2];
                    cardArray8[n3 + 1] = cardArray[i];
                    if (!Card.containsASet(cardArray8)) continue;
                    return Card.getRandomSet(cardArray8);
                }
            }
        }
        if (Card.containsASet(cardArray)) {
            return Card.getRandomSet(cardArray);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof Card) {
            Card card = (Card)object;
            return card.countryCode == this.countryCode && card.symbol == this.symbol;
        }
        return false;
    }

    public String toString() {
        return "<Card symbol=\"" + this.symbol + "\" country=\"" + this.countryCode + "\">";
    }
}

