/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.B.X;
import java.io.Serializable;

public class CardSequence
implements Serializable {
    static final long serialVersionUID = -95003076774053141L;
    public static String[] sequences = new String[]{"5, 5, 5...", "4, 4, 6, 6, 6, 8, 8, 8, 8, 10...", "4, 5, 6...", "4, 6, 8...", "3, 6, 9...", "4, 6, 8, 10, 15, 20...", "5, 10, 15...", "4, 6, 8, 10, 15, 20, 25, 10, 10, 10..."};
    private int cardSequence;
    private int nextCardSetValue;
    private boolean cardPeakReached;
    private int incCounter;

    public static int getIDFromString(String string) {
        if ("555".equals(string)) {
            return 0;
        }
        if ("44666888810".equals(string)) {
            return 1;
        }
        if ("456".equals(string)) {
            return 2;
        }
        if ("468".equals(string)) {
            return 3;
        }
        if ("369".equals(string)) {
            return 4;
        }
        if ("468101520".equals(string) || "4681015".equals(string)) {
            return 5;
        }
        if ("51015".equals(string)) {
            return 6;
        }
        if ("46810152025101010".equals(string)) {
            return 7;
        }
        return -1;
    }

    public CardSequence(int n) {
        this.cardSequence = n;
        this.reset();
    }

    void reset() {
        this.nextCardSetValue = -1;
        this.incCounter = 0;
        this.cardPeakReached = false;
        this.incrementCardSetValue();
    }

    int getNextCardSetValue() {
        return this.nextCardSetValue;
    }

    public void incrementCardSetValue() {
        if (this.cardSequence == 0) {
            this.nextCardSetValue = 5;
        } else if (this.cardSequence == 1) {
            if (this.nextCardSetValue == -1) {
                this.nextCardSetValue = 4;
            }
            if (this.nextCardSetValue == this.incCounter * 2) {
                this.nextCardSetValue += 2;
                this.incCounter = 0;
            }
            ++this.incCounter;
        } else if (this.cardSequence == 2) {
            this.nextCardSetValue = this.nextCardSetValue == -1 ? 4 : ++this.nextCardSetValue;
        } else if (this.cardSequence == 3) {
            this.nextCardSetValue = this.nextCardSetValue == -1 ? 4 : (this.nextCardSetValue += 2);
        } else if (this.cardSequence == 4) {
            this.nextCardSetValue = this.nextCardSetValue == -1 ? 3 : (this.nextCardSetValue += 3);
        } else if (this.cardSequence == 5) {
            this.nextCardSetValue = this.nextCardSetValue == -1 ? 4 : (this.nextCardSetValue < 10 ? (this.nextCardSetValue += 2) : (this.nextCardSetValue += 5));
        } else if (this.cardSequence == 6) {
            this.nextCardSetValue = this.nextCardSetValue == -1 ? 5 : (this.nextCardSetValue += 5);
        } else if (this.cardSequence == 7) {
            this.nextCardSetValue = this.cardPeakReached ? 10 : (this.nextCardSetValue == -1 ? 4 : (this.nextCardSetValue < 10 ? (this.nextCardSetValue += 2) : (this.nextCardSetValue += 5)));
            if (this.nextCardSetValue > 24) {
                this.cardPeakReached = true;
            }
        } else {
            System.out.println("ERROR in CardSequence.incrementCardSetValue() -> no such cardSequence. using 5,5,5...     23111002");
            this.nextCardSetValue = 5;
        }
    }

    public CardSequence copy() {
        CardSequence cardSequence = new CardSequence(this.cardSequence);
        cardSequence.cardSequence = this.cardSequence;
        cardSequence.nextCardSetValue = this.nextCardSetValue;
        cardSequence.cardPeakReached = this.cardPeakReached;
        cardSequence.incCounter = this.incCounter;
        return cardSequence;
    }

    public String toString() {
        return "<CardSequence code=\"" + this.cardSequence + "\" nextValue=\"" + this.nextCardSetValue + "\" counter=\"" + this.incCounter + "\" peaked=\"" + this.cardPeakReached + "\">";
    }

    public CardSequence(String string) {
        try {
            this.cardSequence = Integer.parseInt(X.A("code", string));
            this.nextCardSetValue = Integer.parseInt(X.A("nextValue", string));
            this.cardPeakReached = Boolean.valueOf(X.A("peaked", string));
            this.incCounter = Integer.parseInt(X.A("counter", string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

