/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.B.I;
import com.sillysoft.B.X;
import java.io.Serializable;

public class ContinentSequence
implements Serializable {
    static final long serialVersionUID = -2076095180466024606L;
    public static String[] sequences = new String[]{I.B("notatall"), I.B("beforeContinentIncrease") + " 5% " + I.B("afterContinentIncrease"), I.B("beforeContinentIncrease") + " 10% " + I.B("afterContinentIncrease"), I.B("beforeContinentIncrease") + " 15% " + I.B("afterContinentIncrease"), I.B("beforeContinentIncrease") + " 20% " + I.B("afterContinentIncrease"), I.B("beforeContinentIncrease") + " 30% " + I.B("afterContinentIncrease"), I.B("beforeContinentIncrease") + " 40% " + I.B("afterContinentIncrease"), I.B("beforeContinentIncrease") + " 50% " + I.B("afterContinentIncrease")};
    public static String[] shortString = new String[]{"--", "5%", "10%", "15%", "20%", "30%", "40%", "50%"};
    public static int[] intIncrease = new int[]{0, 5, 10, 15, 20, 30, 40, 50};
    private int continentSequence;
    private float currentMultiplier;

    public static int getIDFromString(String string) {
        if ("0".equals(string)) {
            return 0;
        }
        if ("5".equals(string)) {
            return 1;
        }
        if ("10".equals(string)) {
            return 2;
        }
        if ("15".equals(string)) {
            return 3;
        }
        if ("20".equals(string)) {
            return 4;
        }
        if ("30".equals(string)) {
            return 5;
        }
        if ("40".equals(string)) {
            return 6;
        }
        if ("50".equals(string)) {
            return 7;
        }
        return -1;
    }

    public ContinentSequence(int n) {
        this.continentSequence = n;
        this.currentMultiplier = 1.0f;
    }

    private float getSingleRoundIncrease() {
        switch (this.continentSequence) {
            case 0: {
                return 1.0f;
            }
            case 1: {
                return 1.05f;
            }
            case 2: {
                return 1.1f;
            }
            case 3: {
                return 1.15f;
            }
            case 4: {
                return 1.2f;
            }
            case 5: {
                return 1.3f;
            }
            case 6: {
                return 1.4f;
            }
            case 7: {
                return 1.5f;
            }
        }
        System.out.println("ContinentSequence UNKNOWN SEQUENCE CODE: " + this.continentSequence);
        return 1.0f;
    }

    public int[] increment(int[] nArray) {
        if (this.continentSequence == 0) {
            return nArray;
        }
        this.currentMultiplier *= this.getSingleRoundIncrease();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i] >= 0 ? (int)Math.floor((float)nArray[i] * this.currentMultiplier) : (int)Math.ceil((float)nArray[i] * this.currentMultiplier);
        }
        return nArray2;
    }

    public int[] refreshValues(int[] nArray) {
        if (this.continentSequence == 0) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = (int)Math.floor((float)nArray[i] * this.currentMultiplier);
        }
        return nArray2;
    }

    public ContinentSequence copy() {
        ContinentSequence continentSequence = new ContinentSequence(this.continentSequence);
        continentSequence.currentMultiplier = this.currentMultiplier;
        return continentSequence;
    }

    public String shortString() {
        return shortString[this.continentSequence];
    }

    public String longString() {
        return sequences[this.continentSequence];
    }

    public int intIncrease() {
        return intIncrease[this.continentSequence];
    }

    public boolean increases() {
        return this.continentSequence > 0;
    }

    public float getCurrentMultiplier() {
        return this.currentMultiplier;
    }

    public String toString() {
        return "<ContinentSequence code=\"" + this.continentSequence + "\" multiplier=\"" + this.currentMultiplier + "\">";
    }

    public ContinentSequence(String string) {
        try {
            this.continentSequence = Integer.parseInt(X.A("code", string));
            this.currentMultiplier = Float.parseFloat(X.A("multiplier", string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

