/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.E;
import com.sillysoft.lux.O;

public class Country {
    private int countryCode;
    private int continentCode;
    private int ownerCode;
    private int armies;
    private int moveableArmies;
    private Country[] adjoiningCountriesList;
    private String name;
    private Object owner;
    private E viewManager;

    public Country(int n, int n2, Object object) {
        this.owner = object;
        this.countryCode = n;
        this.continentCode = n2;
        this.ownerCode = -1;
        this.armies = 1;
        this.moveableArmies = 0;
        this.viewManager = null;
        this.adjoiningCountriesList = null;
    }

    public void setViewManager(O o) {
        this.viewManager = o;
    }

    public int getCode() {
        return this.countryCode;
    }

    public int getOwner() {
        return this.ownerCode;
    }

    public int getContinent() {
        return this.continentCode;
    }

    public void setContinentCode(int n, Object object) {
        if (object == this.owner) {
            this.continentCode = n;
        }
    }

    public void setOwner(int n, Object object) {
        if (object == this.owner) {
            this.ownerCode = n;
            if (this.viewManager != null) {
                this.viewManager.B(this.countryCode, this.ownerCode);
            }
        }
    }

    public int getArmies() {
        return this.armies;
    }

    public void setArmies(int n, Object object) {
        if (object == this.owner) {
            if (n < 0) {
                Thread.dumpStack();
                System.out.println("Lux ERROR in Country -> cannot have negative amount of armies. Set the country to have 1 army. 547785");
                n = 1;
            }
            this.armies = n;
            if (this.viewManager != null) {
                this.viewManager.A(this.countryCode, this.armies);
            }
        }
    }

    public void addArmy(Object object) {
        if (object == this.owner) {
            ++this.armies;
            if (this.viewManager != null) {
                this.viewManager.A(this.countryCode, this.armies);
            }
        }
    }

    public int getMoveableArmies() {
        return this.moveableArmies;
    }

    public void setMoveableArmies(int n, Object object) {
        if (object == this.owner) {
            this.moveableArmies = n;
        }
    }

    public void copyMoveableArmies(Object object) {
        if (object == this.owner) {
            this.moveableArmies = this.armies;
        }
    }

    public Country[] getAdjoiningList() {
        return this.adjoiningCountriesList;
    }

    public int[] getAdjoiningCodeList() {
        int[] nArray = new int[this.adjoiningCountriesList.length];
        boolean bl = false;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            nArray[i] = this.adjoiningCountriesList[i].countryCode;
        }
        return nArray;
    }

    public void clearAdjoiningList(Object object) {
        if (object == this.owner) {
            this.adjoiningCountriesList = null;
        }
    }

    public void addToAdjoiningList(Country country, Object object) {
        if (object != this.owner) {
            return;
        }
        if (country.countryCode == this.countryCode) {
            return;
        }
        if (this.adjoiningCountriesList == null) {
            this.adjoiningCountriesList = new Country[1];
            this.adjoiningCountriesList[0] = country;
            return;
        }
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].countryCode != country.countryCode) continue;
            return;
        }
        Country[] countryArray = new Country[this.adjoiningCountriesList.length + 1];
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            countryArray[i] = this.adjoiningCountriesList[i];
        }
        countryArray[this.adjoiningCountriesList.length] = country;
        this.adjoiningCountriesList = countryArray;
    }

    public void addToAdjoiningListBoth(Country country, Object object) {
        this.addToAdjoiningList(country, object);
        country.addToAdjoiningList(this, object);
    }

    public void ensureAdjoiningList(Object object) throws Exception {
        if (object != this.owner) {
            return;
        }
        if (this.adjoiningCountriesList == null) {
            throw new Exception("Country named '" + this.name + "' (ID: " + this.countryCode + ") does not connect to any other countries.");
        }
    }

    public boolean canGoto(Country country) {
        return this.canGoto(country.countryCode);
    }

    public boolean canGoto(int n) {
        if (this.adjoiningCountriesList == null) {
            return false;
        }
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].countryCode != n) continue;
            return true;
        }
        return false;
    }

    public boolean isNextTo(Country country) {
        return this.isNextTo(country.countryCode);
    }

    public boolean isNextTo(int n) {
        System.out.println("ERROR the method Country->isNextTo() is depreciated. Please use Country->canGoto() instead");
        if (this.adjoiningCountriesList == null) {
            return false;
        }
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].countryCode != n) continue;
            return true;
        }
        return false;
    }

    public Country getWeakestEnemyNeighbor() {
        int n = 1000000;
        Country country = null;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode == this.ownerCode || this.adjoiningCountriesList[i].armies >= n) continue;
            country = this.adjoiningCountriesList[i];
            n = country.armies;
        }
        return country;
    }

    public Country getStrongestNeighborOwnedBy(int n) {
        int n2 = -1;
        Country country = null;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode != n || this.adjoiningCountriesList[i].armies <= n2) continue;
            country = this.adjoiningCountriesList[i];
            n2 = country.armies;
        }
        return country;
    }

    public Country getWeakestEnemyNeighborInContinent(int n) {
        int n2 = 1000000;
        Country country = null;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode == this.ownerCode || this.adjoiningCountriesList[i].armies >= n2 || this.adjoiningCountriesList[i].continentCode != n) continue;
            country = this.adjoiningCountriesList[i];
            n2 = country.armies;
        }
        return country;
    }

    public int getNumberNeighbors() {
        return this.adjoiningCountriesList.length;
    }

    public int getNumberEnemyNeighbors() {
        int n = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode == this.ownerCode) continue;
            ++n;
        }
        return n;
    }

    public int getNumberPlayerNeighbors(int n) {
        int n2 = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getNumberNotPlayerNeighbors(int n) {
        int n2 = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode == n) continue;
            ++n2;
        }
        return n2;
    }

    public int getNumberPlayerNotNamedNeighbors(String string, Board board) {
        int n = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (board.getAgentName(this.adjoiningCountriesList[i].getOwner()).equals(string)) continue;
            ++n;
        }
        return n;
    }

    public String getName() {
        if (this.name == null) {
            return "no-name-" + this.countryCode;
        }
        return this.name;
    }

    public void setName(String string, Object object) {
        if (object == this.owner) {
            this.name = string;
        }
    }

    public String toString() {
        return "<Country name:" + this.getName() + " code:" + this.countryCode + " continent:" + this.continentCode + " owner:" + this.ownerCode + " armies:" + this.armies + ">";
    }

    public int[] getFriendlyAdjoiningCodeList() {
        int[] nArray = new int[this.getNumberPlayerNeighbors(this.ownerCode)];
        int n = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode != this.ownerCode) continue;
            nArray[n] = this.adjoiningCountriesList[i].getCode();
            ++n;
        }
        return nArray;
    }

    public int[] getHostileAdjoiningCodeList() {
        int[] nArray = new int[this.getNumberNotPlayerNeighbors(this.ownerCode)];
        int n = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode == this.ownerCode) continue;
            nArray[n] = this.adjoiningCountriesList[i].getCode();
            ++n;
        }
        return nArray;
    }
}

