/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.B.E;
import com.sillysoft.B.K;
import com.sillysoft.B.N;
import com.sillysoft.B.Q;
import com.sillysoft.lux.BoardFile;
import com.sillysoft.lux.CardSequence;
import com.sillysoft.lux.ContinentSequence;
import com.sillysoft.lux.I;
import com.sillysoft.lux.gui.f;
import java.io.File;
import java.io.Serializable;
import java.util.Random;

public class LuxOptions
implements Serializable {
    static final long serialVersionUID = -6252907239237927233L;
    public String[] playerTypes;
    public String[] playerNames;
    public boolean[] guiControl;
    public String[] colorPassString;
    public int width;
    public int height;
    public boolean customBoard;
    public String boardSize;
    public int boardNumber;
    public BoardFile boardFile;
    private String boardName;
    public boolean useScenario;
    public boolean initialCountries;
    public int initialArmies;
    public boolean allowNetworkPlayers;
    public boolean internetPublic;
    public boolean useCards;
    public boolean cardTransfer;
    public int cardSequenceCode;
    public boolean immediateCardCash;
    public CardSequence cardSequence;
    public ContinentSequence continentSequence;
    public boolean useTurnTimer;
    public float turnTimerLength;
    public long gameStarted;
    public long gameEnded;
    public String boardTitle;
    public boolean isRanked;
    public boolean warFog;
    public int[] playerTeam;
    public boolean savedGame;

    public LuxOptions(String string) {
        this(null, null, null, null, false, false);
        this.boardName = string;
    }

    public LuxOptions(String[] stringArray, String[] stringArray2, String[] stringArray3, boolean[] blArray, boolean bl, boolean bl2) {
        this.guiControl = blArray;
        this.playerTypes = stringArray;
        this.playerNames = stringArray2;
        this.colorPassString = stringArray3;
        this.loadInfo();
        if (bl) {
            this.allowNetworkPlayers = true;
        }
        if (bl2) {
            this.internetPublic = true;
        } else if (bl) {
            this.internetPublic = false;
        }
        this.cardSequence = new CardSequence(this.cardSequenceCode);
        this.continentSequence = new ContinentSequence(Q.B("continentSequenceCode", 1));
        this.gameStarted = System.currentTimeMillis();
        this.isRanked = Q.A("isRanked", true);
    }

    public void takeValues(String[] stringArray, String[] stringArray2, String[] stringArray3, boolean[] blArray, String string) {
        System.out.println("takeValues() playerTypes size=" + stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
        this.guiControl = blArray;
        this.playerTypes = stringArray;
        this.playerNames = stringArray2;
        this.colorPassString = stringArray3;
        this.boardName = string;
    }

    private void loadInfo() {
        this.useCards = Q.A("useCards", true);
        this.cardSequenceCode = Q.B("cardSequence", 2);
        this.cardTransfer = Q.A("cardTransfer", true);
        this.immediateCardCash = Q.A("immediateCardCash", true);
        this.useTurnTimer = Q.A("turnTimer", false);
        this.turnTimerLength = Q.B("turnTimerSeconds", 120);
        f f2 = f.I();
        this.initialArmies = f2.L();
        this.initialCountries = f2.S();
        this.useScenario = f2.u();
        this.boardNumber = f2.Z();
        this.customBoard = f2.V();
        if (this.customBoard) {
            this.boardSize = "custom";
            this.boardName = f2._();
        } else {
            this.boardSize = f2.f();
        }
        this.allowNetworkPlayers = f2.a();
        this.internetPublic = this.allowNetworkPlayers && f2.X();
    }

    public String[] colorPass() {
        return this.colorPassString;
    }

    public void ensureSeed() {
        if (this.boardNumber != -1 || this.customBoard) {
            return;
        }
        this.boardNumber = I.A(this.boardSize);
    }

    public LuxOptions copyWithGuiControlFor(String string) {
        boolean[] blArray = new boolean[this.guiControl.length];
        for (int i = 0; i < this.guiControl.length; ++i) {
            blArray[i] = string.equals(this.playerNames[i]);
        }
        return new LuxOptions(this, blArray);
    }

    private LuxOptions(LuxOptions luxOptions, boolean[] blArray) {
        this.guiControl = blArray;
        this.playerTypes = luxOptions.playerTypes;
        this.playerNames = luxOptions.playerNames;
        this.boardSize = luxOptions.boardSize;
        this.initialCountries = luxOptions.initialCountries;
        this.useScenario = luxOptions.useScenario;
        this.initialArmies = luxOptions.initialArmies;
        this.boardNumber = luxOptions.boardNumber;
        this.colorPassString = luxOptions.colorPassString;
        this.useCards = luxOptions.useCards;
        this.cardSequenceCode = luxOptions.cardSequenceCode;
        this.cardTransfer = luxOptions.cardTransfer;
        this.immediateCardCash = luxOptions.immediateCardCash;
        this.allowNetworkPlayers = luxOptions.allowNetworkPlayers;
        this.internetPublic = luxOptions.internetPublic;
        this.width = luxOptions.width;
        this.height = luxOptions.height;
        this.customBoard = luxOptions.customBoard;
        this.boardName = luxOptions.boardName;
        this.boardFile = luxOptions.boardFile;
        this.useTurnTimer = luxOptions.useTurnTimer;
        this.turnTimerLength = luxOptions.turnTimerLength;
        this.cardSequence = luxOptions.cardSequence.copy();
        this.isRanked = luxOptions.isRanked;
        this.continentSequence = luxOptions.continentSequence.copy();
        this.warFog = luxOptions.warFog;
    }

    public LuxOptions ensureProperOrder() {
        if (Q.A("randomStartingPlayer", true)) {
            this.randomizePlayers();
        }
        return this;
    }

    private void randomizePlayers() {
        int n = 3 * this.playerTypes.length;
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            int n2 = random.nextInt(this.playerTypes.length);
            String string = this.playerTypes[n2];
            this.playerTypes[n2] = this.playerTypes[0];
            this.playerTypes[0] = string;
            string = this.playerNames[n2];
            this.playerNames[n2] = this.playerNames[0];
            this.playerNames[0] = string;
            string = this.colorPassString[n2];
            this.colorPassString[n2] = this.colorPassString[0];
            this.colorPassString[0] = string;
            boolean bl = this.guiControl[n2];
            this.guiControl[n2] = this.guiControl[0];
            this.guiControl[0] = bl;
        }
    }

    public int getNextAIIndex() {
        for (int i = 0; i < this.playerNames.length; ++i) {
            if (this.playerTypes[i].equals("Human")) continue;
            return i;
        }
        return -1;
    }

    public String boardName() {
        if (this.customBoard || this.savedGame) {
            return this.boardName;
        }
        this.ensureSeed();
        return this.boardSize + " ID#" + this.boardNumber;
    }

    public String boardTitle() {
        if (this.boardTitle == null) {
            return this.boardName();
        }
        return this.boardTitle;
    }

    public void setBoardTitle(String string) {
        this.boardTitle = string;
    }

    public void ensureBoardFile() throws Exception {
        if (this.boardFile != null) {
            return;
        }
        this.ensureSeed();
        this.boardFile = this.customBoard ? new BoardFile(this.boardName, true) : new BoardFile(this.boardSize, this.boardNumber);
    }

    public void deleteRandomBoardFile() {
        if (!this.customBoard) {
            try {
                new File(E.A() + "Boards" + File.separator + "Random" + File.separator + this.boardSize + this.boardNumber + ".luxb").delete();
            }
            catch (Throwable throwable) {
                System.out.println("Lux -> Error deleting the boardFile: " + throwable);
            }
        }
    }

    public String toString() {
        return super.toString() + ": " + "\n\t playerTypes=" + this.playerTypes + ",\n\t playerNames=" + this.playerNames + ",\n\t guiControl=" + this.guiControl + ",\n\t continentSequence=" + this.continentSequence + ",\n\t colorPassString=" + this.colorPassString + ",\n\t boardFile=" + this.boardFile + ",\n\t width=" + this.width + ",\n\t height=" + this.height + ",\n\t allowNetworkPlayers=" + this.allowNetworkPlayers + ",\n\t internetPublic=" + this.internetPublic + ",\n\t customBoard=" + this.customBoard + ",\n\t boardName=" + this.boardName + ",\n\t boardSize=" + this.boardSize + ",\n\t boardNumber=" + this.boardNumber + ",\n\t useScenario=" + this.useScenario + ",\n\t initialCountries=" + this.initialCountries + ",\n\t initialArmies=" + this.initialArmies + ",\n\t useCards=" + this.useCards + ",\n\t cardTransfer=" + this.cardTransfer + ",\n\t cardSequenceCode=" + this.cardSequenceCode + ",\n\t immediateCardCash=" + this.immediateCardCash + ",\n\t isRanked=" + this.isRanked + ",\n\t useTurnTimer=" + this.useTurnTimer + ",\n\t turnTimerLength=" + this.turnTimerLength;
    }

    public boolean shortContinentLabels() {
        return this.boardFile.shortContinentLabels();
    }

    public void setEndTime() {
        this.gameEnded = System.currentTimeMillis();
    }

    public LuxOptions() {
        int n = 4;
        this.guiControl = new boolean[]{true, false, false, false};
        this.playerTypes = new String[]{"Human", "Killbot", "Killbot", "Killbot"};
        this.playerNames = new String[]{"dustin", "bot1", "bot2", "bot3"};
        this.colorPassString = new String[]{"0/0/0", "0/1/0", "0/0/1", "1/0/0"};
        this.cardSequence = new CardSequence(1);
        this.continentSequence = new ContinentSequence(1);
        this.gameStarted = System.currentTimeMillis();
        this.isRanked = false;
        this.useCards = true;
        this.cardSequenceCode = 2;
        this.cardTransfer = true;
        this.immediateCardCash = true;
        this.useTurnTimer = false;
        this.turnTimerLength = 120.0f;
        this.initialArmies = 0;
        this.initialCountries = true;
        this.useScenario = false;
        this.boardNumber = -1;
        this.customBoard = true;
        this.boardSize = "custom";
        this.boardName = "Classic Risk";
        this.allowNetworkPlayers = false;
        this.internetPublic = false;
    }

    public void addPlayer(String string, String string2) {
        N.A("addPlayer to LuxOptions");
        boolean[] blArray = new boolean[this.guiControl.length + 1];
        String[] stringArray = new String[this.guiControl.length + 1];
        String[] stringArray2 = new String[this.guiControl.length + 1];
        String[] stringArray3 = new String[this.guiControl.length + 1];
        System.arraycopy(this.guiControl, 0, blArray, 0, this.guiControl.length);
        System.arraycopy(this.playerNames, 0, stringArray, 0, this.guiControl.length);
        System.arraycopy(this.playerTypes, 0, stringArray2, 0, this.guiControl.length);
        System.arraycopy(this.colorPassString, 0, stringArray3, 0, this.guiControl.length);
        blArray[this.guiControl.length] = false;
        stringArray[this.guiControl.length] = string;
        stringArray2[this.guiControl.length] = string2;
        stringArray3[this.guiControl.length] = K.C(K.C());
        this.guiControl = blArray;
        this.playerTypes = stringArray2;
        this.playerNames = stringArray;
        this.colorPassString = stringArray3;
    }
}

