/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.LuxAgent;
import com.sillysoft.lux.util.ArmiesIterator;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.PlayerIterator;
import java.util.List;
import java.util.Random;

public class Angry
implements LuxAgent {
    protected int ID;
    protected Board board;
    protected Country[] countries;
    protected Random rand = new Random();

    public void setPrefs(int n, Board board) {
        this.ID = n;
        this.board = board;
        this.countries = this.board.getCountries();
    }

    public String name() {
        return "Angry";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Angry is an AI that likes to attack.";
    }

    public int pickCountry() {
        int n = BoardHelper.getSmallestPositiveEmptyCont(this.countries, this.board);
        if (n == -1) {
            n = BoardHelper.getSmallestPositiveOpenCont(this.countries, this.board);
        }
        return this.pickCountryInContinent(n);
    }

    protected int pickCountryInContinent(int n) {
        ContinentIterator continentIterator = new ContinentIterator(n, this.countries);
        while (continentIterator.hasNext()) {
            Country country = continentIterator.next();
            if (country.getOwner() != -1 || country.getNumberPlayerNeighbors(this.ID) <= 0) continue;
            return country.getCode();
        }
        continentIterator = new ContinentIterator(n, this.countries);
        int n2 = -1;
        int n3 = 1000000;
        while (continentIterator.hasNext()) {
            Country country = continentIterator.next();
            if (country.getOwner() != -1 || country.getNumberNeighbors() >= n3) continue;
            n2 = country.getCode();
            n3 = country.getNumberNeighbors();
        }
        if (n2 == -1) {
            System.out.println("ERROR in Angry.pickCountryInContinent() -> there are no open countries");
        }
        return n2;
    }

    public void placeInitialArmies(int n) {
        this.placeArmies(n);
    }

    public void cardsPhase(Card[] cardArray) {
    }

    public void placeArmies(int n) {
        int n2 = -1;
        Country country = null;
        int n3 = 0;
        Object var5_5 = null;
        PlayerIterator playerIterator = new PlayerIterator(this.ID, this.countries);
        while (playerIterator.hasNext()) {
            Country country2 = playerIterator.next();
            n3 = country2.getNumberEnemyNeighbors();
            if (n3 <= n2) continue;
            n2 = n3;
            country = country2;
        }
        this.board.placeArmies(n, country);
    }

    public void attackPhase() {
        boolean bl = true;
        while (bl) {
            bl = false;
            ArmiesIterator armiesIterator = new ArmiesIterator(this.ID, 2, this.countries);
            while (armiesIterator.hasNext()) {
                Country country = armiesIterator.next();
                Country country2 = country.getWeakestEnemyNeighbor();
                if (country2 == null || country.getArmies() <= country2.getArmies()) continue;
                this.board.attack(country, country2, true);
                bl = true;
            }
        }
    }

    public int moveArmiesIn(int n, int n2) {
        int n3;
        int n4 = this.countries[n].getNumberEnemyNeighbors();
        if (n4 > (n3 = this.countries[n2].getNumberEnemyNeighbors())) {
            return 0;
        }
        return this.countries[n].getArmies() - 1;
    }

    public void fortifyPhase() {
        for (int i = 0; i < this.board.getNumberOfCountries(); ++i) {
            int n;
            if (this.countries[i].getOwner() != this.ID || this.countries[i].getMoveableArmies() <= 0) continue;
            Country[] countryArray = this.countries[i].getAdjoiningList();
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            for (n = 0; n < countryArray.length; ++n) {
                if (countryArray[n].getOwner() != this.ID || (n4 = countryArray[n].getNumberEnemyNeighbors()) <= n3) continue;
                n2 = countryArray[n].getCode();
                n3 = n4;
            }
            n4 = this.countries[i].getNumberEnemyNeighbors();
            if (n3 > n4) {
                this.board.fortifyArmies(this.countries[i].getMoveableArmies(), i, n2);
                continue;
            }
            if (n4 != 0) continue;
            n = this.rand.nextInt(countryArray.length);
            this.board.fortifyArmies(this.countries[i].getMoveableArmies(), i, countryArray[n].getCode());
        }
    }

    public String youWon() {
        String[] stringArray = new String[]{"Muh-Ha-Ha-Ha\nAngry now very happy!", "Your skull is squishy and mellon-like", "ME STILL ANGRY!!!"};
        return stringArray[this.rand.nextInt(stringArray.length)];
    }

    public String message(String string, Object object) {
        if ("youLose".equals(string)) {
            int n = (Integer)object;
        } else if ("attackNotice".equals(string)) {
            List list = (List)object;
            int n = (Integer)list.get(0);
            int n2 = (Integer)list.get(1);
        } else if ("chat".equals(string)) {
            List list = (List)object;
            String string2 = (String)list.get(0);
            String string3 = (String)list.get(1);
        } else if ("emote".equals(string)) {
            List list = (List)object;
            String string4 = (String)list.get(0);
            String string5 = (String)list.get(1);
        }
        return null;
    }
}

