/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.SmartAgentBase;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.CountryCluster;
import com.sillysoft.lux.util.CountryClusterSet;
import com.sillysoft.lux.util.CountryRoute;
import com.sillysoft.lux.util.NeighborIterator;
import java.util.ArrayList;

public class BetterPixie
extends SmartAgentBase {
    float outnumberBy = 1.0f;
    protected int borderForce = 20;
    boolean[] ourConts;

    public String name() {
        return "BetterPixie";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "BetterPixie is a lovable little sprite. She enjoys kicking your ass.";
    }

    public void cardsPhase(Card[] cardArray) {
        super.cardsPhase(cardArray);
        this.cashCardsIfPossible(cardArray);
    }

    public int pickCountry() {
        if (this.goalCont == -1) {
            this.setGoalToLeastBordersCont();
        }
        return this.pickCountryInContinent(this.goalCont);
    }

    boolean placeHogWild(int n) {
        return false;
    }

    boolean setupOurConts(int n) {
        int n2;
        int n3;
        if (this.ourConts == null) {
            this.ourConts = new boolean[this.numContinents];
        }
        int[] nArray = new int[this.numContinents];
        int n4 = 0;
        while (n4 < this.numContinents) {
            nArray[n4] = BoardHelper.getEnemyArmiesInContinent(this.ID, n4, this.countries);
            int n5 = n4;
            nArray[n5] = (int)((double)nArray[n5] * 1.3);
            n3 = BoardHelper.getPlayerArmiesInContinent(this.ID, n4, this.countries) + BoardHelper.getPlayerArmiesAdjoiningContinent(this.ID, n4, this.countries);
            CountryRoute countryRoute = new CountryRoute(BoardHelper.cheapestRouteFromOwnerToCont(this.ID, n4, this.countries), this.countries);
            n2 = countryRoute.start().getArmies() - (int)((double)countryRoute.costNotCountingPlayer(this.ID) * 1.2);
            int n6 = n4++;
            nArray[n6] = nArray[n6] - Math.max(n3, n2);
        }
        n4 = !BoardHelper.playerOwnsAnyPositiveContinent(this.ID, this.countries, this.board) ? 1 : 0;
        n3 = 1000000;
        int n7 = -1;
        n2 = 0;
        for (int i = 0; i < this.numContinents; ++i) {
            if (n4 != 0) {
                if (nArray[i] < n3 && this.board.getContinentBonus(i) > 0) {
                    n3 = nArray[i];
                    n7 = i;
                }
                this.ourConts[i] = false;
                continue;
            }
            if ((double)nArray[i] < (double)n / ((double)this.numContinents / 4.0) && this.board.getContinentBonus(i) > 0) {
                this.ourConts[i] = true;
                n2 = 1;
                continue;
            }
            this.ourConts[i] = false;
        }
        if (n4 != 0) {
            if (n7 == -1) {
                return false;
            }
            this.ourConts[n7] = true;
            return true;
        }
        return n2 != 0;
    }

    public void placeArmies(int n) {
        if (this.placeHogWild(n)) {
            return;
        }
        if (!this.setupOurConts(n)) {
            this.placeArmiesToTakeCont(n, this.getEasiestContToTake());
            return;
        }
        int n2 = 0;
        boolean bl = true;
        while (n2 < n && bl) {
            bl = false;
            for (int i = 0; i < this.numContinents; ++i) {
                if (!this.ourConts[i] || !this.continentNeedsHelp(i)) continue;
                this.debug("Placing an army to take continent " + this.board.getContinentName(i));
                this.placeArmiesToTakeCont(1, i);
                ++n2;
                bl = true;
            }
        }
        if (n2 < n) {
            this.placeRemainder(n - n2);
        }
    }

    protected void placeRemainder(int n) {
        this.placeNearEnemies(n, true);
    }

    protected void placeNearEnemies(int n, boolean bl) {
        int n2;
        ArrayList arrayList = new ArrayList();
        CountryClusterSet countryClusterSet = CountryClusterSet.getAllCountriesNotOwnedBy(this.ID, this.countries);
        if (bl) {
            countryClusterSet.orderWeakestFirst();
        }
        for (n2 = 0; n2 < countryClusterSet.size() && n > 0; ++n2) {
            CountryCluster countryCluster = countryClusterSet.getCluster(n2);
            Country country = countryCluster.getStrongestNeighborOwnedBy(this.ID);
            if (country == null) continue;
            int n3 = n / countryClusterSet.size();
            if (bl) {
                n3 = countryCluster.estimatedNumberOfArmiesNeededToConquer() - country.getArmies();
            }
            this.board.placeArmies(n3, country);
            n -= n3;
        }
        if (n > 0) {
            System.out.println("BetterPixie still has " + n + " left to place in a really bad manner");
            n2 = 0;
            while (n > 0) {
                if (this.countries[n2].getOwner() == this.ID && this.countries[n2].getNumberEnemyNeighbors() > 0) {
                    this.board.placeArmies(1, n2);
                    --n;
                }
                n2 = (n2 + 1) % this.numCountries;
            }
        }
    }

    boolean borderCountryNeedsHelp(Country country) {
        return country.getArmies() <= this.borderForce && !this.weOwnContsArround(country);
    }

    protected boolean continentNeedsHelp(int n) {
        if (!BoardHelper.playerOwnsContinent(this.ID, n, this.countries)) {
            return true;
        }
        int[] nArray = BoardHelper.getContinentBorders(n, this.countries);
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.borderCountryNeedsHelp(this.countries[nArray[i]])) continue;
            return true;
        }
        return false;
    }

    public void attackPhase() {
        int n;
        for (n = 0; n < this.numContinents; ++n) {
            if (!this.ourConts[n]) continue;
            this.attackInContinent(n);
        }
        for (n = 0; n < this.numContinents; ++n) {
            this.takeOutContinentCheck(n);
        }
        this.attackForCard();
        this.attackHogWild();
        this.attackStalemate();
    }

    protected void attackInContinent(int n) {
        int n2 = BoardHelper.getEnemyArmiesInContinent(this.ID, n, this.countries);
        n2 = (int)((double)n2 * 1.3);
        ContinentIterator continentIterator = new ContinentIterator(n, this.countries);
        while (continentIterator.hasNext()) {
            if (continentIterator.next().getOwner() == this.ID) continue;
            ++n2;
        }
        int n3 = BoardHelper.getPlayerArmiesInContinent(this.ID, n, this.countries);
        this.debug("Attacking in continent " + this.board.getContinentName(n) + ". friendlies = " + (n3 += BoardHelper.getPlayerArmiesAdjoiningContinent(this.ID, n, this.countries)) + ", enemies = " + n2);
        if (n2 > n3) {
            return;
        }
        boolean bl = true;
        while (bl) {
            Country[] countryArray;
            Country country;
            while (bl) {
                bl = false;
                continentIterator = new ContinentIterator(n, this.countries);
                while (continentIterator.hasNext()) {
                    country = continentIterator.next();
                    if (country.getOwner() != this.ID || this.getNumberOfEnemyNeighborsInOurConts(country) != 1 || country.getArmies() <= 1) continue;
                    countryArray = country.getAdjoiningList();
                    for (int i = 0; i < countryArray.length; ++i) {
                        if (countryArray[i].getOwner() == this.ID || !this.ourConts[countryArray[i].getContinent()] || !((float)country.getArmies() > (float)countryArray[i].getArmies() * this.outnumberBy)) continue;
                        this.board.attack(country, countryArray[i], true);
                        bl = true;
                    }
                }
            }
            continentIterator = new ContinentIterator(n, this.countries);
            while (continentIterator.hasNext()) {
                country = continentIterator.next();
                if (country.getOwner() == this.ID) continue;
                countryArray = new NeighborIterator(country);
                while (countryArray.hasNext()) {
                    Country country2 = countryArray.next();
                    if (country2.getOwner() != this.ID || !((float)country2.getArmies() > (float)country.getArmies() * this.outnumberBy) || country.getOwner() == this.ID || !country2.canGoto(country)) continue;
                    this.board.attack(country2, country, true);
                    bl = true;
                }
            }
        }
    }

    protected void takeOutContinentCheck(int n) {
        if (BoardHelper.anyPlayerOwnsContinent(n, this.countries) && this.board.getContinentBonus(n) > 0 && this.countries[BoardHelper.getCountryInContinent(n, this.countries)].getOwner() != this.ID) {
            this.debug("enemy owns continent " + n);
            int[] nArray = BoardHelper.getContinentBorders(n, this.countries);
            for (int i = 0; i < nArray.length; ++i) {
                Country[] countryArray = this.countries[nArray[i]].getAdjoiningList();
                for (int j = 0; j < countryArray.length; ++j) {
                    if (countryArray[j].getOwner() != this.ID || countryArray[j].getArmies() <= this.countries[nArray[i]].getArmies() * 2 || !countryArray[j].canGoto(this.countries[nArray[i]])) continue;
                    this.debug("attacking to take out continent " + n);
                    if (this.board.attack(countryArray[j], this.countries[nArray[i]], true) <= 0) continue;
                    return;
                }
            }
        }
    }

    protected int getNumberOfEnemyNeighborsInOurConts(Country country) {
        int n = 0;
        Country[] countryArray = country.getAdjoiningList();
        for (int i = 0; i < countryArray.length; ++i) {
            if (countryArray[i].getOwner() == this.ID || !this.ourConts[countryArray[i].getContinent()]) continue;
            ++n;
        }
        return n;
    }

    public int moveArmiesIn(int n, int n2) {
        int n3;
        int n4 = this.obviousMoveArmiesInTest(n, n2);
        if (n4 != -1) {
            return n4;
        }
        n4 = this.memoryMoveArmiesInTest(n, n2);
        if (n4 != -1) {
            return n4;
        }
        int n5 = this.countries[n].getNumberEnemyNeighbors();
        int n6 = this.countries[n2].getNumberEnemyNeighbors();
        if (n5 == 0 && n6 != 0) {
            return 1000000;
        }
        if (n5 != 0 && n6 == 0) {
            return 0;
        }
        if (n6 == 0) {
            return this.countries[n].getArmies() / 2;
        }
        ArrayList<Country> arrayList = new ArrayList<Country>();
        ArrayList<Country> arrayList2 = new ArrayList<Country>();
        n5 = 0;
        n6 = 0;
        Country[] countryArray = this.countries[n].getAdjoiningList();
        for (n3 = 0; n3 < countryArray.length; ++n3) {
            if (countryArray[n3].getOwner() == this.ID || !this.ourConts[countryArray[n3].getContinent()]) continue;
            arrayList.add(countryArray[n3]);
        }
        countryArray = this.countries[n2].getAdjoiningList();
        for (n3 = 0; n3 < countryArray.length; ++n3) {
            if (countryArray[n3].getOwner() == this.ID || !this.ourConts[countryArray[n3].getContinent()]) continue;
            arrayList2.add(countryArray[n3]);
        }
        if (arrayList.size() == 0 && arrayList2.size() != 0) {
            return 1000000;
        }
        if (arrayList.size() != 0 && arrayList2.size() == 0) {
            return 0;
        }
        if (arrayList.size() == 0) {
            return this.countries[n].getArmies() / 2;
        }
        ArrayList arrayList3 = new ArrayList(arrayList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (arrayList3.contains(arrayList2.get(i))) continue;
            arrayList3.add(arrayList2.get(i));
        }
        CountryClusterSet countryClusterSet = CountryClusterSet.getHostileCountries(this.ID, arrayList3);
        if (countryClusterSet.numberOfClusters() == 1) {
            return 1000000;
        }
        return this.countries[n].getArmies() / 2;
    }

    public void fortifyPhase() {
        for (int i = 0; i < this.numContinents; ++i) {
            if (BoardHelper.playerOwnsContinent(this.ID, i, this.countries)) {
                while (this.fortifyContinent(i)) {
                    this.debug("Fortifying continent " + this.board.getContinentName(i));
                }
                continue;
            }
            this.fortifyContinentScraps(i);
        }
    }

    protected boolean fortifyContinent(int n) {
        int n2;
        boolean bl = false;
        int[] nArray = BoardHelper.getContinentBorders(n, this.countries);
        ArrayList<Country> arrayList = new ArrayList<Country>();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            arrayList.add(this.countries[nArray[n2]]);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            NeighborIterator neighborIterator = new NeighborIterator((Country)arrayList.get(n2));
            while (neighborIterator.hasNext()) {
                Country country = neighborIterator.next();
                if (country.getOwner() != this.ID || arrayList.contains(country) || country.getContinent() != n || country.getMoveableArmies() <= 0) continue;
                this.debug(" -> fortify " + country.getMoveableArmies() + " armies from " + country + " to " + arrayList.get(n2));
                if (this.board.fortifyArmies(country.getMoveableArmies(), country, (Country)arrayList.get(n2)) == 1) {
                    bl = true;
                }
                arrayList.add(country);
            }
        }
        return bl;
    }

    protected void fortifyContinentScraps(int n) {
        ContinentIterator continentIterator = new ContinentIterator(n, this.countries);
        while (continentIterator.hasNext()) {
            Country country;
            Country country2 = continentIterator.next();
            if (country2.getOwner() != this.ID || country2.getMoveableArmies() <= 0) continue;
            int n2 = 1000000;
            Country country3 = null;
            NeighborIterator neighborIterator = new NeighborIterator(country2);
            while (neighborIterator.hasNext()) {
                Country country4;
                country = neighborIterator.next();
                if (country.getOwner() != this.ID || (country4 = country.getWeakestEnemyNeighbor()) == null || country4.getArmies() >= n2) continue;
                n2 = country.getWeakestEnemyNeighbor().getArmies();
                country3 = country;
            }
            country = country2.getWeakestEnemyNeighbor();
            if (country != null && n2 >= country.getArmies() || country3 == null) continue;
            this.board.fortifyArmies(country2.getMoveableArmies(), country2, country3);
        }
    }

    public String youWon() {
        String[] stringArray = new String[]{"Poof! I win"};
        return stringArray[this.rand.nextInt(stringArray.length)];
    }
}

