/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.SmartAgentBase;
import com.sillysoft.lux.util.ArmiesIterator;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.CountryIterator;
import com.sillysoft.lux.util.PlayerIterator;

public class Communist
extends SmartAgentBase {
    protected int expando;
    protected int expandTo;

    public String name() {
        return "Communist";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Communist is the worker's AI. All countries are equal. Knock them over like dominoes.";
    }

    public int pickCountry() {
        return this.pickCountryInSmallContinent();
    }

    public void placeArmies(int n) {
        int n2 = n;
        while (n2 > 0) {
            Object object;
            int n3 = 1000000;
            PlayerIterator playerIterator = new PlayerIterator(this.ID, this.countries);
            while (playerIterator.hasNext() && n2 > 0) {
                object = playerIterator.next();
                n3 = Math.min(n3, ((Country)object).getArmies());
            }
            object = new ArmiesIterator(this.ID, -n3, this.countries);
            while (((CountryIterator)object).hasNext()) {
                Country country = ((CountryIterator)object).next();
                this.board.placeArmies(1, country);
                --n2;
            }
        }
    }

    protected void setExpandos() {
        int n = 1000000;
        this.expando = -1;
        this.expandTo = -1;
        for (int i = 0; i < this.board.getNumberOfCountries(); ++i) {
            if (this.countries[i].getOwner() != this.ID) continue;
            Country[] countryArray = this.countries[i].getAdjoiningList();
            for (int j = 0; j < countryArray.length; ++j) {
                if (countryArray[j].getOwner() == this.ID || countryArray[j].getArmies() >= n || this.board.getAgentName(countryArray[j].getOwner()).equals(this.name()) && !this.communismWins()) continue;
                n = countryArray[j].getArmies();
                this.expando = i;
                this.expandTo = countryArray[j].getCode();
            }
        }
    }

    protected boolean communismWins() {
        for (int i = 0; i < this.board.getNumberOfPlayers(); ++i) {
            if (this.board.getAgentName(i).equals(this.name()) || !BoardHelper.playerIsStillInTheGame(i, this.countries)) continue;
            return false;
        }
        this.debug("communism has won!");
        return true;
    }

    public void attackPhase() {
        this.setExpandos();
        if (this.expando == -1) {
            return;
        }
        if (this.expandTo != -1 && this.countries[this.expando].getArmies() > this.countries[this.expandTo].getArmies()) {
            this.board.attack(this.expando, this.expandTo, true);
        }
        this.attackHogWild();
        this.attackStalemate();
    }

    public int moveArmiesIn(int n, int n2) {
        int n3 = this.countries[n].getArmies();
        return (n3 + 1) / 2;
    }

    public void fortifyPhase() {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < this.board.getNumberOfCountries(); ++i) {
                if (this.countries[i].getOwner() != this.ID || this.countries[i].getMoveableArmies() <= 0) continue;
                Country[] countryArray = this.countries[i].getAdjoiningList();
                for (int j = 0; j < countryArray.length && this.countries[i].getMoveableArmies() > 0; ++j) {
                    int n;
                    if (countryArray[j].getOwner() != this.ID || (n = this.countries[i].getArmies() - countryArray[j].getArmies()) <= 1) continue;
                    this.board.fortifyArmies(n / 2, i, countryArray[j].getCode());
                    bl = true;
                    this.debug("fort");
                }
            }
        }
    }

    public String youWon() {
        return "Welcome to the new world, Comrade.";
    }
}

