/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.Pixie;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.NeighborIterator;

public class EvilPixie
extends Pixie {
    public EvilPixie() {
        this.mustKillPlayer = -1;
        this.outnumberBy = 1.3f;
        this.borderForce = 7 + this.rand.nextInt(15);
    }

    public String name() {
        return "Evil Pixie";
    }

    public String description() {
        return "EvilPixie is Pixie's evil twin sister.";
    }

    public void cardsPhase(Card[] cardArray) {
        super.cardsPhase(cardArray);
        this.cashCardsIfPossible(cardArray);
    }

    public void placeArmies(int n) {
        if (this.placeArmiesToKillDominantPlayer(n)) {
            this.setupOurConts(0);
            return;
        }
        super.placeArmies(n);
    }

    protected void placeArmiesToTakeCont(int n, int n2) {
        if (BoardHelper.playerOwnsContinent(this.ID, n2, this.countries)) {
            int[] nArray = BoardHelper.getContinentBorders(n2, this.countries);
            for (int i = 0; i < n; ++i) {
                int n3 = 1000000;
                int n4 = -1;
                for (int j = 0; j < nArray.length; ++j) {
                    if (this.countries[nArray[j]].getArmies() >= n3 || !this.borderCountryNeedsHelp(this.countries[nArray[j]])) continue;
                    n3 = this.countries[nArray[j]].getArmies();
                    n4 = this.countries[nArray[j]].getCode();
                }
                this.board.placeArmies(1, n4);
            }
            return;
        }
        super.placeArmiesToTakeCont(n, n2);
    }

    boolean placeHogWild(int n) {
        if (!this.hogWildCheck()) {
            return false;
        }
        this.placeToOutnumberEnemies(n);
        return true;
    }

    void placeToOutnumberEnemies(int n) {
        int n2;
        boolean[] blArray = new boolean[this.countries.length];
        for (n2 = 0; n2 < this.countries.length; ++n2) {
            blArray[n2] = false;
        }
        for (n2 = 0; n2 < this.countries.length; ++n2) {
            if (this.countries[n2].getOwner() != this.ID) {
                Country[] countryArray = this.countries[n2].getAdjoiningList();
                for (int i = 0; i < countryArray.length; ++i) {
                    if (countryArray[i].getOwner() != this.ID || countryArray[i].getArmies() <= this.countries[n2].getArmies()) continue;
                    blArray[n2] = true;
                }
                continue;
            }
            blArray[n2] = true;
        }
        for (n2 = 0; n2 < this.countries.length && n > 0; ++n2) {
            int n3;
            if (blArray[n2]) continue;
            int n4 = 0;
            Country country = null;
            Country[] countryArray = this.countries[n2].getAdjoiningList();
            for (n3 = 0; n3 < countryArray.length; ++n3) {
                if (countryArray[n3].getOwner() != this.ID || countryArray[n3].getArmies() <= n4) continue;
                country = countryArray[n3];
            }
            if (country == null) continue;
            n3 = this.countries[n2].getArmies() - country.getArmies();
            n3 = Math.max(n3, 1);
            this.board.placeArmies(n3, country);
            n -= n3;
        }
        if (n > 0) {
            this.debug("placeToOutnumberEnemies didn't use up all the armies: " + n);
            this.placeNearEnemies(n);
        }
    }

    protected void placeRemainder(int n) {
        this.debug("placeRemainder: " + n);
        this.placeToOutnumberEnemies(n);
    }

    boolean borderCountryNeedsHelp(Country country) {
        return country.getArmies() <= this.borderForce && !this.weOwnContsArround(country);
    }

    public void attackPhase() {
        int n;
        if (this.mustKillPlayer != -1) {
            this.attackToKillPlayer(this.mustKillPlayer);
        }
        for (n = 0; n < this.numContinents; ++n) {
            if (this.ourConts[n]) {
                this.attackInContinent(n);
            }
            this.takeOutContinentCheck(n);
        }
        n = this.board.getNumberOfPlayers();
        for (int i = 0; i < n; ++i) {
            if (i == this.ID) continue;
            this.takeOutPlayerCheck(i);
        }
        this.attackForCard(5);
        this.attackHogWild();
        this.attackStalemate();
    }

    protected void takeOutContinentCheck(int n) {
        if (BoardHelper.anyPlayerOwnsContinent(n, this.countries) && this.countries[BoardHelper.getCountryInContinent(n, this.countries)].getOwner() != this.ID) {
            this.debug("enemy owns continent " + n);
            int[] nArray = BoardHelper.getContinentBorders(n, this.countries);
            for (int i = 0; i < nArray.length; ++i) {
                Country[] countryArray = this.countries[nArray[i]].getAdjoiningList();
                for (int j = 0; j < countryArray.length; ++j) {
                    if (countryArray[j].getOwner() != this.ID || countryArray[j].getArmies() <= this.countries[nArray[i]].getArmies() || !countryArray[j].canGoto(this.countries[nArray[i]])) continue;
                    this.debug("attacking to take out continent " + n);
                    if (this.board.attack(countryArray[j], this.countries[nArray[i]], true) <= 0) continue;
                    return;
                }
            }
        }
    }

    protected void takeOutPlayerCheck(int n) {
        if (BoardHelper.getPlayerArmies(this.ID, this.countries) > 5 * BoardHelper.getPlayerArmies(n, this.countries)) {
            this.debug("try to eliminate player " + n);
            for (int i = 0; i < this.countries.length; ++i) {
                if (this.countries[i].getOwner() != n) continue;
                Country[] countryArray = this.countries[i].getAdjoiningList();
                for (int j = 0; j < countryArray.length && this.countries[i].getOwner() == n; ++j) {
                    if (countryArray[j].getOwner() != this.ID || countryArray[j].getArmies() <= 1 || !countryArray[j].canGoto(i)) continue;
                    this.board.attack(countryArray[j], this.countries[i], true);
                }
            }
        }
    }

    protected void fortifyContinentScraps(int n) {
        ContinentIterator continentIterator = new ContinentIterator(n, this.countries);
        while (continentIterator.hasNext()) {
            Country country = continentIterator.next();
            NeighborIterator neighborIterator = new NeighborIterator(country);
            while (country.getOwner() == this.ID && country.getMoveableArmies() > 0 && neighborIterator.hasNext()) {
                Country country2 = neighborIterator.next();
                if (country2.getOwner() != this.ID || !BoardHelper.playerOwnsContinent(this.ID, country2.getContinent(), this.countries)) continue;
                this.debug("fortifying armies to aid continent " + n);
                this.board.fortifyArmies(country.getMoveableArmies(), country, country2);
            }
        }
        super.fortifyContinentScraps(n);
    }

    protected void fortifyContinent(int n) {
        super.fortifyContinent(n);
        int[] nArray = BoardHelper.getContinentBorders(n, this.countries);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                int n2;
                int n3;
                if (!this.countries[nArray[i]].canGoto(nArray[j]) || (n3 = Math.abs(this.countries[nArray[i]].getArmies() - this.countries[nArray[j]].getArmies()) / 2) == 0 || this.countries[nArray[i]].getArmies() <= this.countries[nArray[j]].getArmies() || (n2 = Math.min(this.countries[nArray[i]].getMoveableArmies(), (this.countries[nArray[i]].getArmies() - this.countries[nArray[j]].getArmies()) / 2)) <= 0) continue;
                this.board.fortifyArmies(n2, nArray[i], nArray[j]);
            }
        }
    }

    public String youWon() {
        String[] stringArray = new String[]{"You'd be evil too if you grew \nup in this wacko forest", "Always look on the dark side on life", "Vader ain't got nothin on me", "mmmm... Your spleen is so tasty", "Your failure is now complete", "My powers are unrivaled in this quadrant of space-time", "Time to go look for a new world to conquer", "She chose fashion, \nand I chose evil", "Your friends have failed you", "You rebel scum", "You can call me Pixie Worldwalker", "Join me, and together we can rule the universe!\n \n Oh wait, you're dead", "Fetch me the head of John Galt", "Now you shall dance for my entertainment", "You shall now become a part of my petting zoo", "Evil shall always prevail,\nbecause good is dumb", "All the best things come in evil packages"};
        return stringArray[this.rand.nextInt(stringArray.length)];
    }
}

