/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.Cluster;
import com.sillysoft.lux.util.ClusterBorderIterator;
import com.sillysoft.lux.util.NeighborIterator;
import java.util.ArrayList;

public class HumanFriendly
extends Cluster {
    public String name() {
        return "HumanFriendly";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "HumanFriendly likes is a radical bot. He likes Humans.";
    }

    protected void attackFromCluster(Country country) {
        if (country != null) {
            while (this.attackEasyExpand(country)) {
            }
            this.attackFillOut(country);
            while (this.attackEasyExpand(country)) {
            }
            while (this.attackConsolidate(country)) {
            }
            while (this.attackSplitUp(country, 1.2f)) {
            }
        }
    }

    protected boolean attackEasyExpand(Country country) {
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        boolean bl = false;
        while (clusterBorderIterator.hasNext()) {
            Country country2 = clusterBorderIterator.next();
            NeighborIterator neighborIterator = new NeighborIterator(country2);
            int n = 0;
            Country country3 = null;
            while (neighborIterator.hasNext()) {
                Country country4 = neighborIterator.next();
                if (this.board.getAgentName(country4.getOwner()).equals("Human")) continue;
                ++n;
                country3 = country4;
            }
            if (n != true || country2.getArmies() <= country3.getArmies()) continue;
            this.moveInMemory = 1000000;
            if (this.board.attack(country2, country3, true) > 0) {
                bl = true;
            }
            this.moveInMemory = -1;
        }
        return bl;
    }

    protected boolean attackFillOut(Country country) {
        boolean bl = false;
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        while (clusterBorderIterator.hasNext()) {
            Country country2 = clusterBorderIterator.next();
            NeighborIterator neighborIterator = new NeighborIterator(country2);
            while (neighborIterator.hasNext()) {
                Country country3 = neighborIterator.next();
                if (this.board.getAgentName(country3.getOwner()).equals("Human") || country3.getNumberPlayerNotNamedNeighbors("Human", this.board) != 0 || country3.getArmies() >= country2.getArmies()) continue;
                this.moveInMemory = 0;
                if (this.board.attack(country2, country3, true) == 7) {
                    bl = true;
                }
                this.moveInMemory = -1;
            }
        }
        return bl;
    }

    protected boolean attackConsolidate(Country country) {
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        boolean bl = false;
        while (clusterBorderIterator.hasNext()) {
            int n;
            Object object;
            Country country2 = clusterBorderIterator.next();
            NeighborIterator neighborIterator = new NeighborIterator(country2);
            int n2 = 0;
            Country country3 = null;
            while (neighborIterator.hasNext()) {
                object = neighborIterator.next();
                if (this.board.getAgentName(((Country)object).getOwner()).equals("Human")) continue;
                ++n2;
                country3 = object;
            }
            if (n2 != true || country3.getNumberPlayerNeighbors(this.ID) <= 1) continue;
            object = new ArrayList();
            NeighborIterator neighborIterator2 = new NeighborIterator(country3);
            while (neighborIterator2.hasNext()) {
                Country country4 = neighborIterator2.next();
                if (country4.getOwner() != this.ID || country4.getNumberPlayerNotNamedNeighbors("Human", this.board) != 1) continue;
                object.add(country4);
            }
            int n3 = 0;
            for (n = 0; n < object.size(); ++n) {
                n3 += ((Country)object.get(n)).getArmies();
            }
            if (n3 <= country3.getArmies()) continue;
            for (n = 0; n < object.size() && country3.getOwner() != this.ID; ++n) {
                if (((Country)object.get(n)).getArmies() <= 1) continue;
                this.moveInMemory = 1000000;
                if (this.board.attack((Country)object.get(n), country3, true) <= 0) continue;
                bl = true;
            }
            this.moveInMemory = -1;
        }
        return bl;
    }

    protected boolean attackSplitUp(Country country, float f2) {
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        boolean bl = false;
        while (clusterBorderIterator.hasNext()) {
            Country country2 = clusterBorderIterator.next();
            NeighborIterator neighborIterator = new NeighborIterator(country2);
            int n = 0;
            int n2 = 0;
            Country country3 = null;
            while (neighborIterator.hasNext()) {
                Country country4 = neighborIterator.next();
                if (this.board.getAgentName(country4.getOwner()).equals("Human")) continue;
                ++n;
                n2 += country4.getArmies();
                country3 = country4;
            }
            if (!((float)country2.getArmies() > (float)n2 * f2)) continue;
            int n3 = country2.getArmies() / Math.max(n, 1);
            neighborIterator = new NeighborIterator(country2);
            while (neighborIterator.hasNext() && country2.getArmies() > 1) {
                Country country5 = neighborIterator.next();
                if (this.board.getAgentName(country5.getOwner()).equals("Human")) continue;
                this.moveInMemory = n3;
                if (this.board.attack(country2, country5, true) > 0) {
                    bl = true;
                }
                this.moveInMemory = -1;
                bl = true;
            }
        }
        return bl;
    }
}

