/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.SmartAgentBase;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.NeighborIterator;
import java.util.ArrayList;

public class Pixie
extends SmartAgentBase {
    float outnumberBy = 1.0f;
    protected int borderForce = 20;
    boolean[] ourConts;

    public String name() {
        return "Pixie";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Pixie is a lovable little sprite. She enjoys kicking your ass.";
    }

    public int pickCountry() {
        if (this.goalCont == -1 || !BoardHelper.playerOwnsContinentCountry(-1, this.goalCont, this.countries)) {
            this.setGoalToLeastBordersCont();
        }
        return this.pickCountryInContinent(this.goalCont);
    }

    boolean placeHogWild(int n) {
        return false;
    }

    boolean setupOurConts(int n) {
        int n2;
        if (this.ourConts == null) {
            this.ourConts = new boolean[this.numContinents];
        }
        int[] nArray = new int[this.numContinents];
        for (n2 = 0; n2 < this.numContinents; ++n2) {
            nArray[n2] = BoardHelper.getEnemyArmiesInContinent(this.ID, n2, this.countries);
            int n3 = n2;
            nArray[n3] = nArray[n3] - BoardHelper.getPlayerArmiesInContinent(this.ID, n2, this.countries);
            int n4 = n2;
            nArray[n4] = nArray[n4] - BoardHelper.getPlayerArmiesAdjoiningContinent(this.ID, n2, this.countries);
        }
        n2 = 0;
        for (int i = 0; i < this.numContinents; ++i) {
            if ((double)nArray[i] < 1.0 / (double)this.numContinents * (double)n && this.board.getContinentBonus(i) > 0) {
                this.ourConts[i] = true;
                n2 = 1;
                continue;
            }
            this.ourConts[i] = false;
        }
        return n2 != 0;
    }

    public void placeArmies(int n) {
        if (this.placeHogWild(n)) {
            return;
        }
        if (!this.setupOurConts(n)) {
            this.placeArmiesToTakeCont(n, this.getEasiestContToTake());
            return;
        }
        int n2 = 0;
        boolean bl = true;
        while (n2 < n && bl) {
            bl = false;
            for (int i = 0; i < this.numContinents; ++i) {
                if (!this.ourConts[i] || !this.continentNeedsHelp(i)) continue;
                this.placeArmiesToTakeCont(1, i);
                ++n2;
                bl = true;
            }
        }
        this.placeRemainder(n - n2);
    }

    protected void placeRemainder(int n) {
        this.placeNearEnemies(n);
    }

    protected void placeNearEnemies(int n) {
        int n2 = 0;
        while (n > 0) {
            if (this.countries[n2].getOwner() == this.ID && this.countries[n2].getNumberEnemyNeighbors() > 0) {
                this.board.placeArmies(1, n2);
                --n;
            }
            n2 = (n2 + 1) % this.numCountries;
        }
    }

    protected boolean weOwnContsArround(Country country) {
        int n = country.getContinent();
        NeighborIterator neighborIterator = new NeighborIterator(country);
        while (neighborIterator.hasNext()) {
            Country country2 = neighborIterator.next();
            if (country2.getContinent() == n || BoardHelper.playerOwnsContinent(this.ID, country2.getContinent(), this.countries)) continue;
            return false;
        }
        return true;
    }

    boolean borderCountryNeedsHelp(Country country) {
        return country.getArmies() <= this.borderForce;
    }

    protected boolean continentNeedsHelp(int n) {
        if (!BoardHelper.playerOwnsContinent(this.ID, n, this.countries)) {
            return true;
        }
        int[] nArray = BoardHelper.getContinentBorders(n, this.countries);
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.borderCountryNeedsHelp(this.countries[nArray[i]])) continue;
            return true;
        }
        return false;
    }

    public void attackPhase() {
        for (int i = 0; i < this.numContinents; ++i) {
            if (!this.ourConts[i]) continue;
            this.attackInContinent(i);
        }
        this.attackForCard();
        this.attackHogWild();
        this.attackStalemate();
    }

    protected void attackInContinent(int n) {
        ContinentIterator continentIterator = new ContinentIterator(n, this.countries);
        while (continentIterator.hasNext()) {
            Country country = continentIterator.next();
            if (country.getOwner() == this.ID) continue;
            NeighborIterator neighborIterator = new NeighborIterator(country);
            while (neighborIterator.hasNext()) {
                Country country2 = neighborIterator.next();
                if (country2.getOwner() != this.ID || !((float)country2.getArmies() > (float)country.getArmies() * this.outnumberBy) || country.getOwner() == this.ID || !country2.canGoto(country)) continue;
                this.board.attack(country2, country, true);
            }
        }
    }

    public int moveArmiesIn(int n, int n2) {
        Country country;
        int n3;
        int n4 = this.countries[n].getNumberEnemyNeighbors();
        if (n4 > (n3 = this.countries[n2].getNumberEnemyNeighbors())) {
            return 0;
        }
        if (n3 > n4) {
            return 1000000;
        }
        if (n4 > 0) {
            return this.countries[n].getArmies() / 2;
        }
        if (this.ourConts[this.countries[n].getContinent()] && this.ourConts[this.countries[n2].getContinent()]) {
            return this.countries[n].getArmies() / 2;
        }
        if (this.ourConts[this.countries[n].getContinent()]) {
            return 0;
        }
        if (this.ourConts[this.countries[n2].getContinent()]) {
            return 1000000;
        }
        int n5 = 0;
        int n6 = 0;
        NeighborIterator neighborIterator = new NeighborIterator(this.countries[n]);
        while (neighborIterator.hasNext()) {
            country = neighborIterator.next();
            if (country.getOwner() == this.ID || !this.ourConts[country.getContinent()]) continue;
            ++n5;
        }
        neighborIterator = new NeighborIterator(this.countries[n2]);
        while (neighborIterator.hasNext()) {
            country = neighborIterator.next();
            if (country.getOwner() == this.ID || !this.ourConts[country.getContinent()]) continue;
            ++n6;
        }
        if (n5 > n6) {
            return 0;
        }
        if (n6 > n5) {
            return 1000000;
        }
        if (n5 > 0) {
            return this.countries[n].getArmies() / 2;
        }
        this.debug("Pixie moveArmiesIn not fully imped");
        return this.countries[n].getArmies() / 2;
    }

    public void fortifyPhase() {
        for (int i = 0; i < this.numContinents; ++i) {
            if (BoardHelper.playerOwnsContinent(this.ID, i, this.countries)) {
                this.fortifyContinent(i);
                continue;
            }
            this.fortifyContinentScraps(i);
        }
    }

    protected void fortifyContinent(int n) {
        int n2;
        int[] nArray = BoardHelper.getContinentBorders(n, this.countries);
        ArrayList<Country> arrayList = new ArrayList<Country>();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            arrayList.add(this.countries[nArray[n2]]);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            NeighborIterator neighborIterator = new NeighborIterator((Country)arrayList.get(n2));
            while (neighborIterator.hasNext()) {
                Country country = neighborIterator.next();
                if (country.getOwner() != this.ID || arrayList.contains(country) || country.getContinent() != n) continue;
                this.board.fortifyArmies(country.getMoveableArmies(), country, (Country)arrayList.get(n2));
                arrayList.add(country);
            }
        }
    }

    protected void fortifyContinentScraps(int n) {
        ContinentIterator continentIterator = new ContinentIterator(n, this.countries);
        while (continentIterator.hasNext()) {
            Country country;
            Country country2 = continentIterator.next();
            if (country2.getOwner() != this.ID || country2.getMoveableArmies() <= 0) continue;
            int n2 = 1000000;
            Country country3 = null;
            NeighborIterator neighborIterator = new NeighborIterator(country2);
            while (neighborIterator.hasNext()) {
                Country country4;
                country = neighborIterator.next();
                if (country.getOwner() != this.ID || (country4 = country.getWeakestEnemyNeighbor()) == null || country4.getArmies() >= n2) continue;
                n2 = country.getWeakestEnemyNeighbor().getArmies();
                country3 = country;
            }
            country = country2.getWeakestEnemyNeighbor();
            if (country != null && n2 >= country.getArmies() || country3 == null) continue;
            this.board.fortifyArmies(country2.getMoveableArmies(), country2, country3);
        }
    }

    public String youWon() {
        String[] stringArray = new String[]{"Eat my dust", "You didn't clap loud enough", "Make a wish", "Now fetch me Yakool", "Careful what you wish for", "Love one another, and be happy", "You can come out now Satyrs, \nit's pixie party time", "I'm the strongest woman in the world", "I want to be the girl with the most bracelets", "I'm not just cute! \nI am a serious fighter!", "All this bloodshed,\nI think I'm going to be sick..."};
        return stringArray[this.rand.nextInt(stringArray.length)];
    }
}

