/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.LuxAgent;
import com.sillysoft.lux.util.ArmiesIterator;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ClusterBorderIterator;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.CountryRoute;
import com.sillysoft.lux.util.NeighborIterator;
import com.sillysoft.lux.util.PlayerIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class SmartAgentBase
implements LuxAgent {
    protected int ID;
    protected Board board;
    protected Country[] countries;
    protected int numCountries;
    protected int numContinents;
    protected int moveInMemory = -1;
    protected int goalCont = -1;
    protected Random rand = new Random();
    protected int mustKillPlayer;
    protected boolean[] mustKillPlayerOwnsCont;

    public void setPrefs(int n, Board board) {
        this.ID = n;
        this.board = board;
        this.countries = this.board.getCountries();
        this.numCountries = this.countries.length;
        this.numContinents = this.board.getNumberOfContinents();
    }

    public abstract String name();

    public abstract int pickCountry();

    public abstract void placeArmies(int var1);

    public abstract void attackPhase();

    public abstract int moveArmiesIn(int var1, int var2);

    public abstract void fortifyPhase();

    public abstract String youWon();

    public void cardsPhase(Card[] cardArray) {
        this.mustKillPlayer = -1;
    }

    public void cashCardsIfPossible(Card[] cardArray) {
        if (Card.containsASet(cardArray)) {
            Card[] cardArray2 = Card.getBestSet(cardArray, this.ID, this.countries);
            this.board.cashCards(cardArray2[0], cardArray2[1], cardArray2[2]);
        }
    }

    protected void setGoalToLeastBordersCont() {
        int n;
        this.goalCont = -1;
        int[] nArray = new int[this.numContinents];
        int n2 = 1000000;
        for (n = 0; n < this.numContinents; ++n) {
            if (this.board.getContinentBonus(n) <= 0) continue;
            nArray[n] = BoardHelper.getContinentSize(n, this.countries);
            if (nArray[n] >= n2 || !BoardHelper.playerOwnsContinent(-1, n, this.countries)) continue;
            n2 = nArray[n];
            this.goalCont = n;
        }
        if (this.goalCont == -1) {
            n2 = 1000000;
            for (n = 0; n < this.numContinents; ++n) {
                if (this.board.getContinentBonus(n) <= 0 || nArray[n] >= n2 || !BoardHelper.playerOwnsContinentCountry(-1, n, this.countries)) continue;
                n2 = nArray[n];
                this.goalCont = n;
            }
        }
    }

    protected int pickCountryInSmallContinent() {
        if (this.goalCont == -1 || !BoardHelper.playerOwnsContinentCountry(-1, this.goalCont, this.countries)) {
            this.goalCont = -1;
            this.goalCont = BoardHelper.getSmallestPositiveEmptyCont(this.countries, this.board);
            if (this.goalCont == -1) {
                this.goalCont = BoardHelper.getSmallestPositiveOpenCont(this.countries, this.board);
            }
        }
        return this.pickCountryInContinent(this.goalCont);
    }

    protected int pickCountryInContinent(int n) {
        ContinentIterator continentIterator = new ContinentIterator(n, this.countries);
        while (continentIterator.hasNext()) {
            Country country = continentIterator.next();
            if (country.getOwner() != -1 || country.getNumberPlayerNeighbors(this.ID) <= 0) continue;
            return country.getCode();
        }
        continentIterator = new ContinentIterator(n, this.countries);
        int n2 = -1;
        int n3 = 1000000;
        while (continentIterator.hasNext()) {
            Country country = continentIterator.next();
            if (country.getOwner() != -1 || country.getNumberNeighbors() >= n3) continue;
            n2 = country.getCode();
            n3 = country.getNumberNeighbors();
        }
        if (n2 == -1) {
            return this.pickCountryTouchingUs();
        }
        return n2;
    }

    protected int pickCountryTouchingUs() {
        Object object;
        int n = -1;
        int n2 = -1;
        PlayerIterator playerIterator = new PlayerIterator(-1, this.countries);
        while (playerIterator.hasNext()) {
            object = playerIterator.next();
            if (((Country)object).getNumberPlayerNeighbors(this.ID) <= n || this.board.getContinentBonus(((Country)object).getContinent()) < 0) continue;
            n = ((Country)object).getNumberPlayerNeighbors(this.ID);
            n2 = ((Country)object).getCode();
        }
        if (n < 1) {
            object = new ArrayList();
            playerIterator = new PlayerIterator(this.ID, this.countries);
            while (playerIterator.hasNext()) {
                Country country = playerIterator.next();
                if (country.getNumberNotPlayerNeighbors(this.ID) <= 0) continue;
                object.add(country);
            }
            return BoardHelper.closestCountryWithOwner((List)object, -1, this.countries);
        }
        return n2;
    }

    protected int pickCountryNearCluster(Country country) {
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        ArrayList<Country> arrayList = new ArrayList<Country>();
        while (clusterBorderIterator.hasNext()) {
            arrayList.add(clusterBorderIterator.next());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            NeighborIterator neighborIterator = new NeighborIterator((Country)arrayList.get(i));
            while (neighborIterator.hasNext()) {
                Country country2 = neighborIterator.next();
                if (country2.getOwner() == -1) {
                    return country2.getCode();
                }
                if (arrayList.contains(country2)) continue;
                arrayList.add(country2);
            }
        }
        System.out.println("ERROR in smartbase.pickCountryNearCluster() 65465477");
        return -1;
    }

    public void placeInitialArmies(int n) {
        this.placeArmies(n);
    }

    protected int getEasiestContToTake() {
        float f2 = -1.0f;
        int n = -1;
        for (int i = 0; i < this.numContinents; ++i) {
            int n2 = BoardHelper.getEnemyArmiesInContinent(this.ID, i, this.countries);
            int n3 = BoardHelper.getPlayerArmiesInContinent(this.ID, i, this.countries);
            float f3 = (float)n3 / (float)n2;
            if (!(f3 > f2) || this.board.getContinentBonus(i) <= 0) continue;
            n = i;
            f2 = f3;
        }
        return n;
    }

    protected boolean weOwnContsArround(Country country) {
        int n = country.getContinent();
        NeighborIterator neighborIterator = new NeighborIterator(country);
        while (neighborIterator.hasNext()) {
            Country country2 = neighborIterator.next();
            if (country2.getContinent() == n || BoardHelper.playerOwnsContinent(this.ID, country2.getContinent(), this.countries)) continue;
            return false;
        }
        return true;
    }

    protected void placeArmiesToTakeCont(int n, int n2) {
        Object object;
        Object object2;
        if (n2 == -1) {
            this.placeArmiesOnClusterBorder(n, BoardHelper.getPlayersBiggestArmy(this.ID, this.countries));
            return;
        }
        if (BoardHelper.playerOwnsContinent(this.ID, n2, this.countries)) {
            int[] nArray = BoardHelper.getContinentBorders(n2, this.countries);
            for (int i = 0; i < n; ++i) {
                int n3 = 1000000;
                int n4 = -1;
                for (int j = 0; j < nArray.length; ++j) {
                    if (this.countries[nArray[j]].getArmies() >= n3 || this.weOwnContsArround(this.countries[nArray[j]])) continue;
                    n3 = this.countries[nArray[j]].getArmies();
                    n4 = nArray[j];
                }
                if (n4 == -1) {
                    n4 = nArray[this.rand.nextInt(nArray.length)];
                }
                this.board.placeArmies(1, n4);
            }
            return;
        }
        ContinentIterator continentIterator = new ContinentIterator(n2, this.countries);
        Object object3 = null;
        int n5 = 0;
        while (continentIterator.hasNext()) {
            object2 = continentIterator.next();
            if (((Country)object2).getOwner() != this.ID) continue;
            object = 0;
            NeighborIterator neighborIterator = new NeighborIterator((Country)object2);
            while (neighborIterator.hasNext()) {
                Country country = neighborIterator.next();
                if (country.getOwner() == this.ID || country.getContinent() != n2) continue;
                ++object;
            }
            if (object <= n5) continue;
            n5 = object;
            object3 = object2;
        }
        if (object3 != null) {
            this.board.placeArmies(n, (Country)object3);
            return;
        }
        object2 = BoardHelper.cheapestRouteFromOwnerToCont(this.ID, n2, this.countries);
        this.debug("BoardHelper.cheapestRouteFromOwnerToCont(" + this.ID + ", " + n2 + ") = " + new CountryRoute((int[])object2, this.countries));
        object = object2[0];
        this.board.placeArmies(n, (int)object);
    }

    protected void placeArmiesOnClusterBorder(int n, Country country) {
        if (country == null) {
            System.out.println("SmartBase.placeArmiesOnClusterBorder() -> the cluster root==null. 654213465");
        }
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        Country country2 = null;
        int n2 = 1000000;
        while (clusterBorderIterator.hasNext()) {
            Country country3 = clusterBorderIterator.next();
            if (country3.getArmies() >= n2) continue;
            n2 = country3.getArmies();
            country2 = country3;
        }
        if (country2 == null) {
            System.out.println("SmartBase.placeArmiesOnClusterBorder() -> weakest==null. 7404524");
        }
        int n3 = Math.min(n, Math.max(1, n / 100));
        this.board.placeArmies(n3, country2);
        if (n > n3) {
            this.placeArmiesOnClusterBorder(n - n3, country);
        }
    }

    protected boolean attackEasyExpand(Country country) {
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        boolean bl = false;
        while (clusterBorderIterator.hasNext()) {
            Country country2 = clusterBorderIterator.next();
            NeighborIterator neighborIterator = new NeighborIterator(country2);
            int n = 0;
            Country country3 = null;
            while (neighborIterator.hasNext()) {
                Country country4 = neighborIterator.next();
                if (country4.getOwner() == this.ID) continue;
                ++n;
                country3 = country4;
            }
            if (n != true || country2.getArmies() <= country3.getArmies()) continue;
            this.moveInMemory = 1000000;
            if (this.board.attack(country2, country3, true) > 0) {
                bl = true;
            }
            this.moveInMemory = -1;
        }
        return bl;
    }

    protected boolean attackFillOut(Country country) {
        boolean bl = false;
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        while (clusterBorderIterator.hasNext()) {
            Country country2 = clusterBorderIterator.next();
            NeighborIterator neighborIterator = new NeighborIterator(country2);
            while (neighborIterator.hasNext()) {
                Country country3 = neighborIterator.next();
                if (country3.getOwner() == this.ID || country3.getNumberNotPlayerNeighbors(this.ID) != 0 || country3.getArmies() >= country2.getArmies()) continue;
                this.moveInMemory = 0;
                if (this.board.attack(country2, country3, true) == 7) {
                    bl = true;
                }
                this.moveInMemory = -1;
            }
        }
        return bl;
    }

    protected boolean attackConsolidate(Country country) {
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        boolean bl = false;
        while (clusterBorderIterator.hasNext()) {
            int n;
            Object object;
            Country country2 = clusterBorderIterator.next();
            NeighborIterator neighborIterator = new NeighborIterator(country2);
            int n2 = 0;
            Country country3 = null;
            while (neighborIterator.hasNext()) {
                object = neighborIterator.next();
                if (((Country)object).getOwner() == this.ID) continue;
                ++n2;
                country3 = object;
            }
            if (n2 != true || country3.getNumberPlayerNeighbors(this.ID) <= 1) continue;
            object = new ArrayList();
            NeighborIterator neighborIterator2 = new NeighborIterator(country3);
            while (neighborIterator2.hasNext()) {
                Country country4 = neighborIterator2.next();
                if (country4.getOwner() != this.ID || country4.getNumberEnemyNeighbors() != 1) continue;
                object.add(country4);
            }
            int n3 = 0;
            for (n = 0; n < object.size(); ++n) {
                n3 += ((Country)object.get(n)).getArmies();
            }
            if (n3 <= country3.getArmies()) continue;
            for (n = 0; n < object.size() && country3.getOwner() != this.ID; ++n) {
                if (((Country)object.get(n)).getArmies() <= 1) continue;
                this.moveInMemory = 1000000;
                if (this.board.attack((Country)object.get(n), country3, true) <= 0) continue;
                bl = true;
            }
            this.moveInMemory = -1;
        }
        return bl;
    }

    protected boolean attackSplitOff(Country country) {
        this.moveInMemory = -1;
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        boolean bl = false;
        while (clusterBorderIterator.hasNext()) {
            Country country2 = clusterBorderIterator.next();
            NeighborIterator neighborIterator = new NeighborIterator(country2);
            while (neighborIterator.hasNext()) {
                Country country3 = neighborIterator.next();
                if (country3.getOwner() == this.ID || country3.getArmies() >= country2.getArmies() || this.board.attack(country2, country3, true) <= 0) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected boolean attackSplitUp(Country country, float f2) {
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        boolean bl = false;
        while (clusterBorderIterator.hasNext()) {
            Country country2 = clusterBorderIterator.next();
            NeighborIterator neighborIterator = new NeighborIterator(country2);
            int n = 0;
            int n2 = 0;
            Country country3 = null;
            while (neighborIterator.hasNext()) {
                Country country4 = neighborIterator.next();
                if (country4.getOwner() == this.ID) continue;
                ++n;
                n2 += country4.getArmies();
                country3 = country4;
            }
            if (!((float)country2.getArmies() > (float)n2 * f2)) continue;
            int n3 = country2.getArmies() / Math.max(n, 1);
            neighborIterator = new NeighborIterator(country2);
            while (neighborIterator.hasNext() && country2.getArmies() > 1) {
                Country country5 = neighborIterator.next();
                if (country5.getOwner() == this.ID) continue;
                this.moveInMemory = n3;
                if (this.board.attack(country2, country5, true) > 0) {
                    bl = true;
                }
                this.moveInMemory = -1;
                bl = true;
            }
        }
        return bl;
    }

    protected boolean tripleAttackPack(Country country) {
        boolean bl = false;
        while (this.attackEasyExpand(country)) {
            bl = true;
        }
        this.attackFillOut(country);
        while (this.attackConsolidate(country)) {
            bl = true;
        }
        return bl;
    }

    protected boolean hogWildCheck() {
        int n = this.board.getNumberOfPlayers();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = BoardHelper.getPlayerArmies(i, this.countries);
            if (i == this.ID) continue;
            n2 += nArray[i];
        }
        return nArray[this.ID] > n2;
    }

    protected void attackHogWild() {
        if (this.hogWildCheck()) {
            this.attackAsMuchAsPossible();
        }
    }

    protected void attackStalemate() {
        if (BoardHelper.getPlayerArmies(this.ID, this.countries) > 1500) {
            this.attackAsMuchAsPossible();
        }
    }

    protected void attackAsMuchAsPossible() {
        boolean bl = true;
        while (bl) {
            bl = false;
            PlayerIterator playerIterator = new PlayerIterator(this.ID, this.countries);
            while (playerIterator.hasNext()) {
                Country country = playerIterator.next();
                while (this.tripleAttackPack(country)) {
                    bl = true;
                }
                while (this.attackSplitUp(country, 0.01f)) {
                    bl = true;
                }
            }
        }
    }

    protected void attackForCard() {
        this.attackForCard(1);
    }

    protected void attackForCard(int n) {
        if (!this.board.useCards() || this.board.tookOverACountry()) {
            return;
        }
        float f2 = 0.0f;
        Country country = null;
        Country country2 = null;
        PlayerIterator playerIterator = new PlayerIterator(this.ID, this.countries);
        while (playerIterator.hasNext()) {
            Country country3 = playerIterator.next();
            NeighborIterator neighborIterator = new NeighborIterator(country3);
            while (neighborIterator.hasNext()) {
                Country country4 = neighborIterator.next();
                if (country4.getOwner() == this.ID || !((double)country3.getArmies() * 1.0 / (double)country4.getArmies() > (double)f2)) continue;
                f2 = (float)country3.getArmies() * 1.0f / (float)country4.getArmies();
                country = country3;
                country2 = country4;
            }
        }
        if (country.getArmies() > country2.getArmies() * n) {
            this.debug("executing an attackForCard attack");
            this.setmoveInMemoryBeforeCardAttack(country);
            this.board.attack(country, country2, true);
            this.moveInMemory = -1;
        }
    }

    protected void setmoveInMemoryBeforeCardAttack(Country country) {
    }

    protected int obviousMoveArmiesInTest(int n, int n2) {
        if (this.countries[n].getNumberNeighbors() == 1) {
            this.moveInMemory = -1;
            return 1000000;
        }
        if (this.countries[n2].getNumberNeighbors() == 1) {
            this.moveInMemory = -1;
            return 0;
        }
        return -1;
    }

    protected int memoryMoveArmiesInTest(int n, int n2) {
        if (this.moveInMemory != -1) {
            int n3 = this.moveInMemory == -2 ? this.countries[n].getArmies() / 2 : this.moveInMemory;
            this.moveInMemory = -1;
            return n3;
        }
        return -1;
    }

    protected void fortifyCluster(Country country) {
        ClusterBorderIterator clusterBorderIterator = new ClusterBorderIterator(country);
        ArrayList<Country> arrayList = new ArrayList<Country>();
        while (clusterBorderIterator.hasNext()) {
            arrayList.add(clusterBorderIterator.next());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            NeighborIterator neighborIterator = new NeighborIterator((Country)arrayList.get(i));
            while (neighborIterator.hasNext()) {
                Country country2 = neighborIterator.next();
                if (country2.getOwner() != this.ID || arrayList.contains(country2)) continue;
                if (country2.canGoto((Country)arrayList.get(i))) {
                    this.board.fortifyArmies(country2.getMoveableArmies(), country2, (Country)arrayList.get(i));
                }
                arrayList.add(country2);
            }
        }
    }

    protected int getBiggestOwnedCont() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.numContinents; ++i) {
            if (!BoardHelper.playerOwnsContinent(this.ID, i, this.countries) || BoardHelper.getContinentSize(i, this.countries) <= n2) continue;
            n = i;
            n2 = BoardHelper.getContinentSize(i, this.countries);
        }
        return n;
    }

    protected int getMostValuablePositiveOwnedCont() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.numContinents; ++i) {
            if (!BoardHelper.playerOwnsContinent(this.ID, i, this.countries) || this.board.getContinentBonus(i) <= n2) continue;
            n = i;
            n2 = this.board.getContinentBonus(i);
        }
        return n;
    }

    public String message(String string, Object object) {
        return null;
    }

    protected boolean placeArmiesToKillDominantPlayer(int n) {
        int n2;
        int n3 = this.board.getNumberOfPlayers();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = BoardHelper.getPlayerArmies(n2, this.countries);
            nArray[n2] = this.board.getPlayerIncome(n2);
            nArray3[n2] = BoardHelper.getPlayerCountries(n2, this.countries);
            n4 += nArray2[n2];
            n5 += nArray[n2];
        }
        n2 = -1;
        for (int i = 0; i < n3; ++i) {
            if (i == this.ID || !((double)nArray2[i] >= (double)n4 * 0.5) && !((double)nArray[i] >= (double)n5 * 0.5) && !((double)nArray3[i] >= (double)this.numCountries * 0.5)) continue;
            n2 = i;
        }
        if (n2 != -1) {
            this.mustKillPlayer = n2;
            if (this.placeArmiesToKillPlayer(n, n2)) {
                return true;
            }
        }
        return false;
    }

    protected boolean placeArmiesToKillPlayer(int n, int n2) {
        this.mustKillPlayerOwnsCont = new boolean[this.numContinents];
        for (int i = 0; i < this.numContinents; ++i) {
            this.mustKillPlayerOwnsCont[i] = false;
            if (!BoardHelper.playerOwnsContinent(n2, i, this.countries)) continue;
            this.mustKillPlayerOwnsCont[i] = true;
        }
        int[] nArray = new int[this.numContinents];
        int n3 = 1000000;
        int n4 = -1;
        for (int i = 0; i < this.numContinents; ++i) {
            int[] nArray2;
            nArray[i] = -1;
            if (!this.mustKillPlayerOwnsCont[i] || (nArray2 = BoardHelper.cheapestRouteFromOwnerToCont(this.ID, i, this.countries)) == null) continue;
            nArray[i] = this.pathCost(nArray2);
            if (nArray[i] >= n3) continue;
            n3 = nArray[i];
            n4 = nArray2[0];
        }
        if (n4 == -1) {
            return false;
        }
        this.board.placeArmies(n, n4);
        return true;
    }

    protected void attackToKillPlayer(int n) {
        int n2;
        this.debug("starting attackToKillPlayer -> " + n);
        int[] nArray = new int[this.numContinents];
        for (n2 = 0; n2 < this.numContinents; ++n2) {
            nArray[n2] = this.mustKillPlayerOwnsCont[n2] ? this.board.getContinentBonus(n2) : -1;
        }
        n2 = 0;
        int n3 = 0;
        while (n2 != -1) {
            n2 = -1;
            n3 = 0;
            for (int i = 0; i < this.numContinents; ++i) {
                if (nArray[i] <= n3) continue;
                n3 = nArray[i];
                n2 = i;
            }
            if (n2 == -1) continue;
            this.attackToKillContinent(n2);
            nArray[n2] = -1;
        }
        this.debug("ending attackToKillPlayer -> " + n);
    }

    protected boolean attackToKillContinent(int n) {
        this.debug("starting attackToKillContinent -> " + n);
        ArmiesIterator armiesIterator = new ArmiesIterator(this.ID, 2, this.countries);
        while (armiesIterator.hasNext()) {
            Country country = armiesIterator.next();
            int[] nArray = BoardHelper.easyCostFromCountryToContinent(country.getCode(), n, this.countries);
            if (nArray == null || this.pathCost(nArray) >= country.getArmies() || !this.attackAlongPath(nArray)) continue;
            return true;
        }
        return false;
    }

    protected int pathCost(int[] nArray) {
        if (nArray == null) {
            System.out.println("SmartAgentBase.pathCost() -> the path was null!");
            return 1000000;
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (this.countries[nArray[i]].getOwner() == this.ID) continue;
            n += this.countries[nArray[i]].getArmies();
        }
        return n;
    }

    protected boolean attackAlongPath(int[] nArray) {
        for (int i = 1; i < nArray.length; ++i) {
            this.moveInMemory = 1000000;
            if (this.countries[nArray[i - 1]].getArmies() != 1 && this.board.attack(nArray[i - 1], nArray[i], true) != 13) continue;
            this.moveInMemory = -1;
            return false;
        }
        this.moveInMemory = -1;
        return true;
    }

    public void debug(Object object) {
    }
}

