/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.Cluster;
import com.sillysoft.lux.agent.LuxAgent;
import com.sillysoft.lux.agent.SmartAgentBase;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.CountryCluster;
import com.sillysoft.lux.util.CountryClusterSet;
import com.sillysoft.lux.util.CountryRoute;
import java.util.ArrayList;
import java.util.List;

public class Vulture
extends SmartAgentBase {
    protected LuxAgent backer;
    protected List attackRoutes = new ArrayList();
    protected int toKillPlayer = -1;
    protected boolean placedToKill = false;

    public Vulture() {
        this.backer = new Cluster();
    }

    public void setPrefs(int n, Board board) {
        this.backer.setPrefs(n, board);
        super.setPrefs(n, board);
    }

    public int pickCountry() {
        return this.backer.pickCountry();
    }

    public void placeInitialArmies(int n) {
        this.backer.placeInitialArmies(n);
    }

    public int moveArmiesIn(int n, int n2) {
        return this.backer.moveArmiesIn(n, n2);
    }

    public void fortifyPhase() {
        this.backer.fortifyPhase();
    }

    public String message(String string, Object object) {
        return this.backer.message(string, object);
    }

    public String name() {
        return "Vulture";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Vulture likes to pick at carcases.";
    }

    public void cardsPhase(Card[] cardArray) {
        this.cashCardsIfPossible(cardArray);
        this.backer.cardsPhase(cardArray);
    }

    protected void setToKillPlayer(int n) {
        int n2 = this.board.getNextCardSetValue();
        int n3 = 1000000;
        int n4 = -1;
        int n5 = this.board.getNumberOfPlayers();
        int[] nArray = new int[n5];
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            nArray[i] = BoardHelper.getPlayerArmies(i, this.countries);
            if (i == this.ID) {
                n6 = nArray[i];
                continue;
            }
            int n7 = i;
            nArray[n7] = (int)((double)nArray[n7] - (double)n2 * ((double)this.board.getPlayerCards(i) / 3.0));
            if (BoardHelper.getPlayerCountries(i, this.countries) <= 0 || nArray[i] >= n3 || BoardHelper.getPlayersBiggestArmyWithEnemyNeighbor(this.ID, this.countries).getArmies() + n <= BoardHelper.getPlayerArmies(i, this.countries) + BoardHelper.getPlayerCountries(i, this.countries)) continue;
            n3 = nArray[i];
            n4 = i;
        }
        this.toKillPlayer = -1;
        if (n6 > n3 * 2) {
            this.toKillPlayer = n4;
            this.debug("We are going to try and totally kill player " + this.board.getPlayerName(this.toKillPlayer));
        }
    }

    public void placeArmies(int n) {
        this.debug("Placing " + n + " armies...");
        this.placedToKill = false;
        this.setToKillPlayer(n);
        if (this.toKillPlayer == -1) {
            this.backer.placeArmies(n);
            return;
        }
        this.placeToKill(n);
    }

    protected void placeToKill(int n) {
        CountryClusterSet countryClusterSet = CountryClusterSet.getAllCountriesOwnedBy(this.toKillPlayer, this.countries);
        if (countryClusterSet.numberOfClusters() == 1) {
            this.debug("They only have 1 cluster!");
            CountryCluster countryCluster = countryClusterSet.getCluster(0);
            CountryRoute countryRoute = null;
            if (countryCluster.size() < 21) {
                countryRoute = countryCluster.getSimpleRoute(true, this.ID);
            }
            if (countryRoute != null) {
                CountryRoute countryRoute2;
                CountryRoute countryRoute3;
                this.debug("It has a simple path! " + countryRoute);
                Country country = countryRoute.start();
                Country country2 = countryRoute.end();
                CountryRoute countryRoute4 = new CountryRoute(BoardHelper.easyCostCountryWithOwner(country, this.ID, this.countries));
                CountryRoute countryRoute5 = new CountryRoute(BoardHelper.easyCostCountryWithOwner(country2, this.ID, this.countries));
                if (countryRoute4.costNotCountingPlayer(this.ID, this.toKillPlayer) - countryRoute4.start().getArmies() < countryRoute5.costNotCountingPlayer(this.ID, this.toKillPlayer) - countryRoute5.start().getArmies()) {
                    countryRoute3 = countryRoute4;
                    countryRoute2 = countryRoute4.append(countryRoute);
                } else {
                    countryRoute3 = countryRoute5;
                    countryRoute2 = countryRoute5.append(countryRoute.reverse());
                }
                Country country3 = countryRoute3.start();
                this.debug("Our closest country is " + country3);
                this.debug("We have " + country3.getArmies() + " + " + n + " armies. They have " + countryRoute.getArmies() + " armies + " + (countryRoute3.costNotCountingPlayer(this.ID) - countryRoute3.end().getArmies()) + " needed to get there.");
                if (country3.getArmies() + n > countryRoute.getArmies() + countryRoute3.costNotCountingPlayer(this.ID) - countryRoute3.end().getArmies()) {
                    this.placedToKill = true;
                    this.debug("Placing all armies on " + country3);
                    this.board.placeArmies(n, country3);
                    this.attackRoutes.add(countryRoute2);
                    return;
                }
            }
        } else {
            this.debug("They have " + countryClusterSet.numberOfClusters() + " clusters.");
        }
        this.backer.placeArmies(n);
    }

    public void attackPhase() {
        if (!this.placedToKill) {
            this.backer.attackPhase();
            return;
        }
        while (this.attackRoutes.size() > 0) {
            CountryRoute countryRoute = (CountryRoute)this.attackRoutes.remove(0);
            this.debug("We are attacking to kill off the player along the route: " + countryRoute);
            this.attackAlongRoute(countryRoute);
        }
        this.attackHogWild();
    }

    protected boolean attackAlongRoute(CountryRoute countryRoute) {
        for (int i = 1; i < countryRoute.size(); ++i) {
            ((SmartAgentBase)this.backer).moveInMemory = 1000000;
            if (countryRoute.get(i - 1).getArmies() <= 1 || !countryRoute.get(i - 1).canGoto(countryRoute.get(i)) || countryRoute.get(i - 1).getOwner() != this.ID || this.board.attack(countryRoute.get(i - 1), countryRoute.get(i), true) != 13) continue;
            ((SmartAgentBase)this.backer).moveInMemory = -1;
            return false;
        }
        ((SmartAgentBase)this.backer).moveInMemory = -1;
        return true;
    }

    public String youWon() {
        return "Picked off";
    }
}

