/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.util;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.CountryIterator;
import com.sillysoft.lux.util.CountryPathStack;
import com.sillysoft.lux.util.CountryStack;
import com.sillysoft.lux.util.PlayerIterator;
import java.util.ArrayList;
import java.util.List;

public class BoardHelper {
    public static Country getPlayersBiggestArmy(int n, Country[] countryArray) {
        PlayerIterator playerIterator = new PlayerIterator(n, countryArray);
        int n2 = -1;
        Country country = null;
        while (playerIterator.hasNext()) {
            Country country2 = playerIterator.next();
            if (country2.getArmies() <= n2) continue;
            n2 = country2.getArmies();
            country = country2;
        }
        return country;
    }

    public static Country getPlayersBiggestArmyWithEnemyNeighbor(int n, Country[] countryArray) {
        PlayerIterator playerIterator = new PlayerIterator(n, countryArray);
        int n2 = -1;
        Country country = null;
        while (playerIterator.hasNext()) {
            Country country2 = playerIterator.next();
            if (country2.getArmies() <= n2 || country2.getNumberEnemyNeighbors() <= 0) continue;
            n2 = country2.getArmies();
            country = country2;
        }
        return country;
    }

    public static int getPlayerArmies(int n, Country[] countryArray) {
        int n2 = 0;
        for (int i = 0; i < countryArray.length; ++i) {
            if (countryArray[i].getOwner() != n) continue;
            n2 += countryArray[i].getArmies();
        }
        return n2;
    }

    public static int getPlayerCountries(int n, Country[] countryArray) {
        int n2 = 0;
        for (int i = 0; i < countryArray.length; ++i) {
            if (countryArray[i].getOwner() != n) continue;
            ++n2;
        }
        return n2;
    }

    public static int getPlayerArmiesInContinent(int n, int n2, Country[] countryArray) {
        int n3 = 0;
        ContinentIterator continentIterator = new ContinentIterator(n2, countryArray);
        while (continentIterator.hasNext()) {
            Country country = continentIterator.next();
            if (country.getOwner() != n) continue;
            n3 += country.getArmies();
        }
        return n3;
    }

    public static int getEnemyArmiesInContinent(int n, int n2, Country[] countryArray) {
        int n3 = 0;
        ContinentIterator continentIterator = new ContinentIterator(n2, countryArray);
        while (continentIterator.hasNext()) {
            Country country = continentIterator.next();
            if (country.getOwner() == n) continue;
            n3 += country.getArmies();
        }
        return n3;
    }

    public static int getPlayerArmiesAdjoiningContinent(int n, int n2, Country[] countryArray) {
        int n3;
        int[] nArray = BoardHelper.getContinentBorders(n2, countryArray);
        ArrayList<Country> arrayList = new ArrayList<Country>();
        for (n3 = 0; n3 < nArray.length; ++n3) {
            Country[] countryArray2 = countryArray[nArray[n3]].getAdjoiningList();
            for (int i = 0; i < countryArray2.length; ++i) {
                if (countryArray2[i].getOwner() != n || countryArray2[i].getContinent() == n2 || arrayList.contains(countryArray2[i])) continue;
                arrayList.add(countryArray2[i]);
            }
        }
        n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            n3 += ((Country)arrayList.get(i)).getArmies();
        }
        return n3;
    }

    public static boolean playerIsStillInTheGame(int n, Country[] countryArray) {
        for (int i = 0; i < countryArray.length; ++i) {
            if (countryArray[i].getOwner() != n) continue;
            return true;
        }
        return false;
    }

    public static int numberOfContinents(Country[] countryArray) {
        boolean bl = true;
        int n = 0;
        while (bl) {
            bl = false;
            ContinentIterator continentIterator = new ContinentIterator(n, countryArray);
            if (continentIterator.hasNext()) {
                bl = true;
            }
            ++n;
        }
        return n - 1;
    }

    public static int getContinentSize(int n, Country[] countryArray) {
        int n2 = 0;
        ContinentIterator continentIterator = new ContinentIterator(n, countryArray);
        while (continentIterator.hasNext()) {
            continentIterator.next();
            ++n2;
        }
        return n2;
    }

    public static int getCountryInContinent(int n, Country[] countryArray) {
        if (n < 0) {
            System.out.println("BoardHelper.getCountryInContinent() called with a continent code of " + n);
        }
        ContinentIterator continentIterator = new ContinentIterator(n, countryArray);
        return continentIterator.next().getCode();
    }

    public static int[] getContinentBorders(int n, Country[] countryArray) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ContinentIterator continentIterator = new ContinentIterator(n, countryArray);
        while (continentIterator.hasNext()) {
            object = continentIterator.next();
            boolean bl = false;
            Country[] countryArray2 = ((Country)object).getAdjoiningList();
            for (int i = 0; i < countryArray2.length; ++i) {
                if (countryArray2[i].getContinent() == n) continue;
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(object);
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = ((Country)arrayList.get(i)).getCode();
        }
        return object;
    }

    public static int[] getContinentBordersBeyond(int n, Country[] countryArray) {
        Object object;
        ArrayList<Country> arrayList = new ArrayList<Country>();
        ContinentIterator continentIterator = new ContinentIterator(n, countryArray);
        while (continentIterator.hasNext()) {
            object = continentIterator.next();
            Country[] countryArray2 = ((Country)object).getAdjoiningList();
            for (int i = 0; i < countryArray2.length; ++i) {
                if (countryArray2[i].getContinent() == n || arrayList.contains(countryArray2[i])) continue;
                arrayList.add(countryArray2[i]);
            }
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = ((Country)arrayList.get(i)).getCode();
        }
        return object;
    }

    public static boolean playerOwnsContinent(int n, int n2, Country[] countryArray) {
        ContinentIterator continentIterator = new ContinentIterator(n2, countryArray);
        while (continentIterator.hasNext()) {
            if (continentIterator.next().getOwner() == n) continue;
            return false;
        }
        return true;
    }

    public static boolean playerOwnsAnyContinent(int n, Country[] countryArray) {
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            bl = false;
            ContinentIterator continentIterator = new ContinentIterator(n2, countryArray);
            if (continentIterator.hasNext()) {
                if (BoardHelper.playerOwnsContinent(n, n2, countryArray)) {
                    return true;
                }
                bl = true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean playerOwnsAnyPositiveContinent(int n, Country[] countryArray, Board board) {
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            bl = false;
            ContinentIterator continentIterator = new ContinentIterator(n2, countryArray);
            if (continentIterator.hasNext()) {
                if (board.getContinentBonus(n2) > 0 && BoardHelper.playerOwnsContinent(n, n2, countryArray)) {
                    return true;
                }
                bl = true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean anyPlayerOwnsContinent(int n, Country[] countryArray) {
        ContinentIterator continentIterator = new ContinentIterator(n, countryArray);
        int n2 = continentIterator.next().getOwner();
        while (continentIterator.hasNext()) {
            if (continentIterator.next().getOwner() == n2) continue;
            return false;
        }
        return true;
    }

    public static boolean playerOwnsContinentCountry(int n, int n2, Country[] countryArray) {
        ContinentIterator continentIterator = new ContinentIterator(n2, countryArray);
        while (continentIterator.hasNext()) {
            if (continentIterator.next().getOwner() != n) continue;
            return true;
        }
        return false;
    }

    public static int getSmallestEmptyCont(Country[] countryArray) {
        int n = BoardHelper.numberOfContinents(countryArray);
        int n2 = 1000000;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            int n4 = BoardHelper.getContinentSize(i, countryArray);
            if (n4 >= n2 || !BoardHelper.playerOwnsContinent(-1, i, countryArray)) continue;
            n2 = n4;
            n3 = i;
        }
        return n3;
    }

    public static int getSmallestPositiveEmptyCont(Country[] countryArray, Board board) {
        int n = BoardHelper.numberOfContinents(countryArray);
        int n2 = 1000000;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            int n4;
            if (board.getContinentBonus(i) <= 0 || (n4 = BoardHelper.getContinentSize(i, countryArray)) >= n2 || !BoardHelper.playerOwnsContinent(-1, i, countryArray)) continue;
            n2 = n4;
            n3 = i;
        }
        return n3;
    }

    public static int getSmallestOpenCont(Country[] countryArray) {
        int n = BoardHelper.numberOfContinents(countryArray);
        int n2 = 1000000;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            int n4 = BoardHelper.getContinentSize(i, countryArray);
            if (n4 >= n2 || !BoardHelper.playerOwnsContinentCountry(-1, i, countryArray)) continue;
            n2 = n4;
            n3 = i;
        }
        return n3;
    }

    public static int getSmallestPositiveOpenCont(Country[] countryArray, Board board) {
        int n = BoardHelper.numberOfContinents(countryArray);
        int n2 = 1000000;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            int n4;
            if (board.getContinentBonus(i) <= 0 || (n4 = BoardHelper.getContinentSize(i, countryArray)) >= n2 || !BoardHelper.playerOwnsContinentCountry(-1, i, countryArray)) continue;
            n2 = n4;
            n3 = i;
        }
        return n3;
    }

    public static Country closestCountryWithOwner(Country country, int n, Country[] countryArray) {
        int n2 = country.getCode();
        int n3 = BoardHelper.closestCountryWithOwner(n2, n, countryArray);
        if (n3 < 0) {
            return null;
        }
        return countryArray[n3];
    }

    public static int closestCountryWithOwner(int n, int n2, Country[] countryArray) {
        if (n < 0 || countryArray.length <= n) {
            return -1;
        }
        int n3 = n;
        int n4 = 0;
        boolean[] blArray = new boolean[countryArray.length];
        for (int i = 0; i < countryArray.length; ++i) {
            blArray[i] = false;
        }
        blArray[n] = true;
        CountryStack countryStack = new CountryStack();
        do {
            Country[] countryArray2 = countryArray[n3].getAdjoiningList();
            for (int i = 0; i < countryArray2.length; ++i) {
                if (blArray[countryArray2[i].getCode()]) continue;
                countryStack.pushWithValue(countryArray2[i], n4 + 1);
                blArray[countryArray2[i].getCode()] = true;
            }
            if (countryStack.isEmpty()) {
                return -2;
            }
            n4 = countryStack.topValue();
        } while (countryArray[n3 = countryStack.pop()].getOwner() != n2);
        return n3;
    }

    public static int closestCountryWithOwner(List list, int n, Country[] countryArray) {
        int n2;
        if (list.size() < 1) {
            return -1;
        }
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = ((Country)list.get(i)).getCode();
        }
        boolean[] blArray = new boolean[countryArray.length];
        for (int i = 0; i < countryArray.length; ++i) {
            blArray[i] = false;
        }
        CountryStack countryStack = new CountryStack();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            blArray[nArray[n2]] = true;
            countryStack.pushWithValue(countryArray[nArray[n2]], 0);
        }
        n2 = countryStack.pop();
        int n3 = 0;
        do {
            Country[] countryArray2 = countryArray[n2].getAdjoiningList();
            for (int i = 0; i < countryArray2.length; ++i) {
                if (blArray[countryArray2[i].getCode()]) continue;
                countryStack.pushWithValue(countryArray2[i], n3 + 1);
                blArray[countryArray2[i].getCode()] = true;
            }
            if (countryStack.isEmpty()) {
                return -2;
            }
            n3 = countryStack.topValue();
        } while (countryArray[n2 = countryStack.pop()].getOwner() != n);
        return n2;
    }

    public static Country[] easyCostCountryWithOwner(Country country, int n, Country[] countryArray) {
        int n2 = country.getCode();
        int[] nArray = BoardHelper.easyCostCountryWithOwner(n2, n, countryArray);
        Country[] countryArray2 = new Country[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            countryArray2[i] = countryArray[nArray[i]];
        }
        return countryArray2;
    }

    public static int[] easyCostCountryWithOwner(int n, int n2, Country[] countryArray) {
        if (n < 0 || countryArray.length <= n) {
            System.out.println("ERROR from easyCostCountryWithOwner: bad params");
            return null;
        }
        if (countryArray[n].getOwner() == n2) {
            int[] nArray = new int[]{n};
            return nArray;
        }
        int n3 = n;
        int n4 = 0;
        int[] nArray = new int[]{n};
        boolean[] blArray = new boolean[countryArray.length];
        for (int i = 0; i < countryArray.length; ++i) {
            blArray[i] = false;
        }
        blArray[n] = true;
        CountryPathStack countryPathStack = new CountryPathStack();
        do {
            Country[] countryArray2 = countryArray[n3].getAdjoiningList();
            for (int i = 0; i < countryArray2.length; ++i) {
                if (blArray[countryArray2[i].getCode()]) continue;
                int[] nArray2 = new int[nArray.length + 1];
                nArray2[0] = countryArray2[i].getCode();
                for (int j = 1; j < nArray2.length; ++j) {
                    nArray2[j] = nArray[j - 1];
                }
                countryPathStack.pushWithValueAndHistory(countryArray2[i], n4 + (countryArray2[i].getOwner() == n2 ? -countryArray2[i].getArmies() : countryArray2[i].getArmies()), nArray2);
                blArray[countryArray2[i].getCode()] = true;
            }
            if (countryPathStack.isEmpty()) {
                System.out.println("ERROR in easyCostCountryWithOwner->can't pop");
                return null;
            }
            n4 = countryPathStack.topValue();
            nArray = countryPathStack.topHistory();
        } while (countryArray[n3 = countryPathStack.pop()].getOwner() != n2);
        return nArray;
    }

    public static Country[] easyCostFromCountryToContinent(Country country, int n, Country[] countryArray) {
        int n2 = country.getCode();
        int[] nArray = BoardHelper.easyCostFromCountryToContinent(n2, n, countryArray);
        Country[] countryArray2 = new Country[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            countryArray2[i] = countryArray[nArray[i]];
        }
        return countryArray2;
    }

    public static int[] easyCostFromCountryToContinent(int n, int n2, Country[] countryArray) {
        if (n < 0 || countryArray.length <= n || n2 < 0) {
            System.out.println("ERROR in easyCostFromCountryToContinent() -> bad parameters.");
            return null;
        }
        int n3 = countryArray[n].getOwner();
        int n4 = n;
        int n5 = 0;
        int[] nArray = new int[]{n};
        boolean[] blArray = new boolean[countryArray.length];
        for (int i = 0; i < countryArray.length; ++i) {
            blArray[i] = false;
        }
        blArray[n] = true;
        CountryPathStack countryPathStack = new CountryPathStack();
        do {
            Country[] countryArray2 = countryArray[n4].getAdjoiningList();
            for (int i = 0; i < countryArray2.length; ++i) {
                if (blArray[countryArray2[i].getCode()] || countryArray2[i].getOwner() == n3) continue;
                int[] nArray2 = new int[nArray.length + 1];
                for (int j = 0; j < nArray.length; ++j) {
                    nArray2[j] = nArray[j];
                }
                nArray2[nArray2.length - 1] = countryArray2[i].getCode();
                countryPathStack.pushWithValueAndHistory(countryArray2[i], n5 + (countryArray2[i].getContinent() == n2 ? -countryArray2[i].getArmies() : countryArray2[i].getArmies()), nArray2);
                blArray[countryArray2[i].getCode()] = true;
            }
            if (countryPathStack.isEmpty()) {
                return null;
            }
            n5 = countryPathStack.topValue();
            nArray = countryPathStack.topHistory();
        } while (countryArray[n4 = countryPathStack.pop()].getContinent() != n2);
        return nArray;
    }

    public static Country[] easyCostBetweenCountries(Country country, Country country2, Country[] countryArray) {
        int n = country.getCode();
        int n2 = country2.getCode();
        int[] nArray = BoardHelper.easyCostBetweenCountries(n, n2, countryArray);
        Country[] countryArray2 = new Country[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            countryArray2[i] = countryArray[nArray[i]];
        }
        return countryArray2;
    }

    public static int[] easyCostBetweenCountries(int n, int n2, Country[] countryArray) {
        if (n < 0 || countryArray.length <= n || n2 < 0 || countryArray.length <= n2) {
            System.out.println("ERROR in easyCostBetweenCountries() -> bad parameters.");
            return null;
        }
        int n3 = countryArray[n].getOwner();
        int n4 = n;
        int n5 = 0;
        int[] nArray = new int[]{n};
        boolean[] blArray = new boolean[countryArray.length];
        for (int i = 0; i < countryArray.length; ++i) {
            blArray[i] = false;
        }
        blArray[n] = true;
        CountryPathStack countryPathStack = new CountryPathStack();
        do {
            Country[] countryArray2 = countryArray[n4].getAdjoiningList();
            for (int i = 0; i < countryArray2.length; ++i) {
                if (blArray[countryArray2[i].getCode()] || countryArray2[i].getOwner() == n3) continue;
                int[] nArray2 = new int[nArray.length + 1];
                nArray2[0] = countryArray2[i].getCode();
                for (int j = 1; j < nArray2.length; ++j) {
                    nArray2[j] = nArray[j - 1];
                }
                countryPathStack.pushWithValueAndHistory(countryArray2[i], n5 + (countryArray2[i].getCode() == n2 ? -countryArray2[i].getArmies() : countryArray2[i].getArmies()), nArray2);
                blArray[countryArray2[i].getCode()] = true;
            }
            if (countryPathStack.isEmpty()) {
                return null;
            }
            n5 = countryPathStack.topValue();
            nArray = countryPathStack.topHistory();
        } while ((n4 = countryPathStack.pop()) != n2);
        return nArray;
    }

    public static Country[] friendlyPathBetweenCountries(Country country, Country country2, Country[] countryArray) {
        int n;
        int n2 = country.getCode();
        int[] nArray = BoardHelper.friendlyPathBetweenCountries(n2, n = country2.getCode(), countryArray);
        if (nArray == null) {
            return null;
        }
        Country[] countryArray2 = new Country[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            countryArray2[i] = countryArray[nArray[i]];
        }
        return countryArray2;
    }

    public static int[] friendlyPathBetweenCountries(int n, int n2, Country[] countryArray) {
        if (n < 0 || countryArray.length <= n || n2 < 0 || countryArray.length <= n2) {
            System.out.println("ERROR in friendlyPathBetweenCountries() -> bad parameters.");
            return null;
        }
        int n3 = countryArray[n].getOwner();
        int n4 = n;
        int n5 = 0;
        int[] nArray = new int[]{n};
        boolean[] blArray = new boolean[countryArray.length];
        for (int i = 0; i < countryArray.length; ++i) {
            blArray[i] = false;
        }
        blArray[n] = true;
        CountryPathStack countryPathStack = new CountryPathStack();
        do {
            Country[] countryArray2 = countryArray[n4].getAdjoiningList();
            for (int i = 0; i < countryArray2.length; ++i) {
                if (countryArray2[i].getOwner() != n3 || blArray[countryArray2[i].getCode()]) continue;
                int[] nArray2 = new int[nArray.length + 1];
                for (int j = 0; j < nArray.length; ++j) {
                    nArray2[j] = nArray[j];
                }
                nArray2[nArray2.length - 1] = countryArray2[i].getCode();
                countryPathStack.pushWithValueAndHistory(countryArray2[i], n5 + 1, nArray2);
                blArray[countryArray2[i].getCode()] = true;
            }
            if (countryPathStack.isEmpty()) {
                return null;
            }
            n5 = countryPathStack.topValue();
            nArray = countryPathStack.topHistory();
        } while ((n4 = countryPathStack.pop()) != n2);
        return nArray;
    }

    public static int[] cheapestRouteFromOwnerToCont(int n, int n2, Country[] countryArray) {
        int[] nArray;
        int n3;
        int n4;
        Object object;
        if (n < 0 || n2 < 0) {
            System.out.println("ERROR in cheapestRouteFromOwnerToCont() -> bad parameters");
            return null;
        }
        if (BoardHelper.playerOwnsContinentCountry(n, n2, countryArray)) {
            object = new ContinentIterator(n2, countryArray);
            while (((CountryIterator)object).hasNext()) {
                Country country = ((CountryIterator)object).next();
                if (country.getOwner() != n) continue;
                return new int[]{country.getCode()};
            }
        }
        object = new boolean[countryArray.length];
        for (int i = 0; i < countryArray.length; ++i) {
            object[i] = false;
        }
        CountryPathStack countryPathStack = new CountryPathStack();
        int[] nArray2 = BoardHelper.getContinentBorders(n2, countryArray);
        for (int i = 0; i < nArray2.length; ++i) {
            n4 = nArray2[i];
            n3 = 0;
            nArray = new int[]{n4};
            object[n4] = true;
            countryPathStack.pushWithValueAndHistory(countryArray[nArray2[i]], 0, nArray);
        }
        do {
            n3 = countryPathStack.topValue();
            nArray = countryPathStack.topHistory();
            n4 = countryPathStack.pop();
            if (countryArray[n4].getOwner() == n) {
                return nArray;
            }
            Country[] countryArray2 = countryArray[n4].getAdjoiningList();
            for (int i = 0; i < countryArray2.length; ++i) {
                if (object[countryArray2[i].getCode()] != false) continue;
                int[] nArray3 = new int[nArray.length + 1];
                nArray3[0] = countryArray2[i].getCode();
                for (int j = 1; j < nArray3.length; ++j) {
                    nArray3[j] = nArray[j - 1];
                }
                countryPathStack.pushWithValueAndHistory(countryArray2[i], n3 + (countryArray2[i].getOwner() == n ? -countryArray2[i].getArmies() : countryArray2[i].getArmies()), nArray3);
                object[countryArray2[i].getCode()] = true;
            }
        } while (!countryPathStack.isEmpty());
        System.out.println("ERROR in cheapestRouteFromOwnerToCont->can't pop");
        return null;
    }

    public static Country[] getCountriesCopy(Country[] countryArray) {
        int n;
        Country[] countryArray2 = new Country[countryArray.length];
        for (n = 0; n < countryArray.length; ++n) {
            countryArray2[n] = new Country(n, countryArray[n].getContinent(), null);
            countryArray2[n].setArmies(countryArray[n].getArmies(), null);
            countryArray2[n].setName(countryArray[n].getName(), null);
            countryArray2[n].setOwner(countryArray[n].getOwner(), null);
        }
        for (n = 0; n < countryArray.length; ++n) {
            Country[] countryArray3 = countryArray[n].getAdjoiningList();
            for (int i = 0; i < countryArray3.length; ++i) {
                countryArray2[n].addToAdjoiningList(countryArray2[countryArray3[i].getCode()], null);
            }
        }
        return countryArray2;
    }
}

