/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.util;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.util.CountryIterator;
import com.sillysoft.lux.util.CountryRoute;
import com.sillysoft.lux.util.NeighborIterator;
import com.sillysoft.lux.util.OrderedNeighborIterator;
import java.util.ArrayList;
import java.util.List;

public class CountryCluster {
    private List cluster;

    public static CountryCluster getOwnedCluster(Country country) {
        return CountryCluster.getOwnedCluster(country, false);
    }

    public static CountryCluster getOwnedCluster(Country country, boolean bl) {
        if (country == null) {
            throw new NullPointerException("CountryCluster created with a null root country");
        }
        ArrayList<Country> arrayList = new ArrayList<Country>();
        arrayList.add(country);
        int n = country.getOwner();
        for (int i = 0; i < arrayList.size(); ++i) {
            CountryIterator countryIterator = bl ? new OrderedNeighborIterator((Country)arrayList.get(i)) : new NeighborIterator((Country)arrayList.get(i));
            while (countryIterator.hasNext()) {
                Country country2 = countryIterator.next();
                if (country2.getOwner() != n || arrayList.contains(country2)) continue;
                arrayList.add(country2);
            }
        }
        return new CountryCluster(arrayList);
    }

    public CountryCluster(List list) {
        this.cluster = list;
    }

    public int getArmies() {
        int n = 0;
        for (int i = 0; i < this.cluster.size(); ++i) {
            n += ((Country)this.cluster.get(i)).getArmies();
        }
        return n;
    }

    public List getList() {
        return this.cluster;
    }

    public int size() {
        return this.cluster.size();
    }

    public CountryRoute getSimpleRoute() {
        return this.getSimpleRoute(false);
    }

    public CountryRoute getSimpleRoute(boolean bl) {
        for (int i = 0; i < this.cluster.size(); ++i) {
            CountryRoute countryRoute;
            Country country = (Country)this.cluster.get(i);
            if (bl && country.getNumberEnemyNeighbors() <= 0 || (countryRoute = this.getSimpleRouteStartingAt(country)) == null) continue;
            return countryRoute;
        }
        return null;
    }

    public CountryRoute getSimpleRoute(boolean bl, int n) {
        CountryRoute countryRoute;
        Country country;
        int n2;
        for (n2 = 0; n2 < this.cluster.size(); ++n2) {
            country = (Country)this.cluster.get(n2);
            if (country.getNumberPlayerNeighbors(n) <= 0 || (countryRoute = this.getSimpleRouteStartingAt(country)) == null) continue;
            return countryRoute;
        }
        for (n2 = 0; n2 < this.cluster.size(); ++n2) {
            country = (Country)this.cluster.get(n2);
            if (country.getNumberPlayerNeighbors(n) != 0 || bl && country.getNumberEnemyNeighbors() <= 0 || (countryRoute = this.getSimpleRouteStartingAt(country)) == null) continue;
            return countryRoute;
        }
        return null;
    }

    public CountryRoute getSimpleRouteStartingAt(Country country) {
        if (this.cluster.size() == 1) {
            return new CountryRoute(this.cluster);
        }
        CountryRoute countryRoute = null;
        CountryCluster countryCluster = this.cloneRemoving(country);
        Country[] countryArray = country.getAdjoiningList();
        for (int i = 0; i < countryArray.length && countryRoute == null; ++i) {
            if (!this.cluster.contains(countryArray[i])) continue;
            countryRoute = countryCluster.getSimpleRouteStartingAt(countryArray[i]);
        }
        if (countryRoute == null) {
            return null;
        }
        ArrayList<Country> arrayList = new ArrayList<Country>();
        arrayList.add(country);
        for (int i = 0; i < countryRoute.size(); ++i) {
            arrayList.add(countryRoute.get(i));
        }
        return new CountryRoute(arrayList);
    }

    private CountryCluster cloneRemoving(Country country) {
        ArrayList arrayList = new ArrayList(this.cluster);
        arrayList.remove(country);
        return new CountryCluster(arrayList);
    }

    private static Country expandWalk(Country country, List list, List list2) {
        Country[] countryArray = country.getAdjoiningList();
        for (int i = 0; i < countryArray.length; ++i) {
            if (!list2.contains(countryArray[i]) || list.contains(countryArray[i])) continue;
            list.add(countryArray[i]);
            return countryArray[i];
        }
        return null;
    }

    public Country getStrongestNeighborOwnedBy(int n) {
        int n2 = -1;
        Country country = null;
        for (int i = 0; i < this.cluster.size(); ++i) {
            Country country2 = (Country)this.cluster.get(i);
            Country country3 = country2.getStrongestNeighborOwnedBy(n);
            if (country3 == null || country3.getArmies() <= n2) continue;
            n2 = country3.getArmies();
            country = country3;
        }
        return country;
    }

    public int estimatedNumberOfArmiesNeededToConquer() {
        return (int)((double)(this.getArmies() + this.size()) * 1.2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n\t<CountryCluster size:" + this.size() + " countries:\n\t");
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append(this.cluster.get(i));
            if (i == this.size() - 1) continue;
            stringBuffer.append("\n\t");
        }
        stringBuffer.append(" end of cluster>");
        return stringBuffer.toString();
    }
}

