/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jbinder;

import com.javapro.jbinder.AbstractLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class BinderLayout
extends AbstractLayout {
    protected int page = 0;

    public BinderLayout(int n) {
        super(n, 0);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            if (dimension.height <= n3) continue;
            n3 = dimension.height;
        }
        Insets insets = container.getInsets();
        int n4 = insets.left + insets.right;
        int n5 = insets.top + insets.bottom;
        return new Dimension(n2 * 2 + n4 + this.hgap, n3 + n5);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getMinimumSize();
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            if (dimension.height <= n3) continue;
            n3 = dimension.height;
        }
        Insets insets = container.getInsets();
        int n4 = insets.left + insets.right;
        int n5 = insets.top + insets.bottom;
        return new Dimension(n2 * 2 + n4 + this.hgap, n3 + n5);
    }

    public void layoutContainer(Container container) {
        int n = container.getComponentCount();
        Insets insets = container.getInsets();
        int n2 = insets.left;
        int n3 = insets.top;
        int n4 = container.getSize().width - (insets.left + insets.right) - this.hgap;
        int n5 = container.getSize().height - (insets.top + insets.bottom);
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            boolean bl = i == this.page - 1 || i == this.page;
            component.setVisible(bl);
            component.setEnabled(bl);
            if (i == this.page - 1) {
                component.setBounds(n2, n3, n4 / 2, n5);
            }
            if (i != this.page) continue;
            component.setBounds(n2 + n4 / 2 + this.hgap, n3, n4 / 2, n5);
        }
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }
}

