/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jbinder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

public class ShadowBorder
implements Border,
SwingConstants {
    protected int shadow = 3;
    protected Color color;
    protected int corner = 4;

    public ShadowBorder(int n) {
        this(n, Color.black, 4);
    }

    public ShadowBorder(int n, Color color, int n2) {
        this.shadow = n;
        this.color = this.adjustAlpha(color, 128);
        this.corner = n2;
    }

    private Color adjustAlpha(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public Insets getBorderInsets(Component component) {
        switch (this.corner) {
            case 8: {
                return new Insets(this.shadow, this.shadow, 0, 0);
            }
            case 2: {
                return new Insets(this.shadow, 0, 0, this.shadow);
            }
            case 6: {
                return new Insets(0, this.shadow, this.shadow, 0);
            }
        }
        return new Insets(0, 0, this.shadow, this.shadow);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this.color);
        if (this.corner == 4) {
            graphics.fillRect(n + n3 - this.shadow, n2 + this.shadow, this.shadow, n4 - this.shadow);
            graphics.fillRect(n + this.shadow, n2 + n4 - this.shadow, n3 - this.shadow * 2, this.shadow);
        }
        if (this.corner == 6) {
            graphics.fillRect(n, n2 + this.shadow, this.shadow, n4 - this.shadow);
            graphics.fillRect(n + this.shadow, n2 + n4 - this.shadow, n3 - this.shadow * 2, this.shadow);
        }
        if (this.corner == 2) {
            graphics.fillRect(n + n3 - this.shadow, n2, this.shadow, n4 - this.shadow);
            graphics.fillRect(n + this.shadow, n2, n3 - this.shadow * 2, n2 + this.shadow);
        }
        if (this.corner == 8) {
            graphics.fillRect(n, n2, this.shadow, n4 - this.shadow);
            graphics.fillRect(n + this.shadow, n2, n3 - this.shadow * 2, n2 + this.shadow);
        }
    }
}

