/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jcellborder;

import com.javapro.jcellborder.CellBorder;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class CellBorderPanel
extends JPanel
implements MouseListener {
    protected CellBorder border;
    protected boolean northSelect;
    protected boolean southSelect;
    protected boolean eastSelect;
    protected boolean westSelect;
    protected int northInset;
    protected int southInset;
    protected int eastInset;
    protected int westInset;

    public CellBorderPanel() {
        this.setCellBorder(new CellBorder(new Insets(1, 1, 1, 1), Color.blue));
        this.addMouseListener(this);
        this.setOpaque(false);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.border.setFill(!this.border.getFill());
        this.refresh();
    }

    public CellBorder getCellBorder() {
        return this.border;
    }

    public void setCellBorder(CellBorder cellBorder) {
        this.border = cellBorder;
        this.setBorder(cellBorder);
        Insets insets = this.getInsets();
        this.northInset = insets.top;
        this.southInset = insets.bottom;
        this.eastInset = insets.right;
        this.westInset = insets.left;
        this.northSelect = true;
        this.southSelect = true;
        this.eastSelect = true;
        this.westSelect = true;
    }

    protected void refresh() {
        this.revalidate();
        this.repaint();
    }

    public void toggleNorth(boolean bl) {
        this.northSelect = bl;
        this.border.getInsets().top = this.northSelect ? this.northInset : 0;
        this.refresh();
    }

    public void toggleSouth(boolean bl) {
        this.southSelect = bl;
        this.border.getInsets().bottom = this.southSelect ? this.southInset : 0;
        this.refresh();
    }

    public void toggleEast(boolean bl) {
        this.eastSelect = bl;
        this.border.getInsets().right = this.eastSelect ? this.eastInset : 0;
        this.refresh();
    }

    public void toggleWest(boolean bl) {
        this.westSelect = bl;
        this.border.getInsets().left = this.westSelect ? this.westInset : 0;
        this.refresh();
    }

    public void adjustNorth(int n) {
        if (!this.northSelect) {
            return;
        }
        this.northInset += n;
        this.border.getInsets().top = this.northInset = Math.max(0, this.northInset);
        this.refresh();
    }

    public void adjustSouth(int n) {
        if (!this.southSelect) {
            return;
        }
        this.southInset += n;
        this.border.getInsets().bottom = this.southInset = Math.max(0, this.southInset);
        this.refresh();
    }

    public void adjustWest(int n) {
        if (!this.westSelect) {
            return;
        }
        this.westInset += n;
        this.border.getInsets().left = this.westInset = Math.max(0, this.westInset);
        this.refresh();
    }

    public void adjustEast(int n) {
        if (!this.eastSelect) {
            return;
        }
        this.eastInset += n;
        this.border.getInsets().right = this.eastInset = Math.max(0, this.eastInset);
        this.refresh();
    }
}

