/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jcellborder;

import com.javapro.jcellborder.ArrowIcon;
import com.javapro.jcellborder.CellBorder;
import com.javapro.jcellborder.CellBorderIcon;
import com.javapro.jcellborder.CellBorderPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingConstants;

public class JCellBorder
extends JPanel
implements ActionListener,
SwingConstants {
    protected JButton northMore;
    protected JButton southMore;
    protected JButton eastMore;
    protected JButton westMore;
    protected JButton northLess;
    protected JButton southLess;
    protected JButton eastLess;
    protected JButton westLess;
    protected JToggleButton north;
    protected JToggleButton south;
    protected JToggleButton east;
    protected JToggleButton west;
    protected CellBorderPanel borderPanel;

    public JCellBorder() {
        this.setLayout(new BorderLayout(2, 2));
        this.setPreferredSize(new Dimension(200, 200));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel = new JPanel(new GridLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.borderPanel = new CellBorderPanel();
        jPanel.add(this.borderPanel);
        this.add("Center", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.northLess = this.makeArrowButton(1);
        this.northMore = this.makeArrowButton(5);
        jPanel2.add("Center", this.makeButtonPanel(this.northLess, this.northMore, true));
        this.west = this.makeToggleButton(7);
        jPanel2.add("West", this.west);
        this.north = this.makeToggleButton(1);
        jPanel2.add("East", this.north);
        this.add("North", jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.southMore = this.makeArrowButton(1);
        this.southLess = this.makeArrowButton(5);
        jPanel3.add("Center", this.makeButtonPanel(this.southMore, this.southLess, true));
        this.south = this.makeToggleButton(5);
        jPanel3.add("West", this.south);
        this.east = this.makeToggleButton(3);
        jPanel3.add("East", this.east);
        this.add("South", jPanel3);
        this.westLess = this.makeArrowButton(7);
        this.westMore = this.makeArrowButton(3);
        this.add("West", this.makeButtonPanel(this.westLess, this.westMore, false));
        this.eastMore = this.makeArrowButton(7);
        this.eastLess = this.makeArrowButton(3);
        this.add("East", this.makeButtonPanel(this.eastMore, this.eastLess, false));
        this.north.addActionListener(this);
        this.south.addActionListener(this);
        this.east.addActionListener(this);
        this.west.addActionListener(this);
        this.northMore.addActionListener(this);
        this.northLess.addActionListener(this);
        this.southMore.addActionListener(this);
        this.southLess.addActionListener(this);
        this.westMore.addActionListener(this);
        this.westLess.addActionListener(this);
        this.eastMore.addActionListener(this);
        this.eastLess.addActionListener(this);
    }

    public CellBorder getCellBorder() {
        return this.borderPanel.getCellBorder();
    }

    public void setCellBorder(CellBorder cellBorder) {
        this.borderPanel.setCellBorder(cellBorder);
    }

    public JPanel makeButtonPanel(JButton jButton, JButton jButton2, boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout());
        if (bl) {
            jPanel.add("North", jButton);
            jPanel.add("South", jButton2);
        } else {
            jPanel.add("West", jButton);
            jPanel.add("East", jButton2);
        }
        return jPanel;
    }

    public JToggleButton makeToggleButton(int n) {
        JToggleButton jToggleButton = new JToggleButton(new CellBorderIcon(n));
        jToggleButton.setPreferredSize(new Dimension(24, 24));
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton.setFocusPainted(false);
        jToggleButton.setSelected(true);
        return jToggleButton;
    }

    public JButton makeArrowButton(int n) {
        JButton jButton = new JButton(new ArrowIcon(n));
        jButton.setPreferredSize(new Dimension(12, 12));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.north) {
            this.borderPanel.toggleNorth(this.north.isSelected());
        }
        if (object == this.south) {
            this.borderPanel.toggleSouth(this.south.isSelected());
        }
        if (object == this.east) {
            this.borderPanel.toggleEast(this.east.isSelected());
        }
        if (object == this.west) {
            this.borderPanel.toggleWest(this.west.isSelected());
        }
        if (object == this.northMore) {
            this.borderPanel.adjustNorth(1);
        }
        if (object == this.southMore) {
            this.borderPanel.adjustSouth(1);
        }
        if (object == this.westMore) {
            this.borderPanel.adjustWest(1);
        }
        if (object == this.eastMore) {
            this.borderPanel.adjustEast(1);
        }
        if (object == this.northLess) {
            this.borderPanel.adjustNorth(-1);
        }
        if (object == this.southLess) {
            this.borderPanel.adjustSouth(-1);
        }
        if (object == this.westLess) {
            this.borderPanel.adjustWest(-1);
        }
        if (object == this.eastLess) {
            this.borderPanel.adjustEast(-1);
        }
    }
}

