/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jsequence;

import com.javapro.jsequence.SequenceEvent;
import com.javapro.jsequence.SequenceItem;
import com.javapro.jsequence.SequenceListener;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class SequenceItemView
extends JPanel
implements SequenceListener {
    protected JLabel label;
    protected JProgressBar bar;
    protected static ImageIcon BLANK_ICON;
    protected static ImageIcon READY_ICON;
    protected static ImageIcon UPDATE_ICON;
    protected static ImageIcon DONE_ICON;
    static /* synthetic */ Class class$javax$swing$JViewport;

    public SequenceItemView() {
        BLANK_ICON = new ImageIcon(this.getClass().getResource("images/blank.gif"));
        READY_ICON = new ImageIcon(this.getClass().getResource("images/ready.gif"));
        UPDATE_ICON = new ImageIcon(this.getClass().getResource("images/update.gif"));
        DONE_ICON = new ImageIcon(this.getClass().getResource("images/done.gif"));
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout());
        this.label = new JLabel("", BLANK_ICON, 2);
        this.label.setOpaque(false);
        this.add("North", this.label);
        this.bar = new JProgressBar();
        this.bar.setOpaque(false);
        this.bar.setBorder(BorderFactory.createEmptyBorder(2, 20, 2, 5));
        this.add("Center", this.bar);
        this.setVisible(false);
    }

    public void scrollToVisible() {
        Rectangle rectangle;
        JViewport jViewport;
        Rectangle rectangle2;
        Container container = SwingUtilities.getAncestorOfClass(class$javax$swing$JViewport == null ? (class$javax$swing$JViewport = SequenceItemView.class$("javax.swing.JViewport")) : class$javax$swing$JViewport, this);
        if (container != null && !(rectangle2 = (jViewport = (JViewport)container).getViewRect()).contains(rectangle = this.getBounds())) {
            jViewport.scrollRectToVisible(rectangle);
        }
    }

    public void progressReady(SequenceEvent sequenceEvent) {
        Object object = sequenceEvent.getSource();
        if (object instanceof SequenceItem) {
            SequenceItem sequenceItem = (SequenceItem)object;
            this.label.setText(sequenceItem.getText());
        }
        this.label.setIcon(READY_ICON);
        this.bar.setMinimum(0);
        this.bar.setMaximum(sequenceEvent.getValue());
        this.setVisible(true);
        this.scrollToVisible();
    }

    public void progressUpdate(SequenceEvent sequenceEvent) {
        this.label.setIcon(UPDATE_ICON);
        this.bar.setValue(sequenceEvent.getValue());
        this.scrollToVisible();
    }

    public void progressDone(SequenceEvent sequenceEvent) {
        this.bar.setValue(this.bar.getMaximum());
        this.label.setIcon(DONE_ICON);
        SequenceItemView.sleep(100);
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

